<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "categorias.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }

    //Funcion que devuelve los idiomas:
    function obtener_idiomas()
    {
        global $base_datos;
        
        $idiomas = Array();
        
        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);

        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_idioma = $row["id_idioma"];
            $idioma = htmlentities($row["idioma"]);
            $idiomas[$id_idioma] = $idioma;
        }
        
        return $idiomas;
    }


    //Funcion que indenta una categoria:
    function indentar_categoria($nivel)
    {
        //echo "<br>";
        //if ($nivel == 0) { echo "*&nbsp;"; }
        echo "<table><tr>";
        for ($x = 0; $x < $nivel; $x++)
        {
            echo "<td>&nbsp;</td>";
        }
        echo "</tr></table>";
    }

    
    //Funcion que muestra una categoria (en todos sus idiomas):
    function mostrar_categoria($id_categoria)
    {
        global $this_file, $base_datos;

        $idiomas = obtener_idiomas();

        ?>
            <table>
                <tr>
        <?php
        foreach ($idiomas as $id_idioma => $idioma)
        {
            $consulta = "SELECT * FROM categoria_idioma WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma";
            $resultados2 = $base_datos->haz_consulta($consulta);
            $resultados_matriz = mysql_fetch_assoc($resultados2);
            if (mysql_num_rows($resultados2) > 0)
            {
                $categoria = $resultados_matriz["nombre_categoria"];
                echo '<td><span class="destacado">'.$idioma.':</span><br>' . htmlentities($categoria) . '</td>';
            } else { echo "<td colspan=\"2\">No definido</td>"; }
            $consulta = "SELECT * FROM categorias WHERE id_categoria = $id_categoria";
            $resultados3 = $base_datos->haz_consulta($consulta);
            $resultados_matriz = mysql_fetch_assoc($resultados3);
            $mostrar = $resultados_matriz["mostrar"];
            $mostrar = ($mostrar) ? "si" : "no";
        }
        if (sizeof($idiomas) <= 0) { echo "<td colspan=\"2\">No hay resultados</td>"; }
        else
        {
            ?>
                <td>
                    <table>
                        <tr>
                            <td>
                                <table><tr><td>ID: <?php echo $id_categoria; ?></td></tr></table>
                            </td>
                            <td>
                                <span class="destacado">Mostrar:</span>
                                <br>
                                <?php echo $mostrar; ?>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <a href="productos.php?mostrar_categoria=<?php echo $id_categoria; ?>">Ver productos</a>
                            </td>
                        </tr>
                    </table>
                </td>
                <td>
                    <form method="post" action="categorias_modificacion.php">
                        <input type="hidden" name="id_categoria" value="<?php echo $id_categoria; ?>">
                        <input type="submit" name="boton" value="Modificar">
                    </form>
                </td>
                <td>
                    <form method="post" action="<?php echo $this_file; ?>">
                        <input type="hidden" name="accion" value="descendiente">
                        <input type="hidden" name="id_categoria" value="<?php echo $id_categoria; ?>">
                        <input type="submit" name="boton" value="Descendiente">
                    </form>
                </td>
                <td>
                    <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo $id_categoria; ?>');">
                        <input type="hidden" name="accion" value="eliminar">
                        <input type="hidden" name="id_categoria" value="<?php echo $id_categoria; ?>">
                        <input type="submit" name="boton" value="Eliminar">
                    </form>
                </td>
            <?php
        }
        ?>
                </tr>
            </table>
        <?php
       
       $accion = strtolower(recoger_post("accion"));
       if ($accion == "descendiente")
       {
            $id_categoria_enviada = recoger_post("id_categoria");
            if ($id_categoria_enviada == $id_categoria) { mostrar_formulario_agregar($id_categoria); }
       }
         
    }


    //Funcion recursiva que muestra el arbol de categorias:
    function mostrar_arbol_categorias($raiz, $nivel)
    {
        global $base_datos;
        
        $consulta = "SELECT * FROM categorias AS a LEFT JOIN categoria_idioma AS b ON a.id_categoria = b.id_categoria WHERE raiz = $raiz ORDER BY nombre_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        while ($row = mysql_fetch_assoc($resultados))
        {
            if ($nivel == 0) { echo "<br>"; }
            $id_categoria = $row["id_categoria"];
            echo "<table>";
            if ($nivel == 0) { echo '<tr><td colspan="2"><a href="categoria_archivo.php">Ir a Gesti&oacute;n de los archivos de las categor&iacute;s principales</a></td></tr>'; }
            echo "<tr><td>";
            indentar_categoria($nivel);
            echo "</td><td>";
            mostrar_categoria($id_categoria);
            echo "</tr></table>";
            mostrar_arbol_categorias($id_categoria, $nivel+1);
        }
        
        return mysql_num_rows($resultados);
    }


    //Funcion que muestra el formulario de agregar una categoria:
    function mostrar_formulario_agregar($raiz)
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);

        if (mysql_num_rows($resultados) <= 0)
        {
            mostrar_advertencia("No hay idiomas definidos en la tabla de idiomas.");
        }
        else
        {
            ?>
                <table>
                    <tr>
                        <td>
                            Agregar categor&iacute;a:
                            <br>
                            <br>
                            <form method="post" action="<?php echo $this_file; ?>">
                                <table>
                                    <?php
                                        $x = 0;
                                        while ($row = mysql_fetch_assoc($resultados))
                                        {
                                            $id_idioma = $row["id_idioma"];
                                            $idioma = $row["idioma"];
                                    ?>
                                            <tr>
                                                <td>
                                                    <?php echo htmlentities($idioma).": "; ?>
                                                </td>
                                                <td>
                                                    <input type="text" name="categoria_<?php echo $id_idioma; ?>" id="categoria_nueva_<?php echo $x++; ?>" value="" size="20">
                                                </td>
                                            </tr>
                                    <?php
                                        }
                                    ?>
                                </table>
                                <input type="hidden" name="accion" value="agregar">
                                <input type="hidden" name="raiz" value="<?php echo $raiz; ?>">
                                <br>
                                <input type="submit" name="boton" value="Agregar">
                            </form>
                        </td>
                    </tr>
                </table>
            <?php
        }
    }


    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $resultados = mostrar_arbol_categorias(0, 0);
        
        ?>
            <br>
            <table align="center" width="820">
                <tr>
                    <td valign="middle" class="destacado">
                        <?php
                          if ($resultados <= 0) { mostrar_advertencia("No hay categor&iacute;as definidas en la tabla de categor&iacute;as<br>"); }
                          mostrar_formulario_agregar(0);
                        ?>
                    </td>
                </tr>
        </table>
        <?php    
    }


    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        //$categoria = recoger_post("categoria");
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                $raiz = strtoupper(recoger_post("raiz"));
                if ($raiz != "")
                {
                    $operacion = agregar_categoria($raiz);
                    if (!$operacion) { mostrar_error("No se ha podido agregar la nueva categor&iacute;a."); }
                } else { mostrar_error("No se ha podido agregar la nueva categor&iacute;a, puede que falten datos en el formulario"); }
                break;
            case 'eliminar':
                $id_categoria = recoger_post("id_categoria");
                if ($id_categoria != "" && is_numeric($id_categoria))
                {
                    $operacion = eliminar_categoria($id_categoria);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar la categor&iacute;a con id <b>" . htmlentities($id_categoria) . "</b>."); }
                    else { echo "Categor&iacute;a con id <b>'$id_categoria'</b> eliminada<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar la categor&iacute;a con id <b>" . htmlentities($id_categoria) . "</b>, puede que falten datos en el formulario."); }
                break;
        }
    }


    //Funcion que elimina una categoria:
    function eliminar_categoria($id_categoria)
    {
        global $base_datos;

        $consulta = "SELECT * FROM categorias WHERE id_categoria = $id_categoria";
        $resultados = $base_datos->haz_consulta($consulta);

        $consulta = "DELETE FROM categorias WHERE id_categoria = $id_categoria";
        $resultados2 = $base_datos->haz_consulta($consulta);
        
        if (mysql_num_rows($resultados) > 0) { eliminar_categoria_recursivamente($id_categoria); }
        
        return $resultados;
    }


    //Funcion que elimina categorias de forma recursiva (por su raiz):
    function eliminar_categoria_recursivamente($raiz)
    {
        global $base_datos;

        $consulta = "SELECT * FROM categorias WHERE raiz = $raiz";
        $resultados = $base_datos->haz_consulta($consulta);
        
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            $consulta = "DELETE FROM categorias WHERE id_categoria = $id_categoria";
            $resultados2 = $base_datos->haz_consulta($consulta);
            eliminar_categoria_recursivamente($id_categoria);
        }
        
        return $resultados;
    }

    
    //Funcion que agrega una categoria:
    function agregar_categoria($raiz)
    {
        global $base_datos;

        $consulta = "INSERT INTO categorias (raiz) VALUES ($raiz)";
        $resultados = $base_datos->haz_consulta($consulta);
        $id_categoria = mysql_insert_id($base_datos->conexion);
        
        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0";
        $resultados1 = $base_datos->haz_consulta($consulta);
        
        $resultados2 = TRUE;
        $id_idioma = Array();
        $nombre_categoria = Array();
        $x = 0;
        while ($row = mysql_fetch_assoc($resultados1))
        {
            $id_idioma[] = $row["id_idioma"];
            //$nombre_categoria[] = mysql_real_escape_string(htmlentities(recoger_post("categoria_" . $id_idioma[$x])));
            $nombre_categoria[] = mysql_real_escape_string(recoger_post("categoria_" . $id_idioma[$x]));
            //if ($nombre_categoria[$x] == "" || $id_idioma[$x] == "") { mostrar_error("Al menos un campo ha sido enviado vacio."); eliminar_categoria($id_categoria); return FALSE; }
            if ($id_idioma[$x] == "") { mostrar_error("Al menos un campo ha sido enviado vacio."); eliminar_categoria($id_categoria); return FALSE; }
            $x++;
        }
        
        for ($x = 0; $x < sizeof($id_idioma); $x++)
        {
            $consulta = "INSERT INTO categoria_idioma (id_categoria, id_idioma, nombre_categoria) VALUES ($id_categoria, $id_idioma[$x], '".trim($nombre_categoria[$x])."')";
            $resultados = $base_datos->haz_consulta($consulta);
            if (!$resultados) { $resultados2 = FALSE; }
        }
        
        return ($resultados1 && $resultados2);
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de categor&iacute;as</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('categoria_nueva_0').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de categor&iacute;as</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
