<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "colecciones.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM colecciones ORDER BY nombre_coleccion";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <table align="center" width="620">
            <tr>
                <td class="impar" width="400" valign="middle">Modificar colecci&oacute;n</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador = 0;
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id = $row["id_coleccion"];
            $nombre = $row["nombre_coleccion"];
            ?>
            <br>
            <table align="center" width="620">
                <tr>
                    <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('registro_<?php echo $contador; ?>').value == '') { alert('El texto del registro <?php echo htmlentities($id); ?> no puede estar vacio!'); return false; }">
                    <td class="<?php echo $par_impar; ?>" width="400" valign="middle">
                        <a href="productos.php?mostrar_coleccion=<?php echo $id; ?>">Ver productos de la colecci&oacute;n</a>
                        <br>
                        <br>
                        <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                        <input type="hidden" name="accion" value="modificar">
                        <input type="text" name="nombre" id="registro_<?php echo $contador; ?>" value="<?php echo htmlentities($nombre); ?>"> <input type="submit" name="boton" value="Modificar">
                    </td>
                    </form>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($nombre))); ?>');">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="nombre" value="<?php echo htmlentities($nombre); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador++;
        }

        ?>

            <br>
            <table align="center" width="620">
                <tr>
                    <td valign="middle">
                         <?php
                            if (mysql_num_rows($resultados) <= 0) { mostrar_advertencia("No hay colecciones en la tabla de colecciones<br>"); }
                         ?>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('registro_nuevo').value == '') { alert('Debes introducir un texto!'); return false; }">
                            <input type="hidden" name="accion" value="agregar">
                            Nueva: <input type="text" name="nombre" id="registro_nuevo" value=""> <input type="submit" name="boton" value="Agregar">
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $nombre = recoger_post("nombre");
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                if ($nombre != "")
                {
                    $operacion = agregar($nombre);
                    if (!$operacion) { mostrar_error("No se ha podido agregar <b>" . htmlentities($nombre) . "</b>."); }
                    else { echo "<b>" . htmlentities($nombre) . "</b> agregado<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar <b>" . htmlentities($nombre) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                $id = recoger_post("id");
                if ($id != "" && is_numeric($id))
                {
                    $operacion = eliminar($id);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "')."); }
                    else { echo "<b>" . htmlentities($nombre) . "</b> (con id '$id') eliminado<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "'), puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id = recoger_post("id");
                if ($nombre != "" && $id != "" && is_numeric($id))
                {
                    $operacion = modificar($id, $nombre);
                    if (!$operacion) { mostrar_error("No se ha podido modificar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "')."); }
                    else { echo "Registro con id '" . htmlentities($id) . "' modificado a <b>" . htmlentities($nombre) . "</b><br>"; }
                } else { mostrar_advertencia("No se ha podido modificar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "'), puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un registro o no:
    function existe($nombre)
    {
        global $base_datos;
        
        $nombre = mysql_real_escape_string($nombre);
        
        $consulta = "SELECT * FROM colecciones WHERE UPPER(nombre_coleccion) LIKE '" . strtoupper($nombre) . "'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }


    //Funcion que agrega un registro nuevo:
    function agregar($nombre)
    {
        if (existe($nombre)) { mostrar_error("El registro <b>" . htmlentities($nombre) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $nombre = mysql_real_escape_string(trim($nombre));
        
        $consulta = "INSERT INTO colecciones (nombre_coleccion) VALUES ('$nombre')";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que elimina un registro existente:
    function eliminar($id)
    {
        global $base_datos;

        //$id_idioma = mysql_real_escape_string($id_idioma);
        
        $consulta = "DELETE FROM colecciones WHERE id_coleccion = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica un registro existente:
    function modificar($id, $nombre)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        //$id_idioma = mysql_real_escape_string($id_idioma);
        $nombre = mysql_real_escape_string($nombre);

        $consulta = "UPDATE colecciones SET nombre_coleccion = '".trim($nombre)."' WHERE id_coleccion = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de colecciones</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('registro_nuevo').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de colecciones</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
