<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "constantes_predefinidas.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }

    //Funcion que devuelve una matriz con las constantes predefinidas y su valor por defecto:
    function constantes_predefinidas()
    {
        $constantes = Array(
                                "MOSTRAR_ERRORES" => 0,
                                
                                "IDIOMA_POR_DEFECTO" => 1,
                                "RESOLUCION_POR_DEFECTO" => 800,

                                "EMAIL_POR_DEFECTO" => "albapatch@albapatch.com",
                                "EMAIL_RESPUESTAS" => "EMAIL_POR_DEFECTO",
                                "EMAIL_CONTACTO" => "contacto@albapatch.com",
                                "EMAIL_CONTACTO_PUBLICO" => "contacto_no_spam@albapatch.com",
                                "EMAIL_PEDIDOS" => "pedidos@albapatch.com",
                                "EMAIL_PEDIDOS_PUBLICO" => "pedidos_no_spam@albapatch.com",
                                "EMAIL_ERRORES_ADVERTENCIAS" => "errores@albapatch.com",
                                "EMAIL_REGISTRO" => "registro@albapatch.com",

                                "PREFIJO_PAIS" => "+34",
                                "TELEFONO_FIJO" => "977 77 20 21",
                                "TELEFONO_MOVIL" => "",
                                "CONTESTADOR" => "TELEFONO_FIJO",
                                "FAX" => "977 77 12 77",
                                "TELEFONO_REGISTRO" => "TELEFONO_FIJO",
                                
                                "USAR_SISTEMA_LOGIN" => 1,
                                "PODER_REGISTRARSE" => 1,

                                "WEB_URL" => "http://www.albapatch.com",
                                "WEB_URL2" => "http://www.albapatchwork.com",
                                "DIRECCION" => "C/ Orient, 10 bajos B<br>43204 Reus<br>Tarragona<br>Spain",
                                "WEB_TITULO" => "Alba Patchwork",

                                "COLOR_TEXTO_GENERAL" => "#000000",
                                "COLOR_LINK" => "#111111",
                                "COLOR_LINK_ACTIVE" => "#000000",
                                "COLOR_LINK_OVER" => "#aa0000",
                                "COLOR_LINK_VISITED" => "COLOR_LINK",

                                "COLOR_LINK2" => "#5555cc",
                                "COLOR_LINK_ACTIVE2" => "#ff0000",
                                "COLOR_LINK_OVER2" => "#aa0000",
                                "COLOR_LINK_VISITED2" => "COLOR_LINK2",

                                "COLOR_LINK_MENU" => "#ffffff",
                                "COLOR_LINK_ACTIVE_MENU" => "#000000",
                                "COLOR_LINK_OVER_MENU" => "COLOR_LINK_ACTIVE_MENU",
                                "COLOR_LINK_VISITED_MENU" => "COLOR_LINK_MENU",

                                "COLOR_LINK_MENU2" => "#aaddff",
                                "COLOR_LINK_ACTIVE_MENU2" => "#000000",
                                "COLOR_LINK_OVER_MENU2" => "COLOR_LINK_ACTIVE_MENU2",
                                "COLOR_LINK_VISITED_MENU2" => "COLOR_LINK_MENU2",
                                
                                "COLOR_TEXTO_SITUACION_ACTUAL" => "#0000aa",
                                
                                "COLOR_TEXTO_SUBCATEGORIAS_TABLA_MENU" => "#ffffff",
                                "COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU1" => "#4581c4",
                                "COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU2" => "#4571d4",

                                "COLOR_BACKGROUND" => "#4571c4",
                                "COLOR_TABLA_PRINCIPAL" => "#ffffff",
                                "COLOR_MENU_PRINCIPAL" => "#3173f7",
                                "COLOR_MARGENES_PRINCIPALES" => "#95c7f9",
                                "COLOR_TEXTO_AUTOR" => "#45aad4",
                                "COLOR_MENU_RECUADRO1" => "#0066bb",
                                "COLOR_MENU_RECUADRO2" => "#0055bb",

                                "COLOR_PRODUCTO_RECUADRO1" => "COLOR_MENU_RECUADRO1",
                                "COLOR_PRODUCTO_RECUADRO2" => "COLOR_MENU_RECUADRO2",
                                
                                "ENVIAR_EMAIL_SI_ERROR" => 1,
                                
                                "IMAGENES_PRODUCTOS_ZOOM_ANCHO" => 480,
                                "IMAGENES_PRODUCTOS_ZOOM_ALTO" => 480,
                                "IMAGENES_PRODUCTOS_MINI_ANCHO" => 96,
                                "IMAGENES_PRODUCTOS_MINI_ALTO" => 96,
                                "IMAGENES_PRODUCTOS_ZOOM_BYTES_MAXIMO" => 512000,
                                "IMAGENES_PRODUCTOS_MINI_BYTES_MAXIMO" => 102400,

                                "IMAGENES_GALERIA_ZOOM_ANCHO" => 640,
                                "IMAGENES_GALERIA_ZOOM_ALTO" => 480,
                                "IMAGENES_GALERIA_MINI_ANCHO" => 192,
                                "IMAGENES_GALERIA_MINI_ALTO" => 192,
                                "IMAGENES_GALERIA_ZOOM_BYTES_MAXIMO" => 1024000,
                                "IMAGENES_GALERIA_MINI_BYTES_MAXIMO" => 204800,
                                
                                "USAR_MENU_DHTML" => 1,

                                "USAR_AJAX" => 1,
                                
                                "METROS_PIEZA_POR_DEFECTO" => 13.7,
                                "MINIMO_CENTIMETROS_NORMAL_POR_DEFECTO" => 25,
                                "MINIMO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO" => 100,
                                "INCREMENTO_CENTIMETROS_NORMAL_POR_DEFECTO" => 5,
                                "INCREMENTO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO" => 5,

                                "BUSCAR_ARCHIVO" => "buscar.php",
                                "BUSCAR_ID" => -1,
                                
                                "INICIO_ARCHIVO" => "index.php",
                                "INICIO_ID" => 1,

                                "CESTA_ARCHIVO" => "cesta.php",
                                "CESTA_ID" => 2,
                                
                                "PEDIDO_ARCHIVO" => "pedido.php",
                                "PEDIDO_ID" => 3,

                                "CONTACTO_ARCHIVO" => "contacto.php",
                                "CONTACTO_ID" => 4,

                                //"HISTORIA_ARCHIVO" => "historia.php",
                                //"HISTORIA_ID" => 5,

                                "GALERIA_ARCHIVO" => "galeria.php",
                                "GALERIA_ID" => 5,

                                //"TALLER_ARCHIVO" => "taller.php",
                                //"TALLER_ID" => 7
                                
                                "NOVEDADES_ID" => 6,
                                
                                "OFERTAS_ID" => 7,

                                "GASTOS_ENVIO" => 7.5

                            );
        
        return $constantes;
    }


    //Funcion que devuelve una matriz con las constantes existentes en la base de datos:
    function constantes_base_datos()
    {
        global $base_datos;
        
        $consulta = "SELECT * FROM constantes;";
        $resultado = mysql_query($consulta) or die(mysql_error());
    
        $constantes = Array();
        while ($row = mysql_fetch_assoc($resultado))
        {
            $constante = $row["constante"];
            $valor = $row["valor"];
            $constantes[$constante] = $valor;
        }

        return $constantes;
    }


    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        return recoger_post("accion");
    }


    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;

        $constantes = constantes_predefinidas();
        $constantes_bd = constantes_base_datos();

        echo '<center><form method="post" action="' . $this_file . '"><table width="700" border="1" align="center">';

        foreach ($constantes as $constante => $valor_por_defecto)
        {
            //$constante = htmlentities($constante);
            $valor_por_defecto = htmlentities($valor_por_defecto);
            echo '<tr>';
            echo '<td class="par">' . htmlentities($constante) . '<br><span class="destacado" style="cursor:pointer; cursor:hand;" onClick="document.getElementById(\'' . htmlentities($constante) . '\').value = \'' . $valor_por_defecto . '\';">usar por defecto</span></td>';
            if (!isset($constantes_bd[$constante])) { $constantes_bd[$constante] = ""; }
            echo '<td class="impar"><input type="text" value="' . htmlentities($constantes_bd[$constante]) . '" size="60" name="' . htmlentities($constante) . '" id="' . htmlentities($constante) . '"></td>';
            echo '</tr>';
        }
        
        $consulta = "SELECT * FROM constantes ORDER BY constante";
        $resultados = $base_datos->haz_consulta($consulta);

        echo '<tr><td colspan="2"><span class="destacado" style="cursor:pointer; cursor:hand;" onClick="rellenar_valor_por_defecto();">Rellenar con valores por defecto</span><br><br>';
        echo '<input type="hidden" name="accion" value="modificar">';
        echo '<input type="submit" name="boton" value="Modificar"></td></tr>';

        
        echo "</table></form></center>";
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        global $base_datos;
        
        $constantes = constantes_predefinidas();

        $operacion1 = $operacion2 = TRUE;

        foreach ($constantes as $constante => $valor_por_defecto)
        {
            //Recoge la variable enviada por post:
            $valor = mysql_real_escape_string(trim(recoger_post($constante)));
            
            //Borra la constante:
            $operacion = borrar_constante($constante);
            if (!$operacion) { $operacion1 = FALSE; }
            
            //Si no esta vacia, inserta la nueva constante enviada:
            if ($constante && $constante != "")
            {
                $operacion = insertar_constante($constante, $valor);
                if (!$operacion) { $operacion2 = FALSE; }
            }
        }
        
        //Notifica como han ido las cosas:
        if ($operacion1 && $operacion2) { echo "Constantes modificadas correctamente<br>"; }
        else { echo "No se pudo realizar correctamente la operaci&oacute;n.<br>"; }
    }

    
    //Funcion que borra una constante:
    function borrar_constante($constante)
    {
        global $base_datos;

        $consulta = "DELETE FROM constantes WHERE constante LIKE '%$constante%';";
        $operacion = mysql_query($consulta) or die(mysql_error());
        
        return $operacion;
        
    }


    //Funcion que inserta una constante con su valor:
    function insertar_constante($constante, $valor)
    {
        global $base_datos;

        $consulta = "INSERT INTO constantes (constante, valor) VALUES ('$constante', '$valor');";
        $operacion = mysql_query($consulta) or die(mysql_error());
        
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de constantes predefinidas</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function rellenar_valor_por_defecto()
            {
                if (!confirm("Pulsa aceptar si quieres rellenar todos los campos con su valor por defecto (los que tengan).\nSe perdera lo que haya escrito en ellos.")) { return; }

                <?php
                    $constantes = constantes_predefinidas();
    
                    foreach ($constantes as $constante => $valor_por_defecto)
                    {
                        echo "document.getElementById('$constante').value = '$valor_por_defecto';";
                    }
                ?>
            }
        // -->
        </script>
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de constantes predefinidas</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
