<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "cuentas_particulares.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM particulares ORDER BY nombre";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        ATENCI&Oacute;N: <b>sensible a may&uacute;sculas y min&uacute;sculas.</b>
        <br>
        <br>
        <table align="center" width="620">
            <tr>
                <td class="impar" width="400" valign="middle">Modificar cuenta</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador = 0;
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id = $row["id_particular"];
            $nombre = $row["nombre"];
            
            $consulta = "SELECT * FROM compradores_particulares WHERE id_particular = $id";
            $resultados2 = $base_datos->haz_consulta($consulta);
            $row2 = mysql_fetch_assoc($resultados2);
            $usuario = $row2["usuario"];
            $clave = $row2["clave"];
            ?>
            <br>
            <table align="center" width="620">
                <tr>
                    <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('usuario_<?php echo $contador; ?>').value == '' || document.getElementById('clave_<?php echo $contador; ?>').value == '') { alert('Se deben rellenar todos los campos para poder enviar el formulario'); return false; }">
                    <td class="<?php echo $par_impar; ?>" width="400" valign="middle">
                        <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                        <input type="hidden" name="accion" value="modificar">
                        Nombre: <i><?php echo $nombre; ?></i>
                        <br>
                        <br>
                        <table border="1">
                            <tr>
                                <td>
                                    Usuario:
                                </td>
                                <td>
                                    <input type="text" name="usuario" id="usuario_<?php echo $contador; ?>" value="<?php echo htmlentities($usuario); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Clave:
                                </td>
                                <td>
                                    <input type="text" name="clave" id="clave_<?php echo $contador; ?>" value="<?php echo htmlentities($clave); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <input type="submit" name="boton" value="Modificar">
                                </td>
                            </tr>
                        </table>
                    </td>
                    </form>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($nombre))); ?>');">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador++;
        }

        ?>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $id = recoger_post("id");
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'eliminar':
                if ($id != "" && is_numeric($id))
                {
                    $operacion = eliminar($id);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar la cuenta para el registro con id <b>" . htmlentities($id) . "</b>."); }
                    else { echo "Cuenta para registro con id <b>" . htmlentities($id) . "</b> eliminada<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar la cuenta para el registro con id <b>" . htmlentities($id) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                if ($id != "" && is_numeric($id))
                {
                    $operacion = modificar($id);
                    if (!$operacion) { mostrar_error("No se ha podido modificar la cuenta para el registro con id <b>" . htmlentities($id) . "</b>."); }
                    else { echo "Cuenta para el registro con id '" . htmlentities($id) . "' modificada.<br>"; }
                } else { mostrar_advertencia("No se ha podido modificar la cuenta para el registro con id <b>" . htmlentities($id) . "</b>, puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un registro o no:
    function existe($usuario, $id)
    {
        global $base_datos;
        
        $usuario = mysql_real_escape_string($usuario);
        
        $consulta = "SELECT * FROM compradores_particulares WHERE usuario LIKE '$usuario' AND id_particular != $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }

    //Funcion que elimina un registro existente:
    function eliminar($id)
    {
        global $base_datos;

        //$id_idioma = mysql_real_escape_string($id_idioma);
        
        $consulta = "DELETE FROM compradores_particulares WHERE id_particular = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica un registro existente:
    function modificar($id)
    {
        $usuario = recoger_post("usuario");
        $clave = recoger_post("clave");
        
        if (existe($usuario, $id)) { mostrar_error("El usuario <b>" . htmlentities($usuario) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $usuario = mysql_real_escape_string(trim($usuario));
        $clave = mysql_real_escape_string(trim($clave));

        if ($usuario == "" || $clave == "") { mostrar_error("El usuario y la clave nunca deben estar vac&iacute;os."); return FALSE; }
        
        $eliminado = eliminar($id);
        
        if ($eliminado)
        {
            $consulta = "INSERT INTO compradores_particulares (id_particular, usuario, clave) VALUES ($id, '$usuario', '$clave')";
            $operacion = $base_datos->haz_consulta($consulta);
        } else { return FALSE; }
        
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de cuentas de los particulares</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar la cuenta del registro " + registro);
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('registro_nuevo').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de cuentas de los particulares</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
