<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "etiquetas_traduccion.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;

        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0 ORDER BY idioma";
        $resultados = $base_datos->haz_consulta($consulta);

        $idiomas = Array();
        $par_impar = "impar";
        echo '<table align="center"><tr><td>Etiqueta</td>';
        while ($row = mysql_fetch_assoc($resultados))
        {
            $idioma = htmlentities($row["idioma"]);
            $id_idioma = $row["id_idioma"];
            echo '<td class="'. $par_impar . '" valign="middle">' . $idioma . '</td>';
            $idiomas[] = $id_idioma;
            $par_impar = ($par_impar == "par") ? "impar" : "par";
        }
        if (mysql_num_rows($resultados) <= 0) { echo '<td>No hay idiomas</td>'; $hay_idiomas = FALSE; }
        else { $hay_idiomas = TRUE; }
        echo '<td>Modificar</td><td>Eliminar</td></tr>';

        //$consulta = "SELECT etiqueta FROM etiquetas_traduccion GROUP BY etiqueta ORDER BY etiqueta";
        $consulta = "SELECT * FROM etiquetas ORDER BY etiqueta";
        $resultados = $base_datos->haz_consulta($consulta);
        while ($row = mysql_fetch_assoc($resultados))
        {
            //$etiqueta = htmlentities($row["etiqueta"]);
            $etiqueta = htmlentities($row["etiqueta"]);
            $id_etiqueta = $row["id_etiqueta"];
            echo "<tr>";
            //echo '<td class="destacado">' . $etiqueta . '</td>';
            $par_impar = "par";
            if ($hay_idiomas)
            {
                ?><form method="post" action="<?php echo $this_file; ?>">
                    <td class="destacado">
                        <input type="text" name="etiqueta" value="<?php echo $etiqueta; ?>" size="30">
                        <br>
                        <?php echo $etiqueta; ?>
                    </td>
                 <?php
                foreach ($idiomas as $id_idioma)
                {
                    $consulta2 = "SELECT texto, eval FROM etiqueta_traduccion WHERE id_etiqueta = $id_etiqueta AND id_idioma = $id_idioma";
                    $resultados2 = $base_datos->haz_consulta($consulta2);
                    $row2 = mysql_fetch_assoc($resultados2);
                    $texto_traducido = $row2["texto"];
                    $eval_texto = $row2["eval"];
                    $checked = ($eval_texto) ? " checked" : "";
                    ?>
                    <td class="<?php echo $par_impar; ?>" valign="middle">
                            <table>
                                <tr>
                                    <td>
                                        <input type="text" size="20" name="texto_traducido_<?php echo htmlentities(trim($id_idioma)); ?>" value="<?php echo htmlentities($texto_traducido); ?>">
                                    </td>
                                    <td>
                                        <label for="eval_<?php echo htmlentities(trim($id_idioma)); ?>_<?php echo htmlentities(trim($id_etiqueta)); ?>" class="casilla"><input type="checkbox" name="eval_<?php echo htmlentities(trim($id_idioma)); ?>_<?php echo htmlentities(trim($id_etiqueta)); ?>" id="eval_<?php echo htmlentities(trim($id_idioma)); ?>_<?php echo htmlentities(trim($id_etiqueta)); ?>" class="casilla"<?php echo $checked; ?>><br>Eval</label>
                                    </td>
                                </tr>
                            </table>
                    </td>
                    <?php
                    $par_impar = ($par_impar == "par") ? "impar" : "par";
                }
                //echo '<td><input type="hidden" name="accion" value="modificar"><input type="hidden" name="id_etiqueta" value="' . $id_etiqueta . '"><input type="hidden" name="etiqueta" value="' . $etiqueta . '"><input type="submit" name="boton" value="Modificar"></td></form>';
                echo '<td><input type="hidden" name="accion" value="modificar"><input type="hidden" name="id_etiqueta" value="' . $id_etiqueta . '"><input type="submit" name="boton" value="Modificar"></td></form>';
            } else { echo "<td>&nbsp;</td><td>&nbsp;</td>"; }
            echo '<td><form method="post" action="' . $this_file . '" onSubmit="return confirmar_eliminar(\'' . addslashes(htmlentities($etiqueta)) . '\');"><input type="hidden" name="accion" value="eliminar"><input type="hidden" name="id_etiqueta" value="' . $id_etiqueta . '"><input type="hidden" name="etiqueta" value="' . $etiqueta . '"><input type="submit" name="boton" value="Eliminar"></form></td>';
            echo "</tr>";
        }
        //else { echo '<tr><td colspan="3">No hay idiomas</td></tr>'; }
        echo "</table>";
        ?>

            <br>
            <table align="center">
                <tr>
                    <td valign="middle">
                        <?php
                            if (mysql_num_rows($resultados) <= 0) { mostrar_advertencia("No hay etiquetas en la tabla de traducci&oacute;n de etiquetas<br>"); }
                        ?>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('etiqueta_nueva').value == '') { alert('Debes introducir una etiqueta!'); return false; }">
                            <input type="hidden" name="accion" value="agregar">
                            Nueva: <input type="text" name="etiqueta" id="etiqueta_nueva" value="" size="20"> <input type="submit" name="boton" value="Agregar">
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        //global $base_datos;

        $etiqueta = strtoupper(recoger_post("etiqueta"));
        $id_etiqueta = recoger_post("id_etiqueta");
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                if ($etiqueta != "")
                {
                    $operacion = agregar_etiqueta($etiqueta);
                    if (!$operacion) { mostrar_error("No se ha podido agregar la etiqueta <b>" . htmlentities($etiqueta) . "</b>."); }
                    else { echo "Etiqueta <b>" . htmlentities($etiqueta) . "</b> agregada<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar la etiqueta <b>" . htmlentities($etiqueta) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                if ($id_etiqueta != "")
                {
                    $operacion = eliminar_etiqueta($id_etiqueta);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar la etiqueta <b>" . htmlentities($etiqueta) . "</b>."); }
                    else { echo "Etiqueta <b>" . htmlentities($etiqueta) . "</b> eliminada<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar la etiqueta <b>" . htmlentities($etiqueta) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                if ($id_etiqueta != "" && $etiqueta != "")
                {
                    $operacion = modificar_etiqueta($id_etiqueta, $etiqueta);
                    if (!$operacion) { mostrar_error("No se ha podido modificar la etiqueta <b>" . htmlentities($etiqueta) . "</b>."); }
                    else { echo "Etiqueta <b>" . htmlentities($etiqueta) . "</b> modificada.<br>"; }
                } else { mostrar_advertencia("No se ha podido modificar la etiqueta <b>" . htmlentities($etiqueta) . "</b>, puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe una etiqueta o no:
    function existe_etiqueta($etiqueta)
    {
        global $base_datos;
        
        //$etiqueta = mysql_real_escape_string(htmlentities($etiqueta));
        $etiqueta = mysql_real_escape_string($etiqueta);
        
        $consulta = "SELECT * FROM etiquetas WHERE etiqueta LIKE '$etiqueta'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }

    
    //Funcion que devuelve el numero de idiomas existentes:
    function numero_idiomas()
    {
        global $base_datos;
        
        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }


    //Funcion que devuelve el primer id_idioma de la tabla idiomas:
/*    function primer_id_idioma()
    {
        global $base_datos;
        
        $consulta = "SELECT id_idioma FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);
        $matriz_resultados = mysql_fetch_assoc($resultados);
        if (is_array($matriz_resultados) && sizeof($matriz_resultados) > 0 && mysql_num_rows($resultados)) { $id_idioma = $matriz_resultados["id_idioma"]; }
        else { $id_idioma = -1; }
        
        return $id_idioma;
    }*/


    //Funcion que agrega una etiqueta nueva:
    function agregar_etiqueta($etiqueta)
    {
        if (existe_etiqueta($etiqueta)) { mostrar_error("La etiqueta <b>" . htmlentities($etiqueta) . "</b> ya existe."); return FALSE; }
        else if (!numero_idiomas()) { mostrar_error("No se pueden agregar etiquetas si no hay idiomas."); return FALSE; }
        
        global $base_datos;

        $etiqueta = strtoupper(mysql_real_escape_string(trim($etiqueta)));

        //$id_idioma = primer_id_idioma();
        //if ($id_idioma >= 0)
        //{
            $consulta = "INSERT INTO etiquetas (etiqueta) VALUES ('$etiqueta')";
            $operacion = $base_datos->haz_consulta($consulta);
        //} else { mostrar_error("No se ha podido encontrar el valor id_idioma, de cualquier idioma, en la tabla idiomas."); return FALSE; }
        
        return $operacion;
    }
    
    
    //Funcion que elimina una etiqueta existente:
    function eliminar_etiqueta($id_etiqueta)
    {
        global $base_datos;

        //$etiqueta = mysql_real_escape_string($etiqueta);
        
        $consulta = "DELETE FROM etiquetas WHERE id_etiqueta = $id_etiqueta";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica una etiqueta existente:
    function modificar_etiqueta($id_etiqueta, $etiqueta)
    {
        global $base_datos;

        //$etiqueta = strtoupper(mysql_real_escape_string($etiqueta));

        //Recoge los input text de cada idioma de la etiqueta enviada:
        $consulta = "SELECT id_idioma FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);
        $textos_traducidos = Array();
        $evals = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            //$id_idioma = htmlentities(htmlentities(trim($row["id_idioma"])));
            $id_idioma = mysql_real_escape_string(trim($row["id_idioma"]));
            $texto_enviado = recoger_post("texto_traducido_" . $id_idioma);
            $eval_enviado = recoger_post("eval_" . $id_idioma . "_" . htmlentities(trim($id_etiqueta)));
            if (!$texto_enviado) { $texto_enviado = ""; }
            if (!$eval_enviado) { $eval_enviado = FALSE; }
            $textos_traducidos[$id_idioma] = $texto_enviado;
            $evals[$id_idioma] = $eval_enviado;
        }

        $operacion = TRUE;

        //Borra la etiqueta antigua, si existia:
        $consulta = "DELETE FROM etiquetas WHERE id_etiqueta = $id_etiqueta";
        $operacion_actual = $base_datos->haz_consulta($consulta);
        if (!$operacion_actual) { $operacion = FALSE; }

        //Vuelve a poner la etiqueta:
        $consulta = "INSERT INTO etiquetas (id_etiqueta, etiqueta) VALUES ($id_etiqueta, '" . trim($etiqueta) . "')";
        $operacion_actual = $base_datos->haz_consulta($consulta);
        if (!$operacion_actual) { $operacion = FALSE; }
        
        //Inserta las etiquetas nuevas:
        foreach ($textos_traducidos as $k => $v)
        {
            //$k = htmlentities($k);
            $v = (trim($v) != "") ? trim($v) : "";
            if (trim($k) != "" && is_numeric($k))
            {
                $eval = ($evals[$k]) ? 1 : 0;
                $consulta = "INSERT INTO etiqueta_traduccion (id_etiqueta, id_idioma, texto, eval) VALUES (" . $id_etiqueta . ", " . mysql_real_escape_string(trim($k)) . ", '" . mysql_real_escape_string(trim($v)) . "', $eval)";
                $operacion_actual = $base_datos->haz_consulta($consulta);
                if (!$operacion_actual) { $operacion = FALSE; }
            }
        }
       
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de etiquetas traducibles</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('etiqueta_nueva').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de etiquetas traducibles</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
