<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "idiomas.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM idiomas ORDER BY idioma";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <table align="center" width="620">
            <tr>
                <td class="impar" width="100" valign="middle">Activado</td>
                <td class="impar" width="400" valign="middle">Modificar idioma</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador_idiomas = 0;
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_idioma = $row["id_idioma"];
            $idioma = $row["idioma"];
            $checked = ($row["mostrar"]) ? " checked" : "";
            ?>
            <br>
            <table align="center" width="620">
                <tr>
                    <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('idioma_<?php echo $contador_idiomas; ?>').value == '') { alert('El nombre del idioma no puede estar vacio!'); return false; }">
                    <td class="<?php echo $par_impar; ?>" width="100" valign="middle">
                        <input type="checkbox" name="mostrar" class="casilla"<?php echo $checked; ?>>
                    </td>
                    <td class="<?php echo $par_impar; ?>" width="400" valign="middle">
                        <input type="hidden" name="id_idioma" value="<?php echo htmlentities($id_idioma); ?>">
                        <input type="hidden" name="accion" value="modificar">
                        ID: <?php echo $id_idioma; ?> &nbsp;
                        <input type="text" name="idioma" id="idioma_<?php echo $contador_idiomas; ?>" value="<?php echo htmlentities($idioma); ?>"> <input type="submit" name="boton" value="Modificar">
                    </td>
                    </form>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($idioma))); ?>');">
                            <input type="hidden" name="id_idioma" value="<?php echo htmlentities($id_idioma); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="hidden" name="idioma" value="<?php echo htmlentities($idioma); ?>">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador_idiomas++;
        }

        ?>

            <br>
            <table align="center" width="620">
                <tr>
                    <td valign="middle">
                         <?php
                            if (mysql_num_rows($resultados) <= 0) { mostrar_advertencia("No hay idiomas en la tabla de idiomas<br>"); }
                         ?>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('idioma_nuevo').value == '') { alert('Debes introducir un idioma!'); return false; }">
                            <input type="hidden" name="accion" value="agregar">
                            Nuevo: <input type="text" name="idioma" id="idioma_nuevo" value=""> <input type="submit" name="boton" value="Agregar">
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        //global $base_datos;

        $idioma = recoger_post("idioma");
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                if ($idioma != "")
                {
                    $operacion = agregar_idioma($idioma);
                    if (!$operacion) { mostrar_error("No se ha podido agregar el idioma <b>" . htmlentities($idioma) . "</b>."); }
                    else { echo "Idioma <b>" . htmlentities($idioma) . "</b> agregado<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar el idioma <b>" . htmlentities($idioma) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                $id_idioma = recoger_post("id_idioma");
                if ($id_idioma != "" && is_numeric($id_idioma))
                {
                    $operacion = eliminar_idioma($id_idioma);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar el idioma <b>" . htmlentities($idioma) . "</b> (con id '" . htmlentities($id_idioma) . "')."); }
                    else { echo "Idioma <b>" . htmlentities($idioma) . "</b> (con id '$id_idioma') eliminado<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar el idioma <b>" . htmlentities($idioma) . "</b> (con id '" . htmlentities($id_idioma) . "'), puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id_idioma = recoger_post("id_idioma");
                $mostrar = recoger_post("mostrar");
                if ($idioma != "" && $id_idioma != "" && is_numeric($id_idioma))
                {
                    $operacion = modificar_idioma($id_idioma, $idioma, $mostrar);
                    if (!$operacion) { mostrar_error("No se ha podido modificar el idioma <b>" . htmlentities($idioma) . "</b> (con id '" . htmlentities($id_idioma) . "')."); }
                    else { $mostrar = ($mostrar) ? "activado" : "desactivado"; echo "Idioma con id '" . htmlentities($id_idioma) . "' modificado a <b>" . htmlentities($idioma) . "</b> ($mostrar)<br>"; }
                } else { mostrar_advertencia("No se ha podido modificar el idioma <b>" . htmlentities($idioma) . "</b> (con id '" . htmlentities($id_idioma) . "'), puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un idioma o no:
    function existe_idioma($idioma)
    {
        global $base_datos;
        
        //$idioma = mysql_real_escape_string(htmlentities($idioma));
        $idioma = strtolower(mysql_real_escape_string($idioma));
        
        $consulta = "SELECT * FROM idiomas WHERE idioma LIKE '$idioma'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }


    //Funcion que agrega un idioma nuevo:
    function agregar_idioma($idioma)
    {
        if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        //$idioma = strtolower(mysql_real_escape_string(htmlentities(trim($idioma))));
        $idioma = strtolower(mysql_real_escape_string(trim($idioma)));
        
        $consulta = "INSERT INTO idiomas (idioma) VALUES ('$idioma')";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que elimina un idioma existente:
    function eliminar_idioma($id_idioma)
    {
        global $base_datos;

        //$id_idioma = mysql_real_escape_string($id_idioma);
        
        $consulta = "DELETE FROM idiomas WHERE id_idioma = $id_idioma";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica un idioma existente:
    function modificar_idioma($id_idioma, $idioma, $mostrar)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        //$id_idioma = mysql_real_escape_string($id_idioma);
        //$idioma = strtolower(mysql_real_escape_string(htmlentities($idioma)));
        $idioma = strtolower(mysql_real_escape_string($idioma));
        $mostrar = ($mostrar) ? 1 : 0;

        $consulta = "UPDATE idiomas SET idioma = '".trim($idioma)."', mostrar = '$mostrar' WHERE id_idioma = $id_idioma";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de idiomas</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('idioma_nuevo').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de idiomas</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();
            
            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
