<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    //Guarda que pagina es esta:
    $this_file = "menu_subgrupos.php";

    //Funcion que devuelve las categorias principales en una matriz:
    function obtener_categorias()
    {
        global $base_datos, $constantes;
        $categorias = Array();
        
        if (!isset($constantes["IDIOMA_POR_DEFECTO"]) || isset($constantes["IDIOMA_POR_DEFECTO"]) && (trim($constantes["IDIOMA_POR_DEFECTO"]) == "" || !is_numeric(trim($constantes["IDIOMA_POR_DEFECTO"])))) { mostrar_error('No se pudo recoger un idioma por defecto. Por favor, define la constante del idioma por defecto en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else { $idioma_por_defecto = $constantes["IDIOMA_POR_DEFECTO"]; }
        
        $consulta = "SELECT * FROM categorias AS a JOIN categoria_idioma AS b WHERE mostrar != 0 AND raiz = 0 AND a.id_categoria = b.id_categoria AND b.id_idioma = $idioma_por_defecto";
        $resultados = $base_datos->haz_consulta($consulta);
        
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            $nombre_categoria = $row["nombre_categoria"];
            $categorias[$id_categoria] = $nombre_categoria;
        }
        
        return $categorias;
    }

    
    //Funcion que obtiene las categorias que ya estan en un subgrupo:
    function obtener_categorias_subgrupo($id_subgrupo, $insertadas = TRUE)
    {
        global $base_datos;
        
        if (!$insertadas) { $consulta = "SELECT * FROM categorias AS a WHERE a.id_categoria NOT IN (SELECT b.id_categoria FROM menu_subgrupos_categorias AS b WHERE id_subgrupo = $id_subgrupo)"; }
        else { $consulta = "SELECT * FROM categorias AS a JOIN menu_subgrupos_categorias AS b WHERE a.id_categoria = b.id_categoria AND id_subgrupo = $id_subgrupo ORDER BY b.orden"; }
        
        $resultados = $base_datos->haz_consulta($consulta);
        
        //echo "yyyyyyyyy";
        
        $categorias_subgrupo = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            if (isset($row["orden"]) && trim($row["orden"]) != "" && is_numeric($row["orden"]))
            {
                $orden = $row["orden"];
                $categorias_subgrupo[$id_categoria] = $orden;
            }
            //else { $categorias_subgrupo[] = $id_categoria; }
            else { $categorias_subgrupo[$id_categoria] = 0; }
        }
        return $categorias_subgrupo;
    }


    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        return recoger_post("accion");
    }


    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;

        $categorias = obtener_categorias();

        $consulta = "SELECT * FROM menu_subgrupos ORDER BY orden";
        $resultados = $base_datos->haz_consulta($consulta);

        if (mysql_num_rows($resultados) > 0)
        {
        echo '<center><form method="post" action="' . $this_file . '"><input type="hidden" name="accion" value="modificar"><table width="850" border="1" align="center">';

        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_subgrupo = $row["id_subgrupo"];
            $orden_subgrupo = $row["orden"];
            $categorias_subgrupo = obtener_categorias_subgrupo($id_subgrupo, true);
            $categorias_subgrupo_restantes = obtener_categorias_subgrupo($id_subgrupo, false);
            echo '<tr>';
            echo '<td class="par" valign="top" width="425"><div align="left">';
            echo '<label for="eliminar_' . $id_subgrupo . '"><input type="checkbox" name="eliminar_' . $id_subgrupo . '" id="eliminar_' . $id_subgrupo . '" class="casilla"> Eliminar</label><br><br>';
            echo 'Orden: <input type="text" name="orden_' . $id_subgrupo . '" size="2" maxlength="2" value="' . $orden_subgrupo . '"><br><br>';
            echo 'Categor&iacute;as:<br>';
            echo '<center><select multiple name="categorias_' . $id_subgrupo . '[]" size="10" width="280" style="width:280px;">';
            print_r($categorias_subgrupo_restantes);
            echo "<br><br>HOLA (subgrupo $id_subgrupo)<br><br>";
            //foreach ($categorias_subgrupo_restantes as $id_categoria)
            foreach ($categorias_subgrupo_restantes as $id_categoria => $orden_categoria)
            {
                if (isset($categorias) && isset($id_categoria) && isset($categorias[$id_categoria]))
                {
                    $nombre_categoria = $categorias[$id_categoria];
                    echo '<option value="' . $id_categoria . '">' .$nombre_categoria . '</option>';
                }
            }
            echo '</select></center>';
            echo '</div></td><td class="impar" valign="top" width="425">';
            echo '<br><br><center>';
            echo '<table border="1" align="center" width="380">';
            echo '<tr><td class="destacado">Orden de las categor&iacute;as:</td><td class="destacado">Eliminar</td></tr>';
            //$consulta = "SELECT * FROM categorias AS a JOIN menu_subgrupos_categorias AS b WHERE a.id_categoria = b.id_categoria AND b.id_subgrupo = $id_subgrupo ORDER BY b.orden";
            //$resultados2 = $base_datos->haz_consulta($consulta);
            //while ($row2 = mysql_fetch_assoc($resultados2))
            foreach ($categorias_subgrupo as $id_categoria => $orden_categoria)
            {
                if (isset($categorias) && isset($id_categoria) && isset($categorias[$id_categoria]))
                {
                    $nombre_categoria = $categorias[$id_categoria];
                    echo '<tr>';
                    echo '<td align="left">';
                    echo '<div align="left"><input type="text" name="orden_subgrupo_' . $id_subgrupo . '_categoria_' . $id_categoria . '" size="2" maxlength="2" value="' . $orden_categoria . '"> ' . $nombre_categoria . '</div>';
                    echo '</td><td><center>';
                    echo '<label for="eliminar_subgrupo_' . $id_subgrupo . '_categoria_' . $id_categoria . '"><input type="checkbox" name="eliminar_subgrupo_' . $id_subgrupo . '_categoria_' . $id_categoria . '" id="eliminar_subgrupo_' . $id_subgrupo . '_categoria_' . $id_categoria . '" class="casilla"> Eliminar</label><br><br>';
                    echo '</center></td>';
                    echo '</tr>';
                }
            }
            echo "</table>";
            echo '</center></td>';
            echo '</tr>';
        }
        
        echo '<tr><td colspan="2"><input type="submit" name="boton" value="Modificar"></td></tr></table></form><br>';
        }
        else { echo "<center>No hay subgrupos en la tabla de los subgrupos del men&uacute;</center><br>"; }
        
        echo '<table border="1" width="850" align="center"><tr><td class="destacado"><form method="post" action="' . $this_file . '"><input type="hidden" name="accion" value="agregar"><input type="submit" name="boton" value="Agregar subgrupo"></form></td></tr></table></center>';
        
        //$consulta = "SELECT * FROM constantes ORDER BY constante";
        //$resultados = $base_datos->haz_consulta($consulta);
    }


    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $accion = recoger_post("accion");
        
        switch ($accion)
        {
            case "agregar":
                $operacion = insertar_subgrupo();
                if ($operacion) { mostrar_advertencia("Subgrupo insertado"); }
                else { mostrar_error("No se pudo insertar un nuevo subgrupo"); }
                break;
            case 'modificar':
                $operacion = modificar_subgrupos();
                if ($operacion) { mostrar_advertencia("Subgrupos modificados"); }
                else { mostrar_error("No se pudieron modificar los subgrupos"); }
                break;
        }
    }    


    //Funcion que inserta un subgrupo (vacio):
    function insertar_subgrupo()
    {
        global $base_datos;

        $consulta = "INSERT INTO menu_subgrupos (orden) VALUES (0)";
        $resultados = $base_datos->haz_consulta($consulta);
       
        return $resultados;
    }


    //Funcion que modifica los subgrupos con los valores enviados por formulario:
    function modificar_subgrupos()
    {
        global $base_datos;

        $operacion = TRUE;

        $consulta = "SELECT * FROM menu_subgrupos ORDER BY orden";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (!$resultados) { $operacion = FALSE; }

        $categorias = obtener_categorias();
        
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_subgrupo = $row["id_subgrupo"];
            $eliminar = recoger_post("eliminar_" . $id_subgrupo);
            $orden = recoger_post("orden_" . $id_subgrupo);
            $categorias_subgrupo = recoger_post("categorias_" . $id_subgrupo);

            //Si se ha enviado eliminar el subgrupo, lo elimina y se salta este loop:
            if ($eliminar)
            {
                eliminar_subgrupo($id_subgrupo);
                continue;
            }
            else
            {
//            echo "<br><br><br>Id subgrupo: $id_subgrupo, Eliminar: $eliminar, orden: $orden<br>Categorias a insertar: ";

                modificar_subgrupo_orden($id_subgrupo, $orden);

                if (is_array($categorias_subgrupo))
                {
                    foreach ($categorias_subgrupo as $id_categoria)
                    {
    //                    echo $categorias[$id_categoria] . "($id_categoria), ";
                        $resultado = insertar_categoria_subgrupo($id_subgrupo, $id_categoria);
                        if (!$resultado) { $operacion = FALSE; }
                    }
                }

//            echo "<br>Categorias ya insertadas: ";

                $consulta = "SELECT * FROM categorias AS a JOIN menu_subgrupos_categorias AS b WHERE a.id_categoria = b.id_categoria AND b.id_subgrupo = $id_subgrupo ORDER BY b.orden";
                $resultados2 = $base_datos->haz_consulta($consulta);
                while ($row2 = mysql_fetch_assoc($resultados2))
                {
                    $id_categoria = $row2["id_categoria"];
    //                echo $categorias[$id_categoria] . "($id_categoria), ";
                    $eliminar_categoria = recoger_post("eliminar_subgrupo_" . $id_subgrupo . "_categoria_" . $id_categoria);
                    $orden_categoria = recoger_post("orden_subgrupo_" . $id_subgrupo . "_categoria_" . $id_categoria);
                    if ($orden_categoria && trim($orden_categoria) != "" && is_numeric($orden_categoria)) { modificar_categoria_insertada($id_subgrupo, $id_categoria, $orden_categoria); }
                    if ($eliminar_categoria) { eliminar_categoria_subgrupo($id_subgrupo, $id_categoria); }
                }
            }
        }
        
        return $operacion;
    }


    //Funcion que elimina el orden de un subgrupo:
    function modificar_subgrupo_orden($id_subgrupo, $orden)
    {
        global $base_datos;
        
        $consulta = "UPDATE menu_subgrupos SET orden = $orden WHERE id_subgrupo = $id_subgrupo;";
        $operacion = $base_datos->haz_consulta($consulta);

        return $operacion;        
    }


    //Funcion que elimina un subgrupo:
    function eliminar_subgrupo($id_subgrupo)
    {
        global $base_datos;
        
        $consulta = "DELETE FROM menu_subgrupos WHERE id_subgrupo = $id_subgrupo;";
        $operacion = $base_datos->haz_consulta($consulta);

        return $operacion;        
    }

    
    //Funcion que inserta una categoria en un subgrupo:
    function insertar_categoria_subgrupo($id_subgrupo, $id_categoria)
    {
        global $base_datos;
        
        //Si el valor ya existe, sale de la funcion:
        $consulta = "SELECT * FROM menu_subgrupos_categorias WHERE id_subgrupo = $id_subgrupo AND id_categoria = $id_categoria;";
        $operacion = $base_datos->haz_consulta($consulta);
        if (mysql_num_rows($operacion) > 0) { return $operacion; }
        
        
        $consulta = "INSERT INTO menu_subgrupos_categorias (id_subgrupo, id_categoria) VALUES ($id_subgrupo, $id_categoria);";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica el orden de una categoria ya insertada:
    function modificar_categoria_insertada($id_subgrupo, $id_categoria, $orden = 0)
    {
        global $base_datos;

        $consulta = "UPDATE menu_subgrupos_categorias SET orden = $orden WHERE id_subgrupo = $id_subgrupo AND id_categoria = $id_categoria;";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }


    //Funcion que elimina una categoria de un subgrupo:
    function eliminar_categoria_subgrupo($id_subgrupo, $id_categoria)
    {
        global $base_datos;

        $consulta = "DELETE FROM menu_subgrupos_categorias WHERE id_subgrupo = $id_subgrupo AND id_categoria = $id_categoria;";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }

?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n del men&uacute; principal</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
        // -->
        </script>
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n del men&uacute; principal</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";
            
            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Incluye las constantes de la base de datos (es necesaria la del idioma por defecto):
            require_once "../cod/func/constantes.php";

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
