<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "monedas.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM monedas_respecto_euro ORDER BY moneda";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <center>
        <br>
        <br>
        <table align="center" width="620">
            <tr>
                <td class="impar" width="400" valign="middle">Modificar moneda</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador = 0;
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id = $row["id_moneda"];
            $nombre = $row["moneda"];
            $valor = $row["valor_respecto_euro"];
            ?>
            
            <br>
            <table align="center" width="620">
                <tr>
                    <form method="post" action="<?php echo $this_file; ?>" onSubmit="return comprobar_formulario(<?php echo $contador; ?>);">
                    <td class="<?php echo $par_impar; ?>" width="400" valign="middle">
                        <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                        <input type="hidden" name="accion" value="modificar">
                        Nombre: <i><?php echo htmlentities($nombre); ?></i>
                        <br>
                        <br>
                        <table border="1">
                            <tr>
                                <td>
                                    Moneda:
                                </td>
                                <td>
                                    <input type="text" name="moneda" id="moneda_<?php echo $contador; ?>" value="<?php echo htmlentities($nombre); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Valor respecto al Euro:
                                </td>
                                <td>
                                    <input type="text" name="valor" id="valor_<?php echo $contador; ?>" value="<?php echo htmlentities($valor); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <input type="submit" name="boton" value="Modificar">
                                </td>
                            </tr>
                        </table>
                    </td>
                    </form>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($nombre))); ?>');">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador++;
        }
        ?>
        
        <br>
        <br>
        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return comprobar_formulario('nuevo');">
            <input type="hidden" name="accion" value="agregar">
            <table border="1">
                <tr>
                    <td>
                        Moneda:
                    </td>
                    <td>
                        <input type="text" name="moneda" id="moneda_nuevo" value="">
                    </td>
                </tr>
                <tr>
                    <td>
                        Valor respecto al Euro:
                    </td>
                    <td>
                        <input type="text" name="valor" id="valor_nuevo" value="">
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <input type="submit" name="boton" value="Agregar">
                    </td>
                </tr>
            </table>
        </form>

        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                $operacion = agregar();
                if (!$operacion) { mostrar_error("No se pudo agregar la nueva moneda"); }
                else { mostrar_advertencia("Nueva moneda agregada."); }
                break;
            case 'eliminar':
                $id = recoger_post("id");
                if ($id != "" && is_numeric($id))
                {
                    $operacion = eliminar($id);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar la moneda con id <b>" . htmlentities($id) . "</b>."); }
                    else { echo "Moneda con id <b>" . htmlentities($id) . "</b> eliminada<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar la moneda con id <b>" . htmlentities($id) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id = recoger_post("id");
                if ($id != "" && is_numeric($id))
                {
                    $operacion = modificar($id);
                    if (!$operacion) { mostrar_error("No se ha podido modificar la moneda con id <b>" . htmlentities($id) . "</b>."); }
                    else { echo "Moneda con id '" . htmlentities($id) . "' modificada.<br>"; }
                } else { mostrar_advertencia("No se ha podido modificar la moneda con id <b>" . htmlentities($id) . "</b>, puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un registro o no:
    function existe($moneda)
    {
        global $base_datos;
        
        $moneda = mysql_real_escape_string(trim($moneda));
        
        $consulta = "SELECT * FROM monedas_respecto_euro WHERE moneda LIKE '$moneda'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }


    //Funcion que calcula si ya existe un registro o no que no sea el mismo ID:
    function existe_otro($moneda, $id)
    {
        global $base_datos;
        
        $moneda = mysql_real_escape_string(trim($moneda));
        $id = mysql_real_escape_string(trim($id));
        
        $consulta = "SELECT * FROM monedas_respecto_euro WHERE moneda LIKE '$moneda' AND id_moneda != $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }

    //Funcion que agrega un registro nuevo:
    function agregar()
    {
        $moneda = recoger_post("moneda");
        $valor = recoger_post("valor");
        
        if (existe($moneda)) { mostrar_error("El registro <b>" . htmlentities($moneda) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $moneda = strtolower(mysql_real_escape_string(trim($moneda)));
        $valor = strtolower(mysql_real_escape_string(trim($valor)));
        
        $consulta = "INSERT INTO monedas_respecto_euro (moneda, valor_respecto_euro) VALUES ('$moneda', $valor)";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }


    //Funcion que elimina un registro existente:
    function eliminar($id)
    {
        global $base_datos;

        //$id_idioma = mysql_real_escape_string($id_idioma);
        
        $consulta = "DELETE FROM monedas_respecto_euro WHERE id_moneda = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica un registro existente:
    function modificar($id)
    {
        $moneda = recoger_post("moneda");
        $valor = recoger_post("valor");
        
        if (existe_otro($moneda, $id)) { mostrar_error("El registro <b>" . htmlentities($moneda) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $moneda = mysql_real_escape_string(trim($moneda));
        $valor = mysql_real_escape_string(trim($valor));

        if ($moneda == "" || $valor == "") { mostrar_error("El nombre de la moneda y su valor nunca deben estar vac&iacute;os."); return FALSE; }
        
        $consulta = "UPDATE monedas_respecto_euro SET moneda = '$moneda', valor_respecto_euro = $valor";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de monedas</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar la moneda " + registro);
            }
            
            function comprobar_formulario(coletilla)
            {
                var errores = "";
                if (document.getElementById('moneda_' + coletilla).value == '') { errores += "* El campo MONEDA debe ser rellenado.\n"; }
                if (document.getElementById('valor_' + coletilla).value == '' || isNaN(document.getElementById('valor_' + coletilla).value)) { errores += "* El campo VALOR RESPECTO AL EURO debe ser rellenado y con un valor numerico.\n"; }
                
                if (errores != "") { alert("No se puede enviar el formulario porque:\n" + errores); }
                
                return (errores == "");
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('moneda_nuevo').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de monedas</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
