<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    //Incluye el archivo necesario para validar E-Mails:
    require_once "../cod/func/web/validar_email.php";

    
    //Guarda que pagina es esta:
    $this_file = "precio_grupos.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }

    //Funcion que inserta o borra los centimetros de la base de datos:
    function procesar_centimetros($id, $ref)
    {
        global $base_datos, $constantes;

        $id = mysql_real_escape_string(htmlentities($id));
        $ref = mysql_real_escape_string(htmlentities($ref));
        
        $minimo_centimetros = recoger_post("minimo_centimetros");
        $incremento_centimetros = recoger_post("incremento_centimetros");
        
        $consulta = "DELETE FROM tela_minimo_centimetros_grupo WHERE ref_tela LIKE '$ref' AND id_grupo = $id";
        $resultados1 = $base_datos->haz_consulta($consulta);
        
        if ($resultados1)
        {
            if ($minimo_centimetros >= 0 && $incremento_centimetros > 0 && ($minimo_centimetros != $constantes["MINIMO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"] || $incremento_centimetros != $constantes["INCREMENTO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"]))
            {
                $consulta = "INSERT INTO tela_minimo_centimetros_grupo (id_grupo, ref_tela, minimo_centimetros, incremento_centimetros) VALUES ($id, '$ref', $minimo_centimetros, $incremento_centimetros)";
                $resultados2 = $base_datos->haz_consulta($consulta);
            }
            else if ($minimo_centimetros < 0 || $incremento_centimetros < 1)
            {
                mostrar_error("El m&iacute;nimo de centimetros es 0, y el m&iacute;nimo de incremento en cent&iacute;metros es 1. Se han puesto los valores por defecto en ambos.");
                $resultados2 = false;
            }
            else { $resultados2 = true; }
        }
        
        return ($resultados1 && $resultados2);
    }
    
    
    //Funcio que retorna el minimo de centimetros para una tela y cuenta:
    function obtener_minimo_centimetros($ref, $id)
    {
        global $base_datos, $constantes;
        
        $minimo_centimetros = $constantes["MINIMO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"];
        
        $consulta = "SELECT * FROM tela_minimo_centimetros_grupo WHERE ref_tela = '$ref' AND id_grupo = $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysql_num_rows($resultados) > 0)
        {
            $row = mysql_fetch_assoc($resultados);
            $minimo_centimetros = $row["minimo_centimetros"];
        }
        
        return $minimo_centimetros;
    }


    //Funcio que retorna el incremento de centimetros para una tela y cuenta:
    function obtener_incremento_centimetros($ref, $id)
    {
        global $base_datos, $constantes;
        
        $incremento_centimetros = $constantes["INCREMENTO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"];

        $consulta = "SELECT * FROM tela_minimo_centimetros_grupo WHERE ref_tela = '$ref' AND id_grupo = $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysql_num_rows($resultados) > 0)
        {
            $row = mysql_fetch_assoc($resultados);
            $incremento_centimetros = $row["incremento_centimetros"];
        }
        
        return $incremento_centimetros;
    }

    //Funcion que muestra el formulario de minimo e incremento de centimetros para esta tela y cuenta:
    function mostrar_formulario_2($ref, $id)
    {
        global $constantes, $this_file;
        ?>
            <form method="post" action="<?php echo $this_file; ?>">
            <table>
                <tr>
                    <td class="destacado">Cent&iacute;metros para esta tela y cuenta</td>
                </tr>
                <tr>
                    <td>
                        <?php
                            $minimo_centimetros = obtener_minimo_centimetros($ref, $id);
                            $incremento_centimetros = obtener_incremento_centimetros($ref, $id);
                        ?>
                        M&iacute;nimo de cent&iacute;metros que se pueden pedir:
                        <input type="text" name="minimo_centimetros" value="<?php echo $minimo_centimetros; ?>">
                        <?php
                            echo "<br>El valor por defecto es: $minimo_centimetros<br>";
                            if ($minimo_centimetros == $constantes["MINIMO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"] && $incremento_centimetros == $constantes["INCREMENTO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"]) { echo 'Utilizando el valor por defecto'; }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td>
                        Cent&iacute;metros para incremento:
                        <input type="text" name="incremento_centimetros" value="<?php echo $incremento_centimetros; ?>">
                        <?php
                            echo "<br>El valor por defecto es: $incremento_centimetros<br>";
                            if ($minimo_centimetros == $constantes["MINIMO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"] && $incremento_centimetros == $constantes["INCREMENTO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"]) { echo 'Utilizando el valor por defecto'; }
                        ?>
                    </td>
                </tr>
                <tr>
                    <td class="destacado">
                        <input type="hidden" name="id_grupo" value="<?php echo htmlentities($id); ?>">
                        <input type="hidden" name="ref" value="<?php echo htmlentities($ref); ?>">
                        <input type="hidden" name="accion" value="modificar_centimetros">
                        <input type="submit" name="boton" value="Modificar">
                    </td>
                </tr>
            </table>
            </form>
            <br>
            <br>
        <?php
    }

    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $ref = recoger_post("ref");
        
        if (!$ref) { mostrar_error("No se pudo recoger una REF de producto."); exit(); }

        $consulta = "SELECT precio_normal FROM productos WHERE ref = '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysql_fetch_assoc($resultados);
        $precio_normal = $row["precio_normal"];
        
        $consulta = "SELECT * FROM grupos";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <table align="center" width="620">
            <tr>
                <td class="impar" width="400" valign="middle">Modificar o Eliminar</td>
                <td class="impar" width="120" valign="middle">Agregar</td>
            </tr>
        </table>
        
        <?php
        
        $contador = 0;
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_grupo = $row["id_grupo"];
            $nombre = $row["nombre_grupo"];
            
            ?>
            <br>
            <table align="center" width="620">
                <tr><td colspan="2" class="destacado">Nombre: <?php echo htmlentities($nombre); ?></td></tr>
                <tr>
                    <td class="<?php echo $par_impar; ?>" width="400" valign="top">
                    
                        <?php mostrar_formulario_2($ref, $id_grupo); ?>
                    
                        <table border="1">
                                    <?php
                                        $consulta = "SELECT * FROM producto_comprador_grupo WHERE ref_producto = '$ref' AND id_grupo = $id_grupo";
                                        $resultados2 = $base_datos->haz_consulta($consulta);
                                        $par_impar_2 = "par";
                                        while ($row2 = mysql_fetch_assoc($resultados2))
                                        {
                                            $id = $row2["id_relacion"];
                                            $precio = $row2["precio"];
                                            $cantidad_minima = $row2["cantidad_minima"];
                                            $piezas = $row2["piezas"];
                                            $piezas_checked = ($piezas) ? " checked" : "";
                                    ?>
                                            <tr>
                                            <td colspan="2" valign="top" class="<?php echo $par_impar_2; ?>">
                                            <form method="post" action="<?php echo $this_file; ?>" onSubmit="return comprobar_formulario(<?php echo $contador; ?>, true);">
                                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                                            <input type="hidden" name="ref" value="<?php echo htmlentities($ref); ?>">
                                            <input type="hidden" name="id_grupo" value="<?php echo htmlentities($id_grupo); ?>">
                                            <input type="hidden" name="accion" value="modificar">
                                            <table border="1">
                                            <tr><td>Precio:</td><td><input type="text" name="precio" id="precio_<?php echo $contador; ?>" value="<?php echo htmlentities($precio); ?>" maxlength="7" size="8"></td></tr>
                                            <tr><td>Cantidad minima:</td><td><input type="text" name="cantidad_minima" id="cantidad_minima_<?php echo $contador; ?>" value="<?php echo htmlentities($cantidad_minima); ?>" maxlength="7" size="8"></td></tr>
                                            <tr><td><label for="piezas_<?php echo $contador; ?>">Son piezas:</td><td><input type="checkbox" name="piezas" id="piezas_<?php echo $contador; ?>" class="casilla"<?php echo htmlentities($piezas_checked); ?>></label></td></tr>
                                            <tr><td colspan="2"><input type="submit" name="boton" value="Modificar"></td></tr>
                                            </form>
                                            <tr>
                                            <td colspan="2">
                                            <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar();">
                                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                                            <input type="hidden" name="ref" value="<?php echo htmlentities($ref); ?>">
                                            <input type="hidden" name="accion" value="eliminar">
                                            <input type="submit" name="boton" value="Eliminar">
                                            </form>
                                            </td>
                                            </tr>
                                            </table>
                                            </td>
                                            </tr>
                                    <?php
                                            $par_impar_2 = ($par_impar_2 == "par") ? "impar" : "par";
                                            $contador++;
                                        }
                                    ?>
                        </table>
                        <br>
                    </td>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="top">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return comprobar_formulario(<?php echo $contador; ?>, false);">
                        <input type="hidden" name="id_grupo" value="<?php echo htmlentities($id_grupo); ?>">
                        <input type="hidden" name="ref" value="<?php echo htmlentities($ref); ?>">
                        <input type="hidden" name="accion" value="agregar">
                        <table border="1">
                        <tr><td>Precio:</td><td><input type="text" name="precio" id="precio_nuevo_<?php echo $contador; ?>" value="" maxlength="7" size="8"></td></tr>
                        <tr><td>Cantidad minima:</td><td><input type="text" name="cantidad_minima" id="cantidad_minima_nuevo_<?php echo $contador; ?>" value="" maxlength="7" size="8"></td></tr>
                        <tr><td><label for="piezas_nuevo_<?php echo $contador; ?>">Son piezas:</td><td><input type="checkbox" name="piezas" id="piezas_nuevo_<?php echo $contador; ?>" class="casilla"></label></td></tr>
                        <tr><td colspan="2"><input type="submit" name="boton" value="Agregar"></td></tr>
                        </form>
                        </table>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador++;
        }

        if (mysql_num_rows($resultados) <= 0)
        {
            ?>
            <br>
            <table align="center" width="620">
                <tr>
                    <td valign="middle">
                         <?php
                            mostrar_advertencia("No hay grupos en la tabla de grupos<br>");
                         ?>
                    </td>
                </tr>
            </table>
            </center>
            <?
        }
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                $id_grupo = recoger_post("id_grupo");
                $ref = recoger_post("ref");
                if ($id_grupo != "" && is_numeric($id_grupo) && $ref != "")
                {
                    $operacion = agregar($id_grupo, $ref);
                    if (!$operacion) { mostrar_error("No se ha podido agregar el nuevo precio."); }
                    else { echo "Nuevo precio agregado<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar el nuevo precio, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                $id_relacion = recoger_post("id");
                if ($id_relacion != "" && is_numeric($id_relacion))
                {
                    $operacion = eliminar($id_relacion);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar el registro con id '" . htmlentities($id_relacion) . "'."); }
                    else { echo "Registro con id '$id_relacion' eliminado<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar el registro con id '" . htmlentities($id_relacion) . "', puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id_relacion = recoger_post("id");
                if ($id_relacion != "" && is_numeric($id_relacion))
                {
                    $operacion = modificar($id_relacion);
                    if (!$operacion) { mostrar_error("No se ha podido modificar el registro con id '" . htmlentities($id_relacion) . "'."); }
                    else { echo "Registro con id '" . htmlentities($id_relacion) . "' modificado</b><br>"; }
                } else { mostrar_advertencia("No se ha podido modificar el registro con id '" . htmlentities($id_relacion) . "', puede que falten datos en el formulario."); }
                break;
            case 'modificar_centimetros':
                $id_grupo = recoger_post("id_grupo");
                $ref = recoger_post("ref");
                if ($id_grupo != "" && is_numeric($id_grupo) && $ref != "")
                {
                    $operacion = procesar_centimetros($id_grupo, $ref);
                    if (!$operacion) { mostrar_error("No se han podido modificar los cent&iacute;metros del registro."); }
                    else { echo "Registro de los cent&iacute;metros modificado</b><br>"; }
                } else { mostrar_advertencia("No se ha podido modificar el registro de los cent&iacute;metros, puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un registro o no:
    function existe($id_grupo, $ref, $precio, $cantidad_minima, $piezas)
    {
        global $base_datos;
        
        $id_grupo = mysql_real_escape_string(htmlentities($id_grupo));
        $ref = mysql_real_escape_string(htmlentities($ref));
        $precio = mysql_real_escape_string(htmlentities($precio));
        $cantidad_minima = mysql_real_escape_string(htmlentities($cantidad_minima));
        $piezas = mysql_real_escape_string(htmlentities($piezas));
        
        $consulta = "SELECT * FROM producto_comprador_grupo WHERE ref_producto = '$ref' AND id_grupo = $id_grupo AND precio = $precio AND cantidad_minima = $cantidad_minima AND piezas = $piezas";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }

    //Funcion que agrega un registro nuevo:
    function agregar($id_grupo, $ref)
    {
        
        $precio = recoger_post("precio");
        $cantidad_minima = recoger_post("cantidad_minima");
        $piezas = recoger_post("piezas");
        $piezas = ($piezas) ? 1 : 0;
        
        if (existe($id_grupo, $ref, $precio, $cantidad_minima, $piezas)) { mostrar_error("Un registro igual ya existe."); return FALSE; }

        global $base_datos;

        $id_grupo = mysql_real_escape_string(htmlentities($id_grupo));
        $ref = mysql_real_escape_string(htmlentities($ref));
        $precio = mysql_real_escape_string(htmlentities($precio));
        $cantidad_minima = mysql_real_escape_string(htmlentities($cantidad_minima));
        
        $consulta = "INSERT INTO producto_comprador_grupo (id_grupo, ref_producto, precio, cantidad_minima, piezas) VALUES ($id_grupo, '$ref', $precio, $cantidad_minima, $piezas)";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que elimina un registro existente:
    function eliminar($id)
    {
        global $base_datos;

        //$id_idioma = mysql_real_escape_string($id_idioma);
        
        $consulta = "DELETE FROM producto_comprador_grupo WHERE id_relacion = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica un registro existente:
    function modificar($id)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        $precio = recoger_post("precio");
        $cantidad_minima = recoger_post("cantidad_minima");
        $piezas = recoger_post("piezas");
        $piezas = ($piezas) ? 1 : 0;

        $id_grupo = recoger_post("id_grupo");
        $ref = recoger_post("ref");
        if (existe($id_grupo, $ref, $precio, $cantidad_minima, $piezas)) { mostrar_error("Un registro igual ya existe."); return FALSE; }

        global $base_datos;

        $precio = mysql_real_escape_string(htmlentities($precio));
        $cantidad_minima = mysql_real_escape_string(htmlentities($cantidad_minima));

        $consulta = "UPDATE producto_comprador_grupo SET precio = ".trim($precio).", cantidad_minima = ".trim($cantidad_minima).", piezas = ".trim($piezas)." WHERE id_relacion = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de precios seg&uacute;n grupos</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar()
            {
                return confirm("Pulsa aceptar para eliminar el registro");
            }
            
            function comprobar_formulario(contador, existente)
            {
                if (!existente) { contador = "nuevo_" + contador; }
                
                var errores = "";
                if (document.getElementById('precio_' + contador).value == '') { errores += "* Falta el campo PRECIO\n"; }
                if (document.getElementById('cantidad_minima_' + contador).value == '') { errores += "* Falta el campo CANTIDAD MINIMA\n"; }
                
                if (errores != "") { alert("No se puede enviar el formulario porque:\n" + errores); return false; }
                else { return true; }
            }
            
        // -->
        </script>
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de precios seg&uacute;n grupos</h2>
        </center>
        <center>
        <a href="productos.php">Volver al gestor de productos</a>
        <br>
        <?php
            //Enlace para volver abajo de la pagina:
            include "abajo.php";
        ?>
        <b>NOTAS</b>:
        <br>
        Para que el producto <b>no se liste</b> para un grupo, definir su <b>precio en 0</b> y su <b>cantidad m&iacute;nima en -1</b>.
        <br>
        Para que el producto <b>sea gratuito</b> para un grupo, definir su <b>precio y su cantidad m&iacute;nima en 0</b>.
        <br>
        Para una pieza poner cantidad m&iacute;nima en 1, para media a 0.5 y para un cuarto a 0.25.
        <br>
        Si se trata de una tela, todos los precios se refieren a 100 cent&iacute;metros (1 metro).
        <br>
        Para restaurar los valores por defecto en los cent&iacute;metros (m&iacute;nimo e incremento), poner uno o los dos valores con un numero no valido (por ejemplo, -1) y darle a Modificar.<br>
        </center>
        <br>
        <br>
        <?php
            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Incluye las constantes de la base de datos (es necesaria la del idioma por defecto):
            require_once "../cod/func/constantes.php";

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
