<?php
    set_time_limit(0);

    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");

    //Incluye el archivo para recoger variables por GET (url):
    require_once "../cod/func/web/recoger_get.php";

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para recoger archivos por POST:
    require_once "../cod/func/web/recoger_file.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    //Guarda que pagina es esta:
    $this_file = "productos_masivo.php";

    //Define que se soporta JavaScript (para ampliar_imagen()):
    $javascript_soportado = TRUE;
    //Define una ID de sesion ficticia (para ampliar_imagen()):
    $id_sesion = "";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'iso-8859-1'); }

    //Si la funcion image_type_to_extension no existe, crea una similar (gracias a la aportacion de robe@amd.co.at en http://es2.php.net/image_type_to_extension):
    if(!function_exists('image_type_to_extension'))
    {
       function image_type_to_extension($imagetype)
       {
           if(empty($imagetype)) return false;
           switch($imagetype)
           {
               case IMAGETYPE_GIF    : return 'gif';
               case IMAGETYPE_JPEG    : return 'jpg';
               case IMAGETYPE_PNG    : return 'png';
               case IMAGETYPE_SWF    : return 'swf';
               case IMAGETYPE_PSD    : return 'psd';
               case IMAGETYPE_BMP    : return 'bmp';
               case IMAGETYPE_TIFF_II : return 'tiff';
               case IMAGETYPE_TIFF_MM : return 'tiff';
               case IMAGETYPE_JPC    : return 'jpc';
               case IMAGETYPE_JP2    : return 'jp2';
               case IMAGETYPE_JPX    : return 'jpf';
               case IMAGETYPE_JB2    : return 'jb2';
               case IMAGETYPE_SWC    : return 'swc';
               case IMAGETYPE_IFF    : return 'aiff';
               case IMAGETYPE_WBMP    : return 'wbmp';
               case IMAGETYPE_XBM    : return 'xbm';
               default                : return false;
           }
       }
    }
    

    //Funcion que abre una imagen (gracias a PHPit - Totally PHP):
    function open_image ($file)
    {
        # JPEG:
        $im = @imagecreatefromjpeg($file);
        if ($im !== false) { return $im; }

        # GIF:
        $im = @imagecreatefromgif($file);
        if ($im !== false) { return $im; }

        # PNG:
        $im = @imagecreatefrompng($file);
        if ($im !== false) { return $im; }

        # GD File:
        $im = @imagecreatefromgd($file);
        if ($im !== false) { return $im; }

        # GD2 File:
        $im = @imagecreatefromgd2($file);
        if ($im !== false) { return $im; }

        # WBMP:
        $im = @imagecreatefromwbmp($file);
        if ($im !== false) { return $im; }

        # XBM:
        $im = @imagecreatefromxbm($file);
        if ($im !== false) { return $im; }

        # XPM:
        $im = @imagecreatefromxpm($file);
        if ($im !== false) { return $im; }

        # Try and load from string:
        $im = @imagecreatefromstring(file_get_contents($file));
        if ($im !== false) { return $im; }

        return false;
    }


    //Funcion que devuelve los idiomas:
    function obtener_idiomas($ref = -1, $mostrar_todos = FALSE)
    {
        global $base_datos;
        
        //$ref = mysql_real_escape_string(htmlentities_(trim($ref)));
        
        $idiomas = Array();
        
        if ($ref == -1)
        {
            $consulta = "SELECT * FROM idiomas";
            if (!$mostrar_todos) { $consulta .= " WHERE mostrar != 0"; }
        }
        else { $consulta = "SELECT * FROM idiomas AS a JOIN libro_idioma AS b WHERE a.id_idioma = b.id_idioma AND b.ref_libro LIKE '$ref' ORDER BY idioma"; } 
        $resultados = $base_datos->haz_consulta($consulta);

        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_idioma = htmlentities_(trim($row["id_idioma"]));
            $idioma = htmlentities_(trim($row["idioma"]));
            $idiomas[$id_idioma] = $idioma;
        }
        
        return $idiomas;
    }


    //Funcion que muestra un menu de navegacion:
    function mostrar_menu()
    {   
        global $this_file;
        
        $mostrar_todos = TRUE;

        $id_coleccion_enviado = recoger_get("mostrar_coleccion");
        $id_categoria_enviado = recoger_get("mostrar_categoria");
        $id_fabricante_enviado = recoger_get("mostrar_fabricante");
        $id_marca_enviado = recoger_get("mostrar_marca");
        $ref_enviada = recoger_get("mostrar_ref");

        if (recoger_post("enviado_post"))
        {
            $id_coleccion_enviado = recoger_post("mostrar_coleccion");
            $id_categoria_enviado = recoger_post("mostrar_categoria");
            $id_fabricante_enviado = recoger_post("mostrar_fabricante");
            $id_marca_enviado = recoger_post("mostrar_marca");
            $ref_enviada = recoger_post("mostrar_ref");
        }
        
        echo '<center><table border="1" align="center"><tr><td align="center"><center>';

        $colecciones = obtener_colecciones();
        $nombre_coleccion = (isset($colecciones[$id_coleccion_enviado]) && trim($colecciones[$id_coleccion_enviado]) != "") ? trim($colecciones[$id_coleccion_enviado]) : "";

        $categorias = Array();
        $categorias = obtener_categorias(0, 0, $categorias);
        $nombre_categoria = (isset($categorias[$id_categoria_enviado]) && trim($categorias[$id_categoria_enviado]) != "") ? trim(str_replace("-", "", $categorias[$id_categoria_enviado])) : "";

        $fabricantes = obtener_fabricantes();
        $nombre_fabricante = (isset($fabricantes[$id_fabricante_enviado]) && trim($fabricantes[$id_fabricante_enviado]) != "") ? trim($fabricantes[$id_fabricante_enviado]) : "";

        if (isset($id_fabricante_enviado) && trim($id_fabricante_enviado) != "" && is_numeric($id_fabricante_enviado))
        {
            $marcas = obtener_marcas($id_fabricante_enviado);
            $nombre_marca = (isset($marcas[$id_marca_enviado]) && trim($marcas[$id_marca_enviado]) != "") ? trim($marcas[$id_marca_enviado]) : "";
        } else { $nombre_marca = "no encontrado"; }

        if (trim($id_coleccion_enviado) != "" && $id_coleccion_enviado != -1) { $mostrar_todos = FALSE; echo "Mostrando productos de la colecci&oacute;n con id $id_coleccion_enviado (<i>$nombre_coleccion</i>)<br>"; }
        if (trim($id_categoria_enviado) != "" && $id_categoria_enviado != -1) { $mostrar_todos = FALSE; echo "Mostrando productos de la categor&iacute;a con id $id_categoria_enviado (<i>$nombre_categoria</i>)<br>"; }
        if (trim($id_fabricante_enviado) != "" && $id_fabricante_enviado != -1) { $mostrar_todos = FALSE; echo "Mostrando productos del fabricante con id $id_fabricante_enviado (<i>$nombre_fabricante</i>)<br>"; }
        if (trim($id_marca_enviado) != "" && $id_marca_enviado != -1) { $mostrar_todos = FALSE; echo "Mostrando productos de la marca con id $id_marca_enviado (<i>$nombre_marca</i>)<br>"; }
        if (trim($ref_enviada) != "") { $mostrar_todos = FALSE; echo "Mostrando productos que contengan en su referencia lo siguiente: <i>$ref_enviada</i><br>"; }

        if (!$mostrar_todos) { echo '<br><table border=\"1\"><tr><td><a href="productos_masivo.php">Mostrar todos</a></td></tr></table><br>'; }
        else { echo "Mostrando todos los productos.<br><br>"; }

        echo '<table border="1"><tr><td valign="top">'; //ayy
        

        echo '<table border="1"><form action="' . $this_file . '" method="get" onSubmit="if (document.getElementById(\'mostrar_fabricante\').value == \'-1\') { mifabricante = \'ninguno\'; } else { mifabricante = document.getElementById(\'mostrar_fabricante\').value; } document.getElementById(\'mostrar_marca\').value = document.getElementById(\'marca_\' + mifabricante + \'_menu\').value; return true">';

        echo '<br><br>Filtrar por...<br>';


        echo '<tr><td>Colecci&oacute;n:</td><td><select name="mostrar_coleccion">';
        echo '<option value="-1">- TODAS -</option>';
        if (is_array($colecciones) && sizeof($colecciones) > 0)
        {
            foreach ($colecciones as $id_coleccion => $nombre_coleccion)
            {
                $selected = ($id_coleccion_enviado == $id_coleccion) ? " selected" : "";
                echo '<option value="' . $id_coleccion . '"' . $selected . '>' . $nombre_coleccion . '</option>';
            }
        }
        echo '</select>';
        echo '</td></tr>';

        echo '<tr><td>Categor&iacute;a:</td><td><select name="mostrar_categoria">';
        echo '<option value="-1">- TODAS -</option>';
        if (is_array($categorias) && sizeof($categorias) > 0)
        {
            foreach ($categorias as $id_categoria => $nombre_categoria)
            {
                $selected = ($id_categoria_enviado == $id_categoria) ? " selected" : "";
                echo '<option value="' . $id_categoria . '"' . $selected . '>' . $nombre_categoria . '</option>';
            }
        }
        echo '</select>';
        echo '</td></tr>';

        echo '<tr><td>Fabricante:</td><td>';
        mostrar_fabricante_menu($id_fabricante_enviado);
        echo '</td></tr>';

        echo '<tr><td>Marca:</td><td>';
        poner_marcas_menu($id_marca_enviado, $id_fabricante_enviado);
        echo '<input type="hidden" name="mostrar_marca" id="mostrar_marca" value="-1">';
        echo '</td></tr>';

        $modo_lista_checked = (recoger_get("modo_lista")) ? " checked" : "";

        echo '<tr><td colspan="2"><label for="modo_lista"><input type="checkbox" class="casilla" id="modo_lista" name="modo_lista" value="si"' . $modo_lista_checked . '>Modo lista</label><br><br><input type="submit" name="boton" value="Filtrar"></td></tr>';
        echo '</form></table>';

        echo '</td><td valign="top">'; //ayy

        echo '<br><br>Buscar...<br>';
        
        $referencia_buscada = ($ref_enviada != "") ? $ref_enviada : "";
        echo '<form action="' . $this_file . '" method="get"><table border="1"><tr><td>Referencia:</td><td><input type="text" name="mostrar_ref" value="' . $referencia_buscada . '"></td></tr><tr><td colspan="2"><label for="modo_lista_2"><input type="checkbox" class="casilla" id="modo_lista_2" name="modo_lista" value="si"' . $modo_lista_checked . '>Modo lista</label><br><br><input type="submit" name="boton" value="Buscar"></td></tr></table></form>';

        echo '</td></tr></table>'; //ayy

        
        echo '</center></td></tr></table></center><br><br>';
    }

    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
            echo "<center>";
            mostrar_formulario_2(-1, -1);
            echo "</center>";
            return;

        global $base_datos;
        
        mostrar_menu();
        
        $id_coleccion_enviado = recoger_get("mostrar_coleccion");
        $id_categoria_enviado = recoger_get("mostrar_categoria");
        $id_fabricante_enviado = recoger_get("mostrar_fabricante");
        $id_marca_enviado = recoger_get("mostrar_marca");
        $ref_enviada = recoger_get("mostrar_ref");

        if (recoger_post("enviado_post"))
        {
            $id_coleccion_enviado = recoger_post("mostrar_coleccion");
            $id_categoria_enviado = recoger_post("mostrar_categoria");
            $id_fabricante_enviado = recoger_post("mostrar_fabricante");
            $id_marca_enviado = recoger_post("mostrar_marca");
            $ref_enviada = recoger_post("mostrar_ref");
        }
        
        $sql_adicional = "";
        if (trim($id_categoria_enviado) != "" && trim($id_coleccion_enviado) != "" && $id_categoria_enviado != -1 && $id_coleccion_enviado != -1)
        {
            $sql_adicional = " JOIN producto_coleccion AS b JOIN producto_categoria AS c WHERE a.ref = b.ref_producto AND b.ref_producto = c.ref_producto AND id_coleccion = $id_coleccion_enviado AND id_categoria = $id_categoria_enviado";
        }
        else if (trim($id_coleccion_enviado) != ""  && $id_coleccion_enviado != -1)
        {
            $sql_adicional = " JOIN producto_coleccion AS b WHERE a.ref = b.ref_producto AND id_coleccion = $id_coleccion_enviado";
        }
        else if (trim($id_categoria_enviado) != "" && $id_categoria_enviado != -1)
        {
            $sql_adicional = " JOIN producto_categoria AS b WHERE a.ref = b.ref_producto AND id_categoria = $id_categoria_enviado";
        }

        if (trim($sql_adicional) != "")
        {
            if (trim($id_fabricante_enviado) != "" && $id_fabricante_enviado != -1) { $sql_adicional .= " AND a.id_fabricante = $id_fabricante_enviado"; }
            if (trim($id_marca_enviado) != "" && $id_marca_enviado != -1) { $sql_adicional .= " AND a.id_marca = $id_marca_enviado"; }
            if (trim($ref_enviada) != "") { $sql_adicional .= " AND UPPER(a.ref) LIKE '%" . strtoupper($ref_enviada) . "%'"; }
        }
        else
        {
            if (trim($id_fabricante_enviado) != "" && $id_fabricante_enviado != -1) { $sql_adicional .= " WHERE a.id_fabricante = $id_fabricante_enviado"; }
            if (trim($id_marca_enviado) != "" && $id_marca_enviado != -1)
            {
                if ($sql_adicional != "") { $sql_adicional .= " AND a.id_marca = $id_marca_enviado"; }
                else { $sql_adicional .= " WHERE a.id_marca = $id_marca_enviado"; }
            }
            if (trim($ref_enviada) != "")
            {
                if ($sql_adicional != "") { $sql_adicional .= " AND UPPER(a.ref) LIKE '%" . strtoupper($ref_enviada) . "%'"; }
                else { $sql_adicional .= " WHERE UPPER(a.ref) LIKE '%" . strtoupper($ref_enviada) . "%'"; }
                
            }
        }

        $consulta = "SELECT * FROM productos AS a" . $sql_adicional;
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <?php

        $contador = 0;

        $modo_lista = recoger_get("modo_lista");

        $contador = 0;
        while ($row = mysql_fetch_assoc($resultados))
        {
            $ref = trim($row["ref"]);
            if ($modo_lista) { mostrar_formulario_lista($ref, $contador++); }
            else { mostrar_formulario_2($ref, $contador++); }
            echo "<br><br>";
        }

        if (mysql_num_rows($resultados) <= 0) { mostrar_advertencia("No hay productos en la tabla de productos o no se han encontrado con los criterios de b&uacute;squeda<br>"); }
        if (!$ref_enviada)
        {
            echo '<br><br><br>';
            echo '<br><br><br>';
            echo '<br><br><br>';
            mostrar_formulario_2(-1, -1);
        }
        ?>
        </center>
        <?
    }

    
    //Funcion que muestra el formulario en si, en modo lista (para cada producto ya insertado):
    function mostrar_formulario_lista($ref, $contador = 0)
    {
        global $this_file, $base_datos, $constantes;

        if (!isset($constantes["IDIOMA_POR_DEFECTO"]) || isset($constantes["IDIOMA_POR_DEFECTO"]) && (trim($constantes["IDIOMA_POR_DEFECTO"]) == "" || !is_numeric(trim($constantes["IDIOMA_POR_DEFECTO"])))) { mostrar_error('No se pudo recoger un idioma por defecto. Por favor, define la constante del idioma por defecto en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else { $idioma_por_defecto = $constantes["IDIOMA_POR_DEFECTO"]; }

        if (!isset($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]) || isset($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]) && (trim($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]) == "" || !is_numeric(trim($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"])))) { mostrar_error('No se pudo recoger un ancho por defecto. Por favor, define la constante del ancho por defecto de las imagenes en miniatura en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]) || isset($constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]) && (trim($constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]) == "" || !is_numeric(trim($constantes["IMAGENES_PRODUCTOS_MINI_ALTO"])))) { mostrar_error('No se pudo recoger un alto por defecto. Por favor, define la constante del alto por defecto de las imagenes en miniatura en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"]) || isset($constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"]) && (trim($constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"]) == "" || !is_numeric(trim($constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"])))) { mostrar_error('No se pudo recoger un ancho por defecto. Por favor, define la constante del ancho por defecto de las imagenes con zoom en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]) || isset($constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]) && (trim($constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]) == "" || !is_numeric(trim($constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"])))) { mostrar_error('No se pudo recoger un alto por defecto. Por favor, define la constante del alto por defecto de las imagenes con zoom en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else { $imagen_ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]; $imagen_alto = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]; $imagen_ancho_zoom = $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"]; $imagen_alto_zoom = $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]; }

        if ($ref != -1)
        {
            //$consulta = "SELECT * FROM productos JOIN producto_categoria WHERE ref LIKE '$ref' AND ref_producto = ref";
            $consulta = "SELECT * FROM productos WHERE ref LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
            $row = mysql_fetch_assoc($resultados);
            $mostrar = $row["mostrar"];
            $id_fabricante = $row["id_fabricante"];
            $id_marca = $row["id_marca"];
            //$id_categoria = $row["id_categoria"];

            $consulta = "SELECT * FROM producto_categoria WHERE ref_producto LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
            $row = mysql_fetch_assoc($resultados);
            $id_categoria = $row["id_categoria"];                            

            $tipo = "otro";

            $consulta = "SELECT * FROM libro_idioma AS a JOIN libro_tematica AS b WHERE a.ref_libro LIKE '$ref' OR b.ref_libro LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
            if (mysql_num_rows($resultados) > 0) { $tipo = "libro"; }

            $consulta = "SELECT * FROM tela_disenyador AS a JOIN producto_coleccion AS b WHERE a.ref_tela LIKE '$ref' OR b.ref_producto LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
            if (mysql_num_rows($resultados) > 0) { $tipo = "tela"; }
        }
        else
        {
            $mostrar = TRUE;
            $id_fabricante = "";
            $id_marca = "";
            $id_categoria = "";
            $tipo = "otro";
        }

        echo '<table border="1"><tr>';
        
        echo '<td>';
        $directorio = "../img/productos/";
        $directorio_zoom = "../img/productos/zoom/";
        if (file_exists($directorio . nombre_archivo_correcto($ref) . ".gif")) { $imagen = nombre_archivo_correcto($ref) . ".gif"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpg")) { $imagen = nombre_archivo_correcto($ref) . ".jpg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpeg")) { $imagen = nombre_archivo_correcto($ref) . ".jpeg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".png")) { $imagen = nombre_archivo_correcto($ref) . "png"; }
        else { $imagen = "error.gif"; $directorio = "../img/"; }
        //echo "estooooooo: $imagen";
        if (file_exists($directorio . $imagen))
        {
            echo '<center><table align="center" border="1"><tr><td>';
            //if (file_exists($directorio_zoom . $imagen)) { echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho_zoom, $imagen_alto_zoom, $imagen_ancho, $imagen_alto); }
            echo imagen_ampliable($imagen, $directorio, $directorio_zoom, TRUE, $imagen_ancho_zoom, $imagen_alto_zoom, $imagen_ancho, $imagen_alto);
            //else { echo '<img src="' . $directorio . $imagen . '" border="0" hspace="0" vspace="0" width="' . $imagen_ancho . '" height="' . $imagen_alto . '" alt="' . $directorio . $imagen . '" title="' . $directorio . $imagen . '">'; }
            echo '</td></tr></table><center>';
        }
        echo "<br>$ref";
        echo "<br>Tipo: $tipo";
        echo '</td>';

        $consulta = "SELECT * FROM productos AS a JOIN producto_descripcion AS b JOIN producto_nombre AS c WHERE ref LIKE '$ref' AND a.ref LIKE b.ref_producto AND b.ref_producto LIKE c.ref_producto AND b.id_idioma = c.id_idioma AND b.id_idioma = $idioma_por_defecto";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysql_fetch_assoc($resultados);
        $nombre = $row["nombre"];

        echo '<td>';
        echo $nombre;
        echo '</td>';

        echo '<td>';
        echo '<form method="get" action="' . $this_file . '">';
        echo '<input type="hidden" name="mostrar_ref" value="' . $ref . '">';
        echo '<input type="hidden" name="contador" value="' . $contador . '">';
        echo '<input type="submit" name="boton" value="Modificar">';
        echo '</form>';
        echo '<br><br>';
        echo '<form method="post" action="' . $this_file . '" onSubmit="return confirmar_eliminar(\'' . htmlentities_(addslashes($ref)) . '\');">';
        echo '<input type="hidden" name="accion" value="eliminar">';
        echo '<input type="hidden" name="ref" value="' . $ref . '">';
        echo '<input type="submit" name="boton2" value="Eliminar">';
        echo '</form>';
        echo '</td>';
        
        echo '</tr></table>';
       
    }

    
    //Funcion que muestra el formulario en si (para un producto nuevo y para cada producto ya insertado):
    function mostrar_formulario_2($ref, $contador)
    {
        global $this_file, $base_datos, $constantes;

        if (!isset($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]) || isset($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]) && (trim($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]) == "" || !is_numeric(trim($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"])))) { mostrar_error('No se pudo recoger un ancho por defecto. Por favor, define la constante del ancho por defecto de las imagenes en miniatura en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]) || isset($constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]) && (trim($constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]) == "" || !is_numeric(trim($constantes["IMAGENES_PRODUCTOS_MINI_ALTO"])))) { mostrar_error('No se pudo recoger un alto por defecto. Por favor, define la constante del alto por defecto de las imagenes en miniatura en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"]) || isset($constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"]) && (trim($constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"]) == "" || !is_numeric(trim($constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"])))) { mostrar_error('No se pudo recoger un ancho por defecto. Por favor, define la constante del ancho por defecto de las imagenes con zoom en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]) || isset($constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]) && (trim($constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]) == "" || !is_numeric(trim($constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"])))) { mostrar_error('No se pudo recoger un alto por defecto. Por favor, define la constante del alto por defecto de las imagenes con zoom en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else
        {
            $imagen_ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
            $imagen_alto = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"];
            //$imagen_ancho = $imagen_alto = -1;
            $imagen_ancho_zoom = $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"];
            $imagen_alto_zoom = $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"];
        }

        $idiomas = obtener_idiomas();
       
        
        $titulo = ($ref == -1) ? "<b>NUEVO PRODUCTO</b>" : "Modificar producto <i>" . htmlentities_($ref) . "</i>";
        echo '<table border="1"><tr><td colspan="2" class="destacado">' . $titulo . '</td></tr>';
        
        if ($ref != -1)
        {
            //$consulta = "SELECT * FROM productos JOIN producto_categoria WHERE ref LIKE '$ref' AND ref_producto = ref";
            $consulta = "SELECT * FROM productos WHERE ref LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
            $row = mysql_fetch_assoc($resultados);
            $mostrar = htmlentities_($row["mostrar"]);
            $id_fabricante = htmlentities_($row["id_fabricante"]);
            $id_marca = htmlentities_($row["id_marca"]);
            //$id_categoria = $row["id_categoria"];
            $precio = htmlentities_($row["precio_normal"]);

            $consulta = "SELECT * FROM producto_categoria WHERE ref_producto LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
            $row = mysql_fetch_assoc($resultados);
            $id_categoria = $row["id_categoria"];                            

            $tipo = "otro";

            $consulta = "SELECT * FROM libro_idioma AS a JOIN libro_tematica AS b ON a.ref_libro = b.ref_libro WHERE a.ref_libro LIKE '$ref' OR b.ref_libro LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
            if (mysql_num_rows($resultados) > 0) { $tipo = "libro"; }

            $consulta = "SELECT * FROM tela_disenyador AS a JOIN producto_coleccion AS b ON a.ref_tela = b.ref_producto WHERE a.ref_tela LIKE '$ref' OR b.ref_producto LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
            if (mysql_num_rows($resultados) > 0) { $tipo = "tela"; }
        }
        else
        {
            $mostrar = TRUE;
            $id_fabricante = "";
            $id_marca = "";
            $id_categoria = "";
            $tipo = "otro";
            $precio = 0;
        }
        
        echo '<form method="post" action="' . $this_file . '" enctype="multipart/form-data" onSubmit="return validar_formulario(\'' . htmlentities_(addslashes($ref)) . '\', ' . $contador . ');"><input type="hidden" name="ref" value="' . htmlentities_($ref) . '">';



        $mostrar_todos = TRUE;

        $id_coleccion_enviado = recoger_get("mostrar_coleccion");
        $id_categoria_enviado = recoger_get("mostrar_categoria");
        $id_fabricante_enviado = recoger_get("mostrar_fabricante");
        $id_marca_enviado = recoger_get("mostrar_marca");
        $ref_enviada = recoger_get("mostrar_ref");

        if (recoger_post("enviado_post"))
        {
            $id_coleccion_enviado = recoger_post("mostrar_coleccion");
            $id_categoria_enviado = recoger_post("mostrar_categoria");
            $id_fabricante_enviado = recoger_post("mostrar_fabricante");
            $id_marca_enviado = recoger_post("mostrar_marca");
            $ref_enviada = recoger_post("mostrar_ref");
        }

        //$colecciones = obtener_colecciones();
        //$nombre_coleccion = (isset($colecciones[$id_coleccion_enviado]) && trim($colecciones[$id_coleccion_enviado]) != "") ? trim($colecciones[$id_coleccion_enviado]) : "";
        //$categorias = Array();
        //$categorias = obtener_categorias(0, 0, $categorias);
        //$nombre_categoria = (isset($categorias[$id_categoria_enviado]) && trim($categorias[$id_categoria_enviado]) != "") ? trim(str_replace("-", "", $categorias[$id_categoria_enviado])) : "";
        //$fabricantes = obtener_fabricantes();
        //$nombre_fabricante = (isset($fabricantes[$id_fabricante_enviado]) && trim($fabricantes[$id_fabricante_enviado]) != "") ? trim($fabricantes[$id_fabricante_enviado]) : "";
        //if (isset($id_fabricante_enviado) && trim($id_fabricante_enviado) != "" && is_numeric($id_fabricante_enviado))
        //{
        //    $marcas = obtener_marcas($id_fabricante_enviado);
        //    $nombre_marca = (isset($marcas[$id_marca_enviado]) && trim($marcas[$id_marca_enviado]) != "") ? trim($marcas[$id_marca_enviado]) : "";
        //} else { $nombre_marca = "no encontrado"; }
        echo '<input type="hidden" name="enviado_post" value="1">';
        if (trim($id_coleccion_enviado) != "" && $id_coleccion_enviado != -1) { echo '<input type="hidden" name="mostrar_coleccion" value="' . $id_coleccion_enviado . '">'; }
        if (trim($id_categoria_enviado) != "" && $id_categoria_enviado != -1) { echo '<input type="hidden" name="mostrar_categoria" value="' . $id_categoria_enviado . '">'; }
        if (trim($id_fabricante_enviado) != "" && $id_fabricante_enviado != -1) { echo '<input type="hidden" name="mostrar_fabricante" value="' . $id_fabricante_enviado . '">'; }
        if (trim($id_marca_enviado) != "" && $id_marca_enviado != -1) { echo '<input type="hidden" name="mostrar_marca" value="' . $id_marca_enviado . '">'; }
        if (trim($ref_enviada) != "") { echo '<input type="hidden" name="mostrar_ref" value="' . $ref_enviada . '">'; }

        //if (!$mostrar_todos) { echo '<br><table border=\"1\"><tr><td><a href="productos_masivo.php">Mostrar todos</a></td></tr></table><br>'; }
        //else { echo "Mostrando todos los productos.<br><br>"; }




        if ($ref == -1) { echo '<input type="hidden" name="accion" value="agregar">'; }
        else { echo '<input type="hidden" name="accion" value="modificar">'; }
        echo '<input type="hidden" name="contador" value="' . $contador . '">';
        $mostrar_checked = ($mostrar) ? " checked" : "";
        echo '<tr><td><label for="mostrar_' . htmlentities_($ref) . '">Mostrar</td><td><input type="checkbox" class="casilla" name="mostrar_' . htmlentities_($ref) . '" id="mostrar_' . htmlentities_($ref) . '"' . $mostrar_checked . '></label></td></tr>';
        $ref_mostrar = ($ref == -1) ? "" : htmlentities_($ref);

        echo '<tr><td>Directorio:</td><td><input type="text" id="directorio" name="directorio" size="80" value="' . $ref_mostrar . '"></td></tr>';

        echo '<tr><td>Prefijo en referencias:</td><td><input type="text" id="prefijo" name="prefijo" size="10" value=""></td></tr>';

        //echo '<tr><td>Imagen original:</td><td>';
        $directorio = "../img/productos/zoom/";
        if (file_exists($directorio . nombre_archivo_correcto($ref) . ".gif")) { $imagen = nombre_archivo_correcto($ref) . ".gif"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpg")) { $imagen = nombre_archivo_correcto($ref) . ".jpg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpeg")) { $imagen = nombre_archivo_correcto($ref) . ".jpeg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".png")) { $imagen = nombre_archivo_correcto($ref) . "png"; }
        else { $imagen = "error.gif"; $directorio = "../img/"; }
        //echo "estooooooo: $imagen";
        if ($ref != -1 && file_exists($directorio . $imagen))
        {
            //echo '<center><table align="center" border="1"><tr><td>';
            //if (file_exists($directorio . $imagen)) { echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho_zoom, $imagen_alto_zoom, $imagen_ancho, $imagen_alto); }
            //echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho_zoom, $imagen_alto_zoom, $imagen_ancho, $imagen_alto);
            //else { echo '<img src="' . $directorio . $imagen . '" border="0" hspace="0" vspace="0" width="' . $imagen_ancho . '" height="' . $imagen_alto . '" alt="' . $directorio . $imagen . '" title="' . $directorio . $imagen . '">'; }
            //echo '</td></tr></table><center>';
        }
        $ref_name = ($ref != -1) ? $ref : "nuevo_producto";
        //echo '<input type="file" name="imagen_' . htmlentities_($ref_name) . '" id="imagen_' . htmlentities_($ref_name) . '"><br><i>Tama&ntilde;o m&aacute;ximo: ' . $imagen_ancho_zoom . 'x' . $imagen_alto_zoom . '<br>Tama&ntilde;o recomendado: el m&aacute;ximo o uno menor pero proporcional</i></td></tr>';
        //echo '<tr><td>Imagen miniatura:</td><td>';
        $directorio = "../img/productos/";
        if (file_exists($directorio . nombre_archivo_correcto($ref) . ".gif")) { $imagen = nombre_archivo_correcto($ref) . ".gif"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpg")) { $imagen = nombre_archivo_correcto($ref) . ".jpg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpeg")) { $imagen = nombre_archivo_correcto($ref) . ".jpeg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".png")) { $imagen = nombre_archivo_correcto($ref) . "png"; }
        else { $imagen = "error.gif"; $directorio = "../img/"; }
        if ($ref != -1 && file_exists($directorio . $imagen))
        {
            //echo '<center><table align="center" border="1"><tr><td>';
            //if (file_exists($directorio . $imagen)) { echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho, $imagen_alto, $imagen_ancho, $imagen_alto); }
            //echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho, $imagen_alto, $imagen_ancho, $imagen_alto);
            //echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho, $imagen_alto, -1, -1);
            //else { echo '<img src="' . $directorio . $imagen . '" border="0" hspace="0" vspace="0" width="' . $imagen_ancho . '" height="' . $imagen_alto . '" alt="' . $directorio . $imagen . '" title="' . $directorio . $imagen . '">'; }
            //echo '</td></tr></table><center>';
        }
        //echo '<label for="reducir_imagen_' . htmlentities_($ref) . '"><input type="checkbox" onClick="document.getElementById(\'imagen_miniatura_' . htmlentities_($ref_name) . '\').disabled = document.getElementById(\'reducir_imagen_' . htmlentities_($ref) . '\').checked;" class="casilla" id="reducir_imagen_' . htmlentities_($ref) . '" name="reducir_imagen_' . htmlentities_($ref) . '" checked>Reducir imagen original automaticamente<br>(no soporta gif animados ni transparentes)</label><br><br><input type="file" name="imagen_miniatura_' . htmlentities_($ref_name) . '" id="imagen_miniatura_' . htmlentities_($ref_name) . '" disabled><br><i>Tama&ntilde;o m&aacute;ximo: ' . $imagen_ancho . 'x' . $imagen_alto . '<br>Tama&ntilde;o recomendado: el m&aacute;ximo o uno menor pero proporcional</i>';
        //echo '</td></tr>';
        echo '<tr><td>Precio normal:</td><td><input type="text" maxlength="7" size="8" name="precio_' . htmlentities_($ref) . '" id="precio_' . htmlentities_($ref) . '" value="' . $precio . '" onChange="this.value = this.value.replace(\',\', \'.\')"><br><i>Si es una tela, es el precio por metro (100 cm).</i>';
        echo '</td></tr>';
        echo '<tr><td>Fabricante:</td><td>';
        //if ($ref == -1) { $id_fabricante_enviado = recoger_get("mostrar_fabricante"); mostrar_fabricante($ref, $id_fabricante_enviado); }
        if ($ref == -1) { mostrar_fabricante($ref, $id_fabricante_enviado); }
        else { mostrar_fabricante($ref, $id_fabricante); }
        echo '</td></tr><tr><td>Marca:</td><td align="center"><center>';
        //if ($ref == -1) { $id_marca_enviado = recoger_get("mostrar_marca"); poner_marcas($ref, $id_marca_enviado, $id_fabricante_enviado); }
        if ($ref == -1) { poner_marcas($ref, $id_marca_enviado, $id_fabricante_enviado); }
        else { poner_marcas($ref, $id_marca, $id_fabricante); }
        //echo '</center></td></tr><tr><td>Colecci&oacute;n:</td><td>';
        //poner_colecciones($ref);
        //poner_colecciones($ref, $contador);
        //echo '</td></tr><tr><td>Categor&iacute;a:</td><td>';
        //mostrar_categoria($ref, $id_categoria);
        //mostrar_categoria($ref, $contador, $id_categoria);
        //echo "</td></tr>";

        foreach ($idiomas as $id_idioma => $idioma)
        {
            if ($ref != -1)
            {
                $consulta = "SELECT * FROM productos AS a JOIN producto_descripcion AS b JOIN producto_nombre AS c WHERE ref LIKE '$ref' AND a.ref LIKE b.ref_producto AND b.ref_producto LIKE c.ref_producto AND b.id_idioma = c.id_idioma AND b.id_idioma = $id_idioma";
                $resultados = $base_datos->haz_consulta($consulta);
                $row = mysql_fetch_assoc($resultados);
                $nombre = htmlentities_($row["nombre"]);
                $eval = ($row["eval"]) ? " checked" : "";
                $descripcion = htmlentities_($row["descripcion"]);
            }
            else
            {
                $nombre = "";
                $eval = "";
                $descripcion = "";
            }
            //echo '<tr><td>Nombre en <i>' . $idioma . '</i>:</td><td><input type="text" name="nombre_' . $id_idioma . '_' . htmlentities_($ref) . '" id="nombre_' . $id_idioma . '_' . htmlentities_($ref) . '" value="' . $nombre . '" size="60"></td></tr>';
            //echo '<tr><td colspan="2">Descripci&oacute;n en <i>' . $idioma . '</i>: <label for="eval_' . $id_idioma . '_' . htmlentities_($ref) . '"><input type="checkbox" class="casilla" name="eval_' . $id_idioma . '_' . htmlentities_($ref) . '" id="eval_' . $id_idioma . '_' . htmlentities_($ref) . '"' . $eval . '> Eval</label><br><textarea name="descripcion_' . $id_idioma . '_' . htmlentities_($ref) . '" id="descripcion_' . $id_idioma . '_' . htmlentities_($ref) . '" style="width:550px; height:150px;">' . $descripcion . '</textarea></td></tr>';
        }
        
        echo '<tr><td colspan="2">Tipo de producto:<br><center><table align="center"><tr><td align="left" style="text-align:left;">';
        if ($tipo == "tela") { $checked = " checked"; } else { $checked = ""; }
        echo '<label for="tipo_' . htmlentities_($ref) . '_tela"><input type="radio" name="tipo_' . htmlentities_($ref) . '" onChange="mostrar_formulario_tipo_producto(\'' . htmlentities_(addslashes($ref)) . '\');" onClick="mostrar_formulario_tipo_producto(\'' . htmlentities_(addslashes($ref)) . '\');"  value="tela" class="casilla" id="tipo_' . htmlentities_($ref) . '_tela"' . $checked . '>Tela</label>&nbsp;&nbsp;&nbsp;';
        if ($tipo == "libro") { $checked = " checked"; } else { $checked = ""; }
        echo '<label for="tipo_' . htmlentities_($ref) . '_libro"><input type="radio" name="tipo_' . htmlentities_($ref) . '" onChange="mostrar_formulario_tipo_producto(\'' . htmlentities_(addslashes($ref)) . '\');" onClick="mostrar_formulario_tipo_producto(\'' . htmlentities_(addslashes($ref)) . '\');" value="libro" class="casilla" id="tipo_' . htmlentities_($ref) . '_libro"' . $checked . '>Libro</label>&nbsp;&nbsp;&nbsp;';
        if ($tipo == "otro") { $checked = " checked"; } else { $checked = ""; }
        echo '<label for="tipo_' . htmlentities_($ref) . '_otro"><input type="radio" name="tipo_' . htmlentities_($ref) . '" onChange="mostrar_formulario_tipo_producto(\'' . htmlentities_(addslashes($ref)) . '\');" onClick="mostrar_formulario_tipo_producto(\'' . htmlentities_(addslashes($ref)) . '\');" value="otro" class="casilla" id="tipo_' . htmlentities_($ref) . '_otro"' . $checked . '>Otro</label>';
        echo '</input></td></tr></table></center></td></tr>';

        $visibility = ($tipo != "otro") ? "visible" : "hidden";
        echo '<tr id="formulario_adicional_' . htmlentities_($ref) . '" style="visibility:' . $visibility . ';"><td align="center" colspan="2"><center>';
            $display = ($tipo == "tela") ? "block" : "none";
            echo '<div id="formulario_telas_' . htmlentities_($ref) . '" style="display:' . $display . ';">Dise&ntilde;ador:<br>';
            //poner_disenyadores($ref);
            poner_disenyadores($ref, $contador);

            echo '<br><br>Metros por pieza:<br>';

            poner_dimension_pieza($ref, $contador);
            
            
            echo '</div>';
            
            $display = ($tipo == "libro") ? "block" : "none";
            echo '<div id="formulario_libros_' . htmlentities_($ref) . '" style="display:' . $display . ';">Tem&aacute;tica:<br>';
            //poner_tematicas($ref);
            poner_tematicas($ref, $contador);
            echo '<br><br>Idioma:<br>';
            //poner_idiomas($ref);
            poner_idiomas($ref, $contador);
            echo '</div>';
        echo '</center></td></tr>';
        
/*        $display = ($tipo == "tela") ? "block" : "none";
        echo '<tr id="formulario_telas_' . $ref . '" style="display:' . $display . ';"><td>Dise&ntilde;ador:</td><td>';
        poner_disenyadores($ref);
        echo '</td></tr>';

        $display = ($tipo == "libro") ? "block" : "none";
        echo '<tr id="formulario_libros1_' . $ref . '" style="display:' . $display . ';"><td>Tem&aacute;tica:</td><td align="center"><center>';
        poner_tematicas($ref);
        echo '</center></td></tr>';

        echo '<tr id="formulario_libros2_' . $ref . '" style="display:' . $display . ';"><td>Idioma:</td><td align="center"><center>';
        poner_idiomas($ref);
        echo '</center></td></tr>';
*/

        $etiqueta_boton = ($ref == -1) ? "Insertar" : "Modificar";
        echo '<tr><td colspan="2"><input type="submit" name="boton" value="' . $etiqueta_boton . '"></form>';
        if ($ref != -1) { echo ' &nbsp;&nbsp; <form method="post" action="' . $this_file . '" onSubmit="return confirmar_eliminar(\'' . htmlentities_(addslashes($ref)) . '\');"><input type="hidden" name="accion" value="eliminar"><input type="hidden" name="ref" value="' . htmlentities_($ref) . '"><input type="submit" name="boton" value="Eliminar"></form>'; }
        echo '</td></tr>';
        if ($ref != -1)
        {
            echo '<tr><td colspan="2" class="destacado">';
            echo '<form method="post" action="precio_particulares.php"><input type="hidden" name="ref" value="' . htmlentities_($ref) . '"><input type="submit" name="boton" value="Precio por particulares"></form>';
            echo '<br><br><form method="post" action="precio_empresas.php"><input type="hidden" name="ref" value="' . htmlentities_($ref) . '"><input type="submit" name="boton" value="Precio por empresas"></form>';
            echo '<br><br><form method="post" action="precio_grupos.php"><input type="hidden" name="ref" value="' . htmlentities_($ref) . '"><input type="submit" name="boton" value="Precio por grupos"></form>';
            echo '</td></tr>';
        }
        echo "</table>";
    }


    //Funcion que devuelve los fabricantes en una matriz:
    function obtener_fabricantes()
    {
        global $base_datos;

        $consulta = "SELECT * FROM fabricantes";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if ($resultados <= 0) { mostrar_error("No hay fabricantes en la tabla de fabricantes"); exit(); }
        
        $fabricantes = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_fabricante = htmlentities_(trim($row["id_fabricante"]));
            $nombre_fabricante = htmlentities_(trim($row["nombre_fabricante"]));
            $fabricantes[$id_fabricante] = $nombre_fabricante;
        }
        
        return $fabricantes;
    }


    //Funcion que devuelve las categorias en una matriz:
    function obtener_categorias($raiz, $nivel, $categorias)
    {
        global $base_datos, $constantes;

        if (!isset($constantes["IDIOMA_POR_DEFECTO"]) || isset($constantes["IDIOMA_POR_DEFECTO"]) && (trim($constantes["IDIOMA_POR_DEFECTO"]) == "" || !is_numeric(trim($constantes["IDIOMA_POR_DEFECTO"])))) { mostrar_error('No se pudo recoger un idioma por defecto. Por favor, define la constante del idioma por defecto en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else { $idioma_por_defecto = $constantes["IDIOMA_POR_DEFECTO"]; }

        $consulta = "SELECT * FROM categorias AS a JOIN categoria_idioma AS b WHERE mostrar != 0 AND a.id_categoria = b.id_categoria AND b.id_idioma = $idioma_por_defecto AND raiz = $raiz ORDER BY nombre_categoria"; //ORDER BY a.id_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if ($resultados <= 0) { mostrar_error("No hay categorias en la tabla de categorias"); exit(); }
        
        //$categorias = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_categoria = htmlentities_(trim($row["id_categoria"]));
            $nombre_categoria = htmlentities_(trim($row["nombre_categoria"]));
            if ($nivel > 0)
            {
                $indentacion = "";
                for ($x = 0; $x < $nivel; $x++)
                {
                    $indentacion .= "-";
                }
                $nombre_categoria = $indentacion . " " . $nombre_categoria;
            }
            $categorias[$id_categoria] = $nombre_categoria;
            $categorias = obtener_categorias($id_categoria, $nivel+1, $categorias);
        }
        
        return $categorias;
    }


    //Funcion que devuelve las marcas de un fabricante en una matriz:
    function obtener_marcas($id_fabricante)
    {
        global $base_datos;

        $consulta = "SELECT * FROM fabricante_marca WHERE id_fabricante = $id_fabricante";
        $resultados = $base_datos->haz_consulta($consulta);
        
        //if ($resultados <= 0) { mostrar_error("No hay fabricantes en la tabla de fabricantes"); exit(); }
        
        $marcas = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_marca = htmlentities_(trim($row["id_marca"]));
            $nombre_marca = htmlentities_(trim($row["nombre_marca"]));
            $marcas[$id_marca] = $nombre_marca;
        }
        
        return $marcas;
    }

    //Funcion que retorna el ID de una categoria dada:
    function obtener_id_categoria($categoria)
    {
        global $base_datos;

        $categoria = strtoupper($categoria);
        $consulta = "SELECT * FROM categoria_idioma WHERE UPPER(nombre_categoria) = '" . mysql_real_escape_string($categoria) . "'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $marcas = Array();
        $id_categoria = mysql_fetch_assoc($resultados);
        $id_categoria = $id_categoria["id_categoria"];
        
        if ($id_categoria == "") { $id_categoria = -1; }
        
        return $id_categoria;
    }

    //Funcion que retorna el ID de una coleccion dada:
    function obtener_id_coleccion($coleccion)
    {
        global $base_datos;

        $coleccion = strtoupper($coleccion);
        $consulta = "SELECT * FROM colecciones WHERE UPPER(nombre_coleccion) = '" . mysql_real_escape_string($coleccion) . "'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $marcas = Array();
        $id_coleccion = mysql_fetch_assoc($resultados);
        $id_coleccion = $id_coleccion["id_coleccion"];
        
        if ($id_coleccion == "") { $id_coleccion = -1; }
        
        return $id_coleccion;
    }    

    //Funcion que lista en el formulario los fabricantes:
    function mostrar_fabricante($ref, $id_fabricante = "")
    {
        $fabricantes = obtener_fabricantes();
        
        echo '<select name="fabricante_' . htmlentities_($ref) . '" id="fabricante_' . htmlentities_($ref) . '" onChange="mostrar_marcas(this.value, \'' . htmlentities_(addslashes($ref)) . '\');">';
        echo '<option value="-1">---</option>';
        foreach ($fabricantes as $id_fabricante_loop => $fabricante)
        {
            if ($id_fabricante == $id_fabricante_loop) { $selected = " selected"; }
            else { $selected = ""; }
            echo '<option value="' . $id_fabricante_loop . '"' . $selected . '>' . $fabricante . '</option>';
        }
        echo '</select>';
    }


    //Funcion que lista en el menu los fabricantes:
    function mostrar_fabricante_menu($id_fabricante = "")
    {
        $fabricantes = obtener_fabricantes();
        
        echo '<select name="mostrar_fabricante" id="mostrar_fabricante" onChange="mostrar_marcas(this.value, \'menu\');">';
        echo '<option value="-1">- TODOS -</option>';
        //echo '<option value="ninguno">- TODOS -</option>';
        foreach ($fabricantes as $id_fabricante_loop => $fabricante)
        {
            if ($id_fabricante == $id_fabricante_loop) { $selected = " selected"; }
            else { $selected = ""; }
            echo '<option value="' . $id_fabricante_loop . '"' . $selected . '>' . $fabricante . '</option>';
        }
        echo '</select>';
    }


    //Funcion que lista en el formulario las marcas:
    function poner_marcas($ref, $id_marca = "", $id_fabricante = "")
    {
        $fabricantes = obtener_fabricantes();

        $visibilidad = ($id_fabricante == "" && $id_marca == "") ? "block" : "none";
        echo '<select id="marca_ninguno_' . htmlentities_($ref) . '" name="marca_ninguno_' . htmlentities_($ref) . '" style="display:' . $visibilidad . ';">';
        echo '<option value="-1">No se ha escogido fabricante</option>';
        echo "</select>";
        
        foreach ($fabricantes as $id_fabricante_loop => $fabricante)
        {
            if (trim($id_fabricante) != "" && $id_fabricante == $id_fabricante_loop) { $visibilidad = "block"; }
            else { $visibilidad = "none"; }
            echo '<select id="marca_' . $id_fabricante_loop . '_' . htmlentities_($ref) . '" name="marca_' . $id_fabricante_loop . '_' . htmlentities_($ref) . '" style="display:' . $visibilidad . ';">';
            echo '<option value="-1">---</option>';
            $marcas = obtener_marcas($id_fabricante_loop);
            //echo "iddddddddddddddddd: $id_fabricante_loop";
            foreach ($marcas as $id_marca_loop => $marca)
            {
                //echo "\n\nidmarka:$id_marca_loop==$id_marca<br>\n\n";
                if ($id_marca == $id_marca_loop) { $selected = " selected"; }
                else { $selected = ""; }
                echo '<option value="' . $id_marca_loop . '"' . $selected . '>' . $marca . '</option>';
            }
            echo '</select>';
        }
    }

    //Funcion que lista en el menu las marcas:
    function poner_marcas_menu($id_marca = "", $id_fabricante = "")
    {
        $fabricantes = obtener_fabricantes();

        $visibilidad = ($id_fabricante == "" && $id_marca == "") ? "block" : "none";
        echo '<select id="marca_ninguno_menu" name="marca_ninguno_menu" style="display:' . $visibilidad . ';">';
        echo '<option value="-1">No se ha escogido fabricante</option>';
        echo "</select>";
        
        foreach ($fabricantes as $id_fabricante_loop => $fabricante)
        {
            if (trim($id_fabricante) != "" && $id_fabricante == $id_fabricante_loop) { $visibilidad = "block"; }
            else { $visibilidad = "none"; }
            echo '<select id="marca_' . $id_fabricante_loop . '_menu" name="marca_' . $id_fabricante_loop . '_menu" style="display:' . $visibilidad . ';">';
            echo '<option value="-1">- TODAS -</option>';
            $marcas = obtener_marcas($id_fabricante_loop);
            foreach ($marcas as $id_marca_loop => $marca)
            {
                if ($id_marca == $id_marca_loop) { $selected = " selected"; }
                else { $selected = ""; }
                echo '<option value="' . $id_marca_loop . '"' . $selected . '>' . $marca . '</option>';
            }
            echo '</select>';
        }
    }



    //Funcion que lista en el formulario las categorias:
    function mostrar_categoria($ref, $contador, $id_categoria = "")
    {
        global $base_datos;

        $consulta = "SELECT * FROM producto_categoria WHERE ref_producto LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);        
        
        $categorias_seleccionadas = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            $categorias_seleccionadas[$id_categoria] = TRUE;
        }
        
        $categorias = Array();
        $categorias = obtener_categorias(0, 0, $categorias);
        
        if ($ref == -1)
        {
            $id_categoria_enviado = recoger_get("mostrar_categoria");
            if (recoger_post("enviado_post"))
            {
                $id_categoria_enviado = recoger_post("mostrar_categoria");
            }
        }
        else { $id_categoria_enviado = false; }
        
        //echo '<select name="categorias_' . htmlentities_($ref) . '[]" id="categorias_' . htmlentities_($ref) . '" multiple>';
        echo '<select name="categorias_' . htmlentities_($contador) . '[]" id="categorias_' . htmlentities_($contador) . '" multiple>';
        foreach ($categorias as $id_categoria => $categoria)
        {
            if (array_key_exists($id_categoria, $categorias_seleccionadas)) { $selected = " selected"; }
            else { $selected = ""; }
            if ($ref == -1 && $id_categoria == $id_categoria_enviado) { $selected = " selected"; }
            echo '<option value="' . $id_categoria . '"' . $selected . '>' . $categoria . '</option>';
        }
        echo '</select>';
    }


    function obtener_colecciones($ref = -1)
    {
        global $base_datos;

        //$ref = mysql_real_escape_string(htmlentities_(trim($ref)));

        if ($ref == -1) { $consulta = "SELECT * FROM colecciones"; }
        else { $consulta = "SELECT * FROM colecciones AS a JOIN producto_coleccion AS b WHERE a.id_coleccion = b.id_coleccion AND b.ref_producto LIKE '$ref'"; } 
        
        $resultados = $base_datos->haz_consulta($consulta);        

        $colecciones = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_coleccion = htmlentities_(trim($row["id_coleccion"]));
            $nombre_coleccion = htmlentities_(trim($row["nombre_coleccion"]));
            $colecciones[$id_coleccion] = $nombre_coleccion;
        }
        
        return $colecciones;
    }


    function poner_colecciones($ref, $contador)
    {
        global $base_datos;

        $colecciones = obtener_colecciones();
        $colecciones_perteneciente = obtener_colecciones($ref);

        $id_coleccion_enviado = recoger_get("mostrar_coleccion");
        if (recoger_post("enviado_post")) { $id_coleccion_enviado = recoger_post("mostrar_coleccion"); }

        //echo '<select name="colecciones_' . htmlentities_($ref) . '[]" multiple>';
        echo '<select name="colecciones_' . htmlentities_($contador) . '[]" multiple>';
        foreach ($colecciones as $id_coleccion => $nombre_coleccion)
        {
            $selected = (array_key_exists($id_coleccion, $colecciones_perteneciente) && $ref != -1 || $ref == -1 && $id_coleccion_enviado == $id_coleccion) ? " selected" : "";
            echo '<option value="' . $id_coleccion . '"' . $selected . '>' . $nombre_coleccion . '</option>';            
        }
        echo '</select>';
        
    }


    function obtener_disenyadores($ref = -1)
    {
        global $base_datos;

        //$ref = mysql_real_escape_string(htmlentities_(trim($ref)));

        if ($ref == -1) { $consulta = "SELECT * FROM disenyadores"; }
        else { $consulta = "SELECT * FROM disenyadores AS a JOIN tela_disenyador AS b WHERE a.id_disenyador = b.id_disenyador AND b.ref_tela LIKE '$ref'"; } 
        
        $resultados = $base_datos->haz_consulta($consulta);        

        $disenyadores = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_disenyador = htmlentities_(trim($row["id_disenyador"]));
            $nombre_disenyador = htmlentities_(trim($row["nombre_disenyador"]));
            $disenyadores[$id_disenyador] = $nombre_disenyador;
        }
        
        return $disenyadores;
    }


    function poner_disenyadores($ref, $contador)
    {
        global $base_datos;

        $disenyadores = obtener_disenyadores();
        $disenyadores_perteneciente = obtener_disenyadores($ref);
        
        //echo '<select name="disenyadores_' . htmlentities_($ref) . '[]" id="disenyadores_' . htmlentities_($ref) . '" multiple>';
        echo '<select name="disenyadores_' . htmlentities_($contador) . '[]" id="disenyadores_' . htmlentities_($contador) . '" multiple>';
        foreach ($disenyadores as $id_disenyador => $nombre_disenyador)
        {
            $selected = (array_key_exists($id_disenyador, $disenyadores_perteneciente) && $ref != -1) ? " selected" : "";
            echo '<option value="' . $id_disenyador . '"' . $selected . '>' . $nombre_disenyador . '</option>';            
        }
        echo '</select>';
    }


    function poner_dimension_pieza($ref, $contador)
    {
        global $constantes;
        
        $dimension_pieza = obtener_dimension_pieza($ref);
        
        //echo '<select name="disenyadores_' . htmlentities_($ref) . '[]" id="disenyadores_' . htmlentities_($ref) . '" multiple>';
        echo '<input type="text" name="dimension_pieza_' . htmlentities_($contador) . '" id="dimension_pieza_' . htmlentities_($contador) . '" value="' . $dimension_pieza . '">';
        echo '<br>Metros por defecto: ' . $constantes["METROS_PIEZA_POR_DEFECTO"];
        if ($dimension_pieza == $constantes["METROS_PIEZA_POR_DEFECTO"]) { echo '<br>Actualmente utilizando el valor por defecto'; }
    }


    function obtener_dimension_pieza($ref)
    {
        global $base_datos, $constantes;

        $consulta = "SELECT * FROM tela_metros_pieza WHERE ref_tela LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);

        if (mysql_num_rows($resultados) > 0)
        {
            $row = mysql_fetch_assoc($resultados);
            $dimension = $row["metros_pieza"];
        }
        else { $dimension = $constantes["METROS_PIEZA_POR_DEFECTO"]; }
        
        return $dimension;
    }


    function obtener_tematicas($ref = -1)
    {
        global $base_datos, $constantes;

        //$ref = mysql_real_escape_string(htmlentities_(trim($ref)));

        if (!isset($constantes["IDIOMA_POR_DEFECTO"]) || isset($constantes["IDIOMA_POR_DEFECTO"]) && (trim($constantes["IDIOMA_POR_DEFECTO"]) == "" || !is_numeric(trim($constantes["IDIOMA_POR_DEFECTO"])))) { mostrar_error('No se pudo recoger un idioma por defecto. Por favor, define la constante del idioma por defecto en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else { $idioma_por_defecto = $constantes["IDIOMA_POR_DEFECTO"]; }

        if ($ref == -1) { $consulta = "SELECT * FROM tematicas AS a JOIN tematica_idioma AS b WHERE a.id_tematica = b.id_tematica AND b.id_idioma = $idioma_por_defecto ORDER BY tematica"; }
        else { $consulta = "SELECT * FROM tematicas AS a JOIN tematica_idioma AS b JOIN libro_tematica AS c WHERE a.id_tematica = b.id_tematica AND b.id_tematica = c.id_tematica AND b.id_idioma = $idioma_por_defecto AND c.ref_libro LIKE '$ref' ORDER BY tematica"; }
        
        $resultados = $base_datos->haz_consulta($consulta);        

        $tematicas = Array();
        while ($row = mysql_fetch_assoc($resultados))
        {
            $id_tematica = htmlentities_(trim($row["id_tematica"]));
            $nombre_tematica = htmlentities_(trim($row["tematica"]));
            $tematicas[$id_tematica] = $nombre_tematica;
        }
        
        return $tematicas;
    }

    function poner_tematicas($ref, $contador)
    {
        global $base_datos;

        $tematicas = obtener_tematicas();
        $tematicas_perteneciente = obtener_tematicas($ref);
        
        //echo '<select name="tematicas_' . htmlentities_($ref) . '[]" id="tematicas_' . htmlentities_($ref) . '" multiple>';
        echo '<select name="tematicas_' . htmlentities_($contador) . '[]" id="tematicas_' . htmlentities_($contador) . '" multiple>';
        foreach ($tematicas as $id_tematica => $nombre_tematica)
        {
            $selected = (array_key_exists($id_tematica, $tematicas_perteneciente) && $ref != -1) ? " selected" : "";
            echo '<option value="' . $id_tematica . '"' . $selected . '>' . $nombre_tematica . '</option>';            
        }
        echo '</select>';
    }


    function poner_idiomas($ref, $contador)
    {
        global $base_datos;

        $idiomas = obtener_idiomas(-1, TRUE);
        $idiomas_perteneciente = obtener_idiomas($ref, TRUE);
        
        //echo '<select name="idiomas_' . htmlentities_($ref) . '[]" id="idiomas_' . htmlentities_($ref) . '" multiple>';
        echo '<select name="idiomas_' . htmlentities_($contador) . '[]" id="idiomas_' . htmlentities_($contador) . '" multiple>';
        foreach ($idiomas as $id_idioma => $nombre_idioma)
        {
            $selected = (array_key_exists($id_idioma, $idiomas_perteneciente) && $ref != -1) ? " selected" : "";
            echo '<option value="' . $id_idioma . '"' . $selected . '>' . $nombre_idioma . '</option>';            
        }
        echo '</select>';
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = recoger_post("accion");
        
        if (trim($se_ha_enviado) == "") { $se_ha_enviado = FALSE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $directorio = recoger_post("directorio");
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                /*
                if ($ref != "")
                {
                    $operacion = agregar($ref);
                    if (!$operacion) { mostrar_error("No se ha podido agregar el producto nuevo</b>."); }
                    else { echo "Producto nuevo agregado<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar el producto, puede que falten datos en el formulario."); }
                */
                if ($directorio != "")
                {
                    $operacion = agregar_masivamente($directorio);
                    if (!$operacion) { mostrar_error("No se han podido agregar los productos nuevos</b>."); }
                    else { echo "<br><b>$operacion</b> Producto(s) nuevo(s) agregado(s)<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar los productos, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                if ($ref != "")
                {
                    $operacion = eliminar($ref);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar el producto con referencia <b>" . htmlentities_($ref) . "</b>."); }
                    else { echo "Producto con referencia <b>" . htmlentities_($ref) . "</b> eliminado<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar el producto con referencia <b>" . htmlentities_($ref) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                if ($ref != "")
                {
                    $operacion = modificar($ref);
                    if (!$operacion) { mostrar_error("No se ha podido modificar el producto con referencia <b>" . htmlentities_($ref) . "</b>."); }
                    else { echo "Producto con referencia <b>'" . htmlentities_($ref) . "'</b> modificado.<br>"; }
                } else { mostrar_advertencia("No se ha podido modificar el producto con referencia <b>" . htmlentities_($ref) . "</b>, puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que agrega de forma masiva los productos de un directorio:
    function agregar_masivamente($directorio)
    {
        $todo_bien = TRUE;
        
        //Recoge datos enviados:
        $prefijo = strtoupper(trim(recoger_post("prefijo")));
        $precio = trim(recoger_post("precio_-1"));
        $id_fabricante = trim(recoger_post("fabricante_-1"));
        $id_marca = trim(recoger_post("marca_" . $id_fabricante . "_-1"));
        $tipo = trim(recoger_post("tipo_-1"));

        //Si falta algun dato masivo por enviar, da error y sale:
        $errores = FALSE;
        if ($directorio == "")
        {
            echo "El directorio no se ha enviado<br>";
            $errores = TRUE;
        }
        if ($precio == "" || $precio <= 0)
        {
            echo "El precio es menor o igual que cero o no se ha enviado<br>";
            $errores = TRUE;
        }
        if ($id_fabricante == "" || $id_fabricante == 0 || $id_fabricante == -1)
        {
            echo "No se ha enviado un fabricante (ID recibido = $id_fabricante)<br>";
            $errores = TRUE;
        }
        if ($id_marca == "" || $id_marca == 0 || $id_marca == -1)
        {
            echo "No se ha enviado una marca (ID recibido = $id_marca)<br>";
            $errores = TRUE;
        }
        if ($tipo == "")
        {
            echo "No se ha enviado un tipo<br>";
            $errores = TRUE;
        }
        if ($errores) { return FALSE; }

        $directorio = str_replace("\\", "/", $directorio);
        
        echo "Datos masivos:<br>";
        echo "* Directorio: <b>$directorio</b><br>";
        echo "* Prefijo: <b>$prefijo</b><br>";
        echo "* Precio: <b>$precio</b><br>";
        echo "* Fabricante ID: <b>$id_fabricante</b><br>";
        echo "* Marca ID: <b>$id_marca</b><br>";
        echo "* Tipo: $tipo<br>";
        echo "<br>";             

      
        //Si el directorio no existe, da error y sale:
        if (!file_exists($directorio) || !is_dir($directorio))
        {
             echo "El directorio <b>$directorio</b> no existe";
             return FALSE;
        }

        echo "<br>Leyendo directorio <b>" . $directorio . "</b><br><br>";
        
        $productos_agregados = 0;
        
        //Recorre los subdirectorios:
        $archivos = scandir($directorio);
        foreach ($archivos as $archivo)
        {
            $ruta_archivo = $directorio . "/" . $archivo;
            if (file_exists($ruta_archivo) && is_dir($ruta_archivo))
            {
               $mostrado_subdirectorio = FALSE;
               //Recorre los archivos de los subdirectorios:
               $subarchivos = scandir($ruta_archivo);
               $productos_agregados_directorio = 0;
               foreach ($subarchivos as $subarchivo)
               {
                    $ruta_subarchivo = $ruta_archivo . "/" . $subarchivo;
                    if (file_exists($ruta_subarchivo) && !is_dir($ruta_subarchivo))
                    {
                        //Comprueba que sean extensiones de imagenes (jpg, jpeg, gif o png)
                        $extension = explode(".", $subarchivo);
                        $subarchivo_sin_extension = $extension[0];
                        $extension = strtolower($extension[sizeof($extension)-1]);
                        if ($extension == "jpg" || $extension == "jpeg" || $extension == "gif" || $extension == "png")
                        {
                            $referencia = strtoupper(str_replace("-", "", str_replace("_", "", $prefijo . $subarchivo_sin_extension)));
                            $coleccion = $categoria = $archivo;
                            if ($tipo != "tela") { $coleccion = ""; }
                            $nombre = "$coleccion ($referencia)";
                            
                            //Obtener ID de la coleccion y de la categoria:
                            $ids_obtenidas = TRUE;
                            $id_coleccion = obtener_id_coleccion($coleccion);
                            $id_categoria = obtener_id_categoria($categoria);
                            if ($tipo != "tela") { $id_coleccion = -1; }

                            if (!$mostrado_subdirectorio)
                            {
                                $mostrado_subdirectorio = TRUE;
                                
                                echo "* Subdirectorio <b>$archivo</b><br>";

                                //Si algun ID no se puede encontrar, continua sin tener en cuenta la imagen:
                                if ($id_coleccion == -1 && $tipo == "tela") { echo "** => No se puede obtener la ID de la coleccion <b>$coleccion</b><br>"; $ids_obtenidas = FALSE; }
                                if ($id_categoria == -1) { echo "** => No se puede obtener la ID de la categoria <b>$categoria</b><br>"; $ids_obtenidas = FALSE; }

                                if ($ids_obtenidas)
                                { 
                                    echo "** Coleccion: $coleccion (ID = <b>$id_coleccion</b>)<br>";
                                    echo "** Categoria: $categoria (ID = <b>$id_categoria</b>)<br>";
                                }
                            }

                            if ($id_coleccion == -1 && $tipo == "tela" || $id_categoria == -1) { $ids_obtenidas = FALSE; }
                            if (!$ids_obtenidas) { continue; }

                            echo "*** Archivo <b>$subarchivo</b> (extension: $extension)<br>";
                            
                            if ($subarchivo[0] == ".")
                            {
								echo "*** => Archivo ignorado (por comenzar por punto).<br>";
								continue;
							}
                            
                            echo "*** => Ruta: $ruta_subarchivo<br>";
                            echo "*** => Referencia: <b>$referencia</b><br>";
                            echo "*** => Nombre: $nombre<br>";
                            
                            //Se agrega el producto:
                            echo "*** => Ejecutando: agregar('$referencia', '$nombre', $id_coleccion, $id_categoria, '$ruta_subarchivo');<br>";
                            $agregado = agregar($referencia, $nombre, $id_coleccion, $id_categoria, $ruta_subarchivo);
                            if ($agregado) { echo "*** => Producto <b>agregado con exito</b><br>"; $productos_agregados++; $productos_agregados_directorio++; }
                            else { echo "*** => Producto <b>NO agregado</b> :(<br>"; $todo_bien = FALSE; }
                        }
                    }
               }
               if ($archivo != "." && $archivo != "..")
               {
                    echo "** Producto(s) agregado(s) del directorio <b>$archivo</b>: $productos_agregados_directorio<br><br>";
               }
            }
        }
        
        return $productos_agregados;
    }




    //Funcion que calcula si ya existe un registro o no:
    function existe($ref)
    {
        global $base_datos;
        
        //$ref = mysql_real_escape_string(htmlentities_($ref));
        //$ref = mysql_real_escape_string(htmlentities_(trim($ref)));
        
        $consulta = "SELECT * FROM productos WHERE UPPER(ref) LIKE '".strtoupper($ref)."'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysql_num_rows($resultados);
    }

    //Funcion que recibe el nombre de un archivo y devuelve el correcto:
    function nombre_archivo_correcto($nombre)
    {
        //FALTARIA: substituir todos aquellos caracteres prohibidos para un archivo (caracteres raros, etc).
        return strtolower(str_replace(":", "", str_replace(" ", "_", str_replace("-", "_", trim($nombre)))));
    }

    //Funcion que sube la imagen o imagenes de un producto (y resizea si hace falta):
    function subir_imagenes($ref, $ref_nueva = "", $ruta_archivo = "")
    {
        global $constantes, $HTTP_POST_FILES;

        $ref = trim($ref);
        $ref_nueva = trim($ref_nueva);
        
        $operacion = TRUE;

/*
        if ($ref != -1) { $archivo = recoger_file("imagen_" . $ref); }
        else { $archivo = recoger_file("imagen_nuevo_producto"); }
        if ($ref != -1) { $archivo_mini = recoger_file("imagen_miniatura_" . $ref); }
        else { $archivo_mini = recoger_file("imagen_miniatura_nuevo_producto"); }
*/

    $archivo["tmp_name"] = $ruta_archivo;


/*
            if (is_uploaded_file($archivo_mini['tmp_name']))
            {
                $archivo_bytes = $archivo_mini['size'];
                $maximo_bytes = $constantes["IMAGENES_PRODUCTOS_MINI_BYTES_MAXIMO"];
                $directorio = "../img/productos/";
                //$archivo_nombre_extension = explode($archivo_mini['name']);
                list($ancho, $alto, $tipo, $html) = getimagesize($archivo_mini['tmp_name']);
                $extension = str_replace("jpeg", "jpg", str_replace(".", "", image_type_to_extension($tipo)));
                //$extension = str_replace(".", "", image_type_to_extension($tipo));
                if (strtolower($extension) != "gif" && strtolower($extension) != "jpg" && strtolower($extension) != "jpeg" && strtolower($extension) != "png") { mostrar_error("La imagen debe tener una de las siguientes extensiones: gif, jpg, jpeg o png. Si la imagen ya la tiene, es posible que no corresponda en realidad a su formato."); exit(); }
                if ($ancho > $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] || $alto > $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]) { mostrar_error("La imagen debe tener como maximo " . $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] . "x" . $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"] . " pixels"); exit(); }
                //$extension = trim($archivo_nombre_extension[1]);
                //if ($extension == "") { $extension = "gif"; }
                $nombre = $ref_nueva . "." . $extension;
                $nombre = nombre_archivo_correcto($nombre);

                if ($archivo_bytes > $maximo_bytes) { mostrar_error("La imagen en miniatura debe tener $maximo_bytes o menos."); $operacion = FALSE; }
                else
                {
                    $operacion = eliminar_imagen_producto($ref, $directorio);
                    if ($operacion) { $operacion = copy($archivo_mini['tmp_name'], $directorio.$nombre); }
                }

                if (!$operacion) { mostrar_error("Error al subir la im&aacute;gen en miniatura del producto con referencia $ref_nueva (nueva: $ref_nueva)"); }
            }
*/
        //if (is_uploaded_file($archivo['tmp_name']))
        if (file_exists($archivo['tmp_name']))
        { 
            $archivo["size"] = filesize($archivo['tmp_name']);
            $archivo_bytes = $archivo['size'];
            $maximo_bytes = $constantes["IMAGENES_PRODUCTOS_ZOOM_BYTES_MAXIMO"];
            $directorio = "../img/productos/zoom/";
            //$archivo_nombre_extension = explode(".", $archivo['name']);
            list($ancho, $alto, $tipo, $html) = getimagesize($archivo['tmp_name']);
            $extension = str_replace("jpeg", "jpg", str_replace(".", "", image_type_to_extension($tipo)));
            //$extension = str_replace(".", "", image_type_to_extension($tipo));
            if (strtolower($extension) != "gif" && strtolower($extension) != "jpg" && strtolower($extension) != "jpeg" && strtolower($extension) != "png") { mostrar_error("La imagen debe tener una de las siguientes extensiones: gif, jpg, jpeg o png. Si la imagen ya la tiene, es posible que no corresponda en realidad a su formato."); exit(); }
            if ($ancho > $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"] || $alto > $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]) { mostrar_error("La imagen debe tener como maximo " . $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"] . "x" . $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"] . " pixels"); exit(); }
            //$extension = trim($archivo_nombre_extension[1]);
            //if ($extension == "") { $extension = "gif"; }
            $nombre = $ref_nueva . "." . $extension;
            $nombre = nombre_archivo_correcto($nombre);

            if ($archivo_bytes > $maximo_bytes) { mostrar_error("La imagen original debe tener $maximo_bytes o menos."); $operacion = FALSE; }
            else
            { 
                $operacion = eliminar_imagen_producto($ref, $directorio);
                if ($operacion) { $operacion = copy($archivo['tmp_name'], $directorio.$nombre); }

            }
            
            if (!$operacion) { mostrar_error("Error al subir la im&aacute;gen original del producto con referencia $ref (nueva: $ref_nueva)"); exit(); }
            /*else if (is_uploaded_file($archivo_mini['tmp_name']))
            {
                $archivo_bytes = $archivo_mini['size'];
                $maximo_bytes = $constantes["IMAGENES_PRODUCTOS_MINI_BYTES_MAXIMO"];
                $directorio = "../img/productos/";
                //$archivo_nombre_extension = explode($archivo_mini['name']);
                list($ancho, $alto, $tipo, $html) = getimagesize($archivo['tmp_name']);
                $extension = image_type_to_extension($tipo);
                if (strtolower($extension) != "gif" && strtolower($extension) != "jpg" && strtolower($extension) != "jpeg" && strtolower($extension) != "png") { mostrar_error("La imagen debe tener una de las siguientes extensiones: gif, jpg, jpeg o png. Si la imagen ya la tiene, es posible que no corresponda en realidad a su formato."); exit(); }
                if ($ancho > $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] || $alto > $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]) { mostrar_error("La imagen debe tener como maximo " . $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] . "x" . $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"] + " pixels"); exit(); }
                //$extension = trim($archivo_nombre_extension[1]);
                //if ($extension == "") { $extension = "gif"; }
                $nombre = $ref_nueva . "." . $extension;
                $nombre = nombre_archivo_correcto($nombre);

                if ($archivo_bytes > $maximo_bytes) { mostrar_error("La imagen en miniatura debe tener $maximo_bytes o menos."); $operacion = FALSE; }
                else
                {
                    $operacion = eliminar_imagen_producto($ref, $directorio);
                    if ($operacion) { $operacion = copy($archivo_mini['tmp_name'], $directorio.$nombre); }
                }

                if (!$operacion) { mostrar_error("Error al subir la im&aacute;gen en miniatura del producto con referencia $ref_nueva (nueva: $ref_nueva)"); }
            }*/
            
            //else if (file_exists($directorio.$nombre) && !is_uploaded_file($archivo_mini['tmp_name']) && recoger_post("reducir_imagen_" . $ref))
            else if (file_exists($directorio.$nombre))
            {
                //Copia la imagen original, que ya esta en su directorio, la resizea y la guarda en el otro directorio:
                $operacion = eliminar_imagen_producto($ref, "../img/productos/");
                //if ($operacion) { copy($directorio.$nombre, "../img/productos/" . $nombre); }
                
                //Se resizea la imagen (gracias a PHPit - Totally PHP):
                // Load image
                $image = open_image($directorio . $nombre);
                if ($image === false) { mostrar_error("La imagen " . $directorio . $nombre . " existe pero no puede abrirse."); exit(0);}

                // Get original width and height
                //$width = imagesx($image);
                //$height = imagesy($image);

                // New width and height
                
                //Modificacion: respeta el ratio de aspecto:
                //$ancho_nuevo = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
                //$alto_nuevo = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"];
                $ancho_nuevo = $ancho;
                $alto_nuevo = $alto;
                if ($ancho_nuevo > $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] || $alto_nuevo > $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"])
                {
                    if ($ancho_nuevo > $alto_nuevo)
                    {
                        $ancho_nuevo = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
                        $ratio = $ancho / $ancho_nuevo;
                        $alto_nuevo /= $ratio;
                    }
                    else if ($alto_nuevo > $ancho_nuevo)
                    {
                        $alto_nuevo = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"];
                        $ratio = $alto / $alto_nuevo;
                        $ancho_nuevo /= $ratio;
                    }
                    else
                    {
                        $ancho_nuevo = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
                        $alto_nuevo = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"];
                    }
                }
                $ancho_nuevo = (int) $ancho_nuevo;
                $alto_nuevo = (int) $alto_nuevo;

                // Resample
                $image_resized = imagecreatetruecolor($ancho_nuevo, $alto_nuevo);
                imagecopyresampled($image_resized, $image, 0, 0, 0, 0, $ancho_nuevo, $alto_nuevo, $ancho, $alto);

                // Display resized image
                //header('Content-type: image/jpeg');
                $extension = str_replace("jpeg", "jpg", str_replace(".", "", image_type_to_extension($tipo)));
                if ($extension == "jpg" || $extension == "jpeg") { imagejpeg($image_resized, "../img/productos/" . $nombre); }
                else if ($extension == "gif") { imagegif($image_resized, "../img/productos/" . $nombre); }
                else if ($extension == "png") { imagepng($image_resized, "../img/productos/" . $nombre); }
                else { mostrar_error("Error al resizear la imagen partiendo de la original. No se encuentra el tipo $tipo ($extension)."); }
                //die();

                
                
            }
        }
      
        return $operacion;
    }


    //Funcion que agrega un registro nuevo:
    function agregar($ref_nueva, $nombre_nuevo, $id_coleccion, $id_categoria, $ruta_archivo)
    {
        global $base_datos, $constantes;

        //$ref = strtoupper(mysql_real_escape_string(trim($ref)));
        //$ref = strtoupper(mysql_real_escape_string(trim($ref)));
        $ref = "-1";

        $idiomas = obtener_idiomas();

        $contador = recoger_post("contador");
        //echo "kontataaaaaaa=$contador<br>";

        $mostrar = (recoger_post("mostrar_" . $ref)) ? 1 : 0;
        
        //$ref_nueva = str_replace(" ", "_", strtoupper(mysql_real_escape_string(trim(recoger_post("ref_" . $ref)))));
        
        if ($ref != -1 && $ref != $ref_nueva && existe($ref_nueva) || $ref == -1 && existe($ref_nueva)) { echo "*** => El registro con referencia <b>" . htmlentities_($ref_nueva) . "</b> ya <b>existe</b>.<br>"; return FALSE; }
        else if ($ref == -1 && existe($ref)) { mostrar_error("El registro con referencia <b>" . htmlentities_($ref) . "</b> ya existe."); return FALSE; }
        $fabricante = mysql_real_escape_string(trim(recoger_post("fabricante_" . $ref)));
        $marca = mysql_real_escape_string(trim(recoger_post("marca_" . $fabricante . "_" . $ref)));
        //if ($marca == "" || !$marca && $marca != 0) { $marca = -1; }
        //$colecciones = recoger_post("colecciones_" . $contador);
        $colecciones[0] = $id_coleccion;
        //$colecciones = recoger_post("colecciones_" . $ref);
        //$categorias = recoger_post("categorias_" . $contador);
        $categorias[0] = $id_categoria;
        //$categorias = recoger_post("categorias_" . $ref);
        foreach ($idiomas as $id_idioma => $idioma)
        {
            //$nombre[$id_idioma] = mysql_real_escape_string(trim(recoger_post("nombre_" . $id_idioma . "_" . $ref)));
            $nombre[$id_idioma] = mysql_real_escape_string(trim($nombre_nuevo));
            //$eval[$id_idioma] = (recoger_post("eval_" . $id_idioma . "_" . $ref)) ? 1 : 0;
            $eval[$id_idioma] = 0;
            //$descripcion[$id_idioma] = mysql_real_escape_string(trim(recoger_post("descripcion_" . $id_idioma . "_" . $ref)));
            $descripcion[$id_idioma] = "";
        }
        
        $tipo = trim(strtolower(recoger_post("tipo_" . $ref)));
        if ($tipo != "tela" && $tipo != "libro") { $tipo = "otro"; }
        
        if ($tipo == "tela")
        {
            //$disenyadores = recoger_post("disenyadores_" . $ref);
            $disenyadores = recoger_post("disenyadores_" . $contador);
            $dimension = recoger_post("dimension_pieza_" . $contador);
        }
        else if ($tipo == "libro")
        {
            //$tematicas = recoger_post("tematicas_" . $ref);
            $tematicas = recoger_post("tematicas_" . $contador);
            //$idiomas_enviado = recoger_post("idiomas_" . $ref);
            $idiomas_enviado = recoger_post("idiomas_" . $contador);
        }

        if (!is_array($categorias)) { $errores = TRUE; mostrar_error("Debes elegir al menos una categoria"); }
        //if ($tipo == "tela" && !is_array($disenyadores)) { mostrar_error("Debes elegir al menos un dise&ntilde;ador"); }
        if ($tipo == "libro")
        {
            $errores = FALSE;
            if (!is_array($tematicas)) { $errores = TRUE; mostrar_error("Debes elegir al menos una tem&aacute;tica"); }
            if (!is_array($idiomas_enviado)) { $errores = TRUE; mostrar_error("Debes elegir al menos un idioma"); }
            if ($errores) { exit(); }
            
        }
        $precio = recoger_post("precio_" . $ref);
        $precio = str_replace(",", ".", $precio);
        $errores = FALSE;
        if ($ref_nueva == "") { $errores = TRUE; mostrar_error("Debes poner una referencia"); }
        if ($fabricante == "") { $errores = TRUE; mostrar_error("Debes poner un fabricante"); }
        if ($marca == "") { $errores = TRUE; mostrar_error("Debes poner una marca"); }
        if ($precio == "" || $precio <= 0 || $precio > 9999) { $errores = TRUE; mostrar_error("El precio debe ser un valor numerico superior a 0 e inferior a 9999."); }
        if ($errores) { exit(); }

        $consulta = "INSERT INTO productos (ref, id_fabricante, id_marca, mostrar, precio_normal) VALUES ('$ref_nueva', $fabricante, $marca, $mostrar, $precio)";
        echo "*** => SQL: $consulta<br>";
        $operacion = $base_datos->haz_consulta($consulta);

        $consulta = "INSERT INTO producto_tipo (ref_producto, tipo) VALUES ('$ref_nueva', '$tipo')";
        echo "*** => SQL: $consulta<br>";
        $operacion1 = $base_datos->haz_consulta($consulta);

        if (is_array($colecciones))
        {
            foreach ($colecciones as $coleccion)
            {
                if ($coleccion == -1) { continue; }
                $consulta = "INSERT INTO producto_coleccion (ref_producto, id_coleccion) VALUES ('$ref_nueva', $coleccion)";
                echo "*** => SQL: $consulta<br>";
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
        }

        if (is_array($categorias))
        {
            foreach ($categorias as $categoria)
            {
                $consulta = "INSERT INTO producto_categoria (ref_producto, id_categoria) VALUES ('$ref_nueva', $categoria)";
                echo "*** => SQL: $consulta<br>";
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
        }

        if (is_array($idiomas))
        {
            foreach ($idiomas as $id_idioma => $idioma)
            {
                $consulta = "INSERT INTO producto_nombre (ref_producto, id_idioma, nombre) VALUES ('$ref_nueva', $id_idioma, '" . $nombre[$id_idioma] . "')";
                echo "*** => SQL: $consulta<br>";
                $operacion1 = $base_datos->haz_consulta($consulta);

                $consulta = "INSERT INTO producto_descripcion (ref_producto, id_idioma, descripcion, eval) VALUES ('$ref_nueva', $id_idioma, '" . $descripcion[$id_idioma] . "', " . $eval[$id_idioma] . ")";
                echo "*** => SQL: $consulta<br>";
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
        }

        if ($tipo == "tela")
        {
            if (is_array($disenyadores))
            {
                foreach ($disenyadores as $disenyador)
                {
                    $consulta = "INSERT INTO tela_disenyador (ref_tela, id_disenyador) VALUES ('$ref_nueva', $disenyador)";
                    echo "*** => SQL: $consulta<br>";
                    $operacion1 = $base_datos->haz_consulta($consulta);
                }
            }
            if ($dimension == $constantes["METROS_PIEZA_POR_DEFECTO"] || $dimension <= 0 || trim($dimension) == "")
            {
                $consulta = "DELETE FROM tela_metros_pieza WHERE ref_tela LIKE '$ref'";
                echo "*** => SQL: $consulta<br>";
                $operacion1 = $base_datos->haz_consulta($consulta);
                $consulta = "DELETE FROM tela_metros_pieza WHERE ref_tela LIKE '$ref_nueva'";
                echo "*** => SQL: $consulta<br>";
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
            else if ($dimension > 0)
            {
                $consulta = "INSERT INTO tela_metros_pieza (ref_tela, metros_pieza) VALUES ('$ref_nueva', $dimension)";
                echo "*** => SQL: $consulta<br>";
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
        }
        else if ($tipo == "libro")
        {
            if (is_array($tematicas))
            {
                foreach ($tematicas as $tematica)
                {
                    $consulta = "INSERT INTO libro_tematica (ref_libro, id_tematica) VALUES ('$ref_nueva', $tematica)";
                    echo "*** => SQL: $consulta<br>";
                    $operacion1 = $base_datos->haz_consulta($consulta);
                }
            }

            if (is_array($idiomas_enviado))
            {
                foreach ($idiomas_enviado as $idioma)
                {
                    $consulta = "INSERT INTO libro_idioma (ref_libro, id_idioma) VALUES ('$ref_nueva', $idioma)";
                    echo "*** => SQL: $consulta<br>";
                    $operacion1 = $base_datos->haz_consulta($consulta);
                }
            }
        }

        renombrar_imagen_producto($ref, $ref_nueva, "../img/productos/");
        renombrar_imagen_producto($ref, $ref_nueva, "../img/productos/zoom/");

        echo "*** => Ejecutando: subir_imagenes('$ref', '$ref_nueva', '$ruta_archivo');<br>";
        $imagenes_subidas = subir_imagenes($ref, $ref_nueva, $ruta_archivo);
        
        if (!$imagenes_subidas) { mostrar_error("Error al subir la im&aacute;gen o im&aacute;genes del producto con referencia $ref_nueva"); }

        return $operacion;
    }
    
    
    //Funcion que elimina un registro existente:
    function eliminar($ref, $eliminar_imagenes = TRUE)
    {
        global $base_datos;

        //$id_idioma = mysql_real_escape_string($id_idioma);

        $ref = mysql_real_escape_string(trim($ref));

        $consulta = "DELETE FROM productos WHERE ref LIKE '$ref'";
        $operacion = $base_datos->haz_consulta($consulta);
        
        //Si la operacion ha ido bien y se ha enviado eliminar imagenes, se procede:
        if ($operacion && $eliminar_imagenes)
        {
            $directorio = "../img/productos/";
            $operacion2 = eliminar_imagen_producto($ref, $directorio);
            
            $directorio = "../img/productos/zoom/";
            $operacion3 = eliminar_imagen_producto($ref, $directorio);
        }
        
        return $operacion;
    }


    function eliminar_imagen_producto($ref, $directorio = "../img/productos/")
    {
            $operacion = TRUE;
            
            $extensiones = Array(".gif", ".jpg", ".jpeg", ".png");
            
            $nombre = nombre_archivo_correcto($ref);
            $puntero = opendir($directorio);
            if (!$directorio) { mostrar_error("No se pudo abrir el directorio $directorio para poder borrar las im&aacute;genes."); exit(); }
            while ($archivo = readdir($puntero))
            {
                foreach ($extensiones as $extension)
                {
                    $extension = strtolower($extension);
                    if ($archivo == $nombre . $extension)
                    {
                        $operacion = unlink($directorio . $nombre . $extension);
                        if (!$operacion) { mostrar_error("No se pudo eliminar $directorio . $nombre . $extension. Se deber&aacute; hacer manualmente."); }
                    }
                }
            }
            
            return $operacion;
    }


    function renombrar_imagen_producto($ref, $ref_nueva, $directorio = "../img/productos/")
    {
            $operacion = TRUE;
            
            $extensiones = Array(".gif", ".jpg", ".jpeg", ".png");
            
            $nombre = nombre_archivo_correcto($ref);
            $nombre_nuevo = nombre_archivo_correcto($ref_nueva);
            $puntero = opendir($directorio);
            if (!$directorio) { mostrar_error("No se pudo abrir el directorio $directorio para poder renombrar las im&aacute;genes."); exit(); }
            while ($archivo = readdir($puntero))
            {
                foreach ($extensiones as $extension)
                {
                    $extension = strtolower($extension);
                    if ($archivo == $nombre . $extension)
                    {
                        $operacion = rename($directorio . $nombre . $extension, $directorio . $nombre_nuevo . $extension);
                        if (!$operacion) { mostrar_error("No se pudo renombrar $directorio . $nombre . $extension a $directorio . $nombre_nuevo . $extension. Se deber&aacute; hacer manualmente."); }
                    }
                }
            }
            
            return $operacion;
    }
    
    
    //Funcion que modifica un registro existente:
    function modificar($ref)
    {
        global $base_datos;

        //$ref = mysql_real_escape_string(htmlentities_(trim($ref)));

        if ($ref == -1) { mostrar_error("No se puede poner la referencia -1."); exit(); }
        
        $ref_nueva = str_replace(" ", "_", strtoupper(mysql_real_escape_string(trim(recoger_post("ref_" . $ref)))));
        if ($ref != $ref_nueva && existe($ref_nueva)) { mostrar_error("El registro con referencia <b>" . htmlentities_($ref_nueva) . "</b> ya existe."); return FALSE; }
        else
        {
            //$operacion1 = eliminar($ref, FALSE);        
        
            //$operacion2 = agregar($ref);
            
            $operacion = modificar_proceder($ref);
        
            return ($operacion);
        }
    }
    
    function modificar_proceder($ref)
    {
        global $base_datos, $constantes;

        //$ref = strtoupper(mysql_real_escape_string(trim($ref)));
        $ref = strtoupper(mysql_real_escape_string(trim($ref)));

        $idiomas = obtener_idiomas();

        $contador = recoger_post("contador");
        //echo "kontataaaaaaa=$contador<br>";

        $mostrar = (recoger_post("mostrar_" . $ref)) ? 1 : 0;
        
        $ref_nueva = str_replace(" ", "_", strtoupper(mysql_real_escape_string(trim(recoger_post("ref_" . $ref)))));
        
        if ($ref != -1 && $ref != $ref_nueva && existe($ref_nueva) || $ref == -1 && existe($ref_nueva)) { mostrar_error("El registro con referencia <b>" . htmlentities_($ref_nueva) . "</b> ya existe."); return FALSE; }
        else if ($ref == -1 && existe($ref)) { mostrar_error("El registro con referencia <b>" . htmlentities_($ref) . "</b> ya existe."); return FALSE; }
        $fabricante = mysql_real_escape_string(trim(recoger_post("fabricante_" . $ref)));
        $marca = mysql_real_escape_string(trim(recoger_post("marca_" . $fabricante . "_" . $ref)));
        //if ($marca == "" || !$marca && $marca != 0) { $marca = -1; }
        $colecciones = recoger_post("colecciones_" . $contador);
        //$colecciones = recoger_post("colecciones_" . $ref);
        $categorias = recoger_post("categorias_" . $contador);
        //$categorias = recoger_post("categorias_" . $ref);
        foreach ($idiomas as $id_idioma => $idioma)
        {
            $nombre[$id_idioma] = mysql_real_escape_string(trim(recoger_post("nombre_" . $id_idioma . "_" . $ref)));
            $eval[$id_idioma] = (recoger_post("eval_" . $id_idioma . "_" . $ref)) ? 1 : 0;
            $descripcion[$id_idioma] = mysql_real_escape_string(trim(recoger_post("descripcion_" . $id_idioma . "_" . $ref)));
        }
        
        $tipo = trim(recoger_post("tipo_" . $ref));
        if ($tipo != "tela" && $tipo != "libro") { $tipo = "otro"; }
        if ($tipo == "tela")
        {
            //$disenyadores = recoger_post("disenyadores_" . $ref);
            $disenyadores = recoger_post("disenyadores_" . $contador);
            $dimension = recoger_post("dimension_pieza_" . $contador);
        }
        else if ($tipo == "libro")
        {
            //$tematicas = recoger_post("tematicas_" . $ref);
            $tematicas = recoger_post("tematicas_" . $contador);
            //$idiomas_enviado = recoger_post("idiomas_" . $ref);
            $idiomas_enviado = recoger_post("idiomas_" . $contador);
        }

        if (!is_array($categorias)) { $errores = TRUE; mostrar_error("Debes elegir al menos una categoria"); }
        //if ($tipo == "tela" && !is_array($disenyadores)) { mostrar_error("Debes elegir al menos un dise&ntilde;ador"); }
        if ($tipo == "libro")
        {
            $errores = FALSE;
            if (!is_array($tematicas)) { $errores = TRUE; mostrar_error("Debes elegir al menos una tem&aacute;tica"); }
            if (!is_array($idiomas_enviado)) { $errores = TRUE; mostrar_error("Debes elegir al menos un idioma"); }
            if ($errores) { exit(); }
            
        }
        $precio = recoger_post("precio_" . $ref);
        $errores = FALSE;
        if ($ref_nueva == "") { $errores = TRUE; mostrar_error("Debes poner una referencia"); }
        if ($fabricante == "") { $errores = TRUE; mostrar_error("Debes poner un fabricante"); }
        if ($marca == "") { $errores = TRUE; mostrar_error("Debes poner una marca"); }
        if ($precio == "" || $precio <= 0 || $precio > 9999) { $errores = TRUE; mostrar_error("El precio debe ser un valor numerico superior a 0 e inferior a 9999."); }
        if ($errores) { exit(); }

        $consulta = "UPDATE productos SET ref = '$ref_nueva', id_fabricante = $fabricante, id_marca = $marca, mostrar = $mostrar, precio_normal = $precio WHERE ref LIKE '$ref'";
        $operacion = $base_datos->haz_consulta($consulta);

        $consulta = "DELETE FROM producto_tipo WHERE ref_producto LIKE '$ref'";
        $operacion1 = $base_datos->haz_consulta($consulta);
        $consulta = "INSERT INTO producto_tipo (ref_producto, tipo) VALUES ('$ref_nueva', '$tipo')";
        $operacion1 = $base_datos->haz_consulta($consulta);
        
        //echo "$ref_nueva es $tipo<br><br>";
        
        if (is_array($colecciones))
        {
            $consulta = "DELETE FROM producto_coleccion WHERE ref_producto LIKE '$ref'";
            $operacion1 = $base_datos->haz_consulta($consulta);
            foreach ($colecciones as $coleccion)
            {
                $consulta = "INSERT INTO producto_coleccion (ref_producto, id_coleccion) VALUES ('$ref_nueva', $coleccion)";
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
        }

        if (is_array($categorias))
        {
            $orden_producto_categoria = Array();
            foreach ($categorias as $categoria)
            {
                $orden_producto_categoria_consulta = "SELECT orden FROM producto_categoria WHERE id_categoria = $categoria AND ref_producto = '$ref_nueva'";
                $operacion_orden = $base_datos->haz_consulta($orden_producto_categoria_consulta);
                $resultados_orden = mysql_fetch_assoc($operacion_orden);
                $orden_producto_categoria[$categoria] = trim($resultados_orden["orden"]);
            }
            $consulta = "DELETE FROM producto_categoria WHERE ref_producto LIKE '$ref'";
            $operacion1 = $base_datos->haz_consulta($consulta);
            foreach ($categorias as $categoria)
            {
                if (isset($orden_producto_categoria[$categoria]) && $orden_producto_categoria[$categoria] != "" && is_numeric($orden_producto_categoria[$categoria]))
                {
                    $consulta = "INSERT INTO producto_categoria (ref_producto, id_categoria, orden) VALUES ('$ref_nueva', $categoria, " . $orden_producto_categoria[$categoria] . ")";
                }
                else
                {
                    $consulta = "INSERT INTO producto_categoria (ref_producto, id_categoria) VALUES ('$ref_nueva', $categoria)";
                }
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
        }

        if (is_array($idiomas))
        {
            $consulta = "DELETE FROM producto_nombre WHERE ref_producto LIKE '$ref'";
            $operacion1 = $base_datos->haz_consulta($consulta);
            $consulta = "DELETE FROM producto_descripcion WHERE ref_producto LIKE '$ref'";
            $operacion1 = $base_datos->haz_consulta($consulta);
            foreach ($idiomas as $id_idioma => $idioma)
            {
                $consulta = "INSERT INTO producto_nombre (ref_producto, id_idioma, nombre) VALUES ('$ref_nueva', $id_idioma, '" . $nombre[$id_idioma] . "')";
                $operacion1 = $base_datos->haz_consulta($consulta);

                $consulta = "INSERT INTO producto_descripcion (ref_producto, id_idioma, descripcion, eval) VALUES ('$ref_nueva', $id_idioma, '" . $descripcion[$id_idioma] . "', " . $eval[$id_idioma] . ")";
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
        }

        
        $consulta = "DELETE FROM tela_disenyador WHERE ref_tela LIKE '$ref'";
        $operacion1 = $base_datos->haz_consulta($consulta);

        $consulta = "DELETE FROM tela_metros_pieza WHERE ref_tela LIKE '$ref'";
        $operacion1 = $base_datos->haz_consulta($consulta);

        $consulta = "DELETE FROM libro_tematica WHERE ref_libro LIKE '$ref'";
        $operacion1 = $base_datos->haz_consulta($consulta);

        $consulta = "DELETE FROM libro_idioma WHERE ref_libro LIKE '$ref'";
        $operacion1 = $base_datos->haz_consulta($consulta);

        if ($tipo == "tela")
        {
            if (is_array($disenyadores))
            {
                //$consulta = "DELETE FROM tela_disenyador WHERE ref_tela LIKE '$ref'";
                //$operacion1 = $base_datos->haz_consulta($consulta);
                foreach ($disenyadores as $disenyador)
                {
                    $consulta = "INSERT INTO tela_disenyador (ref_tela, id_disenyador) VALUES ('$ref_nueva', $disenyador)";
                    $operacion1 = $base_datos->haz_consulta($consulta);
                }
            }
            if ($dimension == $constantes["METROS_PIEZA_POR_DEFECTO"] || $dimension <= 0 || trim($dimension) == "")
            {
                //$consulta = "DELETE FROM tela_metros_pieza WHERE ref_tela LIKE '$ref'";
                //$operacion1 = $base_datos->haz_consulta($consulta);
            }
            else if ($dimension > 0)
            {
                $consulta = "INSERT INTO tela_metros_pieza (ref_tela, metros_pieza) VALUES ('$ref_nueva', $dimension)";
                $operacion1 = $base_datos->haz_consulta($consulta);
            }
        }
        else if ($tipo == "libro")
        {
            //$consulta = "DELETE FROM libro_tematica WHERE ref_libro LIKE '$ref'";
            //$operacion1 = $base_datos->haz_consulta($consulta);
            if (is_array($tematicas))
            {
                foreach ($tematicas as $tematica)
                {
                    $consulta = "INSERT INTO libro_tematica (ref_libro, id_tematica) VALUES ('$ref_nueva', $tematica)";
                    $operacion1 = $base_datos->haz_consulta($consulta);
                }
            }

            if (is_array($idiomas_enviado))
            {
                //$consulta = "DELETE FROM libro_idioma WHERE ref_libro LIKE '$ref'";
                //$operacion1 = $base_datos->haz_consulta($consulta);
                foreach ($idiomas_enviado as $idioma)
                {
                    $consulta = "INSERT INTO libro_idioma (ref_libro, id_idioma) VALUES ('$ref_nueva', $idioma)";
                    $operacion1 = $base_datos->haz_consulta($consulta);
                }
            }
        }

        renombrar_imagen_producto($ref, $ref_nueva, "../img/productos/");
        renombrar_imagen_producto($ref, $ref_nueva, "../img/productos/zoom/");

        $imagenes_subidas = subir_imagenes($ref, $ref_nueva);
        
        if (!$imagenes_subidas) { mostrar_error("Error al subir la im&aacute;gen o im&aacute;genes del producto con referencia $ref_nueva"); }

        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n masiva de productos</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
            
            <?php
                //Conecta a la base de datos:
                $base_datos = new base_datos();
                $base_datos->conecta();

                //Selecciona la base de datos:
                $base_datos->selecciona();
            ?>

            function validar_formulario(ref, contador)
            {
                var valido = true;
                var errores = "";
                
                if (document.getElementById("ref_" + ref).value == "") { errores += "* La referencia no puede estar vacia.\n"; }
                
                if (document.getElementById("fabricante_" + ref).selectedIndex == 0) { errores += "* Debes escoger un fabricante.\n"; }
                
                if (document.getElementById("precio_" + ref).value == "" || parseFloat(document.getElementById("precio_" + ref).value) <= 0 || isNaN(document.getElementById("precio_" + ref).value) || parseInt(document.getElementById("precio_" + ref).value) > 9999) { errores += "* El precio debe ser un valor numerico superior a 0 e inferior a 9999.\n"; }
                
                var id_fabricante = document.getElementById("fabricante_" + ref).value;
                
                if (document.getElementById("fabricante_" + ref).selectedIndex != 0)
                {
                    if (document.getElementById("marca_" + id_fabricante + "_" + ref).selectedIndex == 0) { errores += "* Debes escoger una marca.\n"; }
                }

                var hay_categorias = false;
                //for (var x = 0; x < document.getElementById("categorias_" + contador).options.length; x++) 
                for (var x = 0; x < document.getElementById("categorias_" + contador).options.length; x++) 
                { 
                    //if (document.getElementById("categorias_" + ref).options[x].selected) 
                    if (document.getElementById("categorias_" + contador).options[x].selected) 
                    { 
                        hay_categorias = true;
                    } 
                }
                if (!hay_categorias) { errores += "* Debes escoger al menos una categoria.\n"; }
                
                var tipo = "otro";
                
                if (document.getElementById("tipo_" + ref + "_tela").checked) { tipo = "tela"; }
                else if (document.getElementById("tipo_" + ref + "_libro").checked) { tipo = "libro"; }
                
                if (tipo == "tela")
                {
                    //var hay_disenyadores = false;
                    //for (var x = 0; x < document.getElementById("disenyadores_" + ref).options.length; x++) 
                    //{ 
                    //    if (document.getElementById("disenyadores_" + ref).options[x].selected) 
                    //    { 
                    //        hay_disenyadores = true;
                    //    } 
                    //}
                    //if (!hay_disenyadores) { errores += "* Debes escoger al menos un diseador."; }
                }
                else if (tipo == "libro")
                {
                    var hay_tematicas = false;
                    //for (x = 0; x < document.getElementById("tematicas_" + ref).options.length; x++) 
                    for (x = 0; x < document.getElementById("tematicas_" + contador).options.length; x++) 
                    { 
                        //if (document.getElementById("tematicas_" + ref).options[x].selected) 
                        if (document.getElementById("tematicas_" + contador).options[x].selected) 
                        { 
                            hay_tematicas = true;
                        } 
                    }
                    if (!hay_tematicas) { errores += "* Debes escoger al menos una tematica.\n"; }

                    var hay_idiomas = false;
                    //for (x = 0; x < document.getElementById("idiomas_" + ref).options.length; x++) 
                    for (x = 0; x < document.getElementById("idiomas_" + contador).options.length; x++) 
                    { 
                        //if (document.getElementById("idiomas_" + ref).options[x].selected)
                        if (document.getElementById("idiomas_" + contador).options[x].selected)
                        { 
                            hay_idiomas = true;
                        } 
                    }
                    if (!hay_idiomas) { errores += "* Debes escoger al menos un idioma.\n"; }
                }
                
                if (errores != "") { alert("No se puede enviar el formulario porque:\n\n" + errores); valido = false; }

                
                if (errores == "")
                {
                    var advertencias = "";

                    <?php
                        $idiomas = obtener_idiomas();
                        
                        foreach ($idiomas as $id_idioma => $idioma)
                        {
                            ?>
                            if (document.getElementById("nombre_<?php echo $id_idioma; ?>_" + ref).value == "") { advertencias += "* Falta el nombre del producto en el idioma con id <?php echo $id_idioma; ?> (<?php echo addslashes(html_entity_decode($idioma)); ?>)\n"; }
                            <?php
                        }
                    ?>

                    if (advertencias != "")
                    {
                        valido = confirm("Existen las siguientes advertencias:\n\n" + advertencias + "\nPulsa aceptar para continuar o cancelar para volver al formulario y corregir estas advertencias.");
                    }
                }
                
                return valido;
            }

            function mostrar_marcas(id_fabricante, ref)
            {
                document.getElementById("marca_ninguno_" + ref).style.display = "none";
                <?php
                    $fabricantes = obtener_fabricantes();
                    foreach ($fabricantes as $id_fabricante_loop => $fabricante)
                    {
                        echo 'document.getElementById("marca_' . $id_fabricante_loop . '_" + ref).style.display = "none";';
                    }
                ?>
                if (id_fabricante != -1)
                {
                    document.getElementById("marca_" + id_fabricante + "_" + ref).style.display = "block";
                }
                else { document.getElementById("marca_ninguno_" + ref).style.display = "block"; }
            }
            
            function mostrar_formulario_tipo_producto(ref)
            {
                if (document.getElementById("tipo_" + ref + "_tela").checked)
                {
                    document.getElementById("formulario_libros_" + ref).style.display = "none";
                    document.getElementById("formulario_telas_" + ref).style.display = "block";
                    document.getElementById("formulario_adicional_" + ref).style.visibility = "visible";
                }
                else if (document.getElementById("tipo_" + ref + "_libro").checked)
                {
                    document.getElementById("formulario_telas_" + ref).style.display = "none";
                    document.getElementById("formulario_libros_" + ref).style.display = "block";
                    document.getElementById("formulario_adicional_" + ref).style.visibility = "visible";
                }
                else
                {
                    document.getElementById("formulario_telas_" + ref).style.display = "none";
                    document.getElementById("formulario_libros_" + ref).style.display = "none";
                    document.getElementById("formulario_adicional_" + ref).style.visibility = "hidden";
                }
            }
            
            function ampliar_imagen(imagen, ancho, alto)
            {
                var sid_get = '?<?php echo $id_sesion; ?>';
                //Se abre la ventana:
                var margen = 60;
                var window_image = window.open(imagen + sid_get, "_blank", "scrollbars=yes,menubar=no,height=" + (alto+margen) + ",width=" + (ancho+margen) + ",resizable=yes,toolbar=no,location=no,status=no");
                //Se pone en primer plano la ventana:
                window_image.focus();
            }
        // -->
        </script>
        <?php require_once "../cod/func/web/zoom.php"; ?>

        <meta http-equiv="Expires" content="0"> 
        <meta http-equiv="Last-Modified" content="0"> 
        <meta http-equiv="Cache-Control" content="no-cache, mustrevalidate"> 
        <meta http-equiv="Pragma" content="no-cache"> 
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n masiva de productos</h2>
        </center>
        
        <b>Instrucciones</b>:
		<br>
		<br>
		Introducir un directorio que contenga las imagenes de los productos renombradas con la referencia del producto al que pertenecen y clasificadas en subdirectorios con el nombre de la categor&iacute;a donde se quieren insertar los productos nuevos.
        <br>
        <br>
        La(s) categor&iacute;a(s) debe existir previamente y, en caso de las telas, la(s) coleccion(es) tambi&eacute;n (con el mismo nombre tanto la categor&iacute;a como la colecci&oacute;n).
        <br>
        <br>
        
        
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Incluye las constantes de la base de datos (es necesaria la del idioma por defecto):
            require_once "../cod/func/constantes.php";

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
