<?php

    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

	//Reemplazos para funciones obsoletas en versiones nuevas de PHP:
	if(!function_exists('ereg_')) { function ereg_($pattern, $subject, &$matches=NULL) { return preg_match('/'.$pattern.'/', $subject, $matches); } }
	if(!function_exists('eregi_')) { function eregi_($pattern, $subject, &$matches=NULL) { return preg_match('/'.$pattern.'/i', $subject, $matches); } }
	if(!function_exists('ereg_replace_')) { function ereg_replace_($pattern, $replacement, $string) { return preg_replace('/'.$pattern.'/', $replacement, $string); } }
	if(!function_exists('eregi_replace_')) { function eregi_replace_($pattern, $replacement, $string) { return preg_replace('/'.$pattern.'/i', $replacement, $string); } }
	if(!function_exists('split_')) { function split_($pattern, $subject, $limit=NULL) { return preg_split('/'.$pattern.'/', $subject, $limit); } }
	if(!function_exists('spliti_')) { function spliti_($pattern, $subject, $limit=NULL) { return preg_split('/'.$pattern.'/i', $subject, $limit); } }
	
	
    //Incluye los archivos requeridos:
    if (file_exists("web/recoger_get.php")) { require_once "web/recoger_get.php"; }
    else if (file_exists("func/web/recoger_get.php")) { require_once "func/web/recoger_get.php"; }
    if (file_exists("web/recoger_post.php")) { require_once "web/recoger_post.php"; }
    else if (file_exists("func/web/recoger_post.php")) { require_once "func/web/recoger_post.php"; }

    $usando_ajax = recoger_post("usando_ajax");

    if (file_exists("web/recoger_sesion.php")) { require_once "web/recoger_sesion.php"; }
    else if (file_exists("func/web/recoger_sesion.php")) { require_once "func/web/recoger_sesion.php"; }
    if (file_exists("web/error.php")) { require_once "web/error.php"; }
    else if (file_exists("func/web/error.php")) { require_once "func/web/error.php"; }
    if (file_exists("cod/func/categorias.php")) { require_once "cod/func/categorias.php"; }
    else if (file_exists("func/categorias.php")) { require_once "func/categorias.php"; }
    if (file_exists("cod/func/productos.php")) { require_once "cod/func/productos.php"; }
    else if (file_exists("func/productos.php")) { require_once "func/productos.php"; }
    if (file_exists("cod/func/web/zoom.php")) { require_once "cod/func/web/zoom.php"; }
    else if (file_exists("func/web/zoom.php")) { require_once "func/web/zoom.php"; }

    //Precisa: base datos, constantes, id_categoria, id_idioma
    if (isset($usando_ajax) && $usando_ajax == "si")
    {
        header("Cache-Control: no-store, no-cache, must-revalidate");
        header("Pragma: no-cache");
        session_name("albapatch_session");
        session_start("albapatch_session");

        require_once "config/config.php";
        require_once "func/db/db.php";
        //$this_file = recoger_post("this_file");
        //require_once "func/javascript.php";
        //require_once "func/resolucion.php";
        //require_once "func/web/zoom.php";
        $base_datos = new base_datos();
        $base_datos->conecta();
        $base_datos->selecciona();

        require_once "func/id_categoria.php";

        $this_file = recoger_post("this_file");
        require_once "func/javascript.php";


    //Incluye el recogedor del detector de JavaScript:
    //include_once "func/javascript_recogedor.php";

    //Incluye el archivo detector de AJAX:
    //include_once "func/ajax.php";

        require_once "func/resolucion.php";
        require_once "func/web/zoom.php";

        require_once "func/idioma.php";

        //if (file_exists("web/etiquetas.php")) { require_once "web/etiquetas.php"; }
        //else if (file_exists("func/etiquetas.php")) { require_once "func/etiquetas.php"; }
        $id_idioma = recoger_post("id_idioma");


        //Si no se ha podido recoger, se intenta recoger por GET:
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = recoger_get("categoria"); }
        //...y si no, se intenta recoger por POST:
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = recoger_post("categoria"); }
        //...y si no, se intenta recoger por POST (como id_idioma):
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = recoger_post("id_idioma"); }
        //...y si no, se define el idioma por defecto:
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = $constantes["IDIOMA_POR_DEFECTO"]; }
        //...y si no, se define el idioma 1:
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = 1; }


        require_once "func/etiquetas.php";
        require_once "func/constantes.php";
        $id_categoria = recoger_post("id_categoria");


        //Si no se ha podido recoger, se intenta recoger por GET:
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = recoger_get("categoria"); }
        //...y si no, se intenta recoger por POST:
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = recoger_post("categoria"); }
        //...y si no, se intenta recoger por POST (como id_categoria):
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = recoger_post("id_categoria"); }
        //...y si no, se define la categoria segun el archivo actual:
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = obtener_id_categoria_archivo($this_file); }
        //...y si no, se define la categoria principal (la de inicio):
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = $constantes["INICIO_ID"]; }
        //...y si no, se define la categoria 1:
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = 1; }

        
        require_once "func/web/setear_sesion.php";
        setear_sesion("id_categoria_ajax", $id_categoria);

        require_once "func/productos.php";

        //Recoge el titulo de la pagina:
        include_once "titulo.php";
        $usando_ajax = "si"; //La vuelve a poner por si la pagina titulo.php ha alterado su valor.

        //Poner titulo de la seccion:
        if (isset($titulo) && trim($titulo) != "") { echo '<center><h1 align="center">' . htmlentities($titulo, ENT_COMPAT, 'iso-8859-1') . '</h1></center>'; }

        //Pone el path de la categoria actual:
        if ($id_categoria != $constantes["INICIO_ID"]) { incluir_path_actual($id_categoria); incluir_path_actual($id_categoria, TRUE); }
        
        //////if ($id_categoria != $constantes["BUSCAR_ID"]) { echo "<br>"; }

		//Incluye el encabezado:
		incluir_partes(array("encabezado"));
		
        //Pone el menu de las subcategorias:
        incluir_menu_subcategorias($id_categoria);

        //Llama a la funcion para incluir las partes (cuerpo y pie):
        incluir_partes(array("cuerpo", "pie"));

        $base_datos->desconecta();
        //$id_idioma = recoger_post("id_idioma");
    }
    else
    {
        //Poner titulo de la seccion:
        if (isset($titulo) && trim($titulo) != "") { echo '<center><h1 align="center">' . htmlentities($titulo, ENT_COMPAT, 'iso-8859-1') . '</h1></center>'; }

        //Pone el path de la categoria actual:
        //if ($this_file != $constantes["INICIO_ARCHIVO"]) { incluir_path_actual($id_categoria); }
        if ($id_categoria != $constantes["INICIO_ID"]) { incluir_path_actual($id_categoria); incluir_path_actual($id_categoria, TRUE); }

        //if ($id_categoria != $constantes["BUSCAR_ID"]) { echo "<br>"; }

		//Incluye el encabezado:
		incluir_partes(array("encabezado"));
		
        //Pone el menu de las subcategorias:
        incluir_menu_subcategorias($id_categoria);

        //Llama a la funcion para incluir las partes:
        incluir_partes(array("cuerpo", "pie"));
    }
    
    //Funcion que muestra el path de la categoria actual donde nos encontramos:
    function incluir_path_actual($id_categoria_funcion, $es_apadrinada = FALSE, $buscar_padres = TRUE, $id_categoria_padre = 0)
    {
        global $base_datos, $id_idioma, $id_categoria, $constantes, $id_sesion, $ajax_soportado;

        //Si esta en busqueda, sale:
        if ($id_categoria == $constantes["BUSCAR_ID"]) { return; }
   
        $salir = FALSE;
        
        if (!$es_apadrinada)
        {
            $consulta = "SELECT * FROM categorias AS a JOIN categoria_idioma AS b WHERE a.id_categoria = $id_categoria_funcion AND id_idioma = $id_idioma AND a.id_categoria = b.id_categoria AND mostrar != 0 ORDER BY a.orden";
        }
        else
        {
            if ($buscar_padres)
            {
                $consulta_padres = "SELECT * FROM categorias AS a JOIN categorias_adoptadas AS b WHERE a.id_categoria = b.id_categoria_adoptiva AND b.id_categoria = $id_categoria_funcion AND mostrar != 0 ORDER BY a.orden";
                $resultados_padres = $base_datos->haz_consulta($consulta_padres);
                while ($row = mysql_fetch_assoc($resultados_padres))
                {
                    $id_categoria_padre = $row["id_categoria_adoptiva"];
                    incluir_path_actual($id_categoria_funcion, TRUE, FALSE, $id_categoria_padre);
                }
                echo "<br>";
                $salir = TRUE;
            }
            $consulta = "
                                SELECT *
                                    FROM categorias AS a
                                    JOIN categoria_idioma AS b
                                    JOIN categorias_adoptadas AS c
                                    WHERE c.id_categoria = $id_categoria_funcion
                                    AND a.id_categoria = c.id_categoria_adoptiva
                                    AND c.id_categoria_adoptiva = $id_categoria_padre
                                    AND id_idioma = $id_idioma
                                    AND a.id_categoria = b.id_categoria
                                    AND mostrar != 0
									ORDER BY a.orden
                         ";
        }
        $resultados = $base_datos->haz_consulta($consulta);
        
        $menu = Array();
        
        if (mysql_num_rows($resultados) > 0)
        {
            $row = mysql_fetch_assoc($resultados);
            $nombre_categoria = $row["nombre_categoria"];
           
            //echo $nombre_categoria . " < ";
            
            if (!$es_apadrinada) { $raiz = $row["raiz"]; }
            else { $raiz = $row["id_categoria_adoptiva"]; }
            //$raiz = $row["raiz"];
            $menu = incluir_path_actual($raiz);
            
            //echo $nombre_categoria."<br>";
            
            $menu[$id_categoria_funcion] = $nombre_categoria;
        }
        else if ($es_apadrinada) { $salir = TRUE; }

        if ($id_categoria == $id_categoria_funcion && !$salir)
        {
            $categoria_archivo = categorias_archivo();
            $x = 1;
            echo "<font size=\"3\" color=\"" . $constantes["COLOR_TEXTO_SITUACION_ACTUAL"] . "\">";
            if (!$es_apadrinada) { echo usar_etiqueta("SITUACION_ACTUAL") . ": "; }
            else { echo usar_etiqueta("RUTA_ALTERNATIVA") . ": "; }
            foreach ($menu as $key => $nombre_categoria_loop)
            {
                if ($x < sizeof($menu))
                {
                    if (isset($categoria_archivo[$key])) { $url = $categoria_archivo[$key]; }
                    else { $url = $constantes["INICIO_ARCHIVO"]; }

                    $codigoJS_click = "";
                    if ($ajax_soportado)
                    {
                        $codigoJS_click = ' onClick="cambiar_categoria(\'' . $key . '\', \'' . $id_idioma . '\', \'' . $url . '\'); return false;"';
                    }

                    $title = htmlentities(trim($nombre_categoria_loop), ENT_COMPAT, 'iso-8859-1');
                   
                    $enlace = '<a href="' . $url . '?' . $id_sesion . '&categoria=' . $key . '&idioma=' . $id_idioma . '&directo=1" title="' . $title . '"' . $codigoJS_click . ' class="dos">';
                    echo $enlace;
                }
                else { echo "<b>"; }
                echo htmlentities(trim($nombre_categoria_loop), ENT_COMPAT, 'iso-8859-1');
                if ($x < sizeof($menu)) { echo "</a>"; }
                if ($es_apadrinada && $x+1 >= sizeof($menu)) { break; }
                if ($x < sizeof($menu)) { echo " <img src=\"img/web/triangul.gif\" title=\"&gt;\" alt=\"&gt;\" width=\"7\" height=\"9\"> "; }
                else { echo "</b>"; }
                $x++;
            }
            echo "</font>";
            echo "<br>";
            //if ($es_apadrinada) { echo "<br>"; }
        }
        
        return $menu;
    }
    
    
    //Funcion que muestra el menu de las subcategorias pertenecientes a la categoria actual:
    function incluir_menu_subcategorias($id_categoria)
    {
        global $base_datos, $id_idioma, $constantes, $ajax_soportado, $id_sesion, $margen_body, $margen_tablas;
        
        //$consulta = "SELECT * FROM categorias AS a JOIN categoria_idioma AS b WHERE id_idioma = $id_idioma AND a.id_categoria = b.id_categoria AND raiz = $id_categoria AND mostrar != 0 ORDER BY nombre_categoria";
        $consulta = "
                        SELECT *, a.id_categoria AS id_categoria
                            FROM categorias AS a
                            JOIN categoria_idioma AS b ON a.id_categoria = b.id_categoria
                            LEFT JOIN categorias_adoptadas AS c ON b.id_categoria = c.id_categoria
                                WHERE id_idioma = $id_idioma
                                    AND (raiz = $id_categoria OR id_categoria_adoptiva = $id_categoria)
                                    AND mostrar != 0
                            GROUP BY a.id_categoria
                            ORDER BY a.orden, nombre_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        

        $margen_entre_productos = 82;
        if ($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] != 0) { $columnas = $margen_body / ($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] + $margen_entre_productos); }
        else { $columnas = $margen_body / 96; }
        
        if ($columnas < 1) { $columnas = 1; }
        $columnas = (int) $columnas;

        $bg_color = $constantes["COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU1"];
        
        //$columnas = 3;
        if (mysql_num_rows($resultados) > 0)
		{
			echo '<br><center><font size="3" color="' . $constantes["COLOR_TEXTO_SITUACION_ACTUAL"] . '">' . usar_etiqueta("SUBCATEGORIAS_TEXTO") . ':</font><br>';
			echo '<table cellspacing="5" cellpadding="5" border="0" bgcolor="' . $bg_color . '" align="center" width="' . ($margen_body - $margen_tablas) . '" class="recuadro_menu_subcategorias">';
		}
        
        $categoria_archivo = categorias_archivo();
        
        $c = $f = 0;
        while ($row = mysql_fetch_assoc($resultados))
        {
            if ($c == 0) { echo "<tr>"; }
            $nombre_categoria = $row["nombre_categoria"];
            $id_categoria_loop = $row["id_categoria"];
            echo "<td align=\"center\" bgcolor=\"$bg_color\" class=\"menu_subcategorias\"><center>";
            //echo "<td align=\"center\" class=\"recuadro_menu_subcategorias_td\"><center>";

            if (isset($categoria_archivo[$id_categoria_loop])) { $url = $categoria_archivo[$id_categoria_loop]; }
            else { $url = $constantes["INICIO_ARCHIVO"]; }

            $codigoJS_click = "";
            if ($ajax_soportado)
            {
                $codigoJS_click = ' onClick="cambiar_categoria(\'' . $id_categoria_loop . '\', \'' . $id_idioma . '\', \'' . $url . '\'); return false;"';
            }

            $title = htmlentities(trim($nombre_categoria), ENT_COMPAT, 'iso-8859-1');

            $enlace = '<a href="' . $url . '?' . $id_sesion . '&categoria=' . $id_categoria_loop . '&idioma=' . $id_idioma . '&directo=1" title="' . $title . '"' . $codigoJS_click . ' class="menu2">';
            
            $enlace .= obtener_imagen_categoria($id_categoria_loop, $nombre_categoria);

            echo $enlace . htmlentities($nombre_categoria, ENT_COMPAT, 'iso-8859-1') . "</a>";

            echo "</center></td>";
            $c++;
            if ($c > $columnas - 1) { echo "</tr>"; $c = 0; $f++; }
            $bg_color = ($bg_color == $constantes["COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU1"]) ? $constantes["COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU2"] : $constantes["COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU1"];
        }

        if (mysql_num_rows($resultados) > 0)
        { 
            if ($f > 0 && $c > 0)
            {
                while ($c++ <= $columnas - 1) { echo "<td bgcolor=\"$bg_color\" class=\"menu_subcategorias\"><img src=\"img/web/blank.gif\" width=\"1\" height=\"1\" border=\"0\"></td>"; if ($c > $columnas - 1) { echo "</tr>"; } $bg_color = ($bg_color == $constantes["COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU1"]) ? $constantes["COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU2"] : $constantes["COLOR_FONDO_SUBCATEGORIAS_TABLA_MENU1"]; }
				//while ($c++ <= $columnas - 1) { echo "<td class=\"menu_subcategorias\"><img src=\"img/web/blank.gif\" width=\"1\" height=\"1\" border=\"0\"></td>"; if ($c > $columnas - 1) { echo "</tr>"; } }
            }
            else if ($f == 0 && $c > 0) { echo "</tr>"; }
            echo "</table></center>";
        } //else if ($f == 0 && $c == 0) { echo "<tr><td></td></tr>"; } //es lo mismo que else { echo "<tr><td></td></tr>"; }
        
        //////echo "<br>";
    }


    //Funcio que devuelve el codigo HTML de la imagen de una categoria dada (si existe):
    function obtener_imagen_categoria($id_categoria, $nombre_categoria)
    {
        global $constantes, $usando_ajax, $javascript_soportado;
        
        $titulo = htmlentities(trim($nombre_categoria), ENT_COMPAT, 'iso-8859-1');

        $imagen = $id_categoria . ".jpg";

        $directorio = "img/categorias/";
        $directorio_ajax = $directorio;
        if (isset($usando_ajax) && $usando_ajax == "si") { $directorio_ajax = "../" . $directorio; }

        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".jpeg", ".jpg", $imagen))) { $imagen = eregi_replace_(".jpeg", ".jpg", $imagen); }
        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".jpeg", ".gif", $imagen))) { $imagen = eregi_replace_(".jpeg", ".gif", $imagen); }
        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".jpeg", ".png", $imagen))) { $imagen = eregi_replace_(".jpeg", ".png", $imagen); }
        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".jpg", ".gif", $imagen))) { $imagen = eregi_replace_(".jpg", ".gif", $imagen); }
        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".jpg", ".jpeg", $imagen))) { $imagen = eregi_replace_(".jpg", ".jpeg", $imagen); }
        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".jpg", ".png", $imagen))) { $imagen = eregi_replace_(".jpg", ".png", $imagen); }
        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".gif", ".jpg", $imagen))) { $imagen = eregi_replace_(".gif", ".jpg", $imagen); }
        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".gif", ".jpeg", $imagen))) { $imagen = eregi_replace_(".gif", ".jpeg", $imagen); }
        if (!file_exists($directorio_ajax.$imagen) && file_exists($directorio_ajax.eregi_replace_(".gif", ".png", $imagen))) { $imagen = eregi_replace_(".gif", ".png", $imagen); }

        //$ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
        //$alto = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"];
        $ancho = $alto = -1;

        //Si se ha definido, se ponen las medidas reales (siempre que se pueda):
        if (file_exists($directorio_ajax.$imagen))
        {
            list($ancho_real, $alto_real, $tipo, $codigo_html) = getimagesize($directorio_ajax.$imagen);
            if ($ancho == -1)
            {
                $ancho = $ancho_real;
            }
            if ($alto == -1)
            {
                $alto = $alto_real;
            }
        }

        if ($ancho > $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] || $alto > $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"])
        {
            if ($ancho > $alto)
            {
                $ancho_nuevo = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
                $ratio = $ancho / $ancho_nuevo;
                $alto /= $ratio;
                $ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
            }
            else if ($alto > $ancho)
            {
                $alto_nuevo = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"];
                $ratio = $alto / $alto_nuevo;
                $ancho /= $ratio;
                $alto = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"];
            }
            else
            {
                $ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
                $alto = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"];
            }
        }
        $ancho = (int) $ancho;
        $alto = (int) $alto;

        if ($ancho > $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] || $ancho <= 0) { $ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]; }
        if ($alto > $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"] || $alto <= 0) { $alto = $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"]; }

        //if (isset($usando_ajax) && $usando_ajax == "si") { $directorio = str_replace("../", "", $directorio); }

        $html = '<img src="'.$directorio.$imagen.'" border="0" hspace="0" vspace="0" alt="' . $titulo . '" title="' . $titulo . '"';
        if (isset($javascript_soportado) && $javascript_soportado)
		{
			$html .= ' onLoad="var div_cargando = document.getElementById(\'div_cargando_' . $id_categoria . '\'); if (div_cargando !== null) { div_cargando.style.backgroundImage = \'\'; }"';
		}
		
		$html .= ' width="' . $ancho . '" height="' . $alto . '">';

        if (isset($javascript_soportado) && $javascript_soportado)
        {
            $html = '<div style=\"position:relative\"><div style="background-image:url(\'img/web/cargando.gif\'); background-repeat:no-repeat; background-position:center center;" id="div_cargando_' . $id_categoria . '">' . $html . '</div></div>';
        }
        
        $html .= "<br>";
        
        return (file_exists($directorio_ajax.$imagen)) ? $html : "";
    }
    

    //Funcion que incluye un archivo de una categoria (utilizada en el gestor):
    function incluir_archivo_categoria($id_categoria, $id_idioma, $parte)
    {
        global $base_datos, $id_idioma, $constantes, $ajax_soportado, $id_sesion, $margen_body, $margen_tablas;

        $encontrado = FALSE;
        $extensiones = Array("php", "htm", "html", "txt");
        foreach ($extensiones as $extension)
        {
            $archivo = "cod/html/categorias/" . $id_categoria . "_" . $id_idioma . "_" . $parte . "." . $extension;
            if (file_exists($archivo)) { include $archivo; $encontrado = TRUE; }
            else if (file_exists("../" . $archivo)) { include "../".$archivo; $encontrado = TRUE; }
        }
        if (!$encontrado) { mostrar_error("Archivo de esta categor&iacute;a ($id_categoria) y este idioma ($id_idioma) para el $parte no encontrado.", TRUE); }
    }
    

    //Funcion que incluye las categorias:
    function incluir_partes($partes)
    {
        //Hace globales las variables necesarias:
        global $base_datos, $constantes, $id_categoria, $id_idioma, $margen_body, $margen_tablas, $javascript_soportado, $javascript_version, $sesion_form, $ajax_soportado;
        
        //Matriz con las partes posibles que puede tener un texto:
        if (!isset($partes) || $partes == NULL)
		{
			$partes = Array("encabezado", "cuerpo", "pie");
		}

        //Recoge todas las partes de la base de datos:
        foreach ($partes as $parte)
        {
            //Calcula el contenido (cuerpo) de la seccion de la parte actual del loop:
            $consulta = "SELECT * FROM categoria_texto WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma AND parte LIKE '$parte'";
            $resultados = $base_datos->haz_consulta($consulta);
        
            if (mysql_num_rows($resultados) > 0)
            {
                $resultados_matriz = mysql_fetch_assoc($resultados);
                $codigo = $resultados_matriz["codigo"];
                $eval = $resultados_matriz["eval"];
            }
            else
            {
                $codigo = "";
                $eval = FALSE;
            }
        
            if ($eval)
            {
                eval($codigo);
            }
            else
            {
                echo htmlentities($codigo, ENT_COMPAT, 'iso-8859-1');
            }
        
            if (trim($codigo) != "") { echo "<br>"; }
            
            //Despues del cuerpo, agregamos los productos:
            if ($parte == "cuerpo") { procesar_productos($id_categoria); }
            
            //Si estamos en la cesta, agregamos el codigo necesario:
            if ($id_categoria == $constantes["CESTA_ID"])
            {
                if (file_exists("sistema_cesta.php")) { require_once "sistema_cesta.php"; }
                else if (file_exists("cod/sistema_cesta.php")) { require_once "cod/sistema_cesta.php"; }
            }
            
            //Si estamos en pedido, agregamos el codigo necesario:
            if ($id_categoria == $constantes["PEDIDO_ID"])
            {
                if (file_exists("sistema_pedido.php")) { require_once "sistema_pedido.php"; }
                else if (file_exists("cod/sistema_pedido.php")) { require_once "cod/sistema_pedido.php"; }
            }

            //Si estamos en contacto, agregamos el codigo necesario:
            if ($id_categoria == $constantes["CONTACTO_ID"])
            {
                if (file_exists("sistema_contacto.php")) { require_once "sistema_contacto.php"; }
                else if (file_exists("cod/sistema_contacto.php")) { require_once "cod/sistema_contacto.php"; }
            }

            //Si estamos en buscar, agregamos el codigo necesario:
            if ($id_categoria == $constantes["BUSCAR_ID"])
            {
                if (file_exists("sistema_busqueda.php")) { require_once "sistema_busqueda.php"; }
                else if (file_exists("cod/sistema_busqueda.php")) { require_once "cod/sistema_busqueda.php"; }
            }

            //Si estamos en galeria, agregamos el codigo necesario:
            if ($id_categoria == $constantes["GALERIA_ID"])
            {
                if (file_exists("sistema_galeria.php")) { require_once "sistema_galeria.php"; }
                else if (file_exists("cod/sistema_galeria.php")) { require_once "cod/sistema_galeria.php"; }
            }

        }
    }
    
?>
