<?php

    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    //Formato:
        // $cesta[$ref_producto][$modalidad] = $cantidad;
        
    
    //Recoge la cesta de la sesion:
    $cesta = recoger_sesion("cesta");

    
    //Comprueba que la referencia de un producto existe, para la cuenta actual:
    function producto_existente($ref_producto)
    {
        global $base_datos;
        
        $existente = FALSE;
        
		//if ($ref_producto == "-1'") { $ref_producto = "-1"; }
		
        $consulta = "SELECT * FROM productos WHERE ref LIKE '$ref_producto'";
        $resultados = $base_datos->haz_consulta($consulta);
    
        if (mysql_num_rows($resultados) > 0)
        {
            $existente = TRUE;
        }
        
        //Si el producto existe y se esta identificado:
        $identificado = (recoger_sesion("identificado")) ? true : false;
        if ($existente && $identificado)
        {
            $usuario = recoger_sesion("usuario");
            $tipo_usuario = recoger_sesion("tipo");
            //Si el producto debe ocultarse para esta cuenta, no existe:
            if (ocultar_producto($ref_producto, $usuario, $tipo_usuario)) { $existente = FALSE; }
        }
        
        return $existente;
    }

    //Comprueba que la modalidad elegida este permitida para la cuenta actual:
    function producto_existente_modalidad($ref_producto, $modalidad)
    {
        $existente = FALSE;

        $identificado = (recoger_sesion("identificado")) ? true : false;
        
        //Tener en cuenta si es libro, tela u otro. Y tener en cuenta si se esta identificado o no.
        $tipo = trim(obtener_tipo($ref_producto));
       
        //Si es otro o es un libro y la modalidad es cantidad, se permite:
        if (($tipo == "otro" || $tipo == "libro") && $modalidad == "cantidad") { $existente = TRUE; }
        //...o si es una tela y la modalidad es centimetros, tambie se permite:
        else if ($tipo == "tela" && $modalidad == "centimetros") { $existente = TRUE; }
        //...o si es una tela y la modalidad es pieza_entera, pieza_media, pieza_cuarto o piezas y se esta identificado:
        else if ($tipo == "tela" && ($modalidad == "pieza_entera" || $modalidad == "pieza_media" || $modalidad == "pieza_cuarto" || $modalidad == "piezas") && $identificado)
        {
            //Si para esta cuenta se permite esto, tambien se permite:
            if ($modalidad == "pieza_entera" && cantidad_piezas_permitida($ref_producto, 1)) { $existente = TRUE; }
            else if ($modalidad == "pieza_media" && cantidad_piezas_permitida($ref_producto, 0.5)) { $existente = TRUE; }
            else if ($modalidad == "pieza_cuarto" && cantidad_piezas_permitida($ref_producto, 0.25)) { $existente = TRUE; }
            else if ($modalidad == "piezas")
            {
                //NOTA: esto todavia no esta implementado y quiza nunca se implemente, ya que no se pueden comprar piezas que no sean enteras, medias o cuartos. Asi que FALTA.
                $cantidad_minima = recoger_post("cantidad_minima");
                if (cantidad_piezas_permitida($ref_producto, $cantidad_minima)) { $existente = TRUE; }
            }
        }
        
        return $existente;
    }

    //Comprueba si la cantidad es correcta:
    function cantidad_permitida($ref, $cantidad)
    {
        $permitida = TRUE;

        $tipo = trim(obtener_tipo($ref));

        //Si el producto no es un libro u otro, no se permite:
        if ($tipo != "libro" && $tipo != "otro") { $permitida = FALSE; }
        else if ($cantidad < 1) { $permitida = FALSE; }
        
        return $permitida;
    }
    
    //Comprueba si la cantidad en centimetros es correcta:
    function cantidad_centimetros_permitida($ref, $centimetros)
    {
        $permitida = TRUE;

        $tipo = trim(obtener_tipo($ref));

        if ($tipo != "tela") { $permitida = FALSE; }
        else
        {
            //$identificado = (recoger_sesion("identificado")) ? true : false;

            //if (!$identificado) { return FALSE; }

            //if (obtener_metros_por_pieza($ref) > 0)
            //{
                $minimo = obtener_minimo_centimetros($ref);
                $incremento = obtener_incremento_centimetros($ref);
                if ($centimetros < $minimo || $centimetros % $incremento != 0) { $permitida = FALSE; }
            //}
        }
        
        return $permitida;
    }

    //Comprueba que un producto se puede agregar licitamente, para la cuenta actual:
    function producto_licito($ref_producto, $cantidad, $modalidad)
    {
        $licito = FALSE;
        
        //Comprueba que la referencia del producto exista para esta cuenta:
        //echo "A";
        if (producto_existente($ref_producto))
        {
        //echo "B";
            //Si existe, comprueba que la modalidad elegida esta permitida para esta cuenta:
            if (producto_existente_modalidad($ref_producto, $modalidad))
            {
            //echo "C";
                if (!is_numeric($cantidad)) { $cantidad = 1; }
                $cantidad = ceil($cantidad);
                //Si la modalidad es correcta, comprueba si la cantidad lo es tambien:
                if ($modalidad == "cantidad" && cantidad_permitida($ref_producto, $cantidad)) { $licito = TRUE; }
                else if ($modalidad == "centimetros" && cantidad_centimetros_permitida($ref_producto, $cantidad)) { $licito = TRUE; }
                else if (($modalidad != "cantidad" && $modalidad != "centimetros") && $cantidad >= 1) { $licito = TRUE; }
            }
        }                

        return $licito;
    }


    //Agrega un producto:
    function agregar_producto($ref_producto, $cantidad, $modalidad)
    {
        //global $cesta;
        $cesta = recoger_sesion("cesta");

       
        $agregado = TRUE;
        
        //Si el producto ya esta agregado, le suma la cantidad:
        if (producto_agregado($ref_producto, $modalidad))
        {
            $cantidad_existente = $cesta[$ref_producto][$modalidad];
            modificar_producto($ref_producto, $cantidad_existente + $cantidad, $modalidad);
            $cesta = recoger_sesion("cesta");
        }
        else
        {
            if (!isset($cesta) || isset($cesta) && !is_array($cesta)) { $cesta = Array(); }
            if (!isset($cesta[$ref_producto]) || isset($cesta[$ref_producto]) && !is_array($cesta[$ref_producto])) { $cesta[$ref_producto] = Array(); }
            $cesta[$ref_producto][$modalidad] = $cantidad;
        }
        
        if ($agregado) { guardar_cambios_cesta($cesta); }
        
        return $agregado;
    }
    
    
    //Borra un producto, de una modalidad:
    function borrar_producto($ref_producto, $modalidad)
    {
        //global $cesta;
        $cesta = recoger_sesion("cesta");
        
        $borrado = TRUE;
        
        //Si el producto no existe en la cesta, sale de la funcion:
        if (!isset($cesta[$ref_producto])) { return FALSE; }
        else if (isset($cesta[$ref_producto]) && !isset($cesta[$ref_producto][$modalidad])) { return FALSE; }
        else if (isset($cesta[$ref_producto]) && isset($cesta[$ref_producto][$modalidad]) && $cesta[$ref_producto][$modalidad] <= 0) { return FALSE; }
        else { $cesta[$ref_producto][$modalidad] = 0; } //else { unset($cesta[$ref_producto][$modalidad]); }
        
        if ($borrado) { guardar_cambios_cesta($cesta); }
        
        return $borrado;
    }
    
    
    //Modifica la cantidad de un producto, de una modalidad:
    function modificar_producto($ref_producto, $cantidad, $modalidad)
    {
        //global $cesta;
        $cesta = recoger_sesion("cesta");
        
        $modificado = TRUE;
        
        //Si la cantidad no es cero y el producto no es licito, sale de la funcion:
        if ($cantidad != 0 && !producto_licito($ref_producto, $cantidad, $modalidad)) { return FALSE; }
        
        //Si la cantidad no es cero y el producto no esta agregado, lo agrega:
        if ($cantidad != 0 && !producto_agregado($ref_producto, $modalidad)) { agregar_producto($ref_producto, $cantidad, $modalidad); }
        //...pero si el producto ya esta agregado:
        else
        {
            //Si la cantidad es cero, borra el producto:
            if ($cantidad == 0) { borrar_producto($ref_producto, $modalidad); }
            //...pero si no, si la cantidad es licita, modifica el producto:
            else
            {
                $cesta[$ref_producto][$modalidad] = $cantidad;
            }
        }
        
        if ($modificado) { guardar_cambios_cesta($cesta); }
        
        return $modificado;
    }
    
    
    //Comprueba si un producto ya esta agregado a la cesta o no:
    function producto_agregado($ref_producto, $modalidad)
    {
        //global $cesta;
        $cesta = recoger_sesion("cesta");

		//Prueba para evitar error en el servidor con version de PHP nueva ("Uninitialized string offset"):
		if (!isset($cesta)) { $cesta = Array(); }
		if (!isset($cesta[$ref_producto])) { $cesta[$ref_producto] = Array(); }
		
        $existente = FALSE;
        
        //Si el producto existe en esta modalidad y la cantidad es mayor que 0, entonces existe:
        if (isset($cesta[$ref_producto][$modalidad]) && $cesta[$ref_producto][$modalidad] > 0) { $existente = TRUE; }
        
        return $existente;
    }

    //Comprueba si un producto ya esta agregado a la cesta o no:
    function producto_agregado_alguno($ref_producto)
    {
        //global $cesta;
        $cesta = recoger_sesion("cesta");
            
        $existente = FALSE;
        
        if (isset($cesta[$ref_producto]) && is_array($cesta[$ref_producto]))
        {
            foreach ($cesta[$ref_producto] as $modalidad => $cantidad)
            {
                if (producto_agregado($ref_producto, $modalidad)) { $existente = TRUE; }
            }
        }
        
        return $existente;
    }
    
    //Guarda los cambios hechos en la cesta (se le pasa por argumento la cesta modificada):
    function guardar_cambios_cesta($cesta)
    {
        setear_sesion("cesta", $cesta);
    }


    //Funcion que muestra la cesta:
    function mostrar_cesta($editable = TRUE)
    {
        global $margen_body, $margen_tablas, $id_categoria, $constantes, $ajax_soportado, $id_idioma, $id_sesion;
    
        $cesta = recoger_sesion("cesta");

        //Si la cesta no es una matriz, sale:
        //if (!is_array($cesta)) { return; }
        if (!is_array($cesta)) { $cesta = Array(); }
        
        //echo "<br><br>";

        $bgcolor = $constantes["COLOR_PRODUCTO_RECUADRO1"];
        
        echo '<center><table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td bgcolor="' . $bgcolor . '" align="center" class="cesta_producto"><center><font color="#ffffff" size="2" face="verdana">';
        echo usar_etiqueta("MODO_ENVIO") . "<br>";
        echo usar_etiqueta("GASTOS_ENVIO");
        echo '</font></center></td></tr>';
    
        $total = 0;

        $cestaVacia = TRUE;
        foreach ($cesta as $ref => $matriz)
        {
            if (!is_array($cesta[$ref])) { continue; }

            //Si el producto no esta, salta el loop:
            if (!producto_agregado_alguno($ref)) { continue; }
            
            $cestaVacia = FALSE;
            
            //echo "$ref<br>";
            //foreach ($matriz as $modalidad => $cantidad)
            //{
            //    echo "$modalidad => $cantidad<br>";
            //}

            
            //echo '<tr><td bgcolor="' . $bgcolor . '">';
            echo '<tr><td class="cesta_producto">';
            
            $total += mostrar_cesta_producto($matriz, $ref, $editable);
            
            echo '</td></tr>';
            
            //echo "<br><br>";
        }

        if ($cestaVacia)
        {
            echo '<tr><td align="center" class="cesta_producto"><center>';
            echo usar_etiqueta("CESTA_VACIA");
            echo '</center></td></tr>';
        }
        
        echo '</table>';
        
        if (!$cestaVacia)
        {
            echo '<table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center>';

            if ($ajax_soportado)
            {
                echo '<div id="precio_total" class="cesta_producto">';
            }

            echo usar_etiqueta("PRECIO_SIN_GASTOS_ENVIO") . ": " . number_format($total, usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . " " . usar_etiqueta("EURO");
            echo "<br><b>";
            echo usar_etiqueta("PRECIO_TOTAL") . ": " . number_format($total + $constantes["GASTOS_ENVIO"], usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . " " . usar_etiqueta("EURO");
            echo "</b>";

            if ($ajax_soportado)
            {
                echo "</div>";
            }

            echo '</center></td></tr></table>';
         }
        
        if ($id_categoria == $constantes["CESTA_ID"])
        {
            echo "<br>";
            echo '<table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center><b>';
            $id_categoria_pedido = $constantes["PEDIDO_ID"];
            $url = $constantes["PEDIDO_ARCHIVO"] . "?" . $id_sesion . "&categoria=" . $id_categoria_pedido . "&idioma=" . $id_idioma;
            if ($cestaVacia) { $url .= "&confirmar=si"; }
            $codigoJS_click = "";
            if ($ajax_soportado)
            {
              //$codigoJS_click = ' onClick="cambiar_categoria(\'' . $id_categoria_pedido . '\', \'' . $id_idioma . '\', \'' . $url . '\'); return false;"';
                $confirmar_js = ($cestaVacia) ? "true" : "false";
                $manual_js = ($cestaVacia) ? "true" : "false";
                $codigoJS_click = ' onClick="cargar_pedido(' . $id_idioma . ', ' . $manual_js . ', ' . $confirmar_js . ', true); return false;"';
            }
            if (!$cestaVacia)
            {
                echo '<table border="0" cellspacing="0" cellpadding="2"><tr><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '><img src="img/web/realizar.gif" border="0" hspace="0" vspace="0" alt="" width="20" height="20" title="' . usar_etiqueta("PEDIDO_REALIZAR") . '"></a>';
                echo '</td><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_REALIZAR") . '</a>';
                echo '</td></tr></table>';
                //echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_REALIZAR") . '</a>';
            }
            else
            {
                $url .= "&manual=si";
                
                echo '<table border="0" cellspacing="0" cellpadding="2"><tr><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '><img src="img/web/manual.gif" border="0" hspace="0" vspace="0" alt="" width="20" height="20" title="' . usar_etiqueta("PEDIDO_MANUAL_REALIZAR") . '"></a>';
                echo '</td><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_MANUAL_REALIZAR") . '</a>';
                echo '</td></tr></table>';

                //echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_MANUAL_REALIZAR") . '</a>';
            }
            
            echo '</center></td></tr></table>';
        }
        else if ($id_categoria == $constantes["PEDIDO_ID"])
        {
            if (!$cestaVacia)
            {
                echo "<br>";
                echo '<table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center><b>';
                $id_categoria_cesta = $constantes["CESTA_ID"];
                //$url = $constantes["CESTA_ARCHIVO"] . "?" . $id_sesion . "&categoria=" . $id_categoria_cesta . "&confirmar=si";
                $url = $constantes["CESTA_ARCHIVO"] . "?" . $id_sesion . "&categoria=" . $id_categoria_cesta . "&idioma=" . $id_idioma;
                $codigoJS_click = "";
                if ($ajax_soportado)
                {
                    $codigoJS_click = ' onClick="cambiar_categoria(\'' . $id_categoria_cesta . '\', \'' . $id_idioma . '\', \'' . $url . '\'); return false;"';
                }
                
                echo '<table border="0" cellspacing="0" cellpadding="2"><tr><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '><img src="img/web/editar.gif" border="0" hspace="0" vspace="0" alt="" width="20" height="20" title="' . usar_etiqueta("PEDIDO_EDITAR") . '"></a>';
                echo '</td><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_EDITAR") . '</a>';
                echo '</td></tr></table>';
                
                echo '</center></td></tr></table>';
            }

            echo "<br>";
            echo '<table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center><b>';
            $id_categoria_pedido = $constantes["PEDIDO_ID"];
            $url = $constantes["PEDIDO_ARCHIVO"] . "?" . $id_sesion . "&categoria=" . $id_categoria_pedido . "&idioma=" . $id_idioma . "&confirmar=si";
            if ($cestaVacia) { $url .= "&manual=si"; }
            $codigoJS_click = "";
            if ($ajax_soportado)
            {
                $manual_js = ($cestaVacia) ? "true" : "false";
                $confirmar_js = "true";
                //$codigoJS_click = ' onClick="cambiar_categoria(\'' . $id_categoria_pedido . '\', \'' . $id_idioma . '\', \'' . $url . '\'); return false;"';
                $codigoJS_click = ' onClick="cargar_pedido(' . $id_idioma . ', ' . $manual_js . ', ' . $confirmar_js . ', false); return false;"';
            }

            if (!$cestaVacia)
            {
                //echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_PROCESAR") . '</a>';
                
                echo '<table border="0" cellspacing="0" cellpadding="2"><tr><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '><img src="img/web/procesar.gif" border="0" hspace="0" vspace="0" alt="" width="20" height="20" title="' . usar_etiqueta("PEDIDO_PROCESAR") . '"></a>';
                echo '</td><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_PROCESAR") . '</a>';
                echo '</td></tr></table>';
            }
            else
            {
                echo '<table border="0" cellspacing="0" cellpadding="2"><tr><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '><img src="img/web/manual.gif" border="0" hspace="0" vspace="0" alt="" width="20" height="20" title="' . usar_etiqueta("PEDIDO_MANUAL_REALIZAR") . '"></a>';
                echo '</td><td>';
                echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_MANUAL_REALIZAR") . '</a>';
                echo '</td></tr></table>';

                //echo '<a href="' . $url . '" class="menu"' . $codigoJS_click . '>' . usar_etiqueta("PEDIDO_MANUAL_REALIZAR") . '</a>';
            }

            echo '</center></td></tr></table>';
        }
        
        echo '</center>';
        
    }
    
    //Funcion que muestra un solo producto de la cesta:
    function mostrar_cesta_producto($producto, $ref, $editable = TRUE)
    {
        global $margen_body, $margen_tablas, $constantes, $this_file, $javascript_soportado, $javascript_version, $ajax_soportado, $id_idioma, $sesion_form;

        static $contador_producto = 0, $contador_avisos = 0;
        
        $total = 0;
        
        /*
        $codigoJS_texto = $codigoJS_boton = "";
        if ($javascript_soportado && $javascript_version >= 2)
        {
            $codigoJS_texto = ' onMouseOver="this.style.background=\'#3333ff\'; this.style.color=\'#aaaaff\'; this.style.border=\'1px solid #0000ff\';" onMouseOut="this.style.background=\'#3333bb\'; this.style.color=\'#bbbbff\'; this.style.border=\'1px solid #0000aa\';"';
            $codigoJS_boton = ' onMouseOver="this.style.background=\'#ddddff\'; this.style.color=\'#3333cc\';" onMouseOut="this.style.background=\'#ddddee\'; this.style.color=\'#333366\';"';
        }*/

        $codigoJS_texto = $codigoJS_boton = "";
        if ($javascript_soportado && $javascript_version >= 2)
        {
            $codigoJS_texto = ' onMouseOver="this.style.background=\'#3333ff\'; this.style.color=\'#aaaaff\'; this.style.border=\'1px solid #0000ff\';" onMouseOut="this.style.background=\'#3333bb\'; this.style.color=\'#bbbbff\'; this.style.border=\'1px solid #0000aa\';"';
            $codigoJS_boton = ' onMouseOver="this.style.background=\'#ddddff\'; this.style.color=\'#3333cc\';" onMouseOut="this.style.background=\'#ddddee\'; this.style.color=\'#333366\';"';
        }

        $imagen = obtener_imagen_producto($ref);
        //$codigo_imagen = obtener_producto_codigo_imagen($imagen, $ref);
        $codigo_imagen = obtener_producto_codigo_imagen_cesta($imagen, $ref);
        
        $nombre = htmlentities(obtener_nombre_producto($ref), ENT_COMPAT, 'iso-8859-1');
        
        echo '<center><table border="0" width="' . ($margen_body - $margen_tablas - 35) . '" align="center" class="cesta_producto_sin_borde">';
        
		$ancho_td = (int)($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] + $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]/1.8);
		
		$version_encogida = FALSE;
		if (($margen_body - 100) <= $ancho_td) { $version_encogida = TRUE; $ancho_td = (int)( ($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] / 2) + $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]/3.2); }
		
		echo '<tr><td width="' . $ancho_td . '" align="center" class="cesta_imagen"><center>';
		echo '<div style="position:relative">';
        echo $codigo_imagen;
        echo '</div>';
        echo '</center></td><td align="center" class="cesta_producto"><center>';
        if (trim($nombre) != "") { echo '<font size="3" color="#0000aa" face="arial"><b>' . $nombre . '</b></font><br>'; }
        if (trim($ref) != "") { echo '<font size="1" color="#55ccaa" face="courier">' . $ref . "</font><br>"; }

        $hayPiezas = FALSE;
        foreach ($producto as $modalidad => $cantidad)
        {
            if ($modalidad == "pieza_entera" || $modalidad == "pieza_media" || $modalidad == "pieza_cuarto" || $modalidad == "pieza" || $modalidad == "piezas")
            {
                $hayPiezas = TRUE;
            }
        }
        
        if ($hayPiezas) { echo usar_etiqueta("METROS_POR_PIEZA") . ": " . obtener_metros_por_pieza($ref) . " (" . usar_etiqueta("APROXIMADAMENTE") . ")"; }

        echo '</center></td></tr>';
        
        echo '</table><center><table border="0" width="' . ($margen_body - $margen_tablas - 35) . '" align="center" class="cesta_producto_sin_borde">';
        
        //echo "REF = $ref<br>";
        $contador_modalidad = 0;
        foreach ($producto as $modalidad => $cantidad)
        {
            $modalidad = trim($modalidad);
            if ($modalidad == "" || $cantidad == 0) { continue; }

      
            //echo '<tr><td width="10"><img src="img/web/blank.gif" alt="" title="" width="1" height="1" border="0" hspace="0" vspace="0" align="center" align="middle"></td><td>';
            //echo '<table border="0" align="right"><tr>';
            echo '<tr><td border="0"><table border="0"><tr>';
            
            echo  '<td>';
            
                $onSubmit = "";
                $centimetros_minimo = obtener_minimo_centimetros($ref);
                $incremento_centimetros = obtener_incremento_centimetros($ref);
                if ($javascript_soportado) { $onSubmit = ' onSubmit="return validarModificar(' . $contador_producto . ', ' . $incremento_centimetros . ', ' . $centimetros_minimo . ', ' . $id_idioma . ', \'' . $ref . '\', \'' . $modalidad . '\', ' . $contador_avisos . ');"'; }
                if ($editable) { echo '<form method="get" action="' . $this_file . '" id="formulario_modificar_' . $contador_producto . '" name="formulario_modificar_' . $contador_producto . '" class="producto"' . $onSubmit . '>'; }
                echo '<table border="0">';
           
                echo '<tr><td colspan="2"><font size="3" color="#ffffff" face="arial">';

                    if ($editable)
                    {
                        echo $sesion_form;
                        echo '<input type="hidden" name="ref_producto" value="' . $ref . '">';
                        echo '<input type="hidden" name="modalidad" value="' . $modalidad . '">';
                        echo '<input type="hidden" name="accion" value="modificar">';
                    }

                    $codigoJS_label = "";
                    if ($javascript_soportado && $javascript_version >= 2)
                    {
                        $codigoJS_label_prototipo = ' onMouseOver="document.getElementById(\'prototipo_label\').style.color=\'#ccccff\'; document.getElementById(\'prototipo\').style.background=\'#3333ff\'; document.getElementById(\'prototipo\').style.color=\'#aaaaff\'; document.getElementById(\'prototipo\').style.border=\'1px solid #0000ff\';" onMouseOut="document.getElementById(\'prototipo_label\').style.color=\'#ffffff\'; document.getElementById(\'prototipo\').style.background=\'#3333bb\'; document.getElementById(\'prototipo\').style.color=\'#bbbbff\'; document.getElementById(\'prototipo\').style.border=\'1px solid #0000aa\';"';

                        $codigoJS_label = str_replace("prototipo", "cantidad_" . $contador_producto . "_" . $contador_modalidad, $codigoJS_label_prototipo);
                    }
            
                    echo '<label for="cantidad_' . $contador_producto . '_' . $contador_modalidad . '"' . $codigoJS_label . ' id="cantidad_' . $contador_producto . '_' . $contador_modalidad . '_label">';
            
                    if ($modalidad == "cantidad") { echo usar_etiqueta("CANTIDAD"); }
                    else if ($modalidad == "centimetros")
					{
						if ($version_encogida) { echo "CM"; }
						else { echo usar_etiqueta("CENTIMETROS"); }
					}
                    else if ($modalidad == "pieza_entera") { echo usar_etiqueta("PIEZA_ENTERA"); }
                    else if ($modalidad == "pieza_media") { echo usar_etiqueta("MEDIA_PIEZA"); }
                    else if ($modalidad == "pieza_cuarto") { echo usar_etiqueta("CUARTO_DE_PIEZA"); }
                    else { echo $modalidad; }
                    echo ":";
                    
                    echo '</label>';
                    
                echo '</td><td><font size="3" color="#ffffff" face="terminal">';
            
                //echo $cantidad;
            
                echo '<label for="cantidad_' . $contador_producto . '_' . $contador_modalidad . '"' . $codigoJS_label . '>';
            
                if ($editable && $modalidad == "centimetros") { echo '<table border="0" cellspacing="0" cellpadding="2"><tr><td>'; }
            
                $numero_caracteres = 5;
                if ($version_encogida) { $numero_caracteres = 3; }
				if ($editable) { echo '<input type="text" name="cantidad" id="cantidad_' . $contador_producto . '_' . $contador_modalidad . '" value="' . $cantidad . '" size="' . $numero_caracteres . '" maxlength="5" class="texto"' . $codigoJS_texto . '>'; }
                else { echo $cantidad; }
                
                if ($editable && $modalidad == "centimetros")
                {
                    echo '</td><td>';
                
                    if ($javascript_soportado && $javascript_version >= 2)
                    {
                        echo '<table border="0" cellspacing="0" cellpadding="2" align="center">';
                        echo '<tr><td align="center"><center>';
                        echo '<img src="img/web/productos/mas.gif" hspace="0" vspace="0" border="0" width="15" hspace="15" alt="+" title="' . usar_etiqueta("INCREMENTAR_CENTIMETROS") . '" style="cursor:pointer; cursor:hand;" onClick="incrementarCentimetrosCesta(' . $contador_producto . ', ' . $contador_modalidad . ', ' . $incremento_centimetros . ', ' . $centimetros_minimo . ');">';
                        echo '</center></td></tr><tr><td align="center"><center>';
                        echo '<img src="img/web/productos/menos.gif" hspace="0" vspace="0" border="0" width="15" hspace="15" alt="-" title="' . usar_etiqueta("DECREMENTAR_CENTIMETROS") . '" style="cursor:pointer; cursor:hand;" onClick="decrementarCentimetrosCesta(' . $contador_producto . ', ' . $contador_modalidad . ', ' . $incremento_centimetros . ', ' . $centimetros_minimo . ');">';
                        echo '</center></td></tr>';
                        echo '</table>';
                    }
                    
                    echo '</td></tr></table>';
                }
                
                
            
                echo '</label>';
            
                echo '</td>';
                
                $contador_modalidad++;
            
            if ($editable)
            { 
                    //echo "</tr><tr>"; //MIERDA
					echo '<td>';
    
                        echo '<input type="submit" name="boton" value="' . usar_etiqueta("EDITAR") . '" class="boton"' . $codigoJS_boton . '>';

                    echo '</td>';
            }
            
                echo '</tr></table></form></td>';

            
            if ($editable)
            {
                    //echo "</tr><tr>"; //MIERDA

                    echo '<td>';

                    //FALTA: onSubmit vacio si no hay nada o lleno si hay JavaScript para hacer validacion. Y si hay AJAX, usarlo.
                    
                    $onSubmitBorrar = "";
                    if ($ajax_soportado) { $onSubmitBorrar = ' onSubmit="return borrar_producto(' . $id_idioma . ', \'' . $modalidad . '\', \'' . $ref . '\');"'; }
                    
                    echo '<form method="get" action="' . $this_file . '" class="producto"' . $onSubmitBorrar . '>';

                    echo $sesion_form;
                    echo '<input type="hidden" name="ref_producto" value="' . $ref . '">';
                    echo '<input type="hidden" name="modalidad" value="' . $modalidad . '">';
                    echo '<input type="hidden" name="accion" value="eliminar">';
            
					$etiqueta_borrar = usar_etiqueta("BORRAR");
                    if ($version_encogida) { $etiqueta_borrar = "X"; }
					
					echo '<input type="submit" name="boton" value="' . $etiqueta_borrar . '" class="boton"' . $codigoJS_boton . '>';

                    echo '</form>';
                        
                echo '</td>';
            }

            echo '</tr></table>';
            
            //echo '<tr><td>';

            //if ($javascript_soportado && $javascript_version >= 2)
            //{
            //    echo '<div id="modificar_avisos_' . $contador_avisos . '" class="alerta_producto"></div>';
            //}
            //$contador_avisos++;

            //echo '</td></tr>';
            
            //echo '</table>';

            //echo mostrar_precios($ref, $cantidad, $modalidad, $contador_producto);
            
            $total += sumar_totales($ref, $cantidad, $modalidad);

            $contador_producto++;
            
            echo '</td><td><img src="img/web/blank.gif" alt="" title="" width="1" height="1" border="0" hspace="0" vspace="0" align="center" align="middle"></td></tr>';
            //echo "<tr><td></td><td>";
            echo "<tr><td colspan=\"2\">";
            if ($javascript_soportado && $javascript_version >= 2)
            {
                echo '<div id="modificar_avisos_' . $contador_avisos . '" class="alerta_producto"></div>';
            }
            echo mostrar_precios($ref, $cantidad, $modalidad, $contador_avisos);
            $contador_avisos++;
            
            //echo '</td><td><img src="img/web/blank.gif" alt="" title="" width="1" height="1" border="0" hspace="0" vspace="0" align="center" align="middle"></td></tr>';
            echo '</td></tr>';

        }
        echo '</table></center>';
        
        return $total;
        
    }

    
    //Funcion que muestra los precios:
    function mostrar_precios($ref, $cantidad, $modalidad, $contador_producto)
    {
            global $ajax_soportado;

            $html = "";
            
            if ($ajax_soportado)
            {
                $html = '<div id="precios_' . $contador_producto . '" class="cesta_producto">';
            }
            
            //$identificado = (recoger_sesion("identificado")) ? true : false;
            $usuario = recoger_sesion("usuario");
            $tipo_usuario = recoger_sesion("tipo");
            
            
            if ($modalidad == "cantidad")
            {
                $precio_unitario = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario); //obtener_precio_cuenta_producto($ref, $usuario, $tipo_usuario, $cantidad);
                
                $precio_total = $precio_unitario * $cantidad;
            }
            else if ($modalidad == "centimetros")
            {
                $precio_metro = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario); //obtener_precio_cuenta_producto($ref, $usuario, $tipo_usuario, $cantidad);
                
                $precio_unitario = $precio_metro; //Relativo a metro.
                
                $precio_total = $precio_metro / 100 * $cantidad;
            }
            else
            {
                $metros_por_pieza = obtener_metros_por_pieza($ref);
                
                $cantidad_pieza = 1;
                if ($modalidad == "pieza_entera") { $cantidad_pieza = 1; }
                else if ($modalidad == "pieza_media") { $cantidad_pieza = 0.5; }
                else if ($modalidad == "pieza_cuarto") { $cantidad_pieza = 0.25; }
                
                $precio_metro = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario, TRUE); //obtener_precio_cuenta_producto($ref, $cantidad_pieza, $usuario, $tipo_usuario, TRUE);
                
                $precio_unitario = $precio_metro; //Relativo a metro.
                
                $precio_total = $cantidad * $precio_unitario * $metros_por_pieza * $cantidad_pieza;
            }
            
            //$precio_normal = obtener_precio_normal_producto($ref);
            
            $html .= '<font size="2" color="#ffffff" face="arial">';
            
            $html .= usar_etiqueta("PRECIO_UNITARIO") . ": <b>" . number_format($precio_unitario, usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . "</b> " . usar_etiqueta("EURO");
            if ($modalidad != "cantidad") { $html .= "/" . usar_etiqueta("METRO"); }
            
            $html .= "<br>";
            
            $html .= usar_etiqueta("PRECIO_RESULTANTE") . ": <b>" . number_format($precio_total, usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . "</b> " . usar_etiqueta("EURO");
            //if ($modalidad != "cantidad") { $html .= "/" . usar_etiqueta("METRO"); }
            
			if ($modalidad != "cantidad") { $html .= " (" . usar_etiqueta("APROXIMADAMENTE") . ")"; }
            
            $html .= '</font><hr size="1" color="#00aacc" noshadow style="height:1px; width:100%; color:#00aacc;">';

            if ($ajax_soportado)
            {
                $html .= "</div>";
            }
            
            return $html;
    }  

    //Funcion que calcula los precios:
    function sumar_totales($ref, $cantidad, $modalidad)
    {
            global $ajax_soportado;

            //$identificado = (recoger_sesion("identificado")) ? true : false;
            $usuario = recoger_sesion("usuario");
            $tipo_usuario = recoger_sesion("tipo");
            
            if ($modalidad == "cantidad")
            {
                $precio_unitario = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario); //obtener_precio_cuenta_producto($ref, $usuario, $tipo_usuario, $cantidad);
                
                $precio_total = $precio_unitario * $cantidad;
            }
            else if ($modalidad == "centimetros")
            {
                $precio_metro = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario); //obtener_precio_cuenta_producto($ref, $usuario, $tipo_usuario, $cantidad);
                
                $precio_unitario = $precio_metro; //Relativo a metro.
                
                $precio_total = $precio_metro / 100 * $cantidad;
            }
            else
            {
                $metros_por_pieza = obtener_metros_por_pieza($ref);
                
                $cantidad_pieza = 1;
                if ($modalidad == "pieza_entera") { $cantidad_pieza = 1; }
                else if ($modalidad == "pieza_media") { $cantidad_pieza = 0.5; }
                else if ($modalidad == "pieza_cuarto") { $cantidad_pieza = 0.25; }
                
                $precio_metro = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario, TRUE); //obtener_precio_cuenta_producto($ref, $cantidad_pieza, $usuario, $tipo_usuario, TRUE);
                
                $precio_unitario = $precio_metro; //Relativo a metro.
                
                //$precio_total = $precio_unitario * $metros_por_pieza * $cantidad_pieza;
                $precio_total = $cantidad * $precio_unitario * $metros_por_pieza * $cantidad_pieza;
            }
            
            return $precio_total;
    }  




    function calcular_precio_producto($producto, $ref)
    {
        $total = 0;
        
        foreach ($producto as $modalidad => $cantidad)
        {
            $modalidad = trim($modalidad);
            if ($modalidad == "" || $cantidad == 0) { continue; }
            $total += sumar_totales($ref, $cantidad, $modalidad);
        }

        return $total;
    }

    
    //Funcion que calcula el total:
    function calcular_total()
    {
        $cesta = recoger_sesion("cesta");
        
        //Si la cesta no es una matriz, sale:
        if (!is_array($cesta)) { return 0; }
        
        $total = 0;

        $cestaVacia = TRUE;
        foreach ($cesta as $ref => $matriz)
        {
            if (!is_array($cesta[$ref])) { continue; }

            //Si el producto no esta, salta el loop:
            if (!producto_agregado_alguno($ref)) { continue; }
            
            $cestaVacia = FALSE;
            
            $total += calcular_precio_producto($matriz, $ref);
        }
        
        return $total;
    }
    
    
    //Funcion que devuelve la cesta en HTML (para enviarla por E-Mail en un pedido):
    function obtener_cesta_html()
    {
        global $constantes;

        $cesta = recoger_sesion("cesta");

        $html = "";
        
        if (!is_array($cesta)) { return "Cesta vac&iacute;a"; }

        $cestaVacia = TRUE;
        $total = 0;
        foreach ($cesta as $ref => $producto)
        {
            if (!is_array($cesta[$ref])) { continue; }

            //Si el producto no esta, salta el loop:
            if (!producto_agregado_alguno($ref)) { continue; }
            
            $cestaVacia = FALSE;
            
            $hayPiezas = FALSE;
            foreach ($producto as $modalidad => $cantidad)
            {
                if ($modalidad == "pieza_entera" || $modalidad == "pieza_media" || $modalidad == "pieza_cuarto" || $modalidad == "pieza" || $modalidad == "piezas")
                {
                    $hayPiezas = TRUE;
                }
            }
        
            $html .= "<br>Nombre: <b>" . htmlentities(obtener_nombre_producto($ref, TRUE), ENT_COMPAT, 'iso-8859-1') . "</b>";
            $html .= "<br>* Referencia: <b>$ref</b>";
            
            if (trim($constantes["WEB_URL"]) != "") { $direccion_buscar = $constantes["WEB_URL"]; }
            else if (trim($constantes["WEB_URL2"]) != "") { $direccion_buscar = $constantes["WEB_URL2"]; }
            else { $direccion_buscar = "http://www.albapatch.com"; }
            
            if (trim($constantes["BUSCAR_ARCHIVO"]) != "") { $pagina_buscar = $constantes["BUSCAR_ARCHIVO"]; }
            else { $direccion_buscar = "buscar.php"; }
            
            //if (trim($constantes["BUSCAR_ID"]) != "") { $id_buscar = $constantes["BUSCAR_ID"]; }
            //else { $id_buscar = "-1"; }
            
            //$direccion_buscar .= "/" . $pagina_buscar . "?categoria=" . $id_buscar . "&ref=" . $ref;
            $direccion_buscar .= "/" . $pagina_buscar . "?ref=" . $ref;
            
            $html .= "<br>* Buscar en la web: <a href=\"$direccion_buscar\" target=\"_blank\">$direccion_buscar</a><br>";

            if ($hayPiezas) { $html .= "* Metros por pieza: " . obtener_metros_por_pieza($ref) . " (aproximadamente)<br>"; }
        
            $contador_modalidad = 0;
            foreach ($producto as $modalidad => $cantidad)
            {
                $modalidad = trim($modalidad);
                if ($modalidad == "" || $cantidad == 0) { continue; }
                
                if ($modalidad == "cantidad") { $html .= "* <b>Cantidad</b>: "; }
                else if ($modalidad == "centimetros") { $html .= "* <b>Cent&iacute;metros</b>: "; }
                else if ($modalidad == "pieza_entera") { $html .= "* <b>Pieza entera</b>: "; }
                else if ($modalidad == "pieza_media") { $html .= "* <b>Media pieza</b>: "; }
                else if ($modalidad == "pieza_cuarto") { $html .= "* <b>Cuarto de pieza</b>: "; }
                else { $html .= "<b>$modalidad</b>: "; }
                
                $html .= "$cantidad<br>";

                $usuario = recoger_sesion("usuario");
                $tipo_usuario = recoger_sesion("tipo");

                $esPieza = FALSE;
                if ($modalidad == "cantidad")
                {
                    $precio_unitario = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario); //obtener_precio_cuenta_producto($ref, $usuario, $tipo_usuario, $cantidad);
                    $precio_total = $precio_unitario * $cantidad;
                }
                else if ($modalidad == "centimetros")
                {
                    $precio_metro = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario); //obtener_precio_cuenta_producto($ref, $usuario, $tipo_usuario, $cantidad);
                    $precio_unitario = $precio_metro; //Relativo a metro.
                    $precio_total = $precio_metro / 100 * $cantidad;
                }
                else
                {
                    $metros_por_pieza = obtener_metros_por_pieza($ref);
                    $cantidad_pieza = 1;
                    if ($modalidad == "pieza_entera") { $cantidad_pieza = 1; $esPieza = TRUE; }
                    else if ($modalidad == "pieza_media") { $cantidad_pieza = 0.5; $esPieza = TRUE; }
                    else if ($modalidad == "pieza_cuarto") { $cantidad_pieza = 0.25; $esPieza = TRUE; }
                    $precio_metro = obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo_usuario, TRUE); //obtener_precio_cuenta_producto($ref, $cantidad_pieza, $usuario, $tipo_usuario, TRUE);
                    $precio_unitario = $precio_metro; //Relativo a metro.
                    //$precio_total = $precio_unitario * $metros_por_pieza * $cantidad_pieza;
                    $precio_total = $cantidad * $precio_unitario * $metros_por_pieza * $cantidad_pieza;
                }
                
                $html .= "** Precio unitario: " . number_format($precio_unitario, usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES"));
                if ($modalidad == "centimetros" || $esPieza ) { $html .= " (metro)"; }
                $html .= "<br>";
                
                $html .= "** <b>Precio total</b>: " . number_format($precio_total, usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . "<br><br>";
                
                $total += $precio_total;
            }
            $html .= "<hr>";
        }

        $html .= "<br>Total sin gastos: " . number_format($total, usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES"));
        $html .= "<br><b>Total</b>: " . number_format($total + $constantes["GASTOS_ENVIO"], usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES"));

        if ($cestaVacia)
        {
            $html = "Cesta vac&iacute;a";
        }
        
        return $html;
    }
?>
