<?php
    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    if (file_exists("cod/func/web/fecha.php")) { include_once "cod/func/web/fecha.php"; }
    else if (file_exists("web/fecha.php")) { include_once "web/fecha.php"; }
    if (file_exists("cod/func/web/hora.php")) { include_once "cod/func/web/hora.php"; }
    else if (file_exists("web/hora.php")) { include_once "web/hora.php"; }
    if (file_exists("cod/config/variables.php")) { include_once "cod/config/variables.php"; }
    else if (file_exists("../config/variables.php")) { include_once "../config/variables.php"; }

    if (file_exists("cod/func/web/recoger_get.php")) { require_once "cod/func/web/recoger_get.php"; }
    else if (file_exists("web/recoger_get.php")) { require_once "web/recoger_get.php"; }
    if (file_exists("cod/func/web/recoger_post.php")) { require_once "cod/func/web/recoger_post.php"; }
    else if (file_exists("web/recoger_post.php")) { require_once "web/recoger_post.php"; }

    if (file_exists("cod/func/web/recoger_sesion.php")) { require_once "cod/func/web/recoger_sesion.php"; }
    else if (file_exists("web/recoger_sesion.php")) { require_once "web/recoger_sesion.php"; }
    else if (file_exists("../cod/func/web/recoger_sesion.php")) { require_once "../cod/func/web/recoger_sesion.php"; }

    if (file_exists("cod/func/idioma.php")) { require_once "cod/func/idioma.php"; }
    else if (file_exists("idioma.php")) { require_once "idioma.php"; }

    if (isset($base_datos))
    {
        if (file_exists("cod/func/idioma.php")) { require_once "cod/func/idioma.php"; }
        else if (file_exists("idioma.php")) { require_once "idioma.php"; }
    }

    //if (file_exists("cod/func/web/ip_dns.php")) { require_once "cod/func/web/ip_dns.php"; }
    //else if (file_exists("web/ip_dns.php")) { require_once "web/ip_dns.php"; }

    //if (file_exists("cod/func/constantes.php")) { require_once "cod/func/constantes.php"; }
    //else if (file_exists("func/constantes.php")) { require_once "func/constantes.php"; }

    //include_once "cod/func/web/hora.php";
    //include_once "cod/config/variables.php";

    $usando_ajax = recoger_post("usando_ajax");
    if ($usando_ajax && $usando_ajax == "directo")
    {
		session_name("albapatch_session");
        session_start("albapatch_session");

		require_once "web/registrar.php";
        $error = recoger_post("error");
		
		$id_sesion_enviado = recoger_post(session_name());
		
		//Solo envia el error si se ha enviado una sesion valida y es la actual:
		if ($id_sesion_enviado == session_id())
		{
			if (trim($error) != "") { enviar_email_error($error); }
		}
    }
    
    function enviar_email($email, $asunto, $texto, $email_remitente = "", $nombre_remitente = "", $html = TRUE, $enviar_informacion_adicional = TRUE, $enviar_copia = TRUE, $registrar = TRUE)
    {
        global $constantes, $nombre_enviado, $email_respuestas, $email_errores_advertencias, $email_copia;
        
        //Define el nombre y email del remitente y el email de errores:
        if (trim($nombre_remitente) == "")
        {
            if (isset($constantes["WEB_TITULO"]) && trim($constantes["WEB_TITULO"]) != "") { $nombre_enviado = $constantes["WEB_TITULO"]; }
            else if (!isset($nombre_enviado) || isset($nombre_enviado) && trim($nombre_enviado) == "") { $nombre_enviado = "No se pudo obtener WEB_TITULO"; }
        } else { $nombre_enviado = trim($nombre_remitente); }
        
        if (trim($email_remitente) == "")
        {
            if (isset($constantes["EMAIL_RESPUESTAS"]) && trim($constantes["EMAIL_RESPUESTAS"]) != "") { $email_respuestas = $constantes["EMAIL_RESPUESTAS"]; }
            else if (!isset($email_respuestas) || isset($email_respuestas) && trim($email_respuestas) == "") { $email_respuestas = "email_respuestas@noobtenido.com"; }
        }
        else { $email_respuestas = addslashes($email_remitente); }
        
        if (isset($constantes["EMAIL_ERRORES_ADVERTENCIAS"]) && trim($constantes["EMAIL_ERRORES_ADVERTENCIAS"]) != "") { $email_errores_advertencias = $constantes["EMAIL_ERRORES_ADVERTENCIAS"]; }
        else if (!isset($email_errores_advertencias) || isset($email_errores_advertencias) && trim($email_errores_advertencias) == "") { $email_errores_advertencias = "email_errores_advertencias@noobtenido.com"; }
        
		$rule = array("\r" => '',
					  "\n" => '',
					  "\t" => '',
					  '"'  => "'",
					  '<'  => '[',
					  '>'  => ']',
				);


        //Crear las cabeceras:
        //$headers = "Date: ".date("d/m/Y, G:i")."\r\n";
		$headers = "Date: " . strtr(date("r"), $rule) . "\r\n";
        $headers .= "MIME-Version: 1.0\r\n"; 
        $headers .= "From: ".strtr($nombre_enviado, $rule)."<".strtr($email_respuestas, $rule).">\r\n";
		//$headers .= "From: ".strtr($nombre_enviado, $rule)."\r\n";
        $headers .="Return-path: ".strtr($email_respuestas, $rule)."\r\n";
        $headers .="Reply-To: ".strtr($email_respuestas, $rule)."\r\n";
        $headers .= "Errors-To: ".strtr($email_errores_advertencias, $rule)."\r\n";
        $headers .= "X-Personal_name:".strtr($nombre_enviado, $rule)."\r\n";
        $headers .= "X-Mailer:PHP/".strtr(phpversion(), $rule)."\r\n"; 
        if ($html) { $headers .="Content-type: text/html; charset=iso-8859-1\r\n"; }
        else { $headers .="Content-type: text/plain; charset=iso-8859-1\r\n"; }
        $headers_sin_nl = preg_replace("/\r\n|\r|\n/", "<br>", htmlentities($headers));

        //Calcula la hora y la fecha:
        $fecha = obtener_fecha();
        $hora = obtener_hora();

        //Pone la fecha y la hora en el asunyo y en el mensaje:
        $asunto = $asunto . " ($fecha - $hora)";
        $texto = $texto . "<br><br>--- FIN DEL MENSAJE ---<br>Enviado el $fecha a las $hora";

        if ($enviar_informacion_adicional) { $texto .= "<br><br>---<br><br>" . informacion_adicional(); }

        //Pone un salto de linea en cada <br> para que se pueda ver en clientes de email basados en texto (sin HTML):
        $texto = str_replace("<br/>", "<br>\n", str_replace("<br />", "<br>\n", str_replace("<br>", "<br>\n", $texto)));
        $texto_sin_nl = preg_replace("/\r\n|\r|\n/", "", $texto);

        //Si el email no debe contener HTML, quita los tags:
        if (!$html) { $texto = html_entity_decode(strip_tags($texto)); }

        //Enviar E-Mail:
        $email_enviado_bien = @mail($email, $asunto, $texto, $headers);

        //Envia una copia del E-Mail:
        if ($enviar_copia) { @mail($email_copia, "[Alba Patchwork] " . $asunto, $texto, $headers); }
		
		
		//echo "<br><br>";
		//echo "<br>email: " . htmlentities($email);
		//echo "<br>email_copia: " . htmlentities($email_copia);
		//echo "<br>asunto: " . $asunto;
		//echo "<br>texto: " . $texto;
		//echo "<br>HEADERS: " . $headers;
		//echo "<br><br>";
		
        //Registra el E-Mail:
        if ($registrar) { registrar("email", "<hr>INICIO DE E-MAIL<hr><br>\n" . $asunto . ":\n<br>" . $texto_sin_nl . "<br>\n" . $headers_sin_nl . "\n<br><hr>FIN DE E-MAIL<hr><br><br>\n\n"); }
		
        return $email_enviado_bien;
    }

    function enviar_email_error($texto)
    {
        global $constantes, $email_errores_advertencias;
        
        if (isset($constantes["EMAIL_ERRORES_ADVERTENCIAS"]) && trim($constantes["EMAIL_ERRORES_ADVERTENCIAS"]) != "") { $email = $constantes["EMAIL_ERRORES_ADVERTENCIAS"]; }
        else if (isset($email_errores_advertencias) && trim($email_errores_advertencias) != "") { $email = $email_errores_advertencias; }
        else { $email = "email_errores_advertencias@noobtenido.com"; }
        //else { $email = "email_errores_advertencias@noobtenido.com"; }

        $email_enviado = enviar_email($email, "error", $texto, "", "", TRUE, TRUE, TRUE, FALSE);

        if (!$email_enviado) { registrar("error", "No se pudo enviar un email a <b>" . $email . "</b> con la notificacion del error."); }
    }
    
    function informacion_adicional()
    {
        global $javascript_soportado, $javascript_version, $ajax_soportado, $id_sesion, $this_file, $id_categoria, $id_idioma, $HTTP_SERVER_VARS, $constantes;

        $identificado = recoger_sesion("identificado");

        $informacion_adicional = "Informaci&oacute;n adicional:<br>";

        if (!$identificado)
        {
            $informacion_adicional .= "* Registrado: no<br>";
        }
        else
        {

            $informacion_adicional .= "* Registrado: s&iacute;<br>";
            $usuario = recoger_sesion("usuario");

            $clave = recoger_sesion("clave");

            $tipo = recoger_sesion("tipo");

            if (trim($usuario) == "") { $usuario = "desconocido (no se pudo recoger)"; }
            if (trim($tipo) == "") { $tipo = "desconocido (no se pudo recoger)"; }
            $informacion_adicional .= "** Usuario: $usuario<br>";
            $informacion_adicional .= "** Tipo: $tipo<br>";
        }

        $informacion_adicional .= "* IP: " . obtener_ip_dns() . "<br>";
        $informacion_adicional .= "* Hora: " . obtener_hora() . "<br>";
        $informacion_adicional .= "* Fecha: " . obtener_fecha() . "<br>";

        if (!$javascript_soportado)
        {
            $informacion_adicional .= "* JavaScript soportado: no<br>";
        }
        else
        {
            $informacion_adicional .= "* JavaScript soportado: s&iacute;<br>";
            $informacion_adicional .= "** JavaScript versi&oacute;n: $javascript_version<br>";
            if (!$ajax_soportado)
            {
                $informacion_adicional .= "** Ajax soportado: no<br>";
            }
            else
            {
                $informacion_adicional .= "** Ajax soportado: s&iacute;<br>";
            }
        }

        if (SID)
        {
            $informacion_adicional .= "* Cookies activadas: no<br>";
        }
        else
        {
            $informacion_adicional .= "* Cookies activadas: s&iacute;<br>";
        }

        $informacion_adicional .= "* ID de sesi&oacute;n para GET: " . $id_sesion . "<br>";

        $informacion_adicional .= "* ID de sesi&oacute;n reconstruido: " . session_name() . "=" . session_id() . "<br>";

        $informacion_adicional .= "* Categor&iacute;a actual: $id_categoria ($this_file)<br>";

        $idiomas = obtener_idiomas();

        $nombre_idioma = $idiomas[$id_idioma];

        $informacion_adicional .= "* Idioma actual: $id_idioma ($nombre_idioma)<br>";

        if (isset($constantes["WEB_URL"]) && trim($constantes["WEB_URL"]) != "") { $informacion_adicional .= "* P&aacute;gina visitada reconstruida (caduca): " . $constantes["WEB_URL"] . "/" . $this_file . "?" . session_name() . "=" . session_id() . "&categoria=" . $id_categoria . "&idioma=" . $id_idioma . "<br>"; }
        else { $informacion_adicional .= "* P&aacute;gina visitada reconstruida (caduca): no_se_pudo_coger_web_url_de_constantes/" . $this_file . "?" . session_name() . "=" . session_id() . "&categoria=" . $id_categoria . "&idioma=" . $id_idioma . "<br>"; }
        
        $dominio = "http://dominio_desconocido";
        $uri_calculada = "/uri_desconocida";
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["SERVER_NAME"]) && trim($HTTP_SERVER_VARS["SERVER_NAME"]) != "") { $dominio = trim($HTTP_SERVER_VARS["SERVER_NAME"]); }
        else if (isset($_SERVER) && isset($_SERVER["SERVER_NAME"]) && trim($_SERVER["SERVER_NAME"]) != "") { $dominio = trim($_SERVER["SERVER_NAME"]); }
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["REQUEST_URI"]) && trim($HTTP_SERVER_VARS["REQUEST_URI"]) != "") { $uri_calculada = trim($HTTP_SERVER_VARS["REQUEST_URI"]); }
        else if (isset($_SERVER) && isset($_SERVER["REQUEST_URI"]) && trim($_SERVER["REQUEST_URI"]) != "") { $uri_calculada = trim($_SERVER["REQUEST_URI"]); }
        $informacion_adicional .= "* P&aacute;gina visitada real (caduca): $dominio$uri_calculada<br>";

        $metodo = "desconocido";
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["REQUEST_METHOD"]) && trim($HTTP_SERVER_VARS["REQUEST_METHOD"]) != "") { $metodo = trim($HTTP_SERVER_VARS["REQUEST_METHOD"]); }
        else if (isset($_SERVER) && isset($_SERVER["REQUEST_METHOD"]) && trim($_SERVER["REQUEST_METHOD"]) != "") { $metodo = trim($_SERVER["REQUEST_METHOD"]); }
        $informacion_adicional .= "* M&eacute;todo de petici&oacute;n: $metodo<br>";

        $agente = "desconocido";
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["HTTP_USER_AGENT"]) && trim($HTTP_SERVER_VARS["HTTP_USER_AGENT"]) != "") { $agente = trim($HTTP_SERVER_VARS["HTTP_USER_AGENT"]); }
        else if (isset($_SERVER) && isset($_SERVER["HTTP_USER_AGENT"]) && trim($_SERVER["HTTP_USER_AGENT"]) != "") { $agente = trim($_SERVER["HTTP_USER_AGENT"]); }
        $informacion_adicional .= "* Agente de usuario (navegador web): $agente<br>";

        $charset = "desconocido";
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["HTTP_ACCEPT_CHARSET"]) && trim($HTTP_SERVER_VARS["HTTP_ACCEPT_CHARSET"]) != "") { $charset = trim($HTTP_SERVER_VARS["HTTP_ACCEPT_CHARSET"]); }
        else if (isset($_SERVER) && isset($_SERVER["HTTP_ACCEPT_CHARSET"]) && trim($_SERVER["HTTP_ACCEPT_CHARSET"]) != "") { $charset = trim($_SERVER["HTTP_ACCEPT_CHARSET"]); }
        $informacion_adicional .= "** Charset (conjunto de car&aacute;cteres): $charset<br>";

        $codificacion = "desconocida";
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["HTTP_ACCEPT_ENCODING"]) && trim($HTTP_SERVER_VARS["HTTP_ACCEPT_ENCODING"]) != "") { $codificacion = trim($HTTP_SERVER_VARS["HTTP_ACCEPT_ENCODING"]); }
        else if (isset($_SERVER) && isset($_SERVER["HTTP_ACCEPT_ENCODING"]) && trim($_SERVER["HTTP_ACCEPT_ENCODING"]) != "") { $codificacion = trim($_SERVER["HTTP_ACCEPT_ENCODING"]); }
        $informacion_adicional .= "** Codificaci&oacute;n: $codificacion<br>";

        $lenguaje = "desconocido";
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["HTTP_ACCEPT_LANGUAGE"]) && trim($HTTP_SERVER_VARS["HTTP_ACCEPT_LANGUAGE"]) != "") { $lenguaje = trim($HTTP_SERVER_VARS["HTTP_ACCEPT_LANGUAGE"]); }
        else if (isset($_SERVER) && isset($_SERVER["HTTP_ACCEPT_LANGUAGE"]) && trim($_SERVER["HTTP_ACCEPT_LANGUAGE"]) != "") { $lenguaje = trim($_SERVER["HTTP_ACCEPT_LANGUAGE"]); }
        $informacion_adicional .= "** Lenguaje: $lenguaje<br>";

        return $informacion_adicional;
    }
?>
