<?php
    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    if (file_exists("cod/func/web/ip_dns.php")) { require_once "cod/func/web/ip_dns.php"; }
    else if (file_exists("web/ip_dns.php")) { require_once "web/ip_dns.php"; }

    if (file_exists("cod/func/web/setear_sesion.php")) { require_once "cod/func/web/setear_sesion.php"; }
    else if (file_exists("web/setear_sesion.php")) { require_once "web/setear_sesion.php"; }

    if (file_exists("cod/func/web/recoger_sesion.php")) { require_once "cod/func/web/recoger_sesion.php"; }
    else if (file_exists("web/recoger_sesion.php")) { require_once "web/recoger_sesion.php"; }


    //Funcion que detecta si el usuario es el que inicio la sesion o no:
    function es_mismo_usuario()
    {
        global $HTTP_SERVER_VARS;

        $mismo_usuario = TRUE;
        
        $ip_dns_antigua = trim(recoger_sesion("ip_dns"));
        $ip_dns = obtener_ip_dns();

        //Si existen ip y dns anteriores i no coinciden con el actual, no es el mismo usuario:
        if ($ip_dns_antigua != "" && $ip_dns_antigua && $ip_dns != $ip_dns_antigua)
        {
            $mismo_usuario = FALSE;
        }

        $navegador_antiguo = trim(recoger_sesion("navegador"));
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["HTTP_USER_AGENT"]) && trim($HTTP_SERVER_VARS["HTTP_USER_AGENT"]) != "") { $navegador = trim($HTTP_SERVER_VARS["HTTP_USER_AGENT"]); }
        else if (isset($_SERVER) && isset($_SERVER["HTTP_USER_AGENT"]) && trim($_SERVER["HTTP_USER_AGENT"]) != "") { $navegador = trim($_SERVER["HTTP_USER_AGENT"]); }

        //Si existe navegador anterior i no coincide con el actual, no es el mismo usuario:
        if ($navegador_antiguo != "" && $navegador_antiguo && $navegador != $navegador_antiguo)
        {
            $mismo_usuario = FALSE;
        }

        return $mismo_usuario;
    }

    //Funcion que guarda el usuario actual:
    function guardar_usuario()
    {
        guardar_ip_dns_sesion();
        guardar_navegador_sesion();
    }
    
    //Funcion que guarda la ip y dns del usuario actual:
    function guardar_ip_dns_sesion()
    {
        setear_sesion("ip_dns", obtener_ip_dns());
    }
    
    //Funcion que guarda el navegador del:
    function guardar_navegador_sesion()
    {
        global $HTTP_SERVER_VARS;
        $navegador = "desconocido";
        if (isset($HTTP_SERVER_VARS) && isset($HTTP_SERVER_VARS["HTTP_USER_AGENT"]) && trim($HTTP_SERVER_VARS["HTTP_USER_AGENT"]) != "") { $navegador = trim($HTTP_SERVER_VARS["HTTP_USER_AGENT"]); }
        else if (isset($_SERVER) && isset($_SERVER["HTTP_USER_AGENT"]) && trim($_SERVER["HTTP_USER_AGENT"]) != "") { $navegador = trim($_SERVER["HTTP_USER_AGENT"]); }
        setear_sesion("navegador", $navegador);
    }
?>
