<?php
    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    require_once "func/cesta_funciones.php";

    //Procesa las acciones, si han sido enviadas:
    procesar_formularios();

    //Muestra la cesta:
    mostrar_cesta();

    //Funcion que procesa los formularios:
    function procesar_formularios()
    {
        global $margen_body, $margen_tablas;
    
        $cesta = recoger_sesion("cesta");
        
        $mensaje = "";
        
        //Si se ha enviado una accion, la procesa:
        $accion = trim(recoger_get("accion"));
        
        if ($accion == "") { $accion = trim(recoger_post("accion")); }
        
        $error = FALSE;
        switch ($accion)
        {
            //Si se ha enviado agregar un producto:
            case "agregar":
                $modalidad = trim(recoger_get("tipo"));
                $cantidad = trim(recoger_get("cantidad"));
                $ref_producto = trim(recoger_get("ref_producto"));
                if ($modalidad != "" && $cantidad != "" && is_numeric($cantidad) && $ref_producto != "" && producto_licito($ref_producto, $cantidad, $modalidad))
                {
                    $agregado = agregar_producto($ref_producto, $cantidad, $modalidad);
                    if ($agregado)
                    {
                        $mensaje = usar_etiqueta("PRODUCTO_AGREGADO_CESTA");
                    }
                    else
                    {
                        $mensaje = usar_etiqueta("PRODUCTO_NO_AGREGADO_CESTA");
                        
                        $error = TRUE;
                    }
                }
                else
                {
                    $mensaje = usar_etiqueta("PRODUCTO_NO_AGREGADO_CESTA");
                    
                    $error = TRUE;
                }
                break;
            //Si se ha enviado modificar un producto:
            case "modificar":
                $modalidad = trim(recoger_get("modalidad"));
                $cantidad = trim(recoger_get("cantidad"));
                $ref_producto = trim(recoger_get("ref_producto"));

                if ($modalidad != "" && $cantidad != "" && is_numeric($cantidad) && $ref_producto != "" && producto_licito($ref_producto, $cantidad, $modalidad))
                {
                    if (producto_agregado($ref_producto, $modalidad))
                    {
                        $modificado = modificar_producto($ref_producto, $cantidad, $modalidad);
                        if ($cantidad == 0)
                        {
                            if ($modificado)
                            {
                                $mensaje = usar_etiqueta("PRODUCTO_ELIMINADO_CESTA");
                            }
                            else { $mensaje = usar_etiqueta("PRODUCTO_NO_ELIMINADO_CESTA"); }
                        }
                        else
                        {
                            if ($modificado)
                            {
                                $mensaje = usar_etiqueta("PRODUCTO_MODIFICADO_CESTA");
                            }
                            else
                            {
                                $mensaje = usar_etiqueta("PRODUCTO_NO_MODIFICADO_CESTA");
                                
                                $error = TRUE;
                            }
                        }
                    }
                    else
                    {
                        $mensaje = usar_etiqueta("PRODUCTO_NO_MODIFICADO_CESTA");
                        
                        $error = TRUE;
                    }
                }
                else
                {
                    $mensaje = usar_etiqueta("PRODUCTO_NO_MODIFICADO_CESTA");
                    
                    $error = TRUE;
                }
                break;
            //Si se ha enviado eliminar un producto:
            case "eliminar":
                $modalidad = trim(recoger_get("modalidad"));
                if ($modalidad == "") { $modalidad = trim(recoger_post("modalidad")); }
                $ref_producto = trim(recoger_get("ref_producto"));
                if ($ref_producto == "") { $ref_producto = trim(recoger_post("ref_producto")); }
                if ($modalidad != "" && $ref_producto != "")
                {
                    if (producto_agregado($ref_producto, $modalidad))
                    {
                        $eliminado = borrar_producto($ref_producto, $modalidad);
                        if ($eliminado)
                        {
                            $mensaje = usar_etiqueta("PRODUCTO_ELIMINADO_CESTA");
                        }
                        else { $mensaje = usar_etiqueta("PRODUCTO_NO_ELIMINADO_CESTA"); }
                    } //else { $mensaje = usar_etiqueta("PRODUCTO_NO_ELIMINADO_CESTA"); }
                }
                else { $mensaje = usar_etiqueta("PRODUCTO_NO_ELIMINADO_CESTA"); }
                break;
            default:
                break;
        }
        
        if (trim($mensaje) != "")
        {
            echo '<br><center><table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center><b>';
            //echo $mensaje;
            //echo '</b></center></td></tr></table></center>';
        }
        
        if ($error)
        {
            if ($modalidad == "centimetros")
            {
                $minimo = obtener_minimo_centimetros($ref_producto);
                $incremento = obtener_incremento_centimetros($ref_producto);
                
                if (!is_numeric($cantidad) || is_numeric($cantidad) && $cantidad < $minimo || is_numeric($cantidad) && ((int)$cantidad) != $cantidad) { echo usar_etiqueta("ERROR_CENTIMETROS_MINIMO") . " " . $minimo . " " . strtolower(usar_etiqueta("CENTIMETROS")) . "<br>"; }
                if ($cantidad % $incremento != 0) { echo usar_etiqueta("ERROR_CENTIMETROS_INCREMENTO") . " " . $incremento . " " . strtolower(usar_etiqueta("CENTIMETROS")) . "<br>"; }
            }
            else
            {
                if (!is_numeric($cantidad) || is_numeric($cantidad) && $cantidad < 1 || is_numeric($cantidad) && ((int)$cantidad) != $cantidad) { echo usar_etiqueta("ERROR_CANTIDAD") . "<br>"; }
            }
        }
        
        if (trim($mensaje) != "")
        {
            echo $mensaje;
            echo '</b></center></td></tr></table></center>';
        }
    }
    
?>
