<?php
	if (!ini_get("safe_mode")) { @set_time_limit(0); }

	session_name("albapatch_session_admin");
	if (@!session_start("albapatch_session_admin"))
	{
		session_regenerate_id();
		session_start("albapatch_session_admin");
	}
	if (file_exists("../cod/func/web/recoger_sesion.php"))
	{
		require_once("../cod/func/web/recoger_sesion.php");
	}
	else
	{
		require_once("../../cod/func/web/recoger_sesion.php");
	}
	$autorizado = recoger_sesion("autorizado");
	if ($autorizado != "si") { echo "No autorizado"; exit(0); }
	
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Pragma: no-cache");

	if (file_exists("../cod/func/web/recoger_post.php"))
	{
		require_once("../cod/func/web/recoger_post.php");
	}
	else
	{
		require_once("../../cod/func/web/recoger_post.php");
	}

	$realizar_accion = strtolower(trim(recoger_post("realizar_accion")));
	if ($realizar_accion != "si") { echo "No se quiere realizar accion"; exit(0); }
	
	$tipo = strtolower(trim(recoger_post("tipo")));

	$tipos_permitidos = array("pedido", "contacto", "email", "error", "ajax");
	
	if ($tipo == "" || !in_array($tipo, $tipos_permitidos)) { echo "Tipo vacio o no permitido (" . $tipo . ")"; exit(0); }
	
	$archivo = "logs/" . $tipo . ".php";
	
	$existeArchivo = FALSE;
	$directorio = "";
	if (file_exists($archivo))
	{
		require_once($archivo);
		$existeArchivo = TRUE;
	}
	else if (file_exists("../" . $archivo))
	{
		$directorio = "../";
		require_once($directorio . $archivo);
		$existeArchivo = TRUE;
	}
	else { echo "No se encuentra " . $directorio . $archivo; exit(0); }

	if ($existeArchivo)
	{
		$accion = strtolower(trim(recoger_post("accion")));
		if ($accion != "archivar" && $accion != "desarchivar") { echo "Accion desconocida"; exit(0); }
		
		$id_mensaje = trim(recoger_post("id_mensaje"));
		
		if (!is_numeric($id_mensaje)) { echo "Id del mensaje no numerico (" . $id_mensaje . ")"; exit(0); }
		else if (!isset($mensajes) || !isset($mensajes[$id_mensaje])) { echo "Mensaje #" . $id_mensaje . " no existente"; exit(0); }
		else if (!isset($mensajes[$id_mensaje]["fecha"])) { echo "Mensaje #" . $id_mensaje . " existente pero incompleto (no tiene FECHA)"; exit(0); }
		else if (!isset($mensajes[$id_mensaje]["hora"])) { echo "Mensaje #" . $id_mensaje . " existente pero incompleto (no tiene HORA)"; exit(0); }
		else if (!isset($mensajes[$id_mensaje]["ip_dns"])) { echo "Mensaje #" . $id_mensaje . " existente pero incompleto (no tiene IP_DNS)"; exit(0); }
		else if (!isset($mensajes[$id_mensaje]["session_name"])) { echo "Mensaje #" . $id_mensaje . " existente pero incompleto (no tiene SESSION_NAME)"; exit(0); }
		else if (!isset($mensajes[$id_mensaje]["session_id"])) { echo "Mensaje #" . $id_mensaje . " existente pero incompleto (no tiene SESSION_ID)"; exit(0); }
		else if (!isset($mensajes[$id_mensaje]["contenido"])) { echo "Mensaje #" . $id_mensaje . " existente pero incompleto (no tiene CONTENIDO)"; exit(0); }
		
		$archivo_archivados = $directorio . "logs/" . $tipo . "_archivados.php";
		
		if (file_exists($archivo_archivados)) { include_once($archivo_archivados); }
		
		if ($accion == "archivar" && isset($mensajes[$id_mensaje]["archivado"]) && $mensajes[$id_mensaje]["archivado"])
		{
			//echo "El mensaje #" . $id_mensaje . " ya esta archivado";
			echo "ok";
			exit(0);
		}
		else if ($accion == "desarchivar")
		{
			if (!isset($mensajes[$id_mensaje]["archivado"]) || isset($mensajes[$id_mensaje]["archivado"]) && !$mensajes[$id_mensaje]["archivado"])
			{
				//echo "El mensaje #" . $id_mensaje . " ya esta desarchivado";
				echo "ok";
				exit(0);
			}
		}

		$codigo = "";
		foreach ($mensajes as $id_mensaje_actual => $mensaje)
		{
			if (isset($mensaje["archivado"]) && $id_mensaje_actual != $id_mensaje || $accion == "archivar" && $id_mensaje_actual == $id_mensaje)
			{
				$codigo .= "<" . "?php ";
					$codigo .= "\$mensajes[" . $id_mensaje_actual . "][\"archivado\"] = TRUE;";
				$codigo .= " ?" . ">\r\n";
			}
		}
		
		if (trim($codigo) == "") { echo "ok"; exit(0); }
		
		$puntero = fopen($archivo_archivados, "w");
		
		$todo_bien = FALSE;
        if (isset($puntero) && $puntero)
        {
            $todo_bien = fputs($puntero, $codigo);
			
            fclose($puntero);
        }
		
		if ($todo_bien) { echo "ok"; }
		else { echo "Archivo " . $archivo_archivados . " no escrito"; }
		
		exit(0);
	}
?>