<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "categoria_archivo.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'utf-8'); }

    //Funcion que devuelve los idiomas:
    function obtener_idiomas()
    {
        global $base_datos;
        
        $idiomas = Array();
        
        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);

        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_idioma = $row["id_idioma"];
            $idioma = htmlentities($row["idioma"]);
            $idiomas[$id_idioma] = $idioma;
        }
        
        return $idiomas;
    }

    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM categorias WHERE raiz = 0 AND mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);

        $idiomas = obtener_idiomas();

        ?>
            <center>
            <form method="post" action="<?php echo $this_file; ?>">
                <input type="hidden" name="accion" value="modificar">
        <?php

        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            //echo $id_categoria;
            echo '<table width="700"><tr>';
            foreach ($idiomas as $id_idioma => $idioma)
            {
                $consulta = "SELECT * FROM categoria_idioma WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma";
                $resultados2 = $base_datos->haz_consulta($consulta);
                $resultados_matriz = mysqli_fetch_assoc($resultados2);
                $nombre_categoria = $resultados_matriz["nombre_categoria"];
                echo '<td><span class="destacado">'.$idioma.'</span><br>' . $nombre_categoria . '</td>';
            }
            echo "</tr><tr>";
            echo '<td colspan="' . sizeof($idiomas) . '">';
            $consulta = "SELECT * FROM categorias JOIN categoria_archivo WHERE categorias.id_categoria = categoria_archivo.id_categoria AND categorias.id_categoria = $id_categoria AND raiz = 0 AND mostrar != 0";
            $resultados3 = $base_datos->haz_consulta($consulta);
            $resultados_matriz2 = mysqli_fetch_assoc($resultados3);
            $archivo = $resultados_matriz2["archivo"];
            echo 'Archivo: <input type="text" name="archivo_' . $id_categoria . '" size="50" value="' . $archivo . '">';
            echo "</td>";
            echo "</tr></table><br>";
        }
        
        ?>
                <table width="700"><tr><td><input type="submit" name="boton" value="Modificar"></td></tr></table>
            </form>
            </center>
        <?php
    }
    

    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        return recoger_post("accion");
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'modificar':
                $operacion = modificar_categoria_archivo();
                if (!$operacion) { mostrar_error("No se ha podido modificar u operar con la tabla de categoria_archivo."); }
                else { echo "Tabla categoria_archivo modificada correctamente.<br>"; }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }
    
    
    //Funcion que modifica la tabla categoria_archivo:
    function modificar_categoria_archivo()
    {
        global $base_datos;
        
        $consulta = "SELECT * FROM categorias WHERE raiz = 0 AND mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $operacion = TRUE;
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            borrar_categoria_archivo($id_categoria);
            $archivo = mysqli_real_escape_string($base_datos->conexion, recoger_post("archivo_$id_categoria"));
            if ($archivo && $archivo != "")
            {
                $operacion_actual = insertar_categoria_archivo($id_categoria, $archivo);
                if (!$operacion_actual) { $operacion = FALSE; }
            }
        }
        
        return ($resultados && $operacion);
    }
    
    
    //Funcion que borra el registro en que aparece la id de la categoria en categoria_archivo:
    function borrar_categoria_archivo($id_categoria)
    {
        global $base_datos;
        
        $consulta = "DELETE FROM categoria_archivo WHERE id_categoria = $id_categoria";
        $operacion = $base_datos->haz_consulta($consulta);

        return $operacion;    
    }
    
    //Funcion que borra un registro en categoria_archivo:    
    function insertar_categoria_archivo($id_categoria, $archivo)
    {
        global $base_datos;
        
        $consulta = "INSERT INTO categoria_archivo (id_categoria, archivo) VALUES ($id_categoria, '".trim($archivo)."')";
        $operacion = $base_datos->haz_consulta($consulta);

        return $operacion;    
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de los archivos de las categor&iacute;s principales</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de los archivos de las categor&iacute;s principales</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();
            
            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
