<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "categorias_modificacion.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'utf-8'); }

    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $id_categoria = recoger_post("id_categoria");
        
        if (trim($id_categoria) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }


    //Funcion que devuelve los idiomas:
    function obtener_idiomas()
    {
        global $base_datos;
        
        $idiomas = Array();
        
        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);

        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_idioma = $row["id_idioma"];
            $idioma = htmlentities($row["idioma"]);
            $idiomas[$id_idioma] = $idioma;
        }
        
        return $idiomas;
    }
    
    
    function mostrar_formulario()
    {
            global $base_datos, $this_file;
            
            $id_categoria = recoger_post("id_categoria");
            $idiomas = obtener_idiomas();

            $consulta = "SELECT * FROM categorias WHERE id_categoria = $id_categoria";
            $resultados = $base_datos->haz_consulta($consulta);
            $resultados_matriz = mysqli_fetch_assoc($resultados);
            $mostrar = $resultados_matriz["mostrar"];
            $checked = ($mostrar) ? " checked" : "";

            ?>
            <table align="center" width="720">
                <tr>
                    <td>
                        <center>
                        <form method="post" action="<?php echo $this_file; ?>">
                            <table>
                                <tr>
                                    <td>
                                        <label for="mostrar"><input type="checkbox" name="mostrar" id="mostrar" value="si" class="casilla"<?php echo $checked; ?>> Mostrar</label>
                                    </td>
                                </tr>
                            </table>
                            <br>
            <?php
        
            foreach ($idiomas as $id_idioma => $idioma)
            {
                $consulta = "SELECT * FROM categoria_idioma WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma";
                $resultados = $base_datos->haz_consulta($consulta);
                $resultados_matriz = mysqli_fetch_assoc($resultados);
                $nombre_categoria = $resultados_matriz["nombre_categoria"];

                $consulta2 = "SELECT * FROM categoria_titulo WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma";
                $resultados2 = $base_datos->haz_consulta($consulta2);
                $resultados2_matriz = (mysqli_fetch_assoc($resultados2));
                $titulo = $resultados2_matriz["titulo"];
                
                echo '<table><tr><td>';
                echo '<h3 class="destacado">' . $idioma . ':</h3>';
                echo 'Nombre <i>' . $idioma . '</i>:<br><input type="text" name="categoria_' . $id_idioma . '" value="' . htmlentities($nombre_categoria) . '" size="20"><br><br>';
                echo 'T&iacute;tulo <i>' . $idioma . '</i>:<br><input type="text" name="titulo_' . $id_idioma . '" value="' . htmlentities($titulo) . '" size="60"><br><br><br>';

                //$texto_categoria = $resultados_matriz["texto"];
                //echo "[$id_categoria] $idioma($id_idioma, $idioma) = ($nombre_categoria)<br>";

                $consulta = "SELECT * FROM categoria_texto WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma AND LOWER(parte) LIKE 'encabezado'";
                $resultados = $base_datos->haz_consulta($consulta);
                $resultados_matriz = mysqli_fetch_assoc($resultados);
                $categoria_encabezado = $resultados_matriz["codigo"];
                $eval_bd = $resultados_matriz["eval"];
                $eval_checked = ($eval_bd == 0) ? "" : " checked";
                //echo "Encabezado: $categoria_encabezado<br>";
                echo 'Encabezado <i>' . $idioma . '</i>:<br>';
                echo '&nbsp;&nbsp;&nbsp; [<span onClick="poner_archivo(' . $id_categoria . ', ' . $id_idioma . ', \'encabezado\');" onMouseOver="this.style.color=\'red\';" onMouseOut="this.style.color=\'blue\';" style="color:blue; cursor:pointer; cursor:hand;">Utilizar archivo</span>]';
                echo '&nbsp;&nbsp;&nbsp; <label for="eval_encabezado_' . $id_idioma . '"><input type="checkbox" id="eval_encabezado_' . $id_idioma . '" name="eval_encabezado_' . $id_idioma . '" value="si" class="casilla"' . $eval_checked . '> Eval</label><br>';
                echo '<textarea name="encabezado_' . $id_idioma . '" id="encabezado_' . $id_idioma . '" rows="20" cols="75">' . htmlentities($categoria_encabezado) . '</textarea><br><br><br>';

                $consulta = "SELECT * FROM categoria_texto WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma AND LOWER(parte) LIKE 'cuerpo'";
                $resultados = $base_datos->haz_consulta($consulta);
                $resultados_matriz = mysqli_fetch_assoc($resultados);
                $categoria_cuerpo = $resultados_matriz["codigo"];
                $eval_bd = $resultados_matriz["eval"];
                $eval_checked = ($eval_bd == 0) ? "" : " checked";
                //echo "Pie: $categoria_pie<br>";
                //echo 'Cuerpo <i>' . $idioma . '</i>:<br>';
                //echo '<textarea name="cuerpo_' . $id_idioma . '" rows="20" cols="75">' . $categoria_cuerpo . '</textarea><br><br>';
                echo 'Cuerpo <i>' . $idioma . '</i>:<br>';
                echo '&nbsp;&nbsp;&nbsp; [<span onClick="poner_archivo(' . $id_categoria . ', ' . $id_idioma . ', \'cuerpo\');" onMouseOver="this.style.color=\'red\';" onMouseOut="this.style.color=\'blue\';" style="color:blue; cursor:pointer; cursor:hand;">Utilizar archivo</span>]';
                echo '&nbsp;&nbsp;&nbsp; <label for="eval_cuerpo_' . $id_idioma . '"><input type="checkbox" id="eval_cuerpo_' . $id_idioma . '" name="eval_cuerpo_' . $id_idioma . '" value="si" class="casilla"' . $eval_checked . '> Eval</label><br>';
                echo '<textarea name="cuerpo_' . $id_idioma . '" id="cuerpo_' . $id_idioma . '" rows="20" cols="75">' . htmlentities($categoria_cuerpo) . '</textarea><br><br><br>';

                
                $consulta = "SELECT * FROM categoria_texto WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma AND LOWER(parte) LIKE 'pie'";
                $resultados = $base_datos->haz_consulta($consulta);
                $resultados_matriz = mysqli_fetch_assoc($resultados);
                $categoria_pie = $resultados_matriz["codigo"];
                $eval_bd = $resultados_matriz["eval"];
                $eval_checked = ($eval_bd == 0) ? "" : " checked";
                //echo "Pie: $categoria_pie<br>";
                //echo 'Pie <i>' . $idioma . '</i>:<br>';
                //echo '<textarea name="pie_' . $id_idioma . '" rows="20" cols="75">' . $categoria_pie . '</textarea><br><br>';
                echo 'Pie <i>' . $idioma . '</i>:<br>';
                echo '&nbsp;&nbsp;&nbsp; [<span onClick="poner_archivo(' . $id_categoria . ', ' . $id_idioma . ', \'pie\');" onMouseOver="this.style.color=\'red\';" onMouseOut="this.style.color=\'blue\';" style="color:blue; cursor:pointer; cursor:hand;">Utilizar archivo</span>]';
                echo '&nbsp;&nbsp;&nbsp; <label for="eval_pie_' . $id_idioma . '"><input type="checkbox" id="eval_pie_' . $id_idioma . '" name="eval_pie_' . $id_idioma . '" value="si" class="casilla"' . $eval_checked . '> Eval</label><br>';
                echo '<textarea name="pie_' . $id_idioma . '" id="pie_' . $id_idioma . '" rows="20" cols="75">' . htmlentities($categoria_pie) . '</textarea><br><br>';

                echo '</td></tr></table>';
                echo "<br><br><br>";
            }
            
            ?>
                            <input type="hidden" name="id_categoria" value="<?php echo $id_categoria; ?>">
                            <input type="hidden" name="accion" value="modificar">
                            <input type="submit" name="boton" value="Modificar">
                        </form>
                        <form method="post" action="categorias.php" onSubmit="return confirmar_eliminar('<?php echo $id_categoria; ?>');">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="hidden" name="id_categoria" value="<?php echo $id_categoria; ?>">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                        </center>
                    </td>
                </tr>
            </table>
            <?php
    }
    
    
    function procesar_formulario()
    {
        //Si no se ha enviado modificar, sale de la funcion:
        $accion = recoger_post("accion");
        if ($accion == "") { return; }

        //Guarda los datos en la base de datos:
        $id_categoria = recoger_post("id_categoria");
        $operacion = modificar_categoria($id_categoria);
        if ($operacion) { mostrar_advertencia("Categor&iacute;a modificada con exito."); }
        else { mostrar_error("No se pudo modificar la categor&iacute;a, al menos completamente."); }
    }
    
    function modificar_categoria($id_categoria)
    {
        global $base_datos;
        
        //Recoge si se ha enviado mostrar o no:
        $mostrar = recoger_post("mostrar");
        $mostrar_valor = ($mostrar != "") ? 1 : 0;
        $consulta = "UPDATE categorias SET mostrar = $mostrar_valor WHERE id_categoria = $id_categoria";
        $operacion0 = $base_datos->haz_consulta($consulta);
        $operacion = $operacion0;
        
        //Recoge los idiomas:
        $idiomas = obtener_idiomas();

        //Define las partes:
        $partes = Array("encabezado", "cuerpo", "pie");

        //Recorre los idiomas:
        foreach ($idiomas as $id_idioma => $idioma)
        {
            //Pone el nuevo nombre a la categoria para cada idioma:
            //$nombre = mysqli_real_escape_string($base_datos->conexion, htmlentities(recoger_post("categoria_" . $id_idioma)));
            $nombre = mysqli_real_escape_string($base_datos->conexion, recoger_post("categoria_" . $id_idioma));
            //if ($nombre != "") { $operacion_actual1 = cambiar_nombre_categoria($id_categoria, $id_idioma, $nombre); }
            //else { $operacion_actual1 = TRUE; }
            $operacion_actual1 = cambiar_nombre_categoria($id_categoria, $id_idioma, $nombre);

            //Pone el nuevo titulo a la categoria para cada idioma:
            borrar_titulo_categoria($id_categoria, $id_idioma);
            //$titulo = mysqli_real_escape_string($base_datos->conexion, htmlentities(recoger_post("titulo_" . $id_idioma)));
            $titulo = mysqli_real_escape_string($base_datos->conexion, recoger_post("titulo_" . $id_idioma));

            if ($titulo != "") { $operacion_actual2 = cambiar_titulo_categoria($id_categoria, $id_idioma, $titulo); }
            else { $operacion_actual2 = TRUE; }
            
            //Recorre todas las partes:
            foreach ($partes as $parte)
            {
                //Borra todas las partes existentes de la categoria en todos los idiomas:
                $operacion_actual3 = borrar_parte_categoria($id_categoria, $id_idioma, $parte);
            
                //Pone las partes que no se hayan enviado vacias para todos los idiomas:
                $operacion_actual4 = insertar_parte_categoria($id_categoria, $id_idioma, $parte);
            }
            
            if (!$operacion_actual1 || !$operacion_actual2 || !$operacion_actual3 || !$operacion_actual4) { $operacion = FALSE; }
        }
        
        return $operacion;
    }
    
    //Funcion que cambia el nombre a la categoria en un idioma:
    function cambiar_nombre_categoria($id_categoria, $id_idioma, $nombre)
    {
        global $base_datos;

        $operacion = "UPDATE categoria_idioma SET nombre_categoria = '".trim($nombre)."' WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma";
        $resultados = $base_datos->haz_consulta($operacion);
        
        return $resultados;
    }

    //Funcion que cambia el titulo a la categoria en un idioma:
    function cambiar_titulo_categoria($id_categoria, $id_idioma, $titulo)
    {
        global $base_datos;

        $operacion = "INSERT INTO categoria_titulo (id_categoria, id_idioma, titulo) VALUES ($id_categoria, $id_idioma, '".trim($titulo)."')";
        $resultados = $base_datos->haz_consulta($operacion);
        
        return $resultados;
    }

    //Funcion que borra el titulo a la categoria en un idioma:
    function borrar_titulo_categoria($id_categoria, $id_idioma)
    {
        global $base_datos;

        $operacion = "DELETE FROM categoria_titulo WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma";
        $resultados = $base_datos->haz_consulta($operacion);
        
        return $resultados;
    }

    //Funcion que borra la parte especifica a la categoria en un idioma:
    function borrar_parte_categoria($id_categoria, $id_idioma, $parte)
    {
        global $base_datos;

        $operacion = "DELETE FROM categoria_texto WHERE id_categoria = $id_categoria AND id_idioma = $id_idioma AND parte LIKE '$parte'";
        $resultados = $base_datos->haz_consulta($operacion);
        
        return $resultados;
    }
    
    //Funcion que inserta la parte especifica a la categoria en un idioma:
    function insertar_parte_categoria($id_categoria, $id_idioma, $parte)
    {
        //Si la parte se ha enviado vacia, sale de la funcion retornando TRUE:
        global $base_datos;

        $codigo = mysqli_real_escape_string($base_datos->conexion, recoger_post($parte . "_" . $id_idioma));
        $eval_parte_enviado = recoger_post("eval_" . $parte . "_" . $id_idioma);
        $eval_parte = ($eval_parte_enviado != "") ? 1 : 0;
        
        //Si el codigo esta vacio y el eval se ha enviado false, sale de la funcion:
        if ($codigo == "" && !$eval_parte) { return TRUE; }
        //Recoge si se ha enviado mostrar o no:
        $operacion = "INSERT INTO categoria_texto (id_categoria, id_idioma, codigo, parte, eval) VALUES ($id_categoria, $id_idioma, '$codigo', '".trim($parte)."', $eval_parte)";
        $resultados = $base_datos->haz_consulta($operacion);
        
        return $resultados;
    }
    
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de una categor&iacute;a</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
            
            function poner_archivo(id_categoria, id_idioma, parte)
            {
                document.getElementById(parte + '_' + id_idioma).value += 'incluir_archivo_categoria(' + id_categoria + ', ' + id_idioma + ', "' + parte + '");';
                document.getElementById("eval_" + parte + "_" + id_idioma).checked = true;
            }
        // -->
        </script>
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de una categor&iacute;a</h2>
        </center>
        <center><a href="categorias.php">Volver al gestor de categor&iacute;as</a></center>
        <br>
        <br>
        <?php
            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, da error:
            else { mostrar_error('No se ha enviado ninguna categoria para ser modificada. Vuelve a <a href="categorias.php">gesti&oacute;n de categor&iacute;as</a>.'); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
