<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "constantes.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'utf-8'); }
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM constantes ORDER BY constante";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <table align="center" width="920">
            <tr>
                <td class="impar" width="250" valign="middle">Constante</td>
                <td class="impar" width="450" valign="middle">Modificar valor</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador_constantes = 0;
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_constante = $row["id_constante"];
            $constante = $row["constante"];
            $valor = $row["valor"];
            $checked = ($row["eval"]) ? " checked" : "";
            ?>
            <br>
            <table align="center" width="920">
                <tr>
                    <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('constante_<?php echo $contador_constantes; ?>').value == '') { alert('El nombre de la constante no se puede dejar vacio!'); return false; }">
                    <td class="<?php echo $par_impar; ?>" width="250" valign="middle">
                        <input type="text" name="constante" id="constante_<?php echo $contador_constantes; ?>" value="<?php echo htmlentities($constante); ?>" size="30">
                    </td>
                    <td class="<?php echo $par_impar; ?>" width="450" valign="middle">
                        <input type="hidden" name="id_constante" value="<?php echo htmlentities($id_constante); ?>">
                        <input type="hidden" name="accion" value="modificar">
                        <table>
                            <tr>
                                <td>
                                    <label for="eval_<?php echo htmlentities(trim($id_constante)); ?>" class="casilla"><input type="checkbox" name="eval_<?php echo htmlentities(trim($id_constante)); ?>" id="eval_<?php echo htmlentities(trim($id_constante)); ?>" class="casilla"<?php echo $checked; ?>><br>Eval</label>
                                </td>
                                <td>
                                    <input type="text" name="valor" value="<?php echo htmlentities($valor); ?>" size="20"> <input type="submit" name="boton" value="Modificar">
                                </td>
                            </tr>
                        </table>
                    </td>
                    </form>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($constante))); ?>');">
                            <input type="hidden" name="id_constante" value="<?php echo htmlentities($id_constante); ?>">
                            <input type="hidden" name="constante" value="<?php echo htmlentities($constante); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador_constantes++;
        }

        ?>

            <br>
            <table align="center" width="920">
                <tr>
                    <td valign="middle">
                        <?php
                            if (mysqli_num_rows($resultados) <= 0) { mostrar_advertencia("No hay constantes definidas en la tabla de constantes<br>"); }
                        ?>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('constante_nueva').value == '') { alert('Debes introducir una constante!'); return false; }">
                            <input type="hidden" name="accion" value="agregar">
                            Constante: <input type="text" name="constante" id="constante_nueva" value="" size="20"> &nbsp;&nbsp;&nbsp; Valor: <input type="text" name="valor" value="" size="20"> &nbsp;&nbsp;&nbsp; <input type="submit" name="boton" value="Agregar">
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        //global $base_datos;

        $constante = strtoupper(recoger_post("constante"));
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                if ($constante != "")
                {
                    $valor = recoger_post("valor");
                    $operacion = agregar_constante($constante, $valor);
                    if (!$operacion) { mostrar_error("No se ha podido agregar la constante <b>" . htmlentities($constante) . "</b>."); }
                    else { echo "Constante <b>" . htmlentities(strtoupper($constante)) . "</b> agregada<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar la constante <b>" . htmlentities($constante) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                $id_constante = recoger_post("id_constante");
                if ($id_constante != "" && is_numeric($id_constante))
                {
                    $operacion = eliminar_constante($id_constante);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar la constante <b>" . htmlentities($constante) . "</b> (con id '" . htmlentities($id_constante) . "')."); }
                    else { echo "Constante <b>" . htmlentities($constante) . "</b> (con id '$id_constante') eliminada<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar la constante <b>" . htmlentities($constante) . "</b> (con id '" . htmlentities($id_constante) . "'), puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id_constante = recoger_post("id_constante");
                $eval = recoger_post("eval_" . $id_constante);
                $valor = recoger_post("valor");
                if ($constante != "" && $id_constante != "" && is_numeric($id_constante))
                {
                    $operacion = modificar_constante($id_constante, $constante, $valor, $eval);
                    if (!$operacion) { mostrar_error("No se ha podido modificar la constante <b>" . htmlentities($constante) . "</b> (con id '" . htmlentities($id_constante) . "')."); }
                    else { echo "Constante con id '" . htmlentities($id_constante) . "' modificada a <b>" . htmlentities($constante) . "</b> con valor <b>$valor</b><br>"; }
                } else { mostrar_advertencia("No se ha podido modificar la constante <b>" . htmlentities($constante) . "</b> (con id '" . htmlentities($id_constante) . "'), puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe una constante o no:
    function existe_constante($constante)
    {
        global $base_datos;
        
        $constante = mysqli_real_escape_string($base_datos->conexion, $constante);
        
        $consulta = "SELECT * FROM constantes WHERE UPPER(constante) LIKE '$constante'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }


    //Funcion que agrega una constante nueva:
    function agregar_constante($constante, $valor)
    {
        if (existe_constante($constante)) { mostrar_error("La constante <b>" . htmlentities($constante) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $constante = mysqli_real_escape_string($base_datos->conexion, trim($constante));
        $valor = mysqli_real_escape_string($base_datos->conexion, trim($valor));
        
        $consulta = "INSERT INTO constantes (constante, valor) VALUES ('$constante', '$valor')";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que elimina una constante existente:
    function eliminar_constante($id_constante)
    {
        global $base_datos;

        //$id_constante = mysqli_real_escape_string($base_datos->conexion, $id_constante);
        
        $consulta = "DELETE FROM constantes WHERE id_constante = $id_constante";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica una constante existente:
    function modificar_constante($id_constante, $constante, $valor, $eval)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        //$id_constante = mysqli_real_escape_string($base_datos->conexion, $id_constante);
        $constante = mysqli_real_escape_string($base_datos->conexion, $constante);
        $valor = mysqli_real_escape_string($base_datos->conexion, $valor);
        $eval = ($eval) ? 1 : 0;

        $consulta = "UPDATE constantes SET constante = '".trim($constante)."', valor = '".trim($valor)."', eval = '$eval' WHERE id_constante = $id_constante";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de constantes</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('constante_nueva').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de constantes</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();
            
            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
