<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    //Incluye el archivo necesario para validar E-Mails:
    require_once "../cod/func/web/validar_email.php";

    
    //Guarda que pagina es esta:
    $this_file = "empresa_datos.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'utf-8'); }

    //Funcion que devuelve todos los grupos:
    function obtener_grupos()
    {
        global $base_datos;
        
        $consulta = "SELECT * FROM grupos";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $grupos = Array();
        
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_grupo = $row["id_grupo"];
            $nombre_grupo = $row["nombre_grupo"];
            
            $grupos[$id_grupo] = $nombre_grupo;
        }
        
        return $grupos;
    }


    //Funcion que devuelve todos los datos (las direcciones):
    function obtener_datos($id)
    {
        global $base_datos;
        
        $consulta = "SELECT * FROM empresa_datos WHERE id_empresa = $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $datos = Array();
        
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_dato = $row["id_empresa_datos"];
            $direccion = $row["direccion"];
            
            $datos[$id_dato] = $direccion;
        }
        //echo "estooooooooooooo = ".sizeof($datos);
        return $datos;
    }


    //Funcion que devuelve el dato seleccionado por defecto:
    function obtener_dato_actual($id)
    {
        global $base_datos;
        
        $consulta = "SELECT id_empresa_datos FROM empresa_datos_por_defecto WHERE id_empresa = $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysqli_num_rows($resultados) > 0)
        {
            $row = mysqli_fetch_assoc($resultados);        
            $resultado = $row["id_empresa_datos"];
        } else { $resultado = FALSE; }

        return $resultado;
    }
    
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $id = recoger_post("id");
        
        if (!is_numeric($id) || !$id) { mostrar_error("No se pudo recoger un ID de la empresa."); exit(); }

        $consulta = "SELECT id_grupo FROM empresa_grupo WHERE id_empresa = $id";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $id_grupo = $row["id_grupo"];

        ?>
        <center>
        <table border="1" align="center" width="620">
            <tr>
                <td>Grupo de la empresa</td>
                <td>
                    <form method="post" action="<?php echo $this_file; ?>">
                    <input type="hidden" name="accion" value="reagrupar">
                    <input type="hidden" name="id" value="<?php echo $id; ?>">
                    <select name="id_grupo">
                        <option value="0">-- Ninguno --</option>
                        <?php
                            $grupos = obtener_grupos();
                            foreach ($grupos as $id_grupo_actual => $grupo)
                            {
                                $selected = ($id_grupo_actual == $id_grupo) ? " selected" : "";
                                echo '<option value="' . $id_grupo_actual . '"' . $selected . '>' . $grupo . '</option>';
                            }
                        ?>
                    </select>
                </td>
                <td>
                    <input type="submit" name="boton" value="Modificar">
                    </form>
                </td>
            </tr>
        </table>
        <table border="1" align="center" width="620">
            <tr>
                <td>Datos por defecto</td>
                <td>
                    <form method="post" action="<?php echo $this_file; ?>">
                    <input type="hidden" name="accion" value="pordefecto">
                    <input type="hidden" name="id" value="<?php echo $id; ?>">
                    <select name="id_dato">
                        <?php
                        $datos = obtener_datos($id);
                        //if (sizeof($datos) <= 0) {
                        ?>
                        <option value="0">-- Ninguno --</option>
                        <?php
                        //}
                        //else
                        if (sizeof($datos) > 0)
                        {
                            $id_dato = obtener_dato_actual($id);
                            foreach ($datos as $id_dato_actual => $dato)
                            {
                                $selected = ($id_dato_actual == $id_dato) ? " selected" : "";
                                echo '<option value="' . $id_dato_actual . '"' . $selected . '>' . $dato . '</option>';
                            }
                        }
                        ?>
                    </select>
                </td>
                <td>
                    <input type="submit" name="boton" value="Modificar">
                    </form>
                </td>
            </tr>
        </table>
        </center>
        <br>
        <?php
        
        $consulta = "SELECT * FROM empresa_datos WHERE id_empresa = $id ORDER BY provincia_o_estado";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <table align="center" width="620">
            <tr>
                <td class="impar" width="400" valign="middle">Modificar</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador = 0;
        while ($row = mysqli_fetch_assoc($resultados))
        {
            //$id = $row["id_grupo"];
            //$nombre = $row["nombre_grupo"];
            $id_relacion = $row["id_empresa_datos"];
            $direccion = $row["direccion"];
            $codigo_postal = $row["codigo_postal"];
            $poblacion = $row["poblacion"];
            $provincia_o_estado = $row["provincia_o_estado"];
            $pais = $row["pais"];
            $telefono = $row["telefono"];
            $email = $row["email"];
            $fax = $row["fax"];
            ?>
            <br>
            <table align="center" width="620">
                <tr>
                    <form method="post" action="<?php echo $this_file; ?>" onSubmit="return comprobar_formulario(<?php echo $contador; ?>);">
                    <td class="<?php echo $par_impar; ?>" width="400" valign="middle">
                        <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                        <input type="hidden" name="id_relacion" value="<?php echo htmlentities($id_relacion); ?>">
                        <input type="hidden" name="accion" value="modificar">
                        <table border="1">
                            <tr><td>Direcci&oacute;n:</td><td><input type="text" name="direccion" id="direccion_<?php echo $contador; ?>" value="<?php echo htmlentities($direccion); ?>"></td></tr>
                            <tr><td>C&oacute;digo postal:</td><td><input type="text" name="codigo_postal" id="codigo_postal_<?php echo $contador; ?>" value="<?php echo htmlentities($codigo_postal); ?>"></td></tr>
                            <tr><td>Poblaci&oacute;n:</td><td><input type="text" name="poblacion" id="poblacion_<?php echo $contador; ?>" value="<?php echo htmlentities($poblacion); ?>"></td></tr>
                            <tr><td>Provincia, estado o regi&oacute;n:</td><td><input type="text" name="provincia_o_estado" id="provincia_o_estado_<?php echo $contador; ?>" value="<?php echo htmlentities($provincia_o_estado); ?>"></td></tr>
                            <tr><td>Pais:</td><td><input type="text" name="pais" id="pais_<?php echo $contador; ?>" value="<?php echo htmlentities($pais); ?>"></td></tr>
                            <tr><td>Tel&eacute;fono:</td><td><input type="text" name="telefono" id="telefono_<?php echo $contador; ?>" value="<?php echo htmlentities($telefono); ?>"></td></tr>
                            <tr><td>E-Mail:</td><td><input type="text" name="email" id="email_<?php echo $contador; ?>" value="<?php echo htmlentities($email); ?>"></td></tr>
                            <tr><td>Fax:</td><td><input type="text" name="fax" id="fax_<?php echo $contador; ?>" value="<?php echo htmlentities($fax); ?>"></td></tr>
                        </table>
                        <br>
                        <input type="submit" name="boton" value="Modificar">
                    </td>
                    </form>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($direccion))); ?>');">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="id_relacion" value="<?php echo htmlentities($id_relacion); ?>">
                            <input type="hidden" name="direccion" value="<?php echo htmlentities($direccion); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador++;
        }

        ?>

            <br>
            <table align="center" width="620">
                <tr>
                    <td valign="middle">
                         <?php
                            if (mysqli_num_rows($resultados) <= 0) { mostrar_advertencia("No hay datos en la tabla de datos para la empresa con id '$id'<br>"); }
                         ?>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return comprobar_formulario('nuevo');">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="accion" value="agregar">
                            <table border="1">
                                <tr><td>Direcci&oacute;n:</td><td><input type="text" name="direccion" id="direccion_nuevo" value=""></td></tr>
                                <tr><td>C&oacute;digo postal:</td><td><input type="text" name="codigo_postal" id="codigo_postal_nuevo" value=""></td></tr>
                                <tr><td>Poblaci&oacute;n:</td><td><input type="text" name="poblacion" id="poblacion_nuevo" value=""></td></tr>
                                <tr><td>Provincia, estado o regi&oacute;n:</td><td><input type="text" name="provincia_o_estado" id="provincia_o_estado_nuevo" value=""></td></tr>
                                <tr><td>Pais:</td><td><input type="text" name="pais" id="pais_nuevo" value=""></td></tr>
                                <tr><td>Tel&eacute;fono:</td><td><input type="text" name="telefono" id="telefono_nuevo" value=""></td></tr>
                                <tr><td>E-Mail:</td><td><input type="text" name="email" id="email_nuevo" value=""></td></tr>
                                <tr><td>Fax:</td><td><input type="text" name="fax" id="fax_nuevo" value=""></td></tr>
                            </table>
                            <br>
                            <input type="submit" name="boton" value="Agregar">
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        //$nombre = recoger_post("nombre");
        $direccion = recoger_post("direccion");
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                $id = recoger_post("id");
                if ($id != "" && is_numeric($id))
                {
                    $operacion = agregar($id);
                    if (!$operacion) { mostrar_error("No se ha podido agregar <b>" . htmlentities($direccion) . "</b>."); }
                    else { echo "<b>" . htmlentities($direccion) . "</b> agregado<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar <b>" . htmlentities($direccion) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                //$id = recoger_post("id");
                $id_relacion = recoger_post("id_relacion");
                if ($id_relacion != "" && is_numeric($id_relacion))
                {
                    $operacion = eliminar($id_relacion);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar <b>" . htmlentities($direccion) . "</b> (con id '" . htmlentities($id_relacion) . "')."); }
                    else { echo "<b>" . htmlentities($direccion) . "</b> (con id '$id_relacion') eliminado<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar <b>" . htmlentities($direccion) . "</b> (con id '" . htmlentities($id_relacion) . "'), puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                //$id = recoger_post("id");
                $id_relacion = recoger_post("id_relacion");
                if ($id_relacion != "" && is_numeric($id_relacion))
                {
                    $operacion = modificar($id_relacion);
                    if (!$operacion) { mostrar_error("No se ha podido modificar <b>" . htmlentities($direccion) . "</b> (con id '" . htmlentities($id_relacion) . "')."); }
                    else { echo "Registro con id '" . htmlentities($id_relacion) . "' modificado</b><br>"; }
                } else { mostrar_advertencia("No se ha podido modificar <b>" . htmlentities($direccion) . "</b> (con id '" . htmlentities($id_relacion) . "'), puede que falten datos en el formulario."); }
                break;
            case 'reagrupar':
                $id = recoger_post("id");
                $id_grupo = recoger_post("id_grupo");
                if ($id != "" && is_numeric($id) && $id_grupo != "" && is_numeric($id_grupo))
                {
                    $operacion = modificar_grupo($id, $id_grupo);
                    if (!$operacion) { mostrar_error("No se ha podido modificar el grupo de la empresa."); }
                    else { echo "Grupo de la empresa modificado<br>"; }
                } else { mostrar_advertencia("No se ha podido modificar el grupo de la empresa, puede que falten datos en el formulario."); }
                break;
            case 'pordefecto':
                $id = recoger_post("id");
                $id_dato = recoger_post("id_dato");
                if ($id != "" && is_numeric($id) && $id_dato != "" && is_numeric($id_dato))
                {
                    $operacion = modificar_dato_por_defecto($id, $id_dato);
                    if (!$operacion) { mostrar_error("No se han podido modificar los datos por defecto de la empresa."); }
                    else { echo "Datos por defecto de la empresa modificados<br>"; }
                } else { mostrar_advertencia("No se han podido modificar los datos por defecto del articular, puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un registro o no:
    function existe($direccion, $id)
    {
        global $base_datos;
        
        $nombre = mysqli_real_escape_string($base_datos->conexion, $direccion);
        
        $consulta = "SELECT * FROM empresa_datos WHERE UPPER(direccion) = '" . strtoupper($direccion) . "' AND id_empresa = $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que calcula si ya existen datos por defecto o no:
    function existen_datos_por_defecto($id)
    {
        global $base_datos;
        
        $nombre = mysqli_real_escape_string($base_datos->conexion, $direccion);
        
        $consulta = "SELECT * FROM empresa_datos_por_defecto WHERE id_empresa = $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que calcula si ya existe un registro o no (con una ID diferente a la que se envia):
    function existe_otra($direccion, $id)
    {
        global $base_datos;
        
        $nombre = mysqli_real_escape_string($base_datos->conexion, $direccion);
        
        $consulta = "SELECT * FROM empresa_datos WHERE UPPER(direccion) = '".strtoupper($direccion)."' AND id_empresa != $id";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }


    //Funcion que agrega un registro nuevo:
    function agregar($id)
    {
        $direccion = recoger_post("direccion");
        $codigo_postal = recoger_post("codigo_postal");
        $poblacion = recoger_post("poblacion");
        $provincia_o_estado = recoger_post("provincia_o_estado");
        $pais = recoger_post("pais");
        $telefono = recoger_post("telefono");
        $email = recoger_post("email");
        $fax = recoger_post("fax");
        
        if (existe($direccion, $id)) { mostrar_error("El registro <b>" . htmlentities($direccion) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $id = strtolower(mysqli_real_escape_string($base_datos->conexion, trim($id)));
        $direccion = mysqli_real_escape_string($base_datos->conexion, trim($direccion));
        $codigo_postal = strtoupper(mysqli_real_escape_string($base_datos->conexion, trim($codigo_postal)));
        $poblacion = mysqli_real_escape_string($base_datos->conexion, trim($poblacion));
        $provincia_o_estado = mysqli_real_escape_string($base_datos->conexion, trim($provincia_o_estado));
        $pais = mysqli_real_escape_string($base_datos->conexion, trim($pais));
        $telefono = strtoupper(mysqli_real_escape_string($base_datos->conexion, trim($telefono)));
        $email = strtolower(mysqli_real_escape_string($base_datos->conexion, trim($email)));
        $fax = strtolower(mysqli_real_escape_string($base_datos->conexion, trim($fax)));

        if(!validar_email($email)) { mostrar_error("El E-Mail es inv&aacute;lido"); return FALSE; }
        
        $consulta = "INSERT INTO empresa_datos (id_empresa, direccion, codigo_postal, poblacion, provincia_o_estado, pais, telefono, fax, email) VALUES ($id, '$direccion', '$codigo_postal', '$poblacion', '$provincia_o_estado', '$pais', '$telefono', '$fax', '$email')";
        $operacion = $base_datos->haz_consulta($consulta);
        
        if ($operacion)
        {
            if (obtener_dato_actual($id) == FALSE)
            {
                $id_dato = mysqli_insert_id($base_datos->conexion);
                modificar_dato_por_defecto($id, $id_dato);
            }
        }
        
        return $operacion;
    }
    
    
    //Funcion que elimina un registro existente:
    function eliminar($id)
    {
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        
        $consulta = "DELETE FROM empresa_datos WHERE id_empresa_datos = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica un registro existente:
    function modificar($id)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        //$nombre = strtolower(mysqli_real_escape_string($base_datos->conexion, htmlentities($nombre)));

        $direccion = recoger_post("direccion");
        $codigo_postal = recoger_post("codigo_postal");
        $poblacion = recoger_post("poblacion");
        $provincia_o_estado = recoger_post("provincia_o_estado");
        $pais = recoger_post("pais");
        $telefono = recoger_post("telefono");
        $email = recoger_post("email");
        $fax = recoger_post("fax");
        
        $id_empresa = recoger_post("id");
        if (existe_otra($direccion, $id_empresa)) { mostrar_error("El registro <b>" . htmlentities($direccion) . "</b> ya existe."); return FALSE; }

        $id = strtolower(mysqli_real_escape_string($base_datos->conexion, trim($id)));
        $direccion = mysqli_real_escape_string($base_datos->conexion, trim($direccion));
        $codigo_postal = strtoupper(mysqli_real_escape_string($base_datos->conexion, trim($codigo_postal)));
        $poblacion = mysqli_real_escape_string($base_datos->conexion, trim($poblacion));
        $provincia_o_estado = mysqli_real_escape_string($base_datos->conexion, trim($provincia_o_estado));
        $pais = mysqli_real_escape_string($base_datos->conexion, trim($pais));
        $telefono = strtoupper(mysqli_real_escape_string($base_datos->conexion, trim($telefono)));
        $email = strtolower(mysqli_real_escape_string($base_datos->conexion, trim($email)));
        $fax = strtolower(mysqli_real_escape_string($base_datos->conexion, trim($fax)));

        //if(!eregi("^[a-zA-Z0-9]+[a-zA-Z0-9_.-]+[a-zA-Z0-9]+@[a-zA-Z0-9]+[a-zA-Z0-9-]+[a-zA-Z0-9.-]+[a-zA-Z0-9]+.[a-z]{2,4}$", $email)) { mostrar_error("El E-Mail es inv&aacute;lido"); return FALSE; }
        if(!validar_email($email)) { mostrar_error("El E-Mail es inv&aacute;lido"); return FALSE; }

        $consulta = "UPDATE empresa_datos SET direccion = '".trim($direccion)."', codigo_postal = '".trim($codigo_postal)."', poblacion = '".trim($poblacion)."', provincia_o_estado = '".trim($provincia_o_estado)."', pais = '".trim($pais)."', telefono = '".trim($telefono)."', fax = '".trim($fax)."', email = '" . trim($email) . "' WHERE id_empresa_datos = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    
    //Funcion que modifica el grupo al que pertenece (o lo elimina si el ID del grupo es 0):
    function modificar_grupo($id, $id_grupo)
    {
        global $base_datos;

        $consulta = "DELETE FROM empresa_grupo WHERE id_empresa = $id";
        $operacion = $base_datos->haz_consulta($consulta);

        if ($operacion)
        {
            if ($id_grupo != 0) //if ($id != 0)
            {
                $consulta = "INSERT INTO empresa_grupo (id_empresa, id_grupo) VALUES ($id, $id_grupo)";
                $operacion = $base_datos->haz_consulta($consulta);
            } else { $operacion = TRUE; }
            
        }
        else
        {
            mostrar_error("No se pudo modificar el grupo.");
        }
        
        return $operacion;
    }


    //Funcion que modifica los datos por defecto (o los elimina si el ID del dato es 0):
    function modificar_dato_por_defecto($id, $id_dato)
    {
        global $base_datos;

        $consulta = "DELETE FROM empresa_datos_por_defecto WHERE id_empresa = $id";
        $operacion = $base_datos->haz_consulta($consulta);

        if ($operacion)
        {
            if ($id_dato != 0) //if ($id != 0)
            {
                $consulta = "INSERT INTO empresa_datos_por_defecto (id_empresa, id_empresa_datos) VALUES ($id, $id_dato)";
                $operacion = $base_datos->haz_consulta($consulta);
            } else { $operacion = TRUE; }
            
        }
        else
        {
            mostrar_error("No se pudo modificar el grupo.");
        }
        
        return $operacion;
    }
  
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de datos de empresas</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <?php
            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            include_once "../cod/func/constantes.php";

            $id_idioma = $constantes["IDIOMA_POR_DEFECTO"];
            $javascript_soportado = TRUE;
            $javascript_version = "1.2";
            $ajax_soportado = FALSE;
            $id_sesion = "sesion_falsa=si";
            include_once "../cod/func/etiquetas.php";
            include_once "../cod/js/funciones.php";
        ?>
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
            
            function comprobar_formulario(contador)
            {
                var errores = "";
                if (document.getElementById('direccion_' + contador).value == '') { errores += "* Falta el campo DIRECCION\n"; }
                if (document.getElementById('codigo_postal_' + contador).value == '') { errores += "* Falta el campo CODIGO POSTAL\n"; }
                if (document.getElementById('poblacion_' + contador).value == '') { errores += "* Falta el campo POBLACION\n"; }
                if (document.getElementById('provincia_o_estado_' + contador).value == '') { errores += "* Falta el campo PROVINCIA O ESTADO\n"; }
                if (document.getElementById('pais_' + contador).value == '') { errores += "* Falta el campo PAIS\n"; }
                if (document.getElementById('telefono_' + contador).value == '') { errores += "* Falta el campo TELEFONO\n"; }
                if (document.getElementById('email_' + contador).value == '') { errores += "* Falta el campo E-MAIL\n"; }
                else if (!validarEmail(document.getElementById('email_' + contador).value)) { errores += "* El E-MAIL introducido no parece ser valido."; }
                //else if (document.getElementById('email_' + contador).value.indexOf("@") == -1) { errores += "* El E-MAIL introducido no parece ser valido."; }
                
                if (errores != "") { alert("No se puede enviar el formulario porque:\n" + errores); return false; }
                else { return true; }
            }
            
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('direccion_nuevo').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de datos de empresas</h2>
        </center>
        <center><a href="empresas.php">Volver al gestor de empresas</a></center>
        <br>
        <?php
            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
