<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "fabricantes_marcas.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'utf-8'); }
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM fabricantes ORDER BY nombre_fabricante";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <table align="center" width="620">
            <tr>
                <td class="impar" width="400" valign="middle">Modificar fabricante</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador = 0;
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id = $row["id_fabricante"];
            $nombre = $row["nombre_fabricante"];
            ?>
            <br>
            <table align="center" width="620">
                <tr>
                    <td class="<?php echo $par_impar; ?>" width="400" valign="middle" align="center">
                        <a href="productos.php?mostrar_fabricante=<?php echo $id; ?>">Ver productos del fabricante</a>
                        <br>
                        <br>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('registro_<?php echo $contador; ?>').value == '') { alert('El texto del registro <?php echo htmlentities($id); ?> no puede estar vacio!'); return false; }">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="accion" value="modificar">
                            <input type="text" name="nombre" id="registro_<?php echo $contador; ?>" value="<?php echo htmlentities($nombre); ?>"> <input type="submit" name="boton" value="Modificar">
                        </form>
                        <br>
                        <br>
                        Marcas:
                        <br>
                        <br>
                        <?php
                            $consulta = "SELECT * FROM fabricante_marca WHERE id_fabricante = $id ORDER BY nombre_marca";
                            $resultados2 = $base_datos->haz_consulta($consulta);
                            while ($row2 = mysqli_fetch_assoc($resultados2))
                            {
                                $marca = $row2["nombre_marca"];
                                $id_marca = $row2["id_marca"];
                                ?>
                                <center>
                                <table border="1" align="center">
                                <tr>
                                <td align="center">
                                <a href="productos.php?mostrar_fabricante=<?php echo $id; ?>&mostrar_marca=<?php echo $id_marca; ?>">Ver productos de la marca</a>
                                <br>
                                <br>
                                <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('registro_marca_nueva_<?php echo $contador; ?>').value == '') { alert('El texto del registro <?php echo htmlentities($id); ?> no puede estar vacio!'); return false; }">
                                    <input type="hidden" name="id" value="<?php echo htmlentities($id_marca); ?>">
                                    <input type="hidden" name="accion" value="modificar">
                                    <input type="hidden" name="marca" value="si">
                                    <input type="text" name="nombre" id="registro_marca_nueva_<?php echo $contador; ?>" value="<?php echo htmlentities($marca); ?>"> <input type="submit" name="boton" value="Modificar">
                                </form>
                                <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($marca))); ?>');">
                                    <input type="hidden" name="id" value="<?php echo htmlentities($id_marca); ?>">
                                    <input type="hidden" name="nombre" value="<?php echo htmlentities($marca); ?>">
                                    <input type="hidden" name="accion" value="eliminar">
                                    <input type="hidden" name="marca" value="si">
                                    <input type="submit" name="boton" value="Eliminar">
                                </form>
                                </td>
                                </tr>
                                </table>
                                </center>
                                <?php
                                echo "<br>";
                            }
                        ?>
                        <br>
                        <br>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('registro_marca_<?php echo $contador; ?>').value == '') { alert('El texto del registro <?php echo htmlentities($id); ?> no puede estar vacio!'); return false; }">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="accion" value="agregar">
                            <input type="hidden" name="marca" value="si">
                            <input type="text" name="nombre" id="registro_marca_<?php echo $contador; ?>"> <input type="submit" name="boton" value="Nueva marca">
                        </form>
                    </td>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($nombre))); ?>');">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="nombre" value="<?php echo htmlentities($nombre); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador++;
        }

        ?>

            <br>
            <table align="center" width="620">
                <tr>
                    <td valign="middle">
                         <?php
                            if (mysqli_num_rows($resultados) <= 0) { mostrar_advertencia("No hay fabricantes en la tabla de fabricantes<br>"); }
                         ?>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (document.getElementById('registro_nuevo').value == '') { alert('Debes introducir un texto!'); return false; }">
                            <input type="hidden" name="accion" value="agregar">
                            Nuevo: <input type="text" name="nombre" id="registro_nuevo" value=""> <input type="submit" name="boton" value="Agregar">
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $nombre = recoger_post("nombre");
        $accion = strtolower(recoger_post("accion"));
        $marca = recoger_post("marca");
        switch ($accion)
        {
            case 'agregar':
                if ($nombre != "")
                {
                    if (strtolower($marca) == "si")
                    {
                        $id = recoger_post("id");
                        $operacion = agregar_marca($id, $nombre);
                        if (!$operacion) { mostrar_error("No se ha podido agregar <b>" . htmlentities($nombre) . "</b>."); }
                        else { echo "<b>" . htmlentities($nombre) . "</b> agregado<br>"; }
                    }
                    else
                    {
                        $operacion = agregar($nombre);
                        if (!$operacion) { mostrar_error("No se ha podido agregar <b>" . htmlentities($nombre) . "</b>."); }
                        else { echo "<b>" . htmlentities($nombre) . "</b> agregado<br>"; }
                    }
                } else { mostrar_advertencia("No se ha podido agregar <b>" . htmlentities($nombre) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                $id = recoger_post("id");
                if ($id != "" && is_numeric($id))
                {
                    if (strtolower($marca) == "si")
                    {
                        $operacion = eliminar_marca($id);
                        if (!$operacion) { mostrar_error("No se ha podido eliminar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "')."); }
                        else { echo "<b>" . htmlentities($nombre) . "</b> (con id '$id') eliminado<br>"; }
                    }
                    else
                    {
                        $operacion = eliminar($id);
                        if (!$operacion) { mostrar_error("No se ha podido eliminar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "')."); }
                        else { echo "<b>" . htmlentities($nombre) . "</b> (con id '$id') eliminado<br>"; }
                    }
                } else { mostrar_advertencia("No se ha podido eliminar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "'), puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id = recoger_post("id");
                if ($nombre != "" && $id != "" && is_numeric($id))
                {
                    if (strtolower($marca) == "si")
                    {
                        $operacion = modificar_marca($id, $nombre);
                        if (!$operacion) { mostrar_error("No se ha podido modificar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "')."); }
                        else { echo "Registro con id '" . htmlentities($id) . "' modificado a <b>" . htmlentities($nombre) . "</b><br>"; }
                    }
                    else
                    {
                        $operacion = modificar($id, $nombre);
                        if (!$operacion) { mostrar_error("No se ha podido modificar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "')."); }
                        else { echo "Registro con id '" . htmlentities($id) . "' modificado a <b>" . htmlentities($nombre) . "</b><br>"; }
                    }
                } else { mostrar_advertencia("No se ha podido modificar <b>" . htmlentities($nombre) . "</b> (con id '" . htmlentities($id) . "'), puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un registro o no:
    function existe($nombre)
    {
        global $base_datos;
        
        $nombre = mysqli_real_escape_string($base_datos->conexion, $nombre);
        
        $consulta = "SELECT * FROM fabricantes WHERE UPPER(nombre_fabricante) LIKE '" . strtoupper($nombre) . "'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que calcula si ya existe un registro o no:
    function existe_marca($nombre)
    {
        global $base_datos;
        
        $nombre = mysqli_real_escape_string($base_datos->conexion, $nombre);
        
        $consulta = "SELECT * FROM fabricante_marca WHERE UPPER(nombre_marca) LIKE '" . strtoupper($nombre) . "'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que agrega un registro nuevo:
    function agregar($nombre)
    {
        if (existe($nombre)) { mostrar_error("El registro <b>" . htmlentities($nombre) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $nombre = mysqli_real_escape_string($base_datos->conexion, trim($nombre));
        
        $consulta = "INSERT INTO fabricantes (nombre_fabricante) VALUES ('$nombre')";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }

    //Funcion que agrega un registro nuevo:
    function agregar_marca($id_fabricante, $nombre)
    {
        if (existe_marca($nombre)) { mostrar_error("El registro <b>" . htmlentities($nombre) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $nombre = mysqli_real_escape_string($base_datos->conexion, trim($nombre));
        
        $consulta = "INSERT INTO fabricante_marca (id_fabricante, nombre_marca) VALUES ($id_fabricante, '$nombre')";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    //Funcion que elimina un registro existente:
    function eliminar($id)
    {
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        
        $consulta = "DELETE FROM fabricantes WHERE id_fabricante = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }

    //Funcion que elimina un registro existente:
    function eliminar_marca($id)
    {
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        
        $consulta = "DELETE FROM fabricante_marca WHERE id_marca = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
    
    //Funcion que modifica un registro existente:
    function modificar($id, $nombre)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        $nombre = mysqli_real_escape_string($base_datos->conexion, $nombre);

        $consulta = "UPDATE fabricantes SET nombre_fabricante = '".trim($nombre)."' WHERE id_fabricante = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }


    //Funcion que modifica un registro existente:
    function modificar_marca($id, $nombre)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        if (existe_marca($nombre)) { mostrar_error("El registro <b>" . htmlentities($nombre) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        $nombre = mysqli_real_escape_string($base_datos->conexion, $nombre);

        $consulta = "UPDATE fabricante_marca SET nombre_marca = '".trim($nombre)."' WHERE id_marca = $id";
        $operacion = $base_datos->haz_consulta($consulta);
        
        return $operacion;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de fabricantes y marcas</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('registro_nuevo').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de fabricantes y marcas</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
