<?php
    set_time_limit(0);

    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para recoger archivos por POST:
    require_once "../cod/func/web/recoger_file.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'utf-8'); }
    
    //Guarda que pagina es esta:
    $this_file = "galeria.php";

    //Define que se soporta JavaScript (para ampliar_imagen()):
    $javascript_soportado = TRUE;
    //Define una ID de sesion ficticia (para ampliar_imagen()):
    $id_sesion = "";



    //Si la funcion image_type_to_extension no existe, crea una similar (gracias a la aportacion de robe@amd.co.at en http://es2.php.net/image_type_to_extension):
    if(!function_exists('image_type_to_extension'))
    {
       function image_type_to_extension($imagetype)
       {
           if(empty($imagetype)) return false;
           switch($imagetype)
           {
               case IMAGETYPE_GIF    : return 'gif';
               case IMAGETYPE_JPEG    : return 'jpg';
               case IMAGETYPE_PNG    : return 'png';
               case IMAGETYPE_SWF    : return 'swf';
               case IMAGETYPE_PSD    : return 'psd';
               case IMAGETYPE_BMP    : return 'bmp';
               case IMAGETYPE_TIFF_II : return 'tiff';
               case IMAGETYPE_TIFF_MM : return 'tiff';
               case IMAGETYPE_JPC    : return 'jpc';
               case IMAGETYPE_JP2    : return 'jp2';
               case IMAGETYPE_JPX    : return 'jpf';
               case IMAGETYPE_JB2    : return 'jb2';
               case IMAGETYPE_SWC    : return 'swc';
               case IMAGETYPE_IFF    : return 'aiff';
               case IMAGETYPE_WBMP    : return 'wbmp';
               case IMAGETYPE_XBM    : return 'xbm';
               default                : return false;
           }
       }
    }


    //Funcion que abre una imagen (gracias a PHPit - Totally PHP):
    function open_image ($file)
    {
        # JPEG:
        $im = @imagecreatefromjpeg($file);
        if ($im !== false) { return $im; }

        # GIF:
        $im = @imagecreatefromgif($file);
        if ($im !== false) { return $im; }

        # PNG:
        $im = @imagecreatefrompng($file);
        if ($im !== false) { return $im; }

        # GD File:
        $im = @imagecreatefromgd($file);
        if ($im !== false) { return $im; }

        # GD2 File:
        $im = @imagecreatefromgd2($file);
        if ($im !== false) { return $im; }

        # WBMP:
        $im = @imagecreatefromwbmp($file);
        if ($im !== false) { return $im; }

        # XBM:
        $im = @imagecreatefromxbm($file);
        if ($im !== false) { return $im; }

        # XPM:
        $im = @imagecreatefromxpm($file);
        if ($im !== false) { return $im; }

        # Try and load from string:
        $im = @imagecreatefromstring(file_get_contents($file));
        if ($im !== false) { return $im; }

        return false;
    }


    function eliminar_imagen_obra($id_obra, $directorio = "../img/galeria/")
    {
            $operacion = TRUE;
            
            $extensiones = Array(".gif", ".jpg", ".jpeg", ".png");
            
            $nombre = nombre_archivo_correcto($id_obra);
            $puntero = opendir($directorio);
            if (!$directorio) { mostrar_error("No se pudo abrir el directorio $directorio para poder borrar las im&aacute;genes."); exit(); }
            while ($archivo = readdir($puntero))
            {
                foreach ($extensiones as $extension)
                {
                    $extension = strtolower($extension);
                    if ($archivo == $nombre . $extension)
                    {
                        $operacion = unlink($directorio . $nombre . $extension);
                        if (!$operacion) { mostrar_error("No se pudo eliminar $directorio . $nombre . $extension. Se deber&aacute; hacer manualmente."); }
                    }
                }
            }
            
            return $operacion;
    }


    //Funcion que sube la imagen o imagenes de una obra (y resizea si hace falta):
    function subir_imagenes($id_obra, $id_obra_nuevo)
    {
        global $constantes, $HTTP_POST_FILES;

        $id_obra = trim($id_obra);
        
        $operacion = TRUE;

        if ($id_obra != -1) { $archivo = recoger_file("imagen_" . $id_obra); }
        //else { $archivo = recoger_file("imagen_nuevo_obra"); }
        if ($id_obra != -1) { $archivo_mini = recoger_file("imagen_miniatura_" . $id_obra); }
        //else { $archivo_mini = recoger_file("imagen_miniatura_nuevo_obra"); }

        $reducir_id = $id_obra;
        if ($id_obra == "nuevo") { $id_obra = $id_obra_nuevo; }


            if (is_uploaded_file($archivo_mini['tmp_name']))
            {
                $archivo_bytes = $archivo_mini['size'];
                $maximo_bytes = $constantes["IMAGENES_GALERIA_MINI_BYTES_MAXIMO"];
                $directorio = "../img/galeria/";
                //$archivo_nombre_extension = explode($archivo_mini['name']);
                list($ancho, $alto, $tipo, $html) = getimagesize($archivo_mini['tmp_name']);
                $extension = str_replace(".", "", image_type_to_extension($tipo));
                if (strtolower($extension) != "gif" && strtolower($extension) != "jpg" && strtolower($extension) != "jpeg" && strtolower($extension) != "png") { mostrar_error("La imagen debe tener una de las siguientes extensiones: gif, jpg, jpeg o png (extensi&oacute;n: $extension). Si la imagen ya la tiene, es posible que no corresponda en realidad a su formato."); exit(); }
                if ($ancho > $constantes["IMAGENES_GALERIA_MINI_ANCHO"] || $alto > $constantes["IMAGENES_GALERIA_MINI_ALTO"]) { mostrar_error("La imagen debe tener como maximo " . $constantes["IMAGENES_GALERIA_MINI_ANCHO"] . "x" . $constantes["IMAGENES_GALERIA_MINI_ALTO"] . " pixels"); exit(); }
                //$extension = trim($archivo_nombre_extension[1]);
                //if ($extension == "") { $extension = "gif"; }
                $nombre = $id_obra_nuevo . "." . $extension;
                $nombre = nombre_archivo_correcto($nombre);

                if ($archivo_bytes > $maximo_bytes) { mostrar_error("La imagen en miniatura debe tener $maximo_bytes o menos."); $operacion = FALSE; }
                else
                {
                    $operacion = eliminar_imagen_obra($id_obra, $directorio);
                    if ($operacion) { $operacion = copy($archivo_mini['tmp_name'], $directorio.$nombre); }
                }

                if (!$operacion) { mostrar_error("Error al subir la im&aacute;gen en miniatura de la obra."); }
            }

        if (is_uploaded_file($archivo['tmp_name']))
        { 
            $archivo_bytes = $archivo['size'];
            $maximo_bytes = $constantes["IMAGENES_GALERIA_ZOOM_BYTES_MAXIMO"];
            $directorio = "../img/galeria/zoom/";
            //$archivo_nombre_extension = explode(".", $archivo['name']);
            list($ancho, $alto, $tipo, $html) = getimagesize($archivo['tmp_name']);
            $extension = str_replace(".", "", image_type_to_extension($tipo));
            if (strtolower($extension) != "gif" && strtolower($extension) != "jpg" && strtolower($extension) != "jpeg" && strtolower($extension) != "png") { mostrar_error("La imagen debe tener una de las siguientes extensiones: gif, jpg, jpeg o png (extensi&oacute;n: $extension). Si la imagen ya la tiene, es posible que no corresponda en realidad a su formato."); exit(); }
            if ($ancho > $constantes["IMAGENES_GALERIA_ZOOM_ANCHO"] || $alto > $constantes["IMAGENES_GALERIA_ZOOM_ALTO"]) { mostrar_error("La imagen debe tener como maximo " . $constantes["IMAGENES_GALERIA_ZOOM_ANCHO"] . "x" . $constantes["IMAGENES_GALERIA_ZOOM_ALTO"] . " pixels"); exit(); }
            //$extension = trim($archivo_nombre_extension[1]);
            //if ($extension == "") { $extension = "gif"; }
            $nombre = $id_obra_nuevo . "." . $extension;
            $nombre = nombre_archivo_correcto($nombre);

            if ($archivo_bytes > $maximo_bytes) { mostrar_error("La imagen original debe tener $maximo_bytes o menos."); $operacion = FALSE; }
            else
            { 
                $operacion = eliminar_imagen_obra($id_obra, $directorio);
                if ($operacion) { $operacion = copy($archivo['tmp_name'], $directorio.$nombre); }
            }
            
            if (!$operacion) { mostrar_error("Error al subir la im&aacute;gen original de la obra."); exit(); }
            else if (file_exists($directorio.$nombre) && !is_uploaded_file($archivo_mini['tmp_name']) && recoger_post("reducir_imagen_" . $reducir_id))
            {
                //Copia la imagen original, que ya esta en su directorio, la resizea y la guarda en el otro directorio:
                $operacion = eliminar_imagen_obra($id_obra, "../img/galeria/");
                
                //Se resizea la imagen (gracias a PHPit - Totally PHP):
                $image = open_image($directorio . $nombre);
                if ($image === false) { mostrar_error("La imagen " . $directorio . $archivo . " existe pero no puede abrirse."); exit(0);}

                // New width and height

                //Modificacion: respeta el ratio de aspecto:
                //$ancho_nuevo = $constantes["IMAGENES_GALERIA_MINI_ANCHO"];
                //$alto_nuevo = $constantes["IMAGENES_GALERIA_MINI_ALTO"];
                $ancho_nuevo = $ancho;
                $alto_nuevo = $alto;
                if ($ancho_nuevo > $constantes["IMAGENES_GALERIA_MINI_ANCHO"] || $alto_nuevo > $constantes["IMAGENES_GALERIA_MINI_ALTO"])
                {
                    if ($ancho_nuevo > $alto_nuevo)
                    {
                        $ancho_nuevo = $constantes["IMAGENES_GALERIA_MINI_ANCHO"];
                        $ratio = $ancho / $ancho_nuevo;
                        $alto_nuevo /= $ratio;
                    }
                    else if ($alto_nuevo > $ancho_nuevo)
                    {
                        $alto_nuevo = $constantes["IMAGENES_GALERIA_MINI_ALTO"];
                        $ratio = $alto / $alto_nuevo;
                        $ancho_nuevo /= $ratio;
                    }
                    else
                    {
                        $ancho_nuevo = $constantes["IMAGENES_GALERIA_MINI_ANCHO"];
                        $alto_nuevo = $constantes["IMAGENES_GALERIA_MINI_ALTO"];
                    }
                }
                $ancho_nuevo = (int) $ancho_nuevo;
                $alto_nuevo = (int) $alto_nuevo;


                // Resample
                $image_resized = imagecreatetruecolor($ancho_nuevo, $alto_nuevo);
                imagecopyresampled($image_resized, $image, 0, 0, 0, 0, $ancho_nuevo, $alto_nuevo, $ancho, $alto);

                $extension = str_replace(".", "", image_type_to_extension($tipo));
                if ($extension == "jpg" || $extension == "jpeg") { imagejpeg($image_resized, "../img/galeria/" . $nombre); }
                else if ($extension == "gif") { imagegif($image_resized, "../img/galeria/" . $nombre); }
                else if ($extension == "png") { imagepng($image_resized, "../img/galeria/" . $nombre); }
                else { mostrar_error("Error al resizear la imagen partiendo de la original. No se encuentra el tipo $tipo ($extension)."); }
            }
        }
      
        return $operacion;
    }



    //Funcion que devuelve los idiomas:
    function obtener_idiomas()
    {
        global $base_datos;
        
        $idiomas = Array();
        
        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);

        if (mysqli_num_rows($resultados) <= 0) { mostrar_error("No se han podido obtener idiomas de la tabla de idiomas."); exit(); }

        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_idioma = htmlentities(trim($row["id_idioma"]));
            $idioma = htmlentities(trim($row["idioma"]));
            $idiomas[$id_idioma] = $idioma;
        }
        
        return $idiomas;
    }


    //Funcion que devuelve los idiomas:
    function obtener_particulares($id_obra = -1)
    {
        global $base_datos;
        
        $particulares = Array();
        
        if ($id_obra == -1) { $consulta = "SELECT * FROM particulares ORDER BY nombre"; }
        else { $consulta = "SELECT * FROM particulares AS a JOIN galeria_personas AS b WHERE a.id_particular = b.id_particular AND id_obra = $id_obra ORDER BY nombre"; }
        $resultados = $base_datos->haz_consulta($consulta);

        if ($id_obra == -1 && mysqli_num_rows($resultados) <= 0) { mostrar_error("No se han podido obtener particulares de la tabla de particulares."); exit(); }

        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_particular = htmlentities(trim($row["id_particular"]));
            $nombre = htmlentities(trim($row["nombre"]));
            $particulares[$id_particular] = $nombre;
        }
        
        return $particulares;
    }


    //Funcion que recibe el nombre de un archivo y devuelve el correcto:
    function nombre_archivo_correcto($nombre)
    {
        //FALTARIA: substituir todos aquellos caracteres prohibidos para un archivo (caracteres raros, etc).
        return strtolower(str_replace(":", "", str_replace(" ", "_", str_replace("-", "_", trim($nombre)))));
    }



    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos, $constantes;

        if (!isset($constantes["IMAGENES_GALERIA_MINI_ANCHO"]) || isset($constantes["IMAGENES_GALERIA_MINI_ANCHO"]) && (trim($constantes["IMAGENES_GALERIA_MINI_ANCHO"]) == "" || !is_numeric(trim($constantes["IMAGENES_GALERIA_MINI_ANCHO"])))) { mostrar_error('No se pudo recoger un ancho por defecto. Por favor, define la constante del ancho por defecto de las imagenes en miniatura en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_GALERIA_MINI_ALTO"]) || isset($constantes["IMAGENES_GALERIA_MINI_ALTO"]) && (trim($constantes["IMAGENES_GALERIA_MINI_ALTO"]) == "" || !is_numeric(trim($constantes["IMAGENES_GALERIA_MINI_ALTO"])))) { mostrar_error('No se pudo recoger un alto por defecto. Por favor, define la constante del alto por defecto de las imagenes en miniatura en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_GALERIA_ZOOM_ANCHO"]) || isset($constantes["IMAGENES_GALERIA_ZOOM_ANCHO"]) && (trim($constantes["IMAGENES_GALERIA_ZOOM_ANCHO"]) == "" || !is_numeric(trim($constantes["IMAGENES_GALERIA_ZOOM_ANCHO"])))) { mostrar_error('No se pudo recoger un ancho por defecto. Por favor, define la constante del ancho por defecto de las imagenes con zoom en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else if (!isset($constantes["IMAGENES_GALERIA_ZOOM_ALTO"]) || isset($constantes["IMAGENES_GALERIA_ZOOM_ALTO"]) && (trim($constantes["IMAGENES_GALERIA_ZOOM_ALTO"]) == "" || !is_numeric(trim($constantes["IMAGENES_GALERIA_ZOOM_ALTO"])))) { mostrar_error('No se pudo recoger un alto por defecto. Por favor, define la constante del alto por defecto de las imagenes con zoom en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        else { $imagen_ancho = $constantes["IMAGENES_GALERIA_MINI_ANCHO"]; $imagen_alto = $constantes["IMAGENES_GALERIA_MINI_ALTO"]; $imagen_ancho_zoom = $constantes["IMAGENES_GALERIA_ZOOM_ANCHO"]; $imagen_alto_zoom = $constantes["IMAGENES_GALERIA_ZOOM_ALTO"]; }
        
        $consulta = "SELECT * FROM galeria ORDER BY orden";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <table align="center" width="900">
            <tr>
                <td class="impar" width="780" valign="middle">Modificar</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador = 0;
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id = $row["id_obra"];
            $nombre = $row["nombre_obra"];
            $orden = $row["orden"];
            $mostrar = ($row["mostrar"]) ? " checked" : "";
            ?>
            <br>
            <table align="center" width="900">
                <tr>
                    <form method="post" action="<?php echo $this_file; ?>" enctype="multipart/form-data" onSubmit="return comprobar_formulario(<?php echo $contador; ?>);">
                    <td class="<?php echo $par_impar; ?>" width="780" valign="middle">
                        <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                        <input type="hidden" name="accion" value="modificar">
                        <center>
                        <table border="1" align="center">
                            <tr>
                                <td colspan="2">
                                    ID: <?php echo htmlentities($id); ?><br>
                                    Nombre: <?php echo htmlentities($nombre); ?>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <?php
                                        echo 'Imagen original:</td><td>';
                                        $directorio = "../img/galeria/zoom/";
                                        if (file_exists($directorio . nombre_archivo_correcto($id) . ".gif")) { $imagen = nombre_archivo_correcto($id) . ".gif"; }
                                        else if (file_exists($directorio . nombre_archivo_correcto($id) . ".jpg")) { $imagen = nombre_archivo_correcto($id) . ".jpg"; }
                                        else if (file_exists($directorio . nombre_archivo_correcto($id) . ".jpeg")) { $imagen = nombre_archivo_correcto($id) . ".jpeg"; }
                                        else if (file_exists($directorio . nombre_archivo_correcto($id) . ".png")) { $imagen = nombre_archivo_correcto($id) . "png"; }
                                        else { $imagen = "error.gif"; $directorio = "../img/"; }
                                        if (file_exists($directorio . $imagen))
                                        {
                                            echo '<center><table align="center" border="1"><tr><td>';
                                            echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho_zoom, $imagen_alto_zoom, $imagen_ancho, $imagen_alto);
                                            echo '</td></tr></table><center>';
                                        }
                                        
                                        echo '<input type="file" name="imagen_' . htmlentities($id) . '"><br><i>Tama&ntilde;o m&aacute;ximo: ' . $imagen_ancho_zoom . 'x' . $imagen_alto_zoom . '<br>Tama&ntilde;o recomendado: el m&aacute;ximo o uno menor pero proporcional</i></td></tr>';

                                        echo '<tr><td>Imagen miniatura:</td><td>';
                                        $directorio = "../img/galeria/";
                                        if (file_exists($directorio . nombre_archivo_correcto($id) . ".gif")) { $imagen = nombre_archivo_correcto($id) . ".gif"; }
                                        else if (file_exists($directorio . nombre_archivo_correcto($id) . ".jpg")) { $imagen = nombre_archivo_correcto($id) . ".jpg"; }
                                        else if (file_exists($directorio . nombre_archivo_correcto($id) . ".jpeg")) { $imagen = nombre_archivo_correcto($id) . ".jpeg"; }
                                        else if (file_exists($directorio . nombre_archivo_correcto($id) . ".png")) { $imagen = nombre_archivo_correcto($id) . "png"; }
                                        else { $imagen = "error.gif"; $directorio = "../img/"; }
                                        if (file_exists($directorio . $imagen))
                                        {
                                            echo '<center><table align="center" border="1"><tr><td>';
                                            echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho, $imagen_alto, $imagen_ancho, $imagen_alto);
                                            echo '</td></tr></table><center>';
                                        }
                                        echo '<label for="reducir_imagen_' . htmlentities($id) . '"><input type="checkbox" onClick="document.getElementById(\'imagen_miniatura_' . htmlentities($id) . '\').disabled = document.getElementById(\'reducir_imagen_' . htmlentities($id) . '\').checked;" class="casilla" id="reducir_imagen_' . htmlentities($id) . '" name="reducir_imagen_' . htmlentities($id) . '" checked>Reducir imagen original automaticamente<br>(no soporta gif animados ni transparentes)</label><br><br><input type="file" name="imagen_miniatura_' . htmlentities($id) . '" disabled><br><i>Tama&ntilde;o m&aacute;ximo: ' . $imagen_ancho . 'x' . $imagen_alto . '<br>Tama&ntilde;o recomendado: el m&aacute;ximo o uno menor pero proporcional</i>';
                                    ?>
                                </td>
                            <tr>
                                <td>
                                    <label for="mostrar_<?php echo $contador; ?>">
                                    Mostrar:
                                </td>
                                <td>
                                    <input type="checkbox" name="mostrar" id="mostrar_<?php echo $contador; ?>"<?php echo $mostrar; ?>>
                                    </label>
                                </td>
                            </tr>
                                <td>
                                    Nombre de la obra:
                                </td>
                                <td>
                                    <input type="text" name="nombre" id="nombre_<?php echo $contador; ?>" value="<?php echo htmlentities($nombre); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Orden:
                                </td>
                                <td>
                                    <input type="text" name="orden" id="orden_<?php echo $contador; ?>" value="<?php echo htmlentities($orden); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Autor(es):
                                </td>
                                <td>
                                    <select name="autores[]" id="autores_<?php echo $contador ?>" multiple>
                                    <?php
                                        $particulares = obtener_particulares();
                                        $particulares_miembro = obtener_particulares($id);
                                        
                                        foreach ($particulares as $id_particular => $particular)
                                        {
                                            $checked = (array_key_exists($id_particular, $particulares_miembro)) ? " selected" : "";
                                            echo '<option value="' . $id_particular . '"' . $checked . '>' . trim($particular) . '</option>';
                                        }
                                    ?>
                                    </select>
                                </td>
                            </tr>
                            <?php
                                $idiomas = obtener_idiomas();
                                foreach ($idiomas as $id_idioma => $idioma)
                                {
                                    $consulta2 = "SELECT texto, eval FROM galeria_obra_texto WHERE id_obra = $id AND id_idioma = $id_idioma";
                                    $resultados2 = $base_datos->haz_consulta($consulta2);
                                    if (mysqli_num_rows($resultados2) > 0) { $row2 = mysqli_fetch_assoc($resultados2); $texto = htmlentities(trim($row2["texto"])); $checked = ($row2["eval"]) ? " checked" : ""; }
                                    else { $texto = ""; $checked = ""; }
                            ?>
                            <tr>
                                <td>
                                    Texto en <?php echo $idioma; ?>:
                                </td>
                                <td align="center">
                                    <label for="eval_<?php echo $id_idioma; ?>_<?php echo $contador; ?>"><input type="checkbox" name="eval_<?php echo $id_idioma; ?>" id="eval_<?php echo $id_idioma; ?>_<?php echo $contador; ?>" class="casilla"<?php echo $checked; ?>> Eval</label>
                                    <br>
                                    <textarea name="texto_<?php echo $id_idioma; ?>" id="texto_<?php echo $id_idioma; ?>_<?php echo $contador; ?>" rows="12" cols="80"><?php echo $texto; ?></textarea>
                                </td>
                            </tr>
                            <?php
                                }
                            ?>
                            <tr>
                                <td colspan="2">
                                    <input type="submit" name="boton" value="Modificar">
                                </td>
                            </tr>
                        </table>
                        </form>
                        </center>
                    </td>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="bottom">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($nombre))); ?>');">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador++;
        }
        
        if (mysqli_num_rows($resultados) <= 0) { mostrar_advertencia("No hay obras en la tabla de galer&iacute;a<br>"); }
        //$id = "nuevo";
        ?>
    
            <br>
            <table align="center" width="900">
                <tr>
                    <td valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" enctype="multipart/form-data" onSubmit="return comprobar_formulario('nuevo');">
                            <input type="hidden" name="accion" value="agregar">
                            <table border="1">
                                <tr>
                                    <td colspan="2">
                                        Nuevo:
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <?php
                                            echo '<tr><td>Imagen original:</td><td>';
                                            //$directorio = "../img/galeria/zoom/";
                                            //if (file_exists($directorio . nombre_archivo_correcto($id) . ".gif")) { $imagen = nombre_archivo_correcto($id) . ".gif"; }
                                            //else if (file_exists($directorio . nombre_archivo_correcto($id) . ".jpg")) { $imagen = nombre_archivo_correcto($id) . ".jpg"; }
                                            //else if (file_exists($directorio . nombre_archivo_correcto($id) . ".jpeg")) { $imagen = nombre_archivo_correcto($id) . ".jpeg"; }
                                            //else if (file_exists($directorio . nombre_archivo_correcto($id) . ".png")) { $imagen = nombre_archivo_correcto($id) . "png"; }
                                            //else { $imagen = "error.gif"; $directorio = "../img/"; }
                                            /*if (file_exists($directorio . $imagen))
                                            {
                                                echo '<center><table align="center" border="1"><tr><td>';
                                                echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho_zoom, $imagen_alto_zoom, $imagen_ancho, $imagen_alto);
                                                echo '</td></tr></table><center>';
                                            }*/
                                        
                                            echo '<input type="file" name="imagen_nuevo"><br><i>Tama&ntilde;o m&aacute;ximo: ' . $imagen_ancho_zoom . 'x' . $imagen_alto_zoom . '<br>Tama&ntilde;o recomendado: el m&aacute;ximo o uno menor pero proporcional</i></td></tr>';

                                            echo '<tr><td>Imagen miniatura:</td><td>';
                                            //$directorio = "../img/galeria/";
                                            //if (file_exists($directorio . nombre_archivo_correcto($id) . ".gif")) { $imagen = nombre_archivo_correcto($id) . ".gif"; }
                                            //else if (file_exists($directorio . nombre_archivo_correcto($id) . ".jpg")) { $imagen = nombre_archivo_correcto($id) . ".jpg"; }
                                            //else if (file_exists($directorio . nombre_archivo_correcto($id) . ".jpeg")) { $imagen = nombre_archivo_correcto($id) . ".jpeg"; }
                                            //else if (file_exists($directorio . nombre_archivo_correcto($id) . ".png")) { $imagen = nombre_archivo_correcto($id) . "png"; }
                                            //else { $imagen = "error.gif"; $directorio = "../img/"; }
                                            /*if (file_exists($directorio . $imagen))
                                            {
                                                echo '<center><table align="center" border="1"><tr><td>';
                                                echo imagen_ampliable($imagen, $directorio, "", TRUE, $imagen_ancho, $imagen_alto, $imagen_ancho, $imagen_alto);
                                                echo '</td></tr></table><center>';
                                            }*/
                                            echo '<label for="reducir_imagen_nuevo"><input type="checkbox" onClick="document.getElementById(\'imagen_miniatura_nuevo\').disabled = document.getElementById(\'reducir_imagen_nuevo\').checked;" class="casilla" id="reducir_imagen_nuevo" name="reducir_imagen_nuevo" checked>Reducir imagen original automaticamente<br>(no soporta gif animados ni transparentes)</label><br><br><input type="file" name="imagen_miniatura_nuevo" disabled><br><i>Tama&ntilde;o m&aacute;ximo: ' . $imagen_ancho . 'x' . $imagen_alto . '<br>Tama&ntilde;o recomendado: el m&aacute;ximo o uno menor pero proporcional</i>';
                                        ?>
                                    </td>
                                <tr>
                                <tr>
                                    <td>
                                        <label for="mostrar_nuevo">
                                        Mostrar:
                                    </td>
                                    <td>
                                        <input type="checkbox" name="mostrar" id="mostrar_nuevo" checked>
                                        </label>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Nombre de la obra:
                                    </td>
                                    <td>
                                        <input type="text" name="nombre" id="nombre_nuevo" value="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Orden:
                                    </td>
                                    <td>
                                        <input type="text" name="orden" id="orden_nuevo" value="0">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Autor(es):
                                    </td>
                                    <td>
                                        <select name="autores[]" id="autores_nuevo" multiple>
                                        <?php
                                            $particulares = obtener_particulares();
                                            
                                            foreach ($particulares as $id_particular => $particular)
                                            {
                                                echo '<option value="' . $id_particular . '">' . $particular . '</option>';
                                            }
                                        ?>
                                        </select>
                                    </td>
                                </tr>
                                <?php
                                    $idiomas = obtener_idiomas();
                                    foreach ($idiomas as $id_idioma => $idioma)
                                    {
                                ?>
                                <tr>
                                    <td>
                                        Texto en <?php echo $idioma; ?>:
                                    </td>
                                    <td align="left">
                                        <label for="eval_<?php echo $id_idioma; ?>_nuevo"><input type="checkbox" name="eval_<?php echo $id_idioma; ?>" id="eval_<?php echo $id_idioma; ?>_nuevo" class="casilla"> Eval</label>
                                        <br>
                                        <textarea name="texto_<?php echo $id_idioma; ?>" id="texto_<?php echo $id_idioma; ?>_nuevo" rows="12" cols="80"></textarea>
                                    </td>
                                </tr>
                                <?php
                                    }
                                ?>
                                <tr>
                                    <td colspan="2">
                                        <input type="submit" name="boton" value="Agregar">
                                    </td>
                                </tr>
                            </table>
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                $operacion = agregar();
                if (!$operacion) { mostrar_error("No se ha podido agregar la nueva obra."); }
                else { echo "Nueva obra agregada<br>"; }
                break;
            case 'eliminar':
                $id = recoger_post("id");
                if ($id != "" && is_numeric($id))
                {
                    $operacion = eliminar($id);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar la obra con id <b>" . htmlentities($id) . "</b>."); }
                    else { echo "Obra con id <b>" . htmlentities($id) . "</b> eliminada<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar la obra con id <b>" . htmlentities($id) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id = recoger_post("id");
                if ($id != "" && is_numeric($id))
                {
                    $operacion = modificar($id);
                    if (!$operacion) { mostrar_error("No se ha podido modificar la obra con id <b>" . htmlentities($id) . "</b>."); }
                    else { echo "Obra con id '" . htmlentities($id) . "' modificada<br>"; }
                } else { mostrar_advertencia("No se ha podido modificar la obra con id <b>" . htmlentities($id) . "</b>, puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un registro o no:
    function existe_id($id_obra)
    {
        global $base_datos;
        
        $id_obra = mysqli_real_escape_string($base_datos->conexion, $id_obra);
        
        $consulta = "SELECT * FROM galeria WHERE id_obra = $id_obra";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que calcula si ya existe un registro o no:
    function existe($nombre_obra)
    {
        global $base_datos;
        
        $nombre_obra = mysqli_real_escape_string($base_datos->conexion, $nombre_obra);
        
        $consulta = "SELECT * FROM galeria WHERE UPPER(nombre_obra) LIKE '" . strtoupper($nombre_obra) . "'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que calcula si ya existe un registro que no sea el mismo o no:
    function existe_otra($nombre_obra, $id_obra)
    {
        global $base_datos;
        
        $nombre_obra = mysqli_real_escape_string($base_datos->conexion, $nombre_obra);
        
        $consulta = "SELECT * FROM galeria WHERE UPPER(nombre_obra) LIKE '" . strtoupper($nombre_obra) . "' AND id_obra != $id_obra";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que agrega un registro nuevo:
    function agregar($id = -1)
    {
        $mostrar = (recoger_post("mostrar")) ? 1 : 0;
        $nombre_obra = recoger_post("nombre");
        $orden = recoger_post("orden");
        $autores = recoger_post("autores");

        if ($orden == "" || !is_numeric($orden) || $orden < 1) { $orden = 0; }

        if (existe($nombre_obra)) { mostrar_error("El registro <b>" . htmlentities(trim($nombre_obra)) . "</b> ya existe."); return FALSE; }

        global $base_datos;

        $nombre_obra = mysqli_real_escape_string($base_datos->conexion, trim($nombre_obra));

        if ($id == -1 || existe_id($id))
        {
            $consulta = "INSERT INTO galeria (nombre_obra, mostrar, orden) VALUES ('$nombre_obra', $mostrar, $orden)";
        }
        else
        {
            $consulta = "INSERT INTO galeria (id_obra, nombre_obra, mostrar, orden) VALUES ($id, '$nombre_obra', $mostrar, $orden)";
        }
        
        $operacion = $base_datos->haz_consulta($consulta);
        
        if (!$operacion) { mostrar_error("Fallo al agregar el agregar la nueva obra."); exit(); }

        $id_obra = mysqli_insert_id($base_datos->conexion);

        if ($operacion)
        {
            $idiomas = obtener_idiomas();
            foreach ($idiomas as $id_idioma => $idioma)
            {
                $eval = (recoger_post("eval_" . $id_idioma)) ? 1 : 0;
                $texto = recoger_post("texto_" . $id_idioma);
                $texto = mysqli_real_escape_string($base_datos->conexion, trim($texto));
                $consulta = "INSERT INTO galeria_obra_texto (id_obra, id_idioma, texto, eval) VALUES ($id_obra, $id_idioma, '$texto', $eval)";
                $operacion = $base_datos->haz_consulta($consulta);
                if (!$operacion) { mostrar_error("Fallo al agregar el texto para el idioma $idioma (con id $id_idioma)."); }
            }
        }

        if ($operacion && is_array($autores))
        {
            foreach ($autores as $id_autor)
            {
                $consulta = "INSERT INTO galeria_personas (id_obra, id_particular) VALUES ($id_obra, $id_autor)";
                $operacion = $base_datos->haz_consulta($consulta);
                if (!$operacion) { mostrar_error("Fallo al agregar el autor con id $autor."); }
            }
        }

        if ($operacion)
        {
            if ($id == -1) { $id = "nuevo"; }
            $imagenes_subidas = subir_imagenes($id, $id_obra);
            if (!$imagenes_subidas) { mostrar_error("Error al subir la im&aacute;gen o im&aacute;genes de la obra."); }
        }
        //else { echo "ke noooooooooooooooooooooooooooooooooooooooo"; }
       
        return $operacion;
    }
    
    
    //Funcion que elimina un registro existente:
    function eliminar($id, $eliminar_imagenes = TRUE)
    {
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        
        $consulta = "DELETE FROM galeria WHERE id_obra = $id";
        $operacion = $base_datos->haz_consulta($consulta);

        //Si la operacion ha ido bien y se ha enviado eliminar imagenes, se procede:
        $operacion2 = $operacion3 = TRUE;
        if ($operacion && $eliminar_imagenes)
        {
            $directorio = "../img/galeria/";
            $operacion2 = eliminar_imagen_obra($id, $directorio);
            
            $directorio = "../img/galeria/zoom/";
            $operacion3 = eliminar_imagen_obra($id, $directorio);
        }
        
        return $operacion && $operacion2 && $operacion3;
    }
    
    
    //Funcion que modifica un registro existente:
    function modificar($id)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        $nombre_obra = recoger_post("nombre");

        if (existe_otra($nombre_obra, $id)) { mostrar_error("Ya existe otra obra con el nombre <b>" . htmlentities(trim($nombre_obra)) . "</b>"); return FALSE; }
        else
        {
            $operacion = eliminar($id, FALSE);
            if ($operacion)
            {
                return ($operacion = agregar($id));
            }
            else { return false; }
        }
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de la galer&iacute;a</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
<?php
            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();
?>
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
            
            function comprobar_formulario(contador)
            {
                var errores = "";
                if (document.getElementById('nombre_' + contador).value == '') { errores += "* Falta el campo NOMBRE\n"; }
                
                if (isNaN(document.getElementById('orden_' + contador).value) || parseInt(document.getElementById('orden_' + contador).value) < 0) { errores += "* El campo ORDEN debe ser 0 o mayor.\n"; }
                
                var hay_autores = false;
                for (var x = 0; x < document.getElementById("autores_" + contador).options.length; x++) 
                { 
                    if (document.getElementById("autores_" + contador).options[x].selected) 
                    { 
                        hay_autores = true;
                    } 
                }
                if (!hay_autores) { errores += "* Se debe elegir al menos un autor\n"; }
                
                if (errores == "")
                {
                    var advertencias = "";
                    <?php
                        $idiomas = obtener_idiomas();
                        foreach ($idiomas as $id_idioma => $idioma)
                        {
                            echo 'if (document.getElementById("texto_' . $id_idioma . '_" + contador).value == "") { advertencias += "* No se ha introducito el texto para el idioma ' . strtoupper(addslashes(html_entity_decode($idioma))) . ' (con id ' . $id_idioma . ').\n"; }';
                        }
                    ?>
                    if (advertencias != "") { return confirm("Se han producido las siguientes advertencias:\n\n" + advertencias + "\nPulsa ACEPTAR si quieres enviar al formulario de todas formas."); }
                }
                else { alert("No se puede enviar el formulario porque:\n" + errores); return false; }
            }

            function ampliar_imagen(imagen, ancho, alto)
            {
                var sid_get = '?<?php echo $id_sesion; ?>';
                //Se abre la ventana:
                var margen = 60;
                var window_image = window.open(imagen + sid_get, "_blank", "scrollbars=yes,menubar=no,height=" + (alto+margen) + ",width=" + (ancho+margen) + ",resizable=yes,toolbar=no,location=no,status=no");
                //Se pone en primer plano la ventana:
                window_image.focus();
            }
        // -->
        </script>
        <?php require_once "../cod/func/web/zoom.php"; ?>
    </head>
    <body onLoad="document.getElementById('nombre_nuevo').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de la galer&iacute;a</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Incluye las constantes de la base de datos (es necesaria la del idioma por defecto):
            require_once "../cod/func/constantes.php";

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
