<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    //Guarda que pagina es esta:
    $this_file = "limpiar_imagenes_categorias_inexistentes.php";
    
    
    //Comprueba si se ha enviado el formulario:
    function se_ha_enviado_formulario()
    {
        return recoger_post("accion");
    }
    

    //Muestra el formulario:
    function mostrar_formulario($directorio)
    {
        global $this_file, $base_datos;

        $consulta = "SELECT id_categoria FROM categorias";
        $resultados = $base_datos->haz_consulta($consulta);
        $referencias = Array();
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $referencias[] = strtolower(str_replace(":", "", str_replace(" ", "_", str_replace("-", "_", trim(($row["id_categoria"]))))));
        }

        $directorio_puntero = opendir($directorio);
        echo '<center><table border="1" align="center"><tr><td colspan="3">Directorio ' . $directorio . '</td></tr>';
        $hayArchivos = FALSE;
        while ($archivo = readdir($directorio_puntero))
        {
            $archivo_sin_extension = explode(".", $archivo);
            $archivo_sin_extension = $archivo_sin_extension[0];
            if ($archivo != "." && $archivo != ".." && $archivo != "index.htm" && file_exists($directorio . $archivo) && !is_dir($directorio . $archivo) && !in_array(strtolower($archivo_sin_extension), $referencias))
            {
                $hayArchivos = TRUE;
                echo '<tr><td>';
                echo "<img src=\"$directorio$archivo\" width=\"25\" height=\"25\"><br>";
                echo $archivo;
                echo '</td><td>';
                echo '<form method="post" action="' . $this_file . '">';
                echo '<input type="hidden" name="accion" value="ver">';
                echo '<input type="hidden" name="directorio" value="' . $directorio . '">';
                echo '<input type="hidden" name="archivo" value="' . $archivo . '">';
                echo '<input type="submit" name="boton" value="Ver">';
                echo '</form>';
                echo '</td><td>';
                echo '<form method="post" action="' . $this_file . '" onSubmit="return confirmar_eliminar();">';
                echo '<input type="hidden" name="accion" value="eliminar">';
                echo '<input type="hidden" name="directorio" value="' . $directorio . '">';
                echo '<input type="hidden" name="archivo" value="' . $archivo . '">';
                echo '<input type="submit" name="boton" value="Eliminar">';
                echo '</form>';
                echo '</td></tr>';
            }
        }
        if (!$hayArchivos) { echo "<tr><td class=\"destacado\">No hay archivos de categor&iacute;as inexistentes</td></tr>"; }
        
        echo '</table></center>';
    }
    
    
    //Procesa el formulario:
    function procesar_formulario()
    {
        $accion = recoger_post("accion");
        $archivo = recoger_post("archivo");
        $directorio = recoger_post("directorio");
        
        switch ($accion)
        {
            case "ver":
                if (trim($archivo) != "" && trim($directorio) != "" ) { mostrar_archivo($archivo, $directorio); }
                else { mostrar_error("No se pudo procesar el formulario ya que faltan datos."); }
                break;
            case "eliminar":
                if (trim($archivo) != "" && trim($directorio) != "" ) { eliminar_archivo($archivo, $directorio); }
                else { mostrar_error("No se pudo procesar el formulario ya que faltan datos."); }
                break;
            default:
                mostrar_error("No se pudo procesar el formulario ya que faltan datos.");
        }
    }
    
    
    //Funcion que muestra un archivo de registro:
    function mostrar_archivo($archivo, $directorio)
    {
        echo '<br><center><table border="1" align="center"><tr><td class="destacado" align="center"><center>'. $directorio . $archivo . '</center></td></tr><tr><td align="left" class="codigo"><div align="left">';
        
        if (file_exists($directorio . $archivo))
        {
            echo "<img src=\"$directorio$archivo\">";
        }
        else { mostrar_error("No se pudo encontrar el archivo $directorio$archivo"); }
        
        echo '</div></td></tr></table></center>';
    }
    
    
    //Funcion que borra un archivo de registro:
    function eliminar_archivo($archivo, $directorio)
    {
        if (file_exists($directorio . $archivo))
        {
            $operacion = unlink($directorio . $archivo);
            if ($operacion) { mostrar_advertencia("Archivo $directorio$archivo eliminado correctamente."); }
            else { mostrar_error("El archivo $directorio$archivo no pudo ser eliminado."); }
        }
        else { mostrar_error("No se pudo encontrar el archivo $directorio$archivo"); }
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Limpiar im&aacute;genes de categor&iacute;as inexistentes</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar()
            {
                return confirm("Pulsa aceptar para eliminar el archivo");
            }
        // -->
        </script>
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Limpiar im&aacute;genes de categor&iacute;as inexistentes</h2>
        <br>
        <br>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                echo '<center><table border="0" align="center" valign=\"top\"><tr>';
                echo "<td valign=\"top\">";
                mostrar_formulario("../img/categorias/");
                //echo "</td><td valign=\"top\">";
                //mostrar_formulario("../img/web/zoom/");
                echo "</td></tr></table></center>";
            }
            //...pero si no, lo muestra:
            else
            {
                echo '<center><table border="0" align="center"><tr>';
                echo "<td valign=\"top\">";
                mostrar_formulario("../img/categorias/");
                //echo "</td><td valign=\"top\">";
                //mostrar_formulario("../img/productos/zoom/");
                echo "</td></tr></table></center>";
            }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
