<?php
    set_time_limit(0);

    //Incluye el archivo para mostrar errores:
    require_once "../../cod/func/web/error.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../../cod/func/db/db.php";

    //Funcion que crea la base de datosa y sus tablas:
    function crear_base_datos()
    {
        //Reconoce el objeto externo de la base de datos:
        global $base_datos;

        //Crea la base de datos:
        $archivo = "sql/base_datos.sql";
        $operacion = procesar_archivo($archivo);

        //Si la operacion ha ido bien, lo notifica:
        if ($operacion) { echo "Base de datos <b>" . DB_NAME . "</b> creada.<br>"; }

        //Selecciona la base de datos creada:
        $base_datos->selecciona();

        //Crea las tablas de la base de datos: (podria utilizarse mysqli_multi_query, pero no se si seria compatible con la version de PHP del servidor)
        $archivo = "sql/tablas.sql";
        $sentencias = obtener_archivo($archivo);
        $sentencias = explode(";", $sentencias);
        $operacion2 = TRUE;
        foreach ($sentencias as $sentencia)
        {
            $sentencia = trim($sentencia);
            $operacion_actual = TRUE;
            if ($sentencia != "") { $operacion_actual = $base_datos->haz_consulta($sentencia); }
            if (!$operacion_actual) { $operacion2 = FALSE; }
        }
        
        //Si la operacion ha ido bien, lo notifica:
        if ($operacion2) { echo "Tablas creadas.<br>"; }
        
        //Retorna si todo ha ido bien:
        return ($operacion && $operacion2);
    }
    
    //Funcion que procesa un archivo:
    function procesar_archivo($archivo)
    {
        //Reconoce el objeto externo de la base de datos:
        global $base_datos;

        //Recoge en una variable todo el archivo SQL:
        $comandos = obtener_archivo($archivo);
        
        //Si el archivo se ha cargado bien:
        if ($comandos != "")
        {
            //Envia los comandos del archivo a mySQL:
            $operacion = $base_datos->haz_consulta($comandos);
        }
        //...pero si no, notifica del error:
        else
        {
            if (file_exists($archivo)) { mostrar_error("No se han podido leer los comandos del archivo de comandos (<b>$archivo</b>)"); }
            else { mostrar_error("No se ha podido abrir el archivo de comandos (<b>$archivo</b>)"); }
        }
        
        //Retorna el resultado de la operacion:
        return $operacion;
    }

    //Funcion que obtiene un archivo SQL y lo retorna en una variable:
    function obtener_archivo($archivo)
    {
        //Recoge en una variable todo el archivo SQL:
        $comandos = trim(@implode("", @file($archivo)));
        
        //Procesa el codigo PHP que pudiera haber en el archivo:
        $comandos = "\$comandos = '" . str_replace("'", "\'", $comandos) . "';";
        eval($comandos);

        //Cambia el texto que deben ser constantes por su valor (porque el eval no las interpreta):
        $comandos = str_replace("DB_HOST", DB_HOST, $comandos);
        $comandos = str_replace("DB_LOGIN", DB_LOGIN, $comandos);
        $comandos = str_replace("DB_PASSWORD", DB_PASSWORD, $comandos);
        $comandos = str_replace("DB_NAME", DB_NAME, $comandos);

        //Retorna el archivo en una variable:
        return $comandos;   
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Creaci&oacute;n de la base de datos y sus tablas</title>
        <link rel="stylesheet" type="text/css" href="../css/admin.css" title="defecto">
    </head>
    <body>
        <center>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Creaci&oacute;n de la base de datos y sus tablas</h2>
        <a href="../index.php">Volver al men&uacute; principal</a>
        <br>
        <br>
        <b>Nota</b>: las tablas que ya estaban creadas previamente no se vuelven a crear y no se substituye ni modifica su contenido. Para que sean substituidas por las nuevas (vac&iacute;as), las tablas existentes deben eliminarse manualmente.
        </center>
        <br>
        <br>
        <?php
            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Llama a la funcion para crear la base de datos y sus tablas:
            crear_base_datos();

            //Desconecta de la base de datos:
            $base_datos->desconecta();
        ?>
    </body>
</html>
