CREATE TABLE IF NOT EXISTS idiomas
(
    id_idioma INT AUTO_INCREMENT PRIMARY KEY,
    idioma VARCHAR(25) UNIQUE,
    mostrar BOOL NOT NULL DEFAULT 1,
    INDEX (id_idioma)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS etiquetas
(
    id_etiqueta INT AUTO_INCREMENT PRIMARY KEY,
    etiqueta VARCHAR(255) UNIQUE NOT NULL,
    INDEX (id_etiqueta, etiqueta)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS etiqueta_traduccion
(
        id_etiqueta INT NOT NULL,
        id_idioma INT NOT NULL DEFAULT 1,
        texto TEXT NOT NULL DEFAULT '',
        eval BOOL NOT NULL DEFAULT 0,
        INDEX (id_etiqueta, id_idioma),
        FOREIGN KEY (id_etiqueta) REFERENCES etiquetas(id_etiqueta) ON DELETE CASCADE ON UPDATE CASCADE,
        FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
        PRIMARY KEY (id_etiqueta, id_idioma)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS constantes
(
    id_constante INT AUTO_INCREMENT PRIMARY KEY,
    constante VARCHAR(255) UNIQUE NOT NULL,
    valor VARCHAR(255) NOT NULL DEFAULT '',
    eval BOOL NOT NULL DEFAULT 0,
    INDEX (id_constante, constante, valor)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS categorias
(
    id_categoria INT AUTO_INCREMENT PRIMARY KEY,
    raiz INT NOT NULL DEFAULT 0,
	orden INT NOT NULL DEFAULT 0,
    mostrar BOOL NOT NULL DEFAULT 1,
    INDEX (id_categoria, raiz)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS categorias_adoptadas
(
    id_categoria INT NOT NULL,
    id_categoria_adoptiva INT NOT NULL,
    INDEX (id_categoria, id_categoria_adoptiva),
    FOREIGN KEY (id_categoria) REFERENCES categorias(id_categoria) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_categoria_adoptiva) REFERENCES categorias(id_categoria) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_categoria, id_categoria_adoptiva)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS categoria_idioma
(
    id_categoria INT NOT NULL,
    id_idioma INT NOT NULL DEFAULT 1,
    nombre_categoria VARCHAR(255) NOT NULL DEFAULT '',
    INDEX (id_categoria, id_idioma, nombre_categoria),
    FOREIGN KEY (id_categoria) REFERENCES categorias(id_categoria) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_categoria, id_idioma)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS categoria_titulo
(
    id_categoria INT NOT NULL,
    id_idioma INT NOT NULL DEFAULT 1,
    titulo TEXT NOT NULL DEFAULT '',
    INDEX (id_categoria, id_idioma),
    FOREIGN KEY (id_categoria) REFERENCES categorias(id_categoria) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_categoria, id_idioma)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS categoria_texto
(
    id_categoria INT NOT NULL,
    id_idioma INT NOT NULL DEFAULT 1,
    codigo TEXT NOT NULL DEFAULT '',
    parte ENUM('encabezado', 'cuerpo', 'pie') NOT NULL,
    eval BOOL NOT NULL DEFAULT 0,
    INDEX (id_categoria, id_idioma),
    FOREIGN KEY (id_categoria) REFERENCES categorias(id_categoria) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_categoria, id_idioma, parte)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS categoria_archivo
(
    id_categoria INT NOT NULL,
    archivo TEXT NOT NULL DEFAULT '',
    FOREIGN KEY (id_categoria) REFERENCES categorias(id_categoria) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_categoria)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS menu_subgrupos
(
    id_subgrupo INT AUTO_INCREMENT PRIMARY KEY,
    orden INT NOT NULL DEFAULT 0,
    INDEX (id_subgrupo)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS menu_subgrupos_categorias
(
    id_subgrupo INT NOT NULL,
    id_categoria INT NOT NULL,
    orden INT NOT NULL DEFAULT 0,
    INDEX (id_subgrupo, id_categoria),
    FOREIGN KEY (id_subgrupo) REFERENCES menu_subgrupos(id_subgrupo) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_categoria) REFERENCES categorias(id_categoria) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_subgrupo, id_categoria)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS fabricantes
(
    id_fabricante INT AUTO_INCREMENT PRIMARY KEY,
    nombre_fabricante VARCHAR(255) UNIQUE,
    INDEX (id_fabricante, nombre_fabricante)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS fabricante_marca
(
    id_fabricante INT NOT NULL,
    id_marca INT UNIQUE NOT NULL AUTO_INCREMENT,
    nombre_marca VARCHAR(255) UNIQUE,
    INDEX (id_fabricante, id_marca, nombre_marca),
    FOREIGN KEY (id_fabricante) REFERENCES fabricantes(id_fabricante) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_fabricante, id_marca)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS colecciones
(
    id_coleccion INT AUTO_INCREMENT PRIMARY KEY,
    nombre_coleccion VARCHAR(255) UNIQUE,
    INDEX (id_coleccion, nombre_coleccion)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS disenyadores
(
    id_disenyador INT AUTO_INCREMENT PRIMARY KEY,
    nombre_disenyador VARCHAR(255) UNIQUE,
    INDEX (id_disenyador, nombre_disenyador)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS productos
(
    ref VARCHAR(100) PRIMARY KEY,
    id_fabricante INT NOT NULL,
    id_marca INT,
    mostrar BOOL NOT NULL DEFAULT 1,
    precio_normal DECIMAL(6, 2) UNSIGNED NOT NULL DEFAULT 0,
    FOREIGN KEY (id_fabricante) REFERENCES fabricantes(id_fabricante) ON DELETE CASCADE ON UPDATE CASCADE,
    INDEX (ref, id_fabricante, id_marca)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS producto_tipo
(
    ref_producto VARCHAR(100) NOT NULL,
    tipo ENUM('tela', 'libro', 'otro') NOT NULL,
    FOREIGN KEY (ref_producto) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_producto)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS producto_descripcion
(
    ref_producto VARCHAR(100) NOT NULL,
    id_idioma INT NOT NULL DEFAULT 1,
    descripcion TEXT NOT NULL DEFAULT '',
    eval BOOL NOT NULL DEFAULT 0,
    INDEX (ref_producto, id_idioma),
    FOREIGN KEY (ref_producto) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_producto, id_idioma)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS producto_nombre
(
    ref_producto VARCHAR(100) NOT NULL,
    id_idioma INT NOT NULL DEFAULT 1,
    nombre VARCHAR(255) NOT NULL DEFAULT '',
    INDEX (ref_producto, id_idioma, nombre),
    FOREIGN KEY (ref_producto) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_producto, id_idioma)
) ENGINE=INNODB;


CREATE TABLE IF NOT EXISTS producto_categoria
(
    ref_producto VARCHAR(100) NOT NULL,
    id_categoria INT NOT NULL,
    orden INT NOT NULL DEFAULT 0,
    INDEX (ref_producto, id_categoria),
    FOREIGN KEY (ref_producto) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_categoria) REFERENCES categorias(id_categoria) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_producto, id_categoria)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS tela_disenyador
(
    ref_tela VARCHAR(100) NOT NULL,
    id_disenyador INT NOT NULL,
    INDEX (ref_tela, id_disenyador),
    FOREIGN KEY (ref_tela) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_disenyador) REFERENCES disenyadores(id_disenyador) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_tela, id_disenyador)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS producto_coleccion
(
    ref_producto VARCHAR(100) NOT NULL,
    id_coleccion INT NOT NULL,
    INDEX (ref_producto, id_coleccion),
    FOREIGN KEY (ref_producto) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_coleccion) REFERENCES colecciones(id_coleccion) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_producto, id_coleccion)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS tematicas
(
    id_tematica INT AUTO_INCREMENT PRIMARY KEY,
    INDEX (id_tematica)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS tematica_idioma
(
    id_tematica INT NOT NULL,
    id_idioma INT NOT NULL,
    tematica VARCHAR(100),
    INDEX (id_tematica, id_idioma, tematica),
    FOREIGN KEY (id_tematica) REFERENCES tematicas(id_tematica) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_tematica, id_idioma)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS libro_tematica
(
    ref_libro VARCHAR(100) NOT NULL,
    id_tematica INT NOT NULL,
    INDEX (ref_libro, id_tematica),
    FOREIGN KEY (ref_libro) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_tematica) REFERENCES tematicas(id_tematica) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_libro, id_tematica)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS libro_idioma
(
    ref_libro VARCHAR(100) NOT NULL,
    id_idioma INT NOT NULL,
    INDEX (ref_libro, id_idioma),
    FOREIGN KEY (ref_libro) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_libro, id_idioma)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS grupos
(
    id_grupo INT AUTO_INCREMENT PRIMARY KEY,
    nombre_grupo VARCHAR(255) UNIQUE,
    INDEX (id_grupo, nombre_grupo)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS cliente_codigo
(
    id_cliente_codigo INT AUTO_INCREMENT PRIMARY KEY,
    id_particular_empresa INT,
    codigo INT UNSIGNED UNIQUE,
    tipo ENUM ('particular', 'empresa'),
    INDEX (id_particular_empresa, codigo),
    KEY (id_particular_empresa, tipo)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS particulares
(
    id_particular INT AUTO_INCREMENT PRIMARY KEY,
    dni VARCHAR(25) UNIQUE,
    nombre VARCHAR(255) NOT NULL DEFAULT '',
    fecha_nacimiento DATE,
    sexo ENUM ('mujer', 'hombre', 'desconocido') NOT NULL DEFAULT 'desconocido',
    INDEX (id_particular, nombre)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS empresas
(
    id_empresa INT AUTO_INCREMENT PRIMARY KEY,
    nif VARCHAR(25) UNIQUE,
    nombre VARCHAR(255) NOT NULL DEFAULT '',
    INDEX (id_empresa, nombre)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS particular_datos
(
    id_particular_datos INT AUTO_INCREMENT PRIMARY KEY,
    id_particular INT NOT NULL,
    direccion VARCHAR(255) DEFAULT '',
    codigo_postal VARCHAR(255) DEFAULT '',
    poblacion VARCHAR(255) DEFAULT '',
    provincia_o_estado VARCHAR(255) DEFAULT '',
    pais VARCHAR(255) DEFAULT '',
    telefono VARCHAR(255) DEFAULT '',
    email VARCHAR(255) DEFAULT '',
    fax VARCHAR(255) DEFAULT '',
    INDEX (id_particular),
    FOREIGN KEY (id_particular) REFERENCES particulares(id_particular) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS empresa_datos
(
    id_empresa_datos INT AUTO_INCREMENT PRIMARY KEY,
    id_empresa INT NOT NULL,
    direccion VARCHAR(255) DEFAULT '',
    codigo_postal VARCHAR(255) DEFAULT '',
    poblacion VARCHAR(255) DEFAULT '',
    provincia_o_estado VARCHAR(255) DEFAULT '',
    pais VARCHAR(255) DEFAULT '',
    telefono VARCHAR(255) DEFAULT '',
    email VARCHAR(255) DEFAULT '',
    fax VARCHAR(255) DEFAULT '',
    INDEX (id_empresa),
    FOREIGN KEY (id_empresa) REFERENCES empresas(id_empresa) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS particular_datos_por_defecto
(
    id_particular INT PRIMARY KEY,
    id_particular_datos INT NOT NULL,
    INDEX (id_particular, id_particular_datos),
    FOREIGN KEY (id_particular) REFERENCES particulares(id_particular) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_particular_datos) REFERENCES particular_datos(id_particular_datos) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS empresa_datos_por_defecto
(
    id_empresa INT PRIMARY KEY,
    id_empresa_datos INT NOT NULL,
    INDEX (id_empresa, id_empresa_datos),
    FOREIGN KEY (id_empresa) REFERENCES empresas(id_empresa) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_empresa_datos) REFERENCES empresa_datos(id_empresa_datos) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS particular_grupo
(
    id_particular INT NOT NULL,
    id_grupo INT NOT NULL,
    INDEX (id_particular, id_grupo),
    FOREIGN KEY (id_particular) REFERENCES particulares(id_particular) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_grupo) REFERENCES grupos(id_grupo) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_particular, id_grupo)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS empresa_grupo
(
    id_empresa INT NOT NULL,
    id_grupo INT NOT NULL,
    INDEX (id_empresa, id_grupo),
    FOREIGN KEY (id_empresa) REFERENCES empresas(id_empresa) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_grupo) REFERENCES grupos(id_grupo) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_empresa, id_grupo)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS compradores_particulares
(
    id_particular INT NOT NULL,
    usuario VARCHAR(255) NOT NULL UNIQUE,
    clave VARCHAR(255) NOT NULL,
    INDEX (id_particular, usuario, clave),
    FOREIGN KEY (id_particular) REFERENCES particulares(id_particular) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_particular)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS compradores_empresas
(
    id_empresa INT NOT NULL,
    usuario VARCHAR(255) NOT NULL UNIQUE,
    clave VARCHAR(255) NOT NULL,
    INDEX (id_empresa, usuario, clave),
    FOREIGN KEY (id_empresa) REFERENCES empresas(id_empresa) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_empresa)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS compradores_grupos
(
    id_grupo INT NOT NULL,
    usuario VARCHAR(255) NOT NULL UNIQUE,
    clave VARCHAR(255) NOT NULL,
    INDEX (id_grupo, usuario, clave),
    FOREIGN KEY (id_grupo) REFERENCES grupos(id_grupo) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_grupo)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS producto_comprador_particular
(
    id_relacion INT AUTO_INCREMENT PRIMARY KEY,
    ref_producto VARCHAR(100) NOT NULL,
    id_particular INT NOT NULL,
    precio DECIMAL(6, 2) UNSIGNED NOT NULL DEFAULT 0,
    cantidad_minima DECIMAL(6,2) NOT NULL DEFAULT 0,
    piezas BOOL NOT NULL DEFAULT 0,
    FOREIGN KEY (ref_producto) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_particular) REFERENCES particulares(id_particular) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS producto_comprador_empresa
(
    id_relacion INT AUTO_INCREMENT PRIMARY KEY,
    ref_producto VARCHAR(100) NOT NULL,
    id_empresa INT NOT NULL,
    precio DECIMAL(6, 2) UNSIGNED NOT NULL DEFAULT 0,
    cantidad_minima DECIMAL(6,2) NOT NULL DEFAULT 0,
    piezas BOOL NOT NULL DEFAULT 0,
    FOREIGN KEY (ref_producto) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_empresa) REFERENCES empresas(id_empresa) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS producto_comprador_grupo
(
    id_relacion INT AUTO_INCREMENT PRIMARY KEY,
    ref_producto VARCHAR(100) NOT NULL,
    id_grupo INT NOT NULL,
    precio DECIMAL(6, 2) UNSIGNED NOT NULL DEFAULT 0,
    cantidad_minima DECIMAL(6,2) NOT NULL DEFAULT 0,
    piezas BOOL NOT NULL DEFAULT 0,
    FOREIGN KEY (ref_producto) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_grupo) REFERENCES grupos(id_grupo) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS monedas_respecto_euro
(
    id_moneda INT AUTO_INCREMENT PRIMARY KEY,
    moneda VARCHAR(255) UNIQUE,
    valor_respecto_euro DECIMAL(6, 2) UNSIGNED NOT NULL
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS galeria
(
    id_obra INT AUTO_INCREMENT PRIMARY KEY,
    nombre_obra VARCHAR(255),
    orden INT NOT NULL DEFAULT 0,
    mostrar BOOL NOT NULL DEFAULT 1,
    INDEX (id_obra, nombre_obra)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS galeria_personas
(
    id_obra INT NOT NULL,
    id_particular INT NOT NULL,
    INDEX (id_obra, id_particular),
    FOREIGN KEY (id_obra) REFERENCES galeria(id_obra) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_particular) REFERENCES particulares(id_particular) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_obra, id_particular)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS galeria_obra_texto
(
    id_obra INT NOT NULL,
    id_idioma INT NOT NULL DEFAULT 1,
    texto TEXT NOT NULL DEFAULT '',
    eval BOOL NOT NULL DEFAULT 0,
    INDEX (id_obra, id_idioma),
    FOREIGN KEY (id_obra) REFERENCES galeria(id_obra) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_idioma) REFERENCES idiomas(id_idioma) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (id_obra, id_idioma)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS tela_metros_pieza
(
    ref_tela VARCHAR(100) NOT NULL,
    metros_pieza DECIMAL(6, 2) UNSIGNED NOT NULL DEFAULT 13.7,
    INDEX (ref_tela),
    FOREIGN KEY (ref_tela) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_tela)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS tela_minimo_centimetros_particular
(
    ref_tela VARCHAR(100) NOT NULL,
    id_particular INT NOT NULL,
    minimo_centimetros INT NOT NULL,
    incremento_centimetros INT NOT NULL,
    INDEX (ref_tela, id_particular),
    FOREIGN KEY (ref_tela) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_particular) REFERENCES particulares(id_particular) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_tela, id_particular)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS tela_minimo_centimetros_empresa
(
    ref_tela VARCHAR(100) NOT NULL,
    id_empresa INT NOT NULL,
    minimo_centimetros INT NOT NULL,
    incremento_centimetros INT NOT NULL,
    INDEX (ref_tela, id_empresa),
    FOREIGN KEY (ref_tela) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_empresa) REFERENCES empresas(id_empresa) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_tela, id_empresa)
) ENGINE=INNODB;

CREATE TABLE IF NOT EXISTS tela_minimo_centimetros_grupo
(
    ref_tela VARCHAR(100) NOT NULL,
    id_grupo INT NOT NULL,
    minimo_centimetros INT NOT NULL,
    incremento_centimetros INT NOT NULL,
    INDEX (ref_tela, id_grupo),
    FOREIGN KEY (ref_tela) REFERENCES productos(ref) ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (id_grupo) REFERENCES grupos(id_grupo) ON DELETE CASCADE ON UPDATE CASCADE,
    PRIMARY KEY (ref_tela, id_grupo)
) ENGINE=INNODB;

