<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "particulares.php";

	//Llama a la funcion htmlentities como es debido (diciendole la codificacion):
	function htmlentities_($valor) { return htmlentities($valor, ENT_COMPAT, 'utf-8'); }
    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;
        
        $consulta = "SELECT * FROM particulares LEFT JOIN cliente_codigo ON id_particular_empresa = id_particular AND LOWER(tipo) = 'particular' ORDER BY nombre";
        $resultados = $base_datos->haz_consulta($consulta);

        $par_impar = "par";
        
        ?>
        <br>
        <center>
        <table align="center" width="620">
            <tr>
                <td class="impar" width="400" valign="middle">Modificar</td>
                <td class="impar" width="120" valign="middle">Eliminar</td>
            </tr>
        </table>
        
        <?php
        
        $contador = 0;
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $codigo = $row["codigo"];
            $id = $row["id_particular"];
            $dni = $row["dni"];
            $nombre = $row["nombre"];
            $fecha_nacimiento = $row["fecha_nacimiento"];
            $sexo = $row["sexo"];
            ?>
            <br>
            <table align="center" width="620">
                <tr>
                    <form method="post" action="<?php echo $this_file; ?>" onSubmit="return comprobar_formulario(<?php echo $contador; ?>);">
                    <td class="<?php echo $par_impar; ?>" width="400" valign="middle">
                        <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                        <input type="hidden" name="accion" value="modificar">
                        <center>
                        <table border="1" align="center">
                            <tr>
                                <td>
                                    C&oacute;digo:
                                </td>
                                <td>
                                    <input type="text" name="codigo" id="codigo_<?php echo $contador; ?>" value="<?php echo htmlentities($codigo); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    DNI:
                                </td>
                                <td>
                                    <input type="text" name="dni" id="dni_<?php echo $contador; ?>" value="<?php echo htmlentities($dni); ?>">
                                </td>
                            </tr>
                                <td>
                                    Nombre:
                                </td>
                                <td>
                                    <input type="text" name="nombre" id="nombre_<?php echo $contador; ?>" value="<?php echo htmlentities($nombre); ?>">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Fecha de nacimiento (AAAA/MM/DD):
                                </td>
                                <td>
                                    <input type="text" name="fecha_nacimiento" id="fecha_nacimiento_<?php echo $contador; ?>" value="<?php echo htmlentities($fecha_nacimiento); ?>" maxlength="10">
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    Sexo:
                                </td>
                                <td align="left">
                                    <div align="left">
                                        <?php if ($sexo == "hombre") { $checked = " checked"; } else { $checked = ""; } ?>
                                        <label for="sexo_hombre_<?php echo $contador; ?>"><input type="radio" name="sexo" id="sexo_hombre_<?php echo $contador; ?>" class="casilla" value="Hombre"<?php echo $checked; ?>> Hombre</label><br>
                                        <?php if ($sexo == "mujer") { $checked = " checked"; } else { $checked = ""; } ?>
                                        <label for="sexo_mujer_<?php echo $contador; ?>"><input type="radio" name="sexo" id="sexo_mujer_<?php echo $contador; ?>" class="casilla" value="Mujer"<?php echo $checked; ?>> Mujer</label><br>
                                        <?php if ($sexo != "hombre" && $sexo != "mujer") { $checked = " checked"; } else { $checked = ""; } ?>
                                        <label for="sexo_desconocido_<?php echo $contador; ?>"><input type="radio" name="sexo" id="sexo_desconocido_<?php echo $contador; ?>" class="casilla" value="Desconocido"<?php echo $checked; ?>> Desconocido</label>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2">
                                    <input type="submit" name="boton" value="Modificar">
                                </td>
                            </tr>
                        </table>
                        </form>
                        <br>
                        <form method="post" action="particular_datos.php">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="submit" name="boton" value="M&aacute;s Datos">
                        </form>
                        </center>
                    </td>
                    <td class="<?php echo $par_impar; ?>" width="120" valign="middle">
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes(htmlentities(strtoupper($nombre))); ?>');">
                            <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                            <input type="hidden" name="accion" value="eliminar">
                            <input type="submit" name="boton" value="Eliminar">
                        </form>
                    </td>
                </tr>
            </table>
            <?php
            $par_impar = ($par_impar == "par") ? "impar" : "par";
            $contador++;
        }

        ?>

            <br>
            <table align="center" width="620">
                <tr>
                    <td valign="middle">
                         <?php
                            if (mysqli_num_rows($resultados) <= 0) { mostrar_advertencia("No hay particulares en la tabla de particulares<br>"); }
                         ?>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="return comprobar_formulario('nuevo');">
                            <input type="hidden" name="accion" value="agregar">
                            <table border="1">
                                <tr>
                                    <td colspan="2">
                                        Nuevo:
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        C&oacute;digo:
                                    </td>
                                    <td>
                                        <input type="text" id="codigo_nuevo" name="codigo" value="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        DNI:
                                    </td>
                                    <td>
                                        <input type="text" id="dni_nuevo" name="dni" value="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Nombre:
                                    </td>
                                    <td>
                                        <input type="text" name="nombre" id="nombre_nuevo" value="">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Fecha de nacimiento (AAAA/MM/DD):
                                    </td>
                                    <td>
                                        <input type="text" name="fecha_nacimiento" id="fecha_nacimiento_nuevo" value="" maxlength="10">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Sexo:
                                    </td>
                                    <td align="left">
                                        <div align="left">
                                        <label for="sexo_hombre_nuevo"><input type="radio" name="sexo" id="sexo_hombre_nuevo" value="hombre" class="casilla"> Hombre</label><br>
                                        <label for="sexo_mujer_nuevo"><input type="radio" name="sexo" id="sexo_mujer_nuevo" value="mujer" class="casilla"> Mujer</label><br>
                                        <label for="sexo_desconocido_nuevo"><input type="radio" name="sexo" id="sexo_desconocido_nuevo" value="desconocido" class="casilla" checked> Desconocido</label><br>
                                        </div>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <input type="submit" name="boton" value="Agregar">
                                    </td>
                                </tr>
                            </table>
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        $dni = recoger_post("dni");
        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                if ($dni != "")
                {
                    $operacion = agregar($dni);
                    if (!$operacion) { mostrar_error("No se ha podido agregar <b>" . htmlentities($dni) . "</b>."); }
                    else { echo "<b>" . htmlentities($dni) . "</b> agregado<br>"; }
                } else { mostrar_advertencia("No se ha podido agregar <b>" . htmlentities($dni) . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'eliminar':
                $id = recoger_post("id");
                if ($id != "" && is_numeric($id))
                {
                    $operacion = eliminar($id);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar <b>" . htmlentities($dni) . "</b> (con id '" . htmlentities($id) . "')."); }
                    else { echo "<b>" . htmlentities($dni) . "</b> (con id '$id') eliminado<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar <b>" . htmlentities($dni) . "</b> (con id '" . htmlentities($id) . "'), puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id = recoger_post("id");
                if ($dni != "" && $id != "" && is_numeric($id))
                {
                    $operacion = modificar($id, $dni);
                    if (!$operacion) { mostrar_error("No se ha podido modificar <b>" . htmlentities($dni) . "</b> (con id '" . htmlentities($id) . "')."); }
                    else { echo "Registro con id '" . htmlentities($id) . "' modificado a <b>" . htmlentities($dni) . "</b><br>"; }
                } else { mostrar_advertencia("No se ha podido modificar <b>" . htmlentities($dni) . "</b> (con id '" . htmlentities($id) . "'), puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe un registro o no:
    function existe($dni)
    {
        global $base_datos;
        
        $dni = mysqli_real_escape_string($base_datos->conexion, $dni);
        
        $consulta = "SELECT * FROM particulares WHERE dni LIKE '$dni'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que calcula si ya existe un registro con un codigo o no:
    function existeCodigo($codigo)
    {
        global $base_datos;
        
        //$consulta = "SELECT * FROM cliente_codigo WHERE codigo = $codigo AND LOWER(tipo) LIKE 'particular'";
        $consulta = "SELECT * FROM cliente_codigo WHERE codigo = $codigo";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    //Funcion que agrega un registro nuevo:
    function agregar($dni)
    {
        if (existe($dni)) { mostrar_error("El registro <b>" . htmlentities($dni) . "</b> ya existe."); return FALSE; }
        
		global $base_datos;
		
        $codigo = mysqli_real_escape_string($base_datos->conexion, trim(recoger_post("codigo")));
        if (!is_numeric($codigo)) { mostrar_error("El codigo <b>" . htmlentities($codigo) . "</b> no es numerico."); return FALSE; }
        else if (existeCodigo($codigo)) { mostrar_error("El codigo <b>" . htmlentities($codigo) . "</b> ya existe."); return FALSE; }
        
        $nombre = recoger_post("nombre");
        $fecha_nacimiento = recoger_post("fecha_nacimiento");
        $sexo = strtolower(recoger_post("sexo"));
        if ($sexo != "hombre" && $sexo != "mujer") { $sexo = "desconocido"; }

        $dni = strtoupper(mysqli_real_escape_string($base_datos->conexion, trim($dni)));
        $nombre = mysqli_real_escape_string($base_datos->conexion, trim($nombre));
        $fecha_nacimiento = mysqli_real_escape_string($base_datos->conexion, trim($fecha_nacimiento));
        $sexo = strtolower(mysqli_real_escape_string($base_datos->conexion, trim($sexo)));
        
        $consulta = "INSERT INTO particulares (dni, nombre, fecha_nacimiento, sexo) VALUES ('$dni', '$nombre', '$fecha_nacimiento', '$sexo')";
        $operacion1 = $base_datos->haz_consulta($consulta);
        
        if ($operacion1)
        {
            $id = mysqli_insert_id($base_datos->conexion);
            $consulta = "INSERT INTO cliente_codigo (id_particular_empresa, codigo, tipo) VALUES ('$id', '$codigo', 'particular')";
            $operacion2 = $base_datos->haz_consulta($consulta);
        } else { $operacion2 = FALSE; }
        
        return $operacion1 && $operacion2;
    }
    
    
    //Funcion que elimina un registro existente:
    function eliminar($id)
    {
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        
        $consulta = "DELETE FROM particulares WHERE id_particular = $id";
        $operacion1 = $base_datos->haz_consulta($consulta);
        
        if ($operacion1)
        {
            $consulta = "DELETE FROM cliente_codigo WHERE id_particular_empresa = $id AND LOWER(tipo) = 'particular'";
            $operacion2 = $base_datos->haz_consulta($consulta);
        } else { $operacion2 = FALSE; }
        
        return $operacion1 && $operacion2;
    }
    
    
    //Funcion que modifica un registro existente:
    function modificar($id, $dni)
    {
        //if (existe_idioma($idioma)) { mostrar_error("El idioma <b>" . htmlentities($idioma) . "</b> ya existe."); return FALSE; }
        
        global $base_datos;

        //$id_idioma = mysqli_real_escape_string($base_datos->conexion, $id_idioma);
        $codigo = mysqli_real_escape_string($base_datos->conexion, trim(recoger_post("codigo")));
        if (!is_numeric($codigo)) { mostrar_error("El codigo <b>" . htmlentities($codigo) . "</b> no es numerico."); return FALSE; }

        $nombre = recoger_post("nombre");
        $fecha_nacimiento = recoger_post("fecha_nacimiento");
        $sexo = strtolower(recoger_post("sexo"));
        if ($sexo != "hombre" && $sexo != "mujer") { $sexo = "desconocido"; }

        $dni = strtoupper(mysqli_real_escape_string($base_datos->conexion, trim($dni)));
        $nombre = mysqli_real_escape_string($base_datos->conexion, trim($nombre));
        $fecha_nacimiento = mysqli_real_escape_string($base_datos->conexion, trim($fecha_nacimiento));
        $sexo = strtolower(mysqli_real_escape_string($base_datos->conexion, trim($sexo)));

        $consulta = "UPDATE particulares SET dni = '$dni', nombre = '".$nombre."', fecha_nacimiento = '$fecha_nacimiento', sexo = '$sexo' WHERE id_particular = $id";
        $operacion1 = $base_datos->haz_consulta($consulta);

        if ($operacion1)
        {
            $consulta = "UPDATE cliente_codigo SET codigo = '$codigo' WHERE id_particular_empresa = $id AND LOWER(tipo) = 'particular'";
            $operacion2 = $base_datos->haz_consulta($consulta);
        } else { $operacion2 = FALSE; }
        
        return $operacion1 && $operacion2;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de particulares</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }
            
            function comprobar_formulario(contador)
            {
                var errores = "";
                if (document.getElementById('codigo_' + contador).value == '') { errores += "* Falta el campo CODIGO\n"; }
                else if (isNaN(document.getElementById('codigo_' + contador).value)) { errores += "* El campo CODIGO debe ser numerico\n"; }
                if (document.getElementById('dni_' + contador).value == '') { errores += "* Falta el campo DNI\n"; }
                if (document.getElementById('nombre_' + contador).value == '') { errores += "* Falta el campo NOMBRE\n"; }
                if (document.getElementById('fecha_nacimiento_' + contador).value == '') { errores += "* Falta el campo FECHA DE NACIMIENTO\n"; }
                
                if (errores != "") { alert("No se puede enviar el formulario porque:\n" + errores); return false; }
                else { return true; }
            }
        // -->
        </script>
    </head>
    <body onLoad="document.getElementById('dni_nuevo').focus();">
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de particulares</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver abajo de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
