<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    //Guarda que pagina es esta:
    $this_file = "productos_sin_imagen.php";
    

    //Funcion que obtiene la imagen del producto:
    function obtener_imagen_producto($ref, $directorio)
    {
        global $usando_ajax;
        
        if (file_exists($directorio . nombre_archivo_correcto($ref) . ".gif")) { $imagen = nombre_archivo_correcto($ref) . ".gif"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpg")) { $imagen = nombre_archivo_correcto($ref) . ".jpg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpeg")) { $imagen = nombre_archivo_correcto($ref) . ".jpeg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".png")) { $imagen = nombre_archivo_correcto($ref) . ".png"; }
        else { $imagen = "img/error.gif"; }
        return $imagen;
    }


    //Funcion que recibe el nombre de un archivo y devuelve el correcto:
    function nombre_archivo_correcto($nombre)
    {
        //FALTARIA: substituir todos aquellos caracteres prohibidos para un archivo (caracteres raros, etc).
        return strtolower(str_replace(":", "", str_replace(" ", "_", str_replace("-", "_", trim($nombre)))));
    }


    //Muestra el formulario:
    function mostrar_formulario($directorio)
    {
        global $this_file, $base_datos;

        $consulta = "SELECT ref FROM productos ORDER BY ref";
        $resultados = $base_datos->haz_consulta($consulta);
        $referencias = Array();
        $referencias_existe = Array();
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $referencia = trim(strtolower($row["ref"]));
            $referencias[] = strtolower(str_replace(":", "", str_replace(" ", "_", str_replace("-", "_", trim(($row["ref"]))))));
            $referencia_existe[$referencia] = FALSE;
        }

        $directorio_puntero = opendir($directorio);
        echo '<center><table border="1" align="center"><tr><td colspan="3">Directorio ' . $directorio . '</td></tr>';
        while ($archivo = readdir($directorio_puntero))
        {
            $archivo_sin_extension = explode(".", $archivo);
            $archivo_sin_extension = strtolower($archivo_sin_extension[0]);
            
            if ($archivo != "." && $archivo != ".." && $archivo != "index.htm" && file_exists($directorio . $archivo) && !is_dir($directorio . $archivo))
            {
                //Si el archivo corresponde a un producto, se marca como que ya tiene imagen:
                if (in_array($archivo_sin_extension, $referencias))
                {
                    $referencia_real_guion = str_replace("", ":", str_replace("_", "-", $archivo_sin_extension));
                    $referencia_real_espacio = str_replace("", ":", str_replace("_", " ", $archivo_sin_extension));
                    if (isset($referencia_existe[$archivo_sin_extension]) && !$referencia_existe[$archivo_sin_extension])
                    {
                        $referencia_existe[$archivo_sin_extension] = TRUE;
                    }
                    else if (isset($referencia_existe[$referencia_real_guion]) && !$referencia_existe[$referencia_real_guion])
                    {
                        $referencia_existe[$referencia_real_guion] = TRUE;
                    }
                    else if (isset($referencia_existe[$referencia_real_espacio]) && !$referencia_existe[$referencia_real_espacio])
                    {
                        $referencia_existe[$referencia_real_espacio] = TRUE;
                    }

                }
            }
        }
        
        foreach ($referencia_existe as $referencia => $existe)
        {
            if (!$existe || strrpos($referencia, "-"))
            {
                echo '<tr><td>';
                echo "<img src=\"" . $directorio . obtener_imagen_producto($referencia, $directorio) . "\" width=\"25\" height=\"25\"><br>";
                echo $referencia;
                if (strrpos($referencia, "-"))
                {
                    echo "<br><i>Referencia con gui&oacute;n</i>";
                }
                echo '</td><td>';
                echo '<form method="post" action="productos.php">';
                echo '<input type="hidden" name="enviado_post" value="1">';
                echo '<input type="hidden" name="mostrar_ref" value="' . $referencia . '">';
                echo '<input type="submit" name="boton" value="Modificar">';
                echo '</form>';
                echo '</td></tr>';
            }
        }
        
        echo '</table></center>';
    }
    
    
    //Procesa el formulario:
    function procesar_formulario()
    {
        $accion = recoger_post("accion");
        $archivo = recoger_post("archivo");
        $directorio = recoger_post("directorio");
        
        switch ($accion)
        {
            case "ver":
                if (trim($archivo) != "" && trim($directorio) != "" ) { mostrar_archivo($archivo, $directorio); }
                else { mostrar_error("No se pudo procesar el formulario ya que faltan datos."); }
                break;
            case "eliminar":
                if (trim($archivo) != "" && trim($directorio) != "" ) { eliminar_archivo($archivo, $directorio); }
                else { mostrar_error("No se pudo procesar el formulario ya que faltan datos."); }
                break;
            default:
                mostrar_error("No se pudo procesar el formulario ya que faltan datos.");
        }
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Productos sin imagen o referencia il&iacute;cita</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar()
            {
                return confirm("Pulsa aceptar para eliminar el archivo");
            }
        // -->
        </script>
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Productos sin imagen o referencia il&iacute;cita</h2>
        <br>
        <br>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();

            echo '<center><table border="0" align="center"><tr>';
            echo "<td valign=\"top\">";
            mostrar_formulario("../img/productos/");
            echo "</td><td valign=\"top\">";
            mostrar_formulario("../img/productos/zoom/");
            echo "</td></tr></table></center>";

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
