<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";

    //Incluye el archivo de configuracion de la base de datos:
    require_once "../cod/config/db.php";
    
    //Incluye el archivo necesario para conectar a mySQL:
    require_once "../cod/func/db/db.php";

    
    //Guarda que pagina es esta:
    $this_file = "tematicas_libros.php";



    //Funcion que devuelve los idiomas:
    function obtener_idiomas()
    {
        global $base_datos;
        
        $idiomas = Array();
        
        $consulta = "SELECT * FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);

        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_idioma = $row["id_idioma"];
            $idioma = $row["idioma"];
            $idiomas[$id_idioma] = $idioma;
        }
        
        return $idiomas;
    }

    
    //Funcion que muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file, $base_datos;

        $idiomas = obtener_idiomas();

        if (sizeof($idiomas) <= 0) { mostrar_error('No hay idiomas en la tabla de idiomas. Puedes agregar idiomas <a href="idiomas.php">aqui</a>'); exit(); }

        echo '<table align="center"><tr>';
        foreach ($idiomas as $id_idioma => $idioma)
        {
            echo '<td class="destacado">'.$idioma.'</td>';
        }
        echo '<td>Modificar</td><td>Eliminar</td>';
        echo "</tr>";
        $par_impar = "impar";

        $consulta = "SELECT * FROM tematicas";
        $resultados = $base_datos->haz_consulta($consulta);
        while ($row = mysqli_fetch_assoc($resultados))
        {
            echo "<tr>";
            $id_tematica = $row["id_tematica"];
            ?>
            <form method="post" action="<?php echo $this_file; ?>">
                <input type="hidden" name="id_tematica" value="<?php echo $id_tematica; ?>">
                <input type="hidden" name="accion" value="modificar">
            <?php

            foreach ($idiomas as $id_idioma => $idioma)
            {
                $consulta = "SELECT * FROM tematica_idioma WHERE id_tematica = $id_tematica AND id_idioma = $id_idioma";
                $resultados2 = $base_datos->haz_consulta($consulta);
                $row2 = mysqli_fetch_assoc($resultados2);
                $tematica = htmlentities($row2["tematica"], ENT_COMPAT, 'utf-8');
                echo '<td class="'. $par_impar . '" valign="middle"><input type="text" name="tematica_' . $id_idioma . '" value="' . $tematica . '"></td>';
            
                $par_impar = ($par_impar == "par") ? "impar" : "par";
            }
            echo '<td class="destacado">';
            ?><input type="submit" name="boton" value="Modificar"></form><?php
            echo "</td>";
            ?>
            <form method="post" action="<?php echo $this_file; ?>" onSubmit="return confirmar_eliminar('<?php echo addslashes($id_tematica); ?>');">
                <input type="hidden" name="id_tematica" value="<?php echo $id_tematica; ?>">
                <input type="hidden" name="accion" value="eliminar">
                <td class="destacado"><input type="submit" name="boton" value="Eliminar"></td>
            <?php
            echo "</form>";
            
            echo "</tr>";
        }
        if (mysqli_num_rows($resultados) <= 0) { echo '<tr><td colspan="' . (sizeof($idiomas) + 2) . '">No hay tem&aacute;ticas</td></tr>'; $hay_tematicas = FALSE; }
        else { $hay_tematicas = TRUE; }
        echo "</table>";
        
        ?>

            <br>
            <table align="center">
                <tr>
                    <td valign="middle">
                        <?php
                            if (!$hay_tematicas) { mostrar_advertencia("No hay tem&aacute;ticas en la tabla de tem&aacute;ticas<br>"); }
                        ?>
                        <form method="post" action="<?php echo $this_file; ?>" onSubmit="if (!comprobar_formulario_agregar()) { alert('Debes rellenar todos los campos antes de poder enviar el formulario.'); return false; }">
                            <input type="hidden" name="accion" value="agregar">
                            Nueva:
                            <br>
                            <br>
                            <?php
                            echo '<table border="0">';
                            foreach ($idiomas as $id_idioma => $idioma)
                            {
                                echo '<tr><td>' . $idioma . ':</td><td><input type="text" name="tematica_' . $id_idioma . '" id="tematica_nueva_' . $id_idioma . '" value="" size="20"></td></tr>';
                            }
                            echo "</table>";
                            ?>
                            <br>
                            <input type="submit" name="boton" value="Agregar">
                        </form>
                    </td>
                </tr>
        </table>
        </center>
        <?
    }

    
    //Funcion que calcula si se ha enviado el formulario o no:
    function se_ha_enviado_formulario()
    {
        $se_ha_enviado = FALSE;
        
        $idioma_enviado = recoger_post("accion");
        
        if (trim($idioma_enviado) != "") { $se_ha_enviado = TRUE; }
        
        return $se_ha_enviado;
    }
    
    
    //Funcion que procesa el formulario:
    function procesar_formulario()
    {
        //global $base_datos;

        $accion = strtolower(recoger_post("accion"));
        switch ($accion)
        {
            case 'agregar':
                $operacion = agregar_tematica();
                if (!$operacion) { mostrar_error("No se ha podido agregar la nueva tem&aacute;tica."); }
                else { echo "Tem&aacute;tica nueva agregada<br>"; }
                break;
            case 'eliminar':
                $id_tematica = recoger_post("id_tematica");
                if ($id_tematica != "")
                {
                    $operacion = eliminar_tematica($id_tematica);
                    if (!$operacion) { mostrar_error("No se ha podido eliminar la tem&aacute;tica con id <b>" . htmlentities($id_tematica, ENT_COMPAT, 'utf-8') . "</b>."); }
                    else { echo "Tem&aacute;tica con id <b>" . htmlentities($id_tematica, ENT_COMPAT, 'utf-8') . "</b> eliminada<br>"; }
                } else { mostrar_advertencia("No se ha podido eliminar la tem&aacute;tica con id <b>" . htmlentities($id_tematica, ENT_COMPAT, 'utf-8') . "</b>, puede que falten datos en el formulario."); }
                break;
            case 'modificar':
                $id_tematica = recoger_post("id_tematica");
                if ($id_tematica != "")
                {
                    $operacion = modificar_tematica($id_tematica);
                    if (!$operacion) { mostrar_error("No se ha podido modificar la tem&aacute;tica con id <b>" . htmlentities($id_tematica, ENT_COMPAT, 'utf-8') . "</b>."); }
                    else { echo "Tem&aacute;tica con id <b>" . htmlentities($id_tematica, ENT_COMPAT, 'utf-8') . "</b> modificada.<br>"; }
                } else { mostrar_advertencia("No se ha podido modificar la tem&aacute;tica con id <b>" . htmlentities($id_tematica, ENT_COMPAT, 'utf-8') . "</b>, puede que falten datos en el formulario."); }
                break;
            default: mostrar_advertencia("El formulario no ha podido ser procesado, puede que falten datos en &eacute;l."); ;
        }
    }


    //Funcion que calcula si ya existe una etiqueta o no:
    function existe_tematica($tematica, $id_idioma)
    {
        global $base_datos;
        
        $tematica = mysqli_real_escape_string($base_datos->conexion, htmlentities($tematica, ENT_COMPAT, 'utf-8'));
        
        $consulta = "SELECT * FROM tematica_idioma WHERE id_idioma = $id_idioma AND tematica LIKE '$tematica'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        return mysqli_num_rows($resultados);
    }

    
    //Funcion que devuelve el primer id_idioma de la tabla idiomas:
/*    function primer_id_idioma()
    {
        global $base_datos;
        
        $consulta = "SELECT id_idioma FROM idiomas WHERE mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);
        $matriz_resultados = mysqli_fetch_assoc($resultados);
        if (is_array($matriz_resultados) && sizeof($matriz_resultados) > 0 && mysqli_num_rows($resultados)) { $id_idioma = $matriz_resultados["id_idioma"]; }
        else { $id_idioma = -1; }
        
        return $id_idioma;
    }*/


    //Funcion que agrega una tematica nueva:
    function agregar_tematica()
    {
        global $base_datos;
        
        $idiomas = obtener_idiomas();
        if (!sizeof($idiomas)) { mostrar_error("No se pueden agregar tem&aacute;ticas si no hay idiomas."); return FALSE; }        
        
        $operaciones = TRUE;
        $consulta = "INSERT INTO tematicas (id_tematica) VALUES (0)";
        $operacion = $base_datos->haz_consulta($consulta);
        if (!$operacion) { $operaciones = FALSE; }
        else
        {
            $id_tematica = mysqli_insert_id($base_datos->conexion);
            foreach ($idiomas as $id_idioma => $idioma)
            {
                $tematica = recoger_post("tematica_" . $id_idioma);
                $tematica = mysqli_real_escape_string($base_datos->conexion, trim($tematica));
                if (existe_tematica($tematica, $id_idioma)) { mostrar_error("La tem&aacute;tica <b>" . htmlentities($tematica, ENT_COMPAT, 'utf-8') . "</b> ya existe para el idioma $idioma."); return FALSE; }
                else
                {
                    $consulta = "INSERT INTO tematica_idioma (id_tematica, id_idioma, tematica) VALUES ($id_tematica, $id_idioma, '$tematica')";
                    $operacion = $base_datos->haz_consulta($consulta);
                    if (!$operacion) { $operaciones = FALSE; }
                }
            }
        }
        
        return $operacion;
    }
    
    
    //Funcion que elimina una tematica existente:
    function eliminar_tematica($id_tematica)
    {
        global $base_datos;

        //$etiqueta = mysqli_real_escape_string($base_datos->conexion, $etiqueta);
        
        $consulta = "DELETE FROM libro_tematica WHERE id_tematica = $id_tematica";
        $operacion1 = $base_datos->haz_consulta($consulta);

        $consulta = "DELETE FROM tematica_idioma WHERE id_tematica = $id_tematica";
        $operacion2 = $base_datos->haz_consulta($consulta);

        $consulta = "DELETE FROM tematicas WHERE id_tematica = $id_tematica";
        $operacion3 = $base_datos->haz_consulta($consulta);
        
        return ($operacion1 && $operacion2 && $operacion3);
    }
    
    
    //Funcion que modifica una tematica existente:
    function modificar_tematica($id_tematica)
    {
        global $base_datos;

        //$etiqueta = strtoupper(mysqli_real_escape_string($base_datos->conexion, $etiqueta));
        $idiomas = obtener_idiomas();
        if (!sizeof($idiomas)) { mostrar_error("No se pueden agregar tem&aacute;ticas si no hay idiomas."); return FALSE; }                
        
        //Recoge los input text de cada idioma de la tematica enviada y modifica:
        $operaciones = TRUE;
        foreach ($idiomas as $id_idioma => $idioma)
        {
            $tematica = mysqli_real_escape_string($base_datos->conexion, trim(recoger_post("tematica_" . $id_idioma)));
            $consulta = "UPDATE tematica_idioma SET tematica = '$tematica' WHERE id_tematica = $id_tematica AND id_idioma = $id_idioma";
            $operacion_actual = $base_datos->haz_consulta($consulta);
            if (!$operacion_actual) { $operaciones = FALSE; }
        }

        return $operaciones;
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Gesti&oacute;n de etiquetas traducibles</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar(registro)
            {
                return confirm("Pulsa aceptar para eliminar el registro " + registro);
            }

            <?php
            //Conecta a la base de datos:
            $base_datos = new base_datos();
            $base_datos->conecta();

            //Selecciona la base de datos:
            $base_datos->selecciona();
            ?>
            
            function comprobar_formulario_agregar()
            {
                <?php
                $idiomas = obtener_idiomas();
                foreach ($idiomas as $id_idioma => $idioma)
                {
                    ?>
                    if (document.getElementById("tematica_nueva_<?php echo $id_idioma; ?>").value == "") { return false; }
                    <?php
                }
                ?>
                return true;
            }
        // -->
        </script>
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Gesti&oacute;n de tem&aacute;ticas</h2>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Desconecta de la base de datos:
            $base_datos->desconecta();

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
