<?php
    set_time_limit(0);

    //Incluye el archivo para recoger variables por POST:
    require_once "../cod/func/web/recoger_post.php";

    //Incluye el archivo para mostrar errores:
    require_once "../cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    require_once "../cod/func/web/advertencia.php";


    //Guarda que pagina es esta:
    $this_file = "visor_logs.php";
    
    
    //Comprueba si se ha enviado el formulario:
    function se_ha_enviado_formulario()
    {
        return recoger_post("accion");
    }
    

    //Muestra el formulario:
    function mostrar_formulario()
    {
        global $this_file;

        $directorio = "../info/logs/";
        $directorio_puntero = opendir($directorio);

        echo '<br><center><table border="1" align="center">';
        
        $hayArchivos = FALSE;
        while ($archivo = readdir($directorio_puntero))
        {
            if ($archivo != "." && $archivo != ".." && $archivo != "index.htm" && file_exists($directorio . $archivo))
            {
                $hayArchivos = TRUE;
                echo '<tr><td>';
                echo $archivo;
                echo '</td><td>';
                echo '<form method="post" action="' . $this_file . '">';
                echo '<input type="hidden" name="accion" value="ver">';
                echo '<input type="hidden" name="archivo" value="' . $archivo . '">';
                echo '<input type="submit" name="boton" value="Ver">';
                echo '</form>';
                echo '</td><td>';
                echo '<form method="post" action="' . $this_file . '" onSubmit="return confirmar_eliminar();">';
                echo '<input type="hidden" name="accion" value="eliminar">';
                echo '<input type="hidden" name="archivo" value="' . $archivo . '">';
                echo '<input type="submit" name="boton" value="Eliminar">';
                echo '</form>';
                echo '</td></tr>';
            }
        }
        
        if (!$hayArchivos) { echo "<tr><td class=\"destacado\">No hay archivos de error o advertencias</td></tr>"; }
        
        echo '</table></center>';
    }
    
    
    //Procesa el formulario:
    function procesar_formulario()
    {
        $accion = recoger_post("accion");
        $archivo = recoger_post("archivo");
        
        switch ($accion)
        {
            case "ver":
                if (trim($archivo) != "") { mostrar_archivo($archivo); }
                else { mostrar_error("No se pudo procesar el formulario ya que faltan datos."); }
                break;
            case "eliminar":
                if (trim($archivo) != "") { eliminar_archivo($archivo); }
                else { mostrar_error("No se pudo procesar el formulario ya que faltan datos."); }
                break;
            default:
                mostrar_error("No se pudo procesar el formulario ya que faltan datos.");
        }
    }
    
    
    //Funcion que muestra un archivo de registro:
    function mostrar_archivo($archivo)
    {
        $directorio = "../info/logs/";

        echo '<br><center><table border="1" align="center"><tr><td class="destacado" align="center"><center>'. $directorio . $archivo . '</center></td></tr><tr><td align="left" class="codigo"><div align="left">';
        
        if (file_exists($directorio . $archivo))
        {
            $contenido = implode("", file($directorio . $archivo));
            $contenido = nl2br($contenido);
            $contenido = str_replace("<br />", "<br><br>", $contenido);
            echo $contenido;
        }
        else { mostrar_error("No se pudo encontrar el archivo $directorio$archivo"); }
        
        echo '</div></td></tr></table></center>';
    }
    
    
    //Funcion que borra un archivo de registro:
    function eliminar_archivo($archivo)
    {
        $directorio = "../info/logs/";

        if (file_exists($directorio . $archivo))
        {
            $operacion = unlink($directorio . $archivo);
            if ($operacion) { mostrar_advertencia("Archivo $directorio$archivo eliminado correctamente."); }
            else { mostrar_error("El archivo $directorio$archivo no pudo ser eliminado."); }
        }
        else { mostrar_error("No se pudo encontrar el archivo $directorio$archivo"); }
    }
?>
<html>
    <head>
        <title>Alba Patchwork - Visor de logs (registros)</title>
        <link rel="stylesheet" type="text/css" href="css/admin.css" title="defecto">
        <script language="JavaScript">
        <!--
            function confirmar_eliminar()
            {
                return confirm("Pulsa aceptar para eliminar el archivo");
            }
        // -->
        </script>
    </head>
    <body>
        <center>
        <a name="arriba"></a>
        <h1 align="center">Alba Patchwork</h1>
        <h2 align="center">Visor de logs (registros)</h2>
        <br>
        Pueden verse los errores AJAX con sus c&oacute;digos en <a href="errores_ajax.txt" target="_blank">errores_ajax.txt</a>.
        <br>
        <br>
        </center>
        <?php
            //Incluye el codigo para volver al menu principal:
            include "atras.php";

            //Enlace para volver abajo de la pagina:
            include "abajo.php";

            //Si el formulario se ha enviado, lo procesa:
            if (se_ha_enviado_formulario())
            {
                procesar_formulario();
                mostrar_formulario();
            }
            //...pero si no, lo muestra:
            else { mostrar_formulario(); }

            //Enlace para volver arriba de la pagina:
            include "arriba.php";
        ?>
        <a name="abajo"></a>
    </body>
</html>
