<?php

    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    //Incluye los archivos requeridos:
    if (file_exists("web/recoger_get.php")) { require_once "web/recoger_get.php"; }
    else if (file_exists("func/web/recoger_get.php")) { require_once "func/web/recoger_get.php"; }
    if (file_exists("web/recoger_post.php")) { require_once "web/recoger_post.php"; }
    else if (file_exists("func/web/recoger_post.php")) { require_once "func/web/recoger_post.php"; }
    if (file_exists("web/recoger_sesion.php")) { require_once "web/recoger_sesion.php"; }
    else if (file_exists("func/web/recoger_sesion.php")) { require_once "func/web/recoger_sesion.php"; }
    if (file_exists("web/error.php")) { require_once "web/error.php"; }
    else if (file_exists("func/web/error.php")) { require_once "func/web/error.php"; }

    //Incluye el archivo necesario para quitar acentos:
    if (file_exists("cod/func/web/quitar_acentos.php")) { include_once "cod/func/web/quitar_acentos.php"; }
    else if (file_exists("func/web/quitar_acentos.php")) include_once "func/web/quitar_acentos.php";


    $usando_ajax = recoger_post("usando_ajax");
    if (isset($usando_ajax) && $usando_ajax == "si")
    {
        header("Cache-Control: no-store, no-cache, must-revalidate");
        header("Pragma: no-cache");
        session_name("albapatch_session");
        session_start();
        require_once "config/config.php";
        require_once "func/db/db.php";
        //$this_file = recoger_post("this_file");
        //require_once "func/javascript.php";
        $base_datos = new base_datos();
        $base_datos->conecta();
        $base_datos->selecciona();

        require_once "func/id_categoria.php";


        $this_file = recoger_post("this_file");

        require_once "func/javascript.php";
    //Incluye el recogedor del detector de JavaScript:
    //include_once "func/javascript_recogedor.php";

    //Incluye el archivo detector de AJAX:
    //include_once "func/ajax.php";


        require_once "func/idioma.php";
        //if (file_exists("web/etiquetas.php")) { require_once "web/etiquetas.php"; }
        //else if (file_exists("func/etiquetas.php")) { require_once "func/etiquetas.php"; }
        $id_idioma = recoger_post("id_idioma");


        //Si no se ha podido recoger, se intenta recoger por GET:
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = recoger_get("categoria"); }
        //...y si no, se intenta recoger por POST:
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = recoger_post("categoria"); }
        //...y si no, se intenta recoger por POST (como id_idioma):
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = recoger_post("id_idioma"); }
        //...y si no, se define el idioma por defecto:
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = $constantes["IDIOMA_POR_DEFECTO"]; }
        //...y si no, se define el idioma 1:
        if (!$id_idioma || !is_numeric($id_idioma) || $id_idioma == "") { $id_idioma = 1; }


        setear_sesion("idioma", $id_idioma);
        
        require_once "func/etiquetas.php";
        
        require_once "func/constantes.php";
        require_once "func/resolucion.php";
        $id_categoria = recoger_post("id_categoria");

        //Si no se ha podido recoger, se intenta recoger por GET:
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = recoger_get("categoria"); }
        //...y si no, se intenta recoger por POST:
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = recoger_post("categoria"); }
        //...y si no, se intenta recoger por POST (como id_categoria):
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = recoger_post("id_categoria"); }
        //...y si no, se define la categoria segun el archivo actual:
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = obtener_id_categoria_archivo($this_file); }
        //...y si no, se define la categoria principal (la de inicio):
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = $constantes["INICIO_ID"]; }
        //...y si no, se define la categoria 1:
        if (!$id_categoria || !is_numeric($id_categoria) || $id_categoria == "") { $id_categoria = 1; }


       
        require_once "func/categorias.php";

        $this_file = recoger_post("this_file");

        crear_menu_banderas();
        
        $base_datos->desconecta();
        //$id_idioma = recoger_post("id_idioma");
    }
    else
    {
        crear_menu_banderas();
    }


    //Funcion que muestra una bandera:
    function mostrar_bandera($idioma_bandera, $id_idioma_bandera, $archivo = FALSE, $directorio = FALSE)
    {
        global $id_sesion;
        global $this_file;
        global $id_idioma;
        global $id_categoria;
        global $ajax_soportado;
        global $id_categoria;
        
        $idioma_bandera = htmlentities(ucfirst($idioma_bandera), ENT_COMPAT, 'utf-8');

        if ($archivo && $directorio) { $contenido = '<img src="' . $directorio . quitar_acentos($archivo) . '" title="' . $idioma_bandera . '" alt="' . $idioma_bandera . '" width="20" height="10" border="0" hspace="0" vspace="0">'; }
        else { $contenido = "[<b>$idioma_bandera</b>]"; }

        $codigoJS_click = "";
        if ($ajax_soportado)
        {
            //$variables = "id_categoria=$id_categoria&id_idioma=$id_idioma_bandera&this_file=$this_file";
            //$codigoJS_click = ' onClick="cambiar_categoria(\'' . $variables . '\'); return false;"';
            $codigoJS_click = ' onClick="cambiar_categoria(\'' . $id_categoria . '\', \'' . $id_idioma_bandera . '\', \'' . $this_file . '\'); return false;"';
            //$codigoJS_click = ' onclick="alert(\''.addslashes(htmlentities($codigoJS_clicka)).'\'); return false;"';
        }
        
        if ($id_idioma_bandera != $id_idioma) { echo '<a href="' . quitar_acentos($this_file) . '?idioma=' . $id_idioma_bandera . '&categoria=' . $id_categoria . '&' . $id_sesion . '" title="' . $idioma_bandera . '"' . $codigoJS_click . '>' . $contenido . '</a> '; }
        else { echo $contenido . ' '; }
    }


    function crear_menu_banderas()
    {
        global $idiomas, $usando_ajax;
        
        if (sizeof($idiomas) > 1)
        {
            $extensiones = Array(".gif", ".jpg", ".jpeg", ".png");
            foreach ($idiomas as $id_idioma => $idioma)
            {
                $existe_bandera = FALSE;
                foreach ($extensiones as $extension)
                {
                    
                    if ($usando_ajax) { $directorio_comprobar = "../img/web/banderas/"; }
                    else { $directorio_comprobar = "img/web/banderas/"; }
                    $directorio = "img/web/banderas/";
                    
                    $idioma = strtolower(html_entity_decode($idioma));
                    if (file_exists($directorio_comprobar . $id_idioma . $extension)) { $existe_bandera = TRUE; mostrar_bandera($idioma, $id_idioma, $id_idioma . $extension, $directorio); break; }
                    else if (file_exists($directorio_comprobar . quitar_acentos($idioma) . $extension)) { $existe_bandera = TRUE;  mostrar_bandera($idioma, $id_idioma, $idioma . $extension, $directorio); break; }
                }
                if (!$existe_bandera) { mostrar_bandera($idioma, $id_idioma); }
            }
        }
    }
?>
