<?php

    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    //Funcion que devuelve las categorias en una matriz:
    /*
    function obtener_categorias_todas()
    {
        global $base_datos, $constantes, $id_idioma;
        $categorias = Array();
        
        //if (!isset($constantes["IDIOMA_POR_DEFECTO"]) || isset($constantes["IDIOMA_POR_DEFECTO"]) && (trim($constantes["IDIOMA_POR_DEFECTO"]) == "" || !is_numeric(trim($constantes["IDIOMA_POR_DEFECTO"])))) { mostrar_error('No se pudo recoger un idioma por defecto. Por favor, define la constante del idioma por defecto en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        //else { $idioma_por_defecto = $constantes["IDIOMA_POR_DEFECTO"]; }
        
        $consulta = "SELECT * FROM categorias AS a JOIN categoria_idioma AS b WHERE mostrar != 0 AND a.id_categoria = b.id_categoria AND b.id_idioma = $id_idioma";
        $resultados = $base_datos->haz_consulta($consulta);
        
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            $nombre_categoria = $row["nombre_categoria"];
            $categorias[$id_categoria] = $nombre_categoria;
        }
        
        return $categorias;
    }
    */

    
    //Funcion que pone los proyectos (sin titulo, para la seccion Proyectos):
    function proyecto_sin_titulo($titulo, $descripcion = "", $nombre_imagen_y_pdf = "")
    {
        proyecto($titulo, $descripcion, $nombre_imagen_y_pdf, FALSE, TRUE);
    }


    //Funcion que pone los proyectos:
    $proyectos_presentados = 0;
    function proyecto($titulo, $descripcion = "", $nombre_imagen_y_pdf = "", $poner_titulo = TRUE)
    {
        global $proyectos_presentados, $id_categoria, $margen_body, $margen_tablas, $constantes, $id_sesion;
        
        if (trim($nombre_imagen_y_pdf) == "") { $nombre_imagen_y_pdf = $id_categoria; }

        $proyectos_presentados++;
		
		$bordes_redondos_tabla_proyectos = "";
		if ($proyectos_presentados <= 1) { $bordes_redondos_tabla_proyectos = ' class="proyectos_tabla_titulo"'; }
        if ($proyectos_presentados <= 1 && $poner_titulo)
        {
            echo '<center><table border="0" width="' . ($margen_body - $margen_tablas) . '" bgcolor="' . $constantes["COLOR_PRODUCTO_RECUADRO1"] . '" align="center" class="proyectos_tabla_titulo">';
            echo '<tr><td class="proyectos_td_titulo" align="center"><center>';
            echo "<h2>" . usar_etiqueta("PROYECTOS_TITULO") . "</h2>";
            echo '</center></td></tr>';
            echo '</table></center>';
            $bordes_redondos_tabla_proyectos = "";
        }
        
        echo '<center><table border="0" width="' . ($margen_body - $margen_tablas) . '" bgcolor="' . $constantes["COLOR_PRODUCTO_RECUADRO1"] . '" align="center"' . $bordes_redondos_tabla_proyectos . '><tr>';

		echo '<td class="proyectos_td_imagen" align="center" width="' . ($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]+25) . '">';
        
        echo '<center><a href="' . obtener_pdf_proyecto($nombre_imagen_y_pdf) . '?' . $id_sesion . '" target="_blank">';
        
        $imagen = obtener_imagen_proyecto($nombre_imagen_y_pdf);
        echo obtener_proyecto_codigo_imagen($imagen, $titulo);
        
        echo '</a><center>';
        
        echo '</td>';

        echo '<td class="proyectos_td_contenido"><font color="#ffffff" size="3" face="verdana" class="producto">';
        echo '<center><a href="' . obtener_pdf_proyecto($nombre_imagen_y_pdf) . '?' . $id_sesion . '" target="_blank" class="menu2">';
        echo "$titulo";
        $ancho_tabla_texto = ( (($margen_body - $margen_tablas) - ($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"]+25)) - 95 );
        if ($ancho_tabla_texto < 125) { $ancho_tabla_texto = 125; }
        echo '</a><table border="0" cellspacing="0" cellpadding="0" align="center" width="' . $ancho_tabla_texto . '"><tr><td><font color="#ffffff" size="3" face="verdana" class="producto">';
        if (trim($descripcion) != "") { echo "<br><br>" . htmlentities($descripcion, ENT_COMPAT, 'utf-8'); }
        echo '</font>';
		
		echo "<br><br>";
		
		echo '[<a href="' . obtener_pdf_proyecto($nombre_imagen_y_pdf) . '?' . $id_sesion . '" target="_blank" class="menu2">';
		echo usar_etiqueta("PROYECTOS_DOWNLOAD");
		echo "</a>]";
		
		mostrar_colecciones_implicadas_proyecto($nombre_imagen_y_pdf);
		
		echo '</td></tr></table></center></font></td></tr>';

        echo '</table></center>';
    }


	//Funcion que muestra las colecciones (categorias) implicadas con un proyecto:
	function mostrar_colecciones_implicadas_proyecto($id_categorias)
	{
		global $id_sesion, $this_file, $id_idioma, $ajax_soportado, $id_categoria;
	
		$id_categorias = explode("_", $id_categorias);
		$categorias = obtener_categorias_todas();
		
		if (!is_array($categorias) || sizeof($categorias) <= 0) { return ""; }

		$html = '<br><br><font color="#ffffff" size="2" face="verdana" class="producto">';
		$html .= usar_etiqueta("PROYECTOS_COLECCIONES_IMPLICADAS") . ":</font><br>";

		$html .= '<font color="#000000" size="2" face="verdana" class="producto">';

		$x = 0;
		foreach($id_categorias as $id_categoria_loop)
		{
			$id_categoria_loop = trim($id_categoria_loop);
			if (!is_numeric($id_categoria_loop) || !isset($categorias[$id_categoria_loop]) || trim($categorias[$id_categoria_loop]) == "") { continue; }
			$nombre_categoria = htmlentities(trim($categorias[$id_categoria_loop]), ENT_COMPAT, 'utf-8');
			
			if ($x > 0) { $html .= "<br>"; }
			
			$x++;

	        $codigoJS_click = "";
			if ($ajax_soportado)
    	    {
	            $codigoJS_click = ' onClick="cambiar_categoria(\'' . $id_categoria_loop . '\', \'' . $id_idioma . '\', \'' . $this_file . '\'); return false;"';
    	    }
			
			if ($id_categoria == $id_categoria_loop)
			{
				$html .= $nombre_categoria;
			}
			else
			{
				$html .= '<a href="' . $this_file . '?' . $id_sesion . '&categoria=' . $id_categoria_loop . '&idioma=' . $id_idioma . '&directo=1" class="menu2" title="' . $nombre_categoria . '"' . $codigoJS_click . '>' . $nombre_categoria . '</a>';
			}
		}
		
		echo $html;
		
		echo "</font>";
	}

    //Funcion que obtiene la imagen del proyecto:
    function obtener_imagen_proyecto($nombre_imagen_y_pdf)
    {
        global $usando_ajax;
        $directorio = "img/proyectos/";
        if (isset($usando_ajax) && $usando_ajax == "si") { $directorio = "../" . $directorio; }
        
        if (file_exists($directorio . nombre_archivo_correcto($nombre_imagen_y_pdf) . ".gif")) { $imagen = nombre_archivo_correcto($nombre_imagen_y_pdf) . ".gif"; }
        else if (file_exists($directorio . nombre_archivo_correcto($nombre_imagen_y_pdf) . ".jpg")) { $imagen = nombre_archivo_correcto($nombre_imagen_y_pdf) . ".jpg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($nombre_imagen_y_pdf) . ".jpeg")) { $imagen = nombre_archivo_correcto($nombre_imagen_y_pdf) . ".jpeg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($nombre_imagen_y_pdf) . ".png")) { $imagen = nombre_archivo_correcto($nombre_imagen_y_pdf) . ".png"; }
        else { $imagen = "img/error.gif"; }
        return $imagen;
    }


    //Funcion que obtiene la imagen del proyecto:
    function obtener_pdf_proyecto($nombre_imagen_y_pdf)
    {
        global $usando_ajax;
        $directorio = "descargas/proyectos/";
        $pdf = $directorio . nombre_archivo_correcto($nombre_imagen_y_pdf) . ".pdf";
        return $pdf;
    }


    //Funcion que devuelve el codigo HTML de la imagen de un proyecto enviado:
    function obtener_proyecto_codigo_imagen($imagen, $titulo = "")
    {
        global $constantes, $margen_body;
        
        $codigo = "";
        
        $directorio = "img/proyectos/";
        $directorio_zoom = "img/proyectos/zoom/";
        //$codigo = imagen_ampliable($imagen, $directorio, $directorio_zoom, false, $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"], $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"]);
        
        $ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
        
        //echo "$margen_body ($alto x $ancho) ... ";
        
		$version_encogida = FALSE;
        if (($margen_body - 100) <= $ancho) { $version_encogida = TRUE; }
		
		$codigo = imagen_ampliable($imagen, $directorio, $directorio_zoom, false, -1, -1, -1, -1, $titulo, $version_encogida);
        
        return $codigo;
    }


    //Funcion que devuelve todas las categorias en una matriz:
    function obtener_categorias_todas()
    {
        global $base_datos, $constantes, $id_idioma;
        $categorias = Array();
        
        //if (!isset($constantes["IDIOMA_POR_DEFECTO"]) || isset($constantes["IDIOMA_POR_DEFECTO"]) && (trim($constantes["IDIOMA_POR_DEFECTO"]) == "" || !is_numeric(trim($constantes["IDIOMA_POR_DEFECTO"])))) { mostrar_error('No se pudo recoger un idioma por defecto. Por favor, define la constante del idioma por defecto en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        //else { $idioma_por_defecto = $constantes["IDIOMA_POR_DEFECTO"]; }
        
        $consulta = "SELECT * FROM categorias AS a JOIN categoria_idioma AS b WHERE mostrar != 0 AND a.id_categoria = b.id_categoria AND b.id_idioma = $id_idioma ORDER BY a.orden";
        $resultados = $base_datos->haz_consulta($consulta);
        
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            $nombre_categoria = $row["nombre_categoria"];
            $categorias[$id_categoria] = $nombre_categoria;
        }
        
        return $categorias;
    }


    //Funcion que devuelve las categorias principales en una matriz:
    function obtener_categorias()
    {
        global $base_datos, $constantes, $id_idioma;
        $categorias = Array();
        
        //if (!isset($constantes["IDIOMA_POR_DEFECTO"]) || isset($constantes["IDIOMA_POR_DEFECTO"]) && (trim($constantes["IDIOMA_POR_DEFECTO"]) == "" || !is_numeric(trim($constantes["IDIOMA_POR_DEFECTO"])))) { mostrar_error('No se pudo recoger un idioma por defecto. Por favor, define la constante del idioma por defecto en <a href="constantes_predefinidas.php">constantes predefinidas</a>.'); exit(); }
        //else { $idioma_por_defecto = $constantes["IDIOMA_POR_DEFECTO"]; }
        
        $consulta = "SELECT * FROM categorias AS a JOIN categoria_idioma AS b WHERE mostrar != 0 AND raiz = 0 AND a.id_categoria = b.id_categoria AND b.id_idioma = $id_idioma ORDER BY a.orden";
        $resultados = $base_datos->haz_consulta($consulta);
        
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            $nombre_categoria = $row["nombre_categoria"];
            $categorias[$id_categoria] = $nombre_categoria;
        }
        
        return $categorias;
    }

    //Funcion que devuelve las categorias principales en una matriz (ordenadas para el menu):
    function obtener_categorias_principales()
    {
        global $base_datos, $constantes, $id_idioma;

        $categorias = obtener_categorias();
        $categorias_principales = Array();
        
        $consulta = "SELECT * FROM menu_subgrupos_categorias ORDER BY orden";
        $resultados = $base_datos->haz_consulta($consulta);
        
        while ($row = mysqli_fetch_assoc($resultados))
        {
			$id_categoria = $row["id_categoria"];
            if (!isset($categorias[$id_categoria])) { continue; }
            $nombre_categoria = $categorias[$id_categoria];
            $categorias_principales[$id_categoria] = $nombre_categoria;
        }
        
        return $categorias_principales;
    }


    //Funcion que devuelve las categorias hija de una padre dada:
    function obtener_categorias_hijas($id_categoria)
    {
        global $base_datos, $constantes, $id_idioma;
        $categorias = Array();
        
        $consulta = "SELECT * FROM categorias AS a JOIN categoria_idioma AS b WHERE mostrar != 0 AND raiz = $id_categoria AND a.id_categoria = b.id_categoria AND b.id_idioma = $id_idioma ORDER BY a.orden, nombre_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            $nombre_categoria = $row["nombre_categoria"];
            $categorias[$id_categoria] = $nombre_categoria;
        }

        //Obtiene categorias adoptadas:
        /*
        $consulta = "SELECT * FROM categorias_adoptadas WHERE id_categoria_adoptiva = $id_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        $categorias_todas = obtener_categorias_todas();
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria_adoptada = $row["id_categoria"];
            $nombre_categoria = $categorias_todas[$id_categoria_adoptada];
            $categorias[$id_categoria] = $nombre_categoria;
            echo "HIJA ADOPTIVA!!! $id_categoria_adoptada ($id_categoria) ===> $nombre_categoria";
        }
        */
        
        return $categorias;
    }


    //Funcion que retorna si una categoria es la hija de otra o no:
    function categoria_hija_padre($id_categoria, $id_categoria_enlace)
    {
        $es_padre = FALSE;
        $padre = padre_de($id_categoria);
        while ($padre != 0)
        {
            if ($padre == $id_categoria_enlace) { $es_padre = TRUE; break; }
            $padre = padre_de($padre);
        }
        //if ($es_padre) { echo "Categoria $id_categoria es la hija de $id_categoria_enlace<br><br>"; }
        return $es_padre;
    }
    
    //Funcion que retorna el padre de una categoria:
    function padre_de($id_categoria)
    {
        global $base_datos;
        
        $consulta = "SELECT raiz FROM categorias WHERE id_categoria = $id_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $row = mysqli_fetch_assoc($resultados);
        
        $raiz = $row["raiz"];
        
        return $raiz;
    }

    
    //Funcion que devuelve el primer padre (categoria principal) de una categoria dada:
    function raiz_original_de($id_categoria)
    {
        $id_categoria_padre = $id_categoria;
        while ($id_categoria_padre != 0)
        {
            $id_categoria = $id_categoria_padre;
            $id_categoria_padre = padre_de($id_categoria);
        }
        return $id_categoria;
    }


    //Funcion que devuelve una matriz con el archivo de cada categoria principal:
    function categorias_archivo()
    {
        global $base_datos, $constantes;
        
        $consulta = "SELECT * FROM categoria_archivo";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $categoria_archivo = Array();
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            $archivo_categoria = $row["archivo"];
            $categoria_archivo[$id_categoria] = $archivo_categoria;
            //echo "estooooo: $id_categoria = $archivo_categoria<br>";
        }

        return $categoria_archivo;
    }
?>
