<?php
    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Pragma: no-cache");
    session_name("albapatch_session");
    session_start();

    //Incluye los archivos requeridos:
    if (file_exists("web/recoger_get.php")) { require_once "web/recoger_get.php"; }
    if (file_exists("web/recoger_post.php")) { require_once "web/recoger_post.php"; }
    if (file_exists("web/recoger_sesion.php")) { require_once "web/recoger_sesion.php"; }
    if (file_exists("web/error.php")) { require_once "web/error.php"; }
    
    //Recoge la variable para saber si se esta utilizando AJAX:
    $usando_ajax = recoger_post("usando_ajax");
    
    //Si no utiliza AJAX, sale del archivo:
    if ($usando_ajax != "si") { exit(0); }

    require_once "../config/config.php";
    require_once "db/db.php";

    $base_datos = new base_datos();
    $base_datos->conecta();
    $base_datos->selecciona();

    require_once "web/setear_sesion.php";
    require_once "productos.php";

    require_once "constantes.php";

    
    //Recoge las variables enviadas por POST:
    $ref_producto = trim(recoger_post("ref_producto"));
    $modalidad = trim(recoger_post("modalidad"));
    $cantidad = trim(recoger_post("cantidad"));
    $id_idioma = recoger_post("id_idioma");

    $contador_producto = trim(recoger_post("contador_producto"));


    if (file_exists("etiquetas.php")) { require_once "etiquetas.php"; }
    
    //Agrega cesta_funciones.php
    require_once "cesta_funciones.php";
    
    //require_once "resolucion.php";
    require_once "resolucion.php";
    
    //Comprueba que el producto sea licito para la cuenta actual:
    echo '<table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center>';
    
    //echo usar_etiqueta("PRECIO_TOTAL") . ": " . number_format(calcular_total(), usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . " " . usar_etiqueta("EURO");

    echo usar_etiqueta("PRECIO_SIN_GASTOS_ENVIO") . ": " . number_format(calcular_total(), usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . " " . usar_etiqueta("EURO");
    echo "<br><b>";
    echo usar_etiqueta("PRECIO_TOTAL") . ": " . number_format(calcular_total() + $constantes["GASTOS_ENVIO"], usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . " " . usar_etiqueta("EURO");
    echo "</b>";
    
    echo '</center></td></tr></table>';
    
    $base_datos->desconecta();
?>
