<?php
    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Pragma: no-cache");
    session_name("albapatch_session");
    session_start();

    //Incluye los archivos requeridos:
    if (file_exists("web/recoger_get.php")) { require_once "web/recoger_get.php"; }
    if (file_exists("web/recoger_post.php")) { require_once "web/recoger_post.php"; }
    if (file_exists("web/recoger_sesion.php")) { require_once "web/recoger_sesion.php"; }
    if (file_exists("web/error.php")) { require_once "web/error.php"; }

    //Recoge la variable para saber si se esta utilizando AJAX:
    $usando_ajax = recoger_post("usando_ajax");
    
    //Si no utiliza AJAX, sale del archivo:
    if ($usando_ajax != "si") { exit(0); }

    require_once "../config/config.php";
    require_once "db/db.php";

    $base_datos = new base_datos();
    $base_datos->conecta();
    $base_datos->selecciona();

    require_once "web/setear_sesion.php";
    require_once "productos.php";

    require_once "constantes.php";

    
    //Recoge las variables enviadas por POST:
    $ref_producto = trim(recoger_post("ref_producto"));
    $modalidad = trim(recoger_post("modalidad"));
    $cantidad = trim(recoger_post("cantidad"));

    //Agrega cesta_funciones.php
    require_once "cesta_funciones.php";
    
    //Comprueba que el producto sea licito para la cuenta actual:
    if (producto_licito($ref_producto, $cantidad, $modalidad))
    {
        //Lo agrega:
        $agregado = agregar_producto($ref_producto, $cantidad, $modalidad);
        
        //Si lo ha agregado, devuelve "ok":
        if ($agregado)
        {
            echo "ok";
        }
        //...si no, devuelve error:
        else { echo "error"; }
    }
    //...si no, devuelve error:
    else
    {
        echo "error";
    }
    
  
    
    $base_datos->desconecta();
?>
