<?php
//Permite una demora de carga "infinita":
if (!ini_get("safe_mode")) { @set_time_limit(0); }

//Incluye los archivos necesarios:
require_once "cod/func/web/registrar.php";
include_once "cod/func/web/advertencia.php";
include_once "cod/func/web/error.php";
include_once "cod/func/email.php";
include_once "cod/config/variables.php";

//Funcio que maneja los errores:
function manejador_errores($errno, $errstr, $errfile, $errline)
{
    global $constantes, $enviar_email_si_error, $email_errores_advertencias, $mostrar_errores;

    //Define los tipos de errores y nombre:
    $tipos_error = array (
                           E_ERROR           => 'ERROR',
                           E_WARNING         => 'WARNING',
                           E_PARSE           => 'PARSING ERROR',
                           E_NOTICE          => 'NOTICE',
                           E_CORE_ERROR      => 'CORE ERROR',
                           E_CORE_WARNING    => 'CORE WARNING',
                           E_COMPILE_ERROR   => 'COMPILE ERROR',
                           E_COMPILE_WARNING => 'COMPILE WARNING',
                           E_USER_ERROR      => 'USER ERROR',
                           E_USER_WARNING    => 'USER WARNING',
                           E_USER_NOTICE     => 'USER NOTICE',

                           E_USER_ERROR      => 'ERROR',
                           E_USER_WARNING    => 'WARNING',
                           E_USER_NOTICE     => 'NOTICE'

                           //E_STRICT         => 'STRICT NOTICE',
                           //E_RECOVERABLE_ERROR  => 'RECOVERABLE ERROR'
               );

    
    //Define la cadena de texto del error:
    $texto = "";
    if (array_key_exists($errno, $tipos_error)) { $texto .= "[<b>" . $tipos_error[$errno] . "</b>] [$errno] $errstr (en la linea <b>$errline</b> del archivo <b>$errfile</b>)"; }
    //else { mostrar_advertencia("[<b>UNKNOWN</b>] [$errno] $errstr (en la linea <b>$errline</b> del archivo <b>$errfile</b>)", TRUE, FALSE); }
    else { $texto .= "[<b>UNKNOWN</b>] [$errno] $errstr (en la linea <b>$errline</b> del archivo <b>$errfile</b>)"; }

    //Si hay error, lo muestra y lo registra:
    if ($texto != "")
    {
        if (isset($constantes["MOSTRAR_ERRORES"])) { $mostrar_errores = $constantes["MOSTRAR_ERRORES"]; }
        else if (!isset($mostrar_errores)) { $mostrar_errores = FALSE; }
        
        //Muestra el error (pero no lo registra):
        if ($mostrar_errores) { mostrar_error($texto); }

        //Registra el error:
        registrar("error", $texto);

        //Si se ha definido enviar un email (o no se ha definido nada), lo envia:
        if (!isset($constantes) || !is_array($constantes) || !isset($constantes["ENVIAR_EMAIL_SI_ERROR"]) || isset($constantes["ENVIAR_EMAIL_SI_ERROR"]) && $constantes["ENVIAR_EMAIL_SI_ERROR"] || isset($enviar_email_si_error) && $enviar_email_si_error)
        {
            enviar_email_error($texto);
            /*
            if (isset($constantes["EMAIL_ERRORES_ADVERTENCIAS"]) && trim($constantes["EMAIL_ERRORES_ADVERTENCIAS"]) != "") { $email = $constantes["EMAIL_ERRORES_ADVERTENCIAS"]; }
            else if (isset($email_errores_advertencias) && trim($email_errores_advertencias) != "") { $email = $email_errores_advertencias; }
            else { $email = "email_errores_advertencias@noobtenido.com"; }
            $email_enviado = enviar_email($email, "error", $texto);
            if (!$email_enviado) { registrar("error", "No se pudo enviar un email a <b>" . $email . "</b> con la notificacion del error."); }
            */
        }
    }

    //Si es un error fatal, detiene la ejecucion (tambien lo notifica y lo registra):
    if ($errno == E_USER_ERROR)
    {
        if ($mostrar_errores)
        {
            mostrar_error("La ejecuci&oacuter;n se detuvo por un error fatal.", TRUE, TRUE);
        }
        registrar("error", "La ejecuci&oacuter;n se detuvo por un error fatal.");
        exit(1);
    }
    
    //No ejecuta el manejador de errores interno de PHP:
    return TRUE;
}

//Se define el nuevo manejador de errores:
$antiguo_manejador_errores = set_error_handler("manejador_errores");
?>
