<?php

    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    //Funcion que procesa todo lo necesario para mostrar los productos:
    function procesar_productos($id_categoria)
    {
        $productos = obtener_productos($id_categoria);
        mostrar_productos($productos);
    }


    //Funcion que obtiene cuantos metros es una pieza, para una tela en concreto:
    function obtener_metros_por_pieza($ref)
    {
        global $base_datos, $constantes;

        $metros = $constantes["METROS_PIEZA_POR_DEFECTO"];

        $consulta = "SELECT metros_pieza FROM tela_metros_pieza WHERE ref_tela LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);
    
        if (mysqli_num_rows($resultados) > 0)
        {
            $row = mysqli_fetch_assoc($resultados);
            if ($row["metros_pieza"] > 0)
            {
                $precio = $row["metros_pieza"];
            }
        }
        
        return $metros;
    }


    //Funcion que devuelve el minimo de centimetros permitidos para una tela:
    function obtener_minimo_centimetros($ref) //Nota: no comprueba si es una tela.
    {
        global $base_datos, $constantes;
        
        $minimo_centimetros = $constantes["MINIMO_CENTIMETROS_NORMAL_POR_DEFECTO"];

        $identificado = (recoger_sesion("identificado")) ? true : false;
        if ($identificado)
        {
            $minimo_centimetros = $constantes["MINIMO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"];

            $usuario = recoger_sesion("usuario");
            $tipo = recoger_sesion("tipo");
            
            $usuario = mysqli_real_escape_string($base_datos->conexion, trim($usuario));
            $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
            $tipo = mysqli_real_escape_string($base_datos->conexion, strtolower($tipo));
            
            if ($tipo != "particular" && $tipo != "empresa" && $tipo != "grupo") { return $minimo_centimetros; }
            if ($tipo == "" || $usuario == "" || $ref == "") { return $minimo_centimetros; }
        
            $sufijo = "s";
            if ($tipo == "particular") { $sufijo = "es"; }
            $consulta = "SELECT * FROM compradores_" . $tipo . $sufijo . " WHERE usuario LIKE '$usuario'";
            $resultados = $base_datos->haz_consulta($consulta);
            $row = mysqli_fetch_assoc($resultados);
            $id_usuario = $row["id_" . $tipo];
       
            $consulta = "SELECT * FROM tela_minimo_centimetros_$tipo WHERE id_$tipo = $id_usuario AND ref_tela LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
        
            if (mysqli_num_rows($resultados) > 0)
            {
                if (is_numeric($row["minimo_centimetros"]) && $row["minimo_centimetros"] > 0) { $minimo_centimetros = $row["minimo_centimetros"]; }
            }
        }
        
        return $minimo_centimetros;
    }
    

    //Funcion que devuelve el minimo de incremento de centimetros permitido para una tela:
    function obtener_incremento_centimetros($ref) //Nota: no comprueba si es una tela.
    {
        global $base_datos, $constantes;
        
        $incremento_centimetros = $constantes["INCREMENTO_CENTIMETROS_NORMAL_POR_DEFECTO"];

        $identificado = (recoger_sesion("identificado")) ? true : false;
        if ($identificado)
        {
            $incremento_centimetros = $constantes["INCREMENTO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"];

            $usuario = recoger_sesion("usuario");
            $tipo = recoger_sesion("tipo");
            
            $usuario = mysqli_real_escape_string($base_datos->conexion, trim($usuario));
            $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
            $tipo = mysqli_real_escape_string($base_datos->conexion, strtolower($tipo));
            
            if ($tipo != "particular" && $tipo != "empresa" && $tipo != "grupo") { return $incremento_centimetros; }
            if ($tipo == "" || $usuario == "" || $ref == "") { return $incremento_centimetros; }
        
            $sufijo = "s";
            if ($tipo == "particular") { $sufijo = "es"; }
            $consulta = "SELECT * FROM compradores_" . $tipo . $sufijo . " WHERE usuario LIKE '$usuario'";
            $resultados = $base_datos->haz_consulta($consulta);
            $row = mysqli_fetch_assoc($resultados);
            $id_usuario = $row["id_" . $tipo];
       
            $consulta = "SELECT * FROM tela_minimo_centimetros_$tipo WHERE id_$tipo = $id_usuario AND ref_tela LIKE '$ref'";
            $resultados = $base_datos->haz_consulta($consulta);
        
            if (mysqli_num_rows($resultados) > 0)
            {
                if (is_numeric($row["incremento_centimetros"]) && $row["incremento_centimetros"] > 0) { $incremento_centimetros = $row["incremento_centimetros"]; }
            }
        }
        
        if ($incremento_centimetros == 0) { $incremento_centimetros = 1; }
        
        return $incremento_centimetros;
    }


    //Funcion que devuelve si una cantidad minima de piezas se permite o no:
    function cantidad_piezas_permitida($ref, $cantidad_minima)
    {
        global $base_datos;
        
        $identificado = (recoger_sesion("identificado")) ? true : false;
        
        if (!$identificado) { return false; }
        
        $usuario = recoger_sesion("usuario");
        $tipo = recoger_sesion("tipo");
         
        $usuario = mysqli_real_escape_string($base_datos->conexion, trim($usuario));
        $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
        $tipo = mysqli_real_escape_string($base_datos->conexion, strtolower($tipo));
            
        if ($tipo != "particular" && $tipo != "empresa" && $tipo != "grupo") { return false; }
        if ($tipo == "" || $usuario == "" || $ref == "") { return false; }
        
        $sufijo = "s";
        if ($tipo == "particular") { $sufijo = "es"; }
        $consulta = "SELECT * FROM compradores_" . $tipo . $sufijo . " WHERE usuario LIKE '$usuario'";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $id_usuario = $row["id_" . $tipo];
       
        $consulta = "SELECT * FROM producto_comprador_$tipo WHERE id_$tipo = $id_usuario AND ref_producto LIKE '$ref' AND cantidad_minima = $cantidad_minima";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysqli_num_rows($resultados) > 0)
        {
            return true;
        }
        
        return false;
    }

    
    //Funcion que dice si un producto es una oferta o no:
    function es_oferta($ref)
    {
        global $base_datos, $constantes;

        $es_oferta = FALSE;
       
        $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
        
        $id_categoria = $constantes["OFERTAS_ID"];
        
        $consulta = "SELECT * FROM producto_categoria WHERE ref_producto LIKE '$ref' AND id_categoria = $id_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysqli_num_rows($resultados) > 0) { $es_oferta = TRUE; }
        
        //FALTA: igual que en es_novedad(), buscar en las hijas de Ofertas y sin olivdarse de la tabla categorias_adoptadas.
        
        return $es_oferta;
    }
    
    
    //Funcion que dice si un producto es una novedad o no:
    function es_novedad($ref)
    {
        global $base_datos, $constantes;

        $es_novedad = FALSE;
       
        $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
        
        $id_categoria = $constantes["NOVEDADES_ID"];
        
        $consulta = "SELECT * FROM producto_categoria WHERE ref_producto LIKE '$ref' AND id_categoria = $id_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysqli_num_rows($resultados) > 0) { $es_novedad = TRUE; }


        $consulta = "SELECT * FROM producto_categoria WHERE ref_producto LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);
        
        while (!$es_novedad && $row = mysqli_fetch_assoc($resultados))
        {
            $id_categoria = $row["id_categoria"];
            if (categoria_hija_padre($id_categoria, $constantes["NOVEDADES_ID"]))
            {
                $es_novedad = TRUE;
                break;
            }
            
            $consulta2 = "SELECT * FROM categorias_adoptadas WHERE id_categoria = $id_categoria";
            $resultados2 = $base_datos->haz_consulta($consulta2);
            while ($row2 = mysqli_fetch_assoc($resultados2))
            {
                $id_categoria_padre = $row2["id_categoria_adoptiva"];
                if (categoria_hija_padre($id_categoria_padre, $constantes["NOVEDADES_ID"]))
                {
                    $es_novedad = TRUE;
                    break;
                }
            }
        }
       
        return $es_novedad;
    }

    //Funcion que obtiene el tipo de un producto:
    function obtener_tipo($ref)
    {
        global $base_datos;

        $tipo = "otro";

        $consulta = "SELECT tipo FROM producto_tipo WHERE ref_producto LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);
    
        if (mysqli_num_rows($resultados) > 0)
        {
            $row = mysqli_fetch_assoc($resultados);
            if (trim($row["tipo"]) != "")
            {
                $tipo = $row["tipo"];
            }
        }
        
        //echo "$ref es $tipo<br><br>";
        
        return $tipo;
    }


    //Funcion que obtiene las colecciones de un producto:
    function obtener_colecciones_producto($ref)
    {
        global $base_datos;

        $colecciones = Array();

        $consulta = "SELECT id_coleccion FROM producto_coleccion WHERE ref_producto LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);
    
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_coleccion = $row["id_coleccion"];
            $colecciones[] = htmlentities($id_coleccion, ENT_COMPAT, 'utf-8');
        }
        
        return $colecciones;
    }


    //Funcion que obtiene los diseadores de un producto (que sera una tela):
    function obtener_disenyadores_producto($ref)
    {
        global $base_datos;

        $disenyadores = Array();

        $consulta = "SELECT id_disenyador FROM tela_disenyador WHERE ref_tela LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);
    
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_disenyador = $row["id_disenyador"];
            $disenyadores[] = htmlentities($id_disenyador, ENT_COMPAT, 'utf-8');
        }
        
        return $disenyadores;
    }

    //Funcion que obtiene las tematicas de un producto (que sera un libro):
    function obtener_tematicas_producto($ref)
    {
        global $base_datos;

        $tematicas = Array();

        $consulta = "SELECT id_tematica FROM libro_tematica WHERE ref_libro LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);
    
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_tematica = $row["id_tematica"];
            $tematicas[] = htmlentities($id_tematica, ENT_COMPAT, 'utf-8');
        }
        
        return $tematicas;
    }


    //Funcion que obtiene los idiomas de un producto (que sera un libro):
    function obtener_idiomas_producto($ref)
    {
        global $base_datos;

        $idiomas = Array();

        $consulta = "SELECT id_idioma FROM libro_idioma WHERE ref_libro LIKE '$ref'";
        $resultados = $base_datos->haz_consulta($consulta);
    
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $id_idioma_temp = $row["id_idioma"];
            $idiomas[] = htmlentities($id_idioma_temp, ENT_COMPAT, 'utf-8');
        }
        
        return $idiomas;
    }


    //Funcion que obtiene los idiomas de un producto (que sera un libro):
    function obtener_nombre_producto($ref, $idioma_por_defecto = FALSE)
    {
        global $base_datos, $id_idioma, $constantes;

        $nombre = "";

        $consulta = "SELECT nombre FROM producto_nombre WHERE ref_producto LIKE '$ref' AND id_idioma = ";
        if (!$idioma_por_defecto) { $consulta .= $id_idioma; }
        else { $consulta .= $constantes["IDIOMA_POR_DEFECTO"]; }
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
    
        if (is_array($row))
        {
            $nombre = $row["nombre"];
        }

        return $nombre;
    }


    //Funcion que obtiene el precio normal de un producto:
    function obtener_precio_normal_producto($ref)
    {
        global $base_datos;

        $precio_normal = 0;

        $consulta = "SELECT precio_normal FROM productos WHERE ref LIKE '$ref' AND mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
    
        if (is_array($row))
        {
            $precio_normal = $row["precio_normal"];
        }

        return $precio_normal;
    }

    //Funcion que obtiene el precio para una cuenta de un producto (depende de la cantidad):
    function obtener_precio_cuenta_producto($ref, $cantidad, $usuario, $tipo, $es_pieza = FALSE)
    {
        global $base_datos;

        $precio_cuenta = obtener_precio_normal_producto($ref);

        $usuario = mysqli_real_escape_string($base_datos->conexion, trim($usuario));
        $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
        $tipo = mysqli_real_escape_string($base_datos->conexion, strtolower($tipo));
        if ($tipo != "particular" && $tipo != "empresa" && $tipo != "grupo") { return $precio_cuenta; }
        if ($tipo == "" || $usuario == "" || $ref == "") { return $precio_cuenta; }

        $sufijo = "s";
        if ($tipo == "particular") { $sufijo = "es"; }
        $consulta = "SELECT * FROM compradores_" . $tipo . $sufijo . " WHERE usuario LIKE '$usuario'";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $id_usuario = $row["id_" . $tipo];
        
        $es_pieza = ($es_pieza) ? 1 : 0;
        
        if ($es_pieza && ($cantidad == 1 || $cantidad == 0.5 || $cantidad == 0.25))
        {
            $consulta = "SELECT precio FROM producto_comprador_$tipo WHERE ref_producto LIKE '$ref' AND id_$tipo = $id_usuario AND cantidad_minima <= $cantidad AND piezas = $es_pieza ORDER BY cantidad_minima DESC";
            //echo "pieza de $cantidad";
        }
        else
        {
            $consulta = "SELECT precio FROM producto_comprador_$tipo WHERE ref_producto LIKE '$ref' AND id_$tipo = $id_usuario AND cantidad_minima <= $cantidad AND piezas = $es_pieza ORDER BY cantidad_minima DESC";
        }
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
    
        if (is_array($row))
        {
            $precio_cuenta = $row["precio"];
        }

        return $precio_cuenta;
    }


    
    //Funcion que obtiene la imagen del producto:
    function obtener_imagen_producto($ref)
    {
        global $usando_ajax;
        $directorio = "img/productos/";
        if (isset($usando_ajax) && $usando_ajax == "si") { $directorio = "../" . $directorio; }
        
        if (file_exists($directorio . nombre_archivo_correcto($ref) . ".gif")) { $imagen = nombre_archivo_correcto($ref) . ".gif"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpg")) { $imagen = nombre_archivo_correcto($ref) . ".jpg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpeg")) { $imagen = nombre_archivo_correcto($ref) . ".jpeg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".png")) { $imagen = nombre_archivo_correcto($ref) . ".png"; }
        else { $imagen = "img/error.gif"; }
        return $imagen;
    }

    //Funcion que obtiene la imagen en zoom del producto:
    function obtener_imagen_producto_zoom($ref)
    {
        global $usando_ajax;
        $directorio = "img/productos/zoom/";
        if (isset($usando_ajax) && $usando_ajax == "si") { $directorio = "../" . $directorio; }

        if (file_exists($directorio . nombre_archivo_correcto($ref) . ".gif")) { $imagen = nombre_archivo_correcto($ref) . ".gif"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpg")) { $imagen = nombre_archivo_correcto($ref) . ".jpg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".jpeg")) { $imagen = nombre_archivo_correcto($ref) . ".jpeg"; }
        else if (file_exists($directorio . nombre_archivo_correcto($ref) . ".png")) { $imagen = nombre_archivo_correcto($ref) . ".png"; }
        else { $imagen = "img/error.gif"; }
        return $imagen;
    }


    //Funcion que recibe el nombre de un archivo y devuelve el correcto:
    function nombre_archivo_correcto($nombre)
    {
        //FALTARIA: substituir todos aquellos caracteres prohibidos para un archivo (caracteres raros, etc).
        return strtolower(str_replace(":", "", str_replace(" ", "_", str_replace("-", "_", trim($nombre)))));
    }

    
    //Devuelve si el producto debe ocultarse para el usuario enviado o no:
    function ocultar_producto($ref, $usuario, $tipo)
    {
        global $base_datos;
        $ocultar = false;
        
        $usuario = mysqli_real_escape_string($base_datos->conexion, trim($usuario));
        $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
        $tipo = mysqli_real_escape_string($base_datos->conexion, strtolower($tipo));
        if ($tipo != "particular" && $tipo != "empresa" && $tipo != "grupo") { return false; }
        if ($tipo == "" || $usuario == "" || $ref == "") { return false; }
        
        $sufijo = "s";
        if ($tipo == "particular") { $sufijo = "es"; }
        $consulta = "SELECT * FROM compradores_" . $tipo . $sufijo . " WHERE usuario LIKE '$usuario'";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $id_usuario = $row["id_" . $tipo];
       
        $consulta = "SELECT * FROM producto_comprador_$tipo WHERE id_$tipo = $id_usuario AND ref_producto LIKE '$ref' AND cantidad_minima = -1";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysqli_num_rows($resultados) > 0) { $ocultar = true; }
        
        return $ocultar;
    }

    
    //Devuelve si para el producto hay otros precios o no para un usuario enviado:
    function hay_otros_precios($ref, $usuario, $tipo)
    {
        global $base_datos;
        $hay_otros_precios = false;

        $usuario = mysqli_real_escape_string($base_datos->conexion, trim($usuario));
        $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
        $tipo = mysqli_real_escape_string($base_datos->conexion, strtolower($tipo));
        if ($tipo != "particular" && $tipo != "empresa" && $tipo != "grupo") { return false; }
        if ($tipo == "" || $usuario == "" || $ref == "") { return false; }
        
        $sufijo = "s";
        if ($tipo == "particular") { $sufijo = "es"; }
        $consulta = "SELECT * FROM compradores_" . $tipo . $sufijo . " WHERE usuario LIKE '$usuario'";

        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $id_usuario = $row["id_" . $tipo];
        
        $consulta = "SELECT * FROM producto_comprador_$tipo WHERE id_$tipo = $id_usuario AND ref_producto LIKE '$ref' AND cantidad_minima != -1";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysqli_num_rows($resultados) > 0) { $hay_otros_precios = true; }
        
        return $hay_otros_precios;
    }
    

    //Funcion que obtiene los otros precios de un usuario para un producto:
    function obtener_otros_precios($ref, $usuario, $tipo)
    {
        global $base_datos;

        $usuario = mysqli_real_escape_string($base_datos->conexion, trim($usuario));
        $ref = mysqli_real_escape_string($base_datos->conexion, trim($ref));
        $tipo = mysqli_real_escape_string($base_datos->conexion, strtolower($tipo));
        if ($tipo != "particular" && $tipo != "empresa" && $tipo != "grupo") { return false; }
        if ($tipo == "" || $usuario == "" || $ref == "") { return false; }

        $sufijo = "s";
        if ($tipo == "particular") { $sufijo = "es"; }
        $consulta = "SELECT * FROM compradores_" . $tipo . $sufijo . " WHERE usuario LIKE '$usuario'";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $id_usuario = $row["id_" . $tipo];
        
        $consulta = "SELECT * FROM producto_comprador_$tipo WHERE id_$tipo = $id_usuario AND ref_producto LIKE '$ref' AND cantidad_minima != -1";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $otros_precios = Array();
        $x = 0;
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $otros_precios[$x] = Array();
            $otros_precios[$x]["precio"] = $row["precio"];
            $otros_precios[$x]["cantidad_minima"] = $row["cantidad_minima"];
            $otros_precios[$x]["piezas"]  = $row["piezas"];
            $x++;
            
        }
        
        return $otros_precios;
    }


/*
    //Funcion que retorna si una categoria es la hija de otra o no:
    function productos_categoria_hija_padre($id_categoria, $id_categoria_padre)
    {
        $es_padre = FALSE;
        $padre = productos_padre_de($id_categoria);
        while ($padre != 0)
        {
            if ($padre == $id_categoria_padre) { $es_padre = TRUE; break; }
            $padre = productos_padre_de($padre);
        }
        //if ($es_padre) { echo "Categoria $id_categoria es la hija de $id_categoria_padre<br><br>"; }
        //else { echo "Categoria $id_categoria NO es la hija de $id_categoria_padre<br><br>"; }
        return $es_padre;
    }
    
    //Funcion que retorna el padre de una categoria:
    function productos_padre_de($id_categoria)
    {
        global $base_datos;
        
        $consulta = "SELECT raiz FROM categorias WHERE id_categoria = $id_categoria";
        $resultados = $base_datos->haz_consulta($consulta);
        
        $row = mysqli_fetch_assoc($resultados);
        
        $raiz = $row["raiz"];
        
        return $raiz;
    }

*/


    //Funcion que obtiene todos los productos del usuario actual (y si no hay, coge los datos comunes):
    function obtener_productos($id_categoria, $busqueda = "", $busqueda_exacta = FALSE, $solo_ref = FALSE)
    {
        global $base_datos, $id_idioma;
        
        //echo "ID CATEGORIA = " . $id_categoria;

        $busqueda = mysqli_real_escape_string($base_datos->conexion, strtoupper(trim($busqueda)));
        
        $mostrar_todos_productos_hijos = FALSE;
        $consulta = "SELECT nombre_categoria FROM categorias AS a JOIN categoria_idioma AS b WHERE a.id_categoria = $id_categoria AND id_idioma = $id_idioma AND a.id_categoria = b.id_categoria AND mostrar != 0";
        $resultados = $base_datos->haz_consulta($consulta);
        if (mysqli_num_rows($resultados) > 0)
        {
            $row = mysqli_fetch_assoc($resultados);
            $nombre_categoria = $row["nombre_categoria"];
            if (substr($nombre_categoria, 0, 1) == "[") { $mostrar_todos_productos_hijos = TRUE; }
        }
        if ($mostrar_todos_productos_hijos)
        {
            $consulta = "SELECT raiz FROM categorias WHERE id_categoria = $id_categoria";
            $resultados = $base_datos->haz_consulta($consulta);
            $row = mysqli_fetch_assoc($resultados);
            $id_categoria_padre = $row["raiz"];
            $consulta = "SELECT id_categoria FROM categorias";
            $resultados = $base_datos->haz_consulta($consulta);
            $productos = Array();
            $consulta = "SELECT DISTINCT ref, id_fabricante, id_marca, mostrar, precio_normal FROM productos JOIN producto_categoria ON ref = ref_producto WHERE mostrar != 0 AND (id_categoria = $id_categoria ";
            while ($row = mysqli_fetch_assoc($resultados))
            {
                $id_categoria_bucle = $row["id_categoria"];
                
                $consulta2 = "SELECT * FROM producto_categoria WHERE id_categoria = $id_categoria_bucle";
                $resultados2 = $base_datos->haz_consulta($consulta2);
                if (mysqli_num_rows($resultados2) <= 0) { continue; }
                
                if (categoria_hija_padre($id_categoria_bucle, $id_categoria_padre))
                {
                    $consulta .= " OR id_categoria = $id_categoria_bucle";
                }
            }
            $consulta .= ") ORDER BY orden, ref";
           
            //echo "SENTENCIA: $consulta";
        }
        else if ($busqueda == "") { $consulta = "SELECT ref, id_fabricante, id_marca, mostrar, precio_normal FROM productos JOIN producto_categoria WHERE ref = ref_producto AND id_categoria = $id_categoria AND mostrar != 0 ORDER BY orden, ref"; }
        else
        {
            if ($solo_ref)
            {
                $consulta = "SELECT DISTINCT ref, id_fabricante, id_marca, mostrar, precio_normal FROM productos AS a JOIN producto_descripcion AS b JOIN producto_nombre AS c ON a.ref = b.ref_producto AND b.ref_producto = c.ref_producto AND b.id_idioma = c.id_idioma WHERE mostrar != 0 AND UPPER(ref) LIKE '$busqueda' ORDER BY ref";
            }
            else if ($busqueda_exacta)
            {
                $consulta = "SELECT DISTINCT ref, id_fabricante, id_marca, mostrar, precio_normal FROM productos AS a JOIN producto_descripcion AS b JOIN producto_nombre AS c ON a.ref = b.ref_producto AND b.ref_producto = c.ref_producto AND b.id_idioma = c.id_idioma WHERE mostrar != 0 AND (UPPER(descripcion) LIKE '%$busqueda%' OR UPPER(nombre) LIKE '%$busqueda%' OR UPPER(ref) LIKE '$busqueda') ORDER BY ref";
            }
            else
            {
                $busqueda = str_replace(" ", "%", $busqueda);
                $consulta = "SELECT DISTINCT ref, id_fabricante, id_marca, mostrar, precio_normal FROM productos AS a JOIN producto_descripcion AS b JOIN producto_nombre AS c ON a.ref = b.ref_producto AND b.ref_producto = c.ref_producto AND b.id_idioma = c.id_idioma WHERE mostrar != 0 AND (UPPER(descripcion) LIKE '%$busqueda%' OR UPPER(nombre) LIKE '%$busqueda%' OR UPPER(ref) LIKE '%$busqueda%') ORDER BY ref";
            }
        }
                
        $resultados = $base_datos->haz_consulta($consulta);

        
        /*while ($row = mysqli_fetch_assoc($resultados))
        {
            print_r($row);
            //echo $row["id_idioma"];
            echo "<br><br>";
        }*/
        
        
        //echo "<br>CANTIDAD = " . mysqli_num_rows($resultados);
        
        //NOTA: recoger_sesion("identificado"), recoger_sesion("tipo"), recoger_sesion("usuario")
        //NOTA2: listar con precio normal, y poner una opcion ke ponga descuentos partikulares si existen para esa kuenta i produkto (si se esta identifikado solo).

        $productos = formatear_productos($resultados);
        
        return $productos;
    }
    

    //Funcion que devuelve los productos en una array a partir de los resultados de una consulta:
    function formatear_productos($resultados)
    {
        global $base_datos, $id_idioma;

        $identificado = (recoger_sesion("identificado")) ? true : false;
        $usuario = recoger_sesion("usuario");
        $tipo_usuario = recoger_sesion("tipo");
    
        $productos = Array();
        while ($row = mysqli_fetch_assoc($resultados))
        {
            $ref = $row["ref"];
            
            if (isset($productos[$ref]) && isset($productos[$ref]["ref"]) && $productos[$ref]["ref"] == $ref) { continue; }
            
            $id_fabricante = $row["id_fabricante"];
            $id_marca = $row["id_marca"];
            $precio_normal = $row["precio_normal"];
            $mostrar = $row["mostrar"];

            //Si para esta cuenta el producto no se debe mostrar (la cantidad minima es -1), salta el loop:
            if ($identificado && ocultar_producto($ref, $usuario, $tipo_usuario)) { continue; }
            
            //Si se ha definido no mostrar, sale del loop:
            if (!$mostrar) { continue; }

            $consulta = "SELECT * FROM producto_descripcion WHERE id_idioma = $id_idioma AND ref_producto LIKE '$ref'";
            $resultados2 = $base_datos->haz_consulta($consulta);
            $row2 = mysqli_fetch_assoc($resultados2);
            $descripcion = $row2["descripcion"];
            $eval_descripcion = $row2["eval"] ? TRUE : FALSE;
            
            $consulta = "SELECT nombre FROM producto_nombre WHERE id_idioma = $id_idioma AND ref_producto LIKE '$ref'";
            $resultados3 = $base_datos->haz_consulta($consulta);
            $row3 = mysqli_fetch_assoc($resultados3);
            $nombre = $row3["nombre"];

            $colecciones = obtener_colecciones_producto($ref);
            
            $disenyadores = obtener_disenyadores_producto($ref);
            
            $tematicas = obtener_tematicas_producto($ref);
            
            $idiomas = obtener_idiomas_producto($ref);
            
            $tipo = obtener_tipo($ref);
            //$tipo = "otro";
            //if (sizeof($disenyadores) > 0 || $metros_por_pieza) { $tipo = "tela"; }
            //else if (sizeof($tematicas) > 0 || sizeof($idiomas) > 0) { $tipo = "libro"; }

            $imagen = obtener_imagen_producto($ref);
            $imagen_zoom = obtener_imagen_producto_zoom($ref);
            
            $metros_por_pieza = obtener_metros_por_pieza($ref);
            
            $productos[$ref] = Array();
            $productos[$ref]["ref"] = htmlentities($ref, ENT_COMPAT, 'utf-8');
            $productos[$ref]["id_fabricante"] = htmlentities($id_fabricante, ENT_COMPAT, 'utf-8');
            $productos[$ref]["id_marca"] = htmlentities($id_marca, ENT_COMPAT, 'utf-8');
            $productos[$ref]["precio_normal"] = htmlentities($precio_normal, ENT_COMPAT, 'utf-8');
            $productos[$ref]["descripcion"] = str_replace("<br />", "<br>", nl2br(htmlentities($descripcion, ENT_COMPAT, 'utf-8')));
            $productos[$ref]["eval_descripcion"] = $eval_descripcion;
            $productos[$ref]["nombre"] = htmlentities($nombre, ENT_COMPAT, 'utf-8');
            $productos[$ref]["colecciones"] = $colecciones;
            $productos[$ref]["disenyadores"] = $disenyadores;
            $productos[$ref]["tematicas"] = $tematicas;
            $productos[$ref]["idiomas"] = $idiomas;
            $productos[$ref]["tipo"] = htmlentities($tipo, ENT_COMPAT, 'utf-8');
            $productos[$ref]["metros_por_pieza"] = $metros_por_pieza;
            $productos[$ref]["imagen"] = htmlentities($imagen, ENT_COMPAT, 'utf-8');
            $productos[$ref]["imagen_zoom"] = htmlentities($imagen_zoom, ENT_COMPAT, 'utf-8');
            if ($identificado && hay_otros_precios($ref, $usuario, $tipo_usuario))
            {
                $productos[$ref]["otros_precios"] = obtener_otros_precios($ref, $usuario, $tipo_usuario);
            }
        }
        
        return $productos;
    }


    //Funcion que muestra todos los productos:
    function mostrar_productos($productos)
    {
        global $margen_body, $margen_tablas, $constantes, $id_categoria;
        
        if (sizeof($productos) <= 0) { return; }
        
        //Filatra los productos:
        $productos = filtrar_productos($productos);
        
        $margen_entre_productos = 82;
        if ($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] != 0) { $productos_por_fila = $margen_body / ($constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"] + $margen_entre_productos); }
        else { $productos_por_fila = $margen_body / 96; }
        
        if ($productos_por_fila < 1) { $productos_por_fila = 1; }
        $productos_por_fila = (int) $productos_por_fila;
        
        $width_tabla = ($margen_body - $margen_tablas);
        echo '<br><center><table border="0" width="' . $width_tabla . '" cellspacing="2" cellpadding="6" align="center">';
        $f = $c = 0;
        $bgcolor = $constantes["COLOR_PRODUCTO_RECUADRO1"];
        foreach($productos as $producto)
        {
            if ($c == 0) { echo '<tr>'; }
            $width_producto = (int) ($width_tabla / $productos_por_fila);
            echo '<td width="' . $width_producto . '" valign="top" bgcolor="' . $bgcolor . '" class="producto_recuadro_td">';
            //echo '<table border="0" cellspacing="0" cellpadding="6" align="center" class="sin_transparencia"><tr><td align="center" bgcolor="' . $bgcolor . '" style="background:red;" class="sin_transparencia"><center>';
            mostrar_producto($producto);
            //echo '</center></td></tr></table>';
            echo '</td>';
            $c++;
            if ($c >= $productos_por_fila) { echo '</tr>'; $c = 0; $f++; }
            $bgcolor = ($bgcolor == $constantes["COLOR_PRODUCTO_RECUADRO1"]) ? $constantes["COLOR_PRODUCTO_RECUADRO2"] : $constantes["COLOR_PRODUCTO_RECUADRO1"];
        }
        if ($f >= 0 && $c > 0)
        {
            while ($c++ < $productos_por_fila) { echo '<td width="' . $width_producto . '"><img src="img/web/blank.gif" width="1" height="1" border="0"></td>'; }
            echo '</tr>';
        }
        //else if ($f == 0 && $c > 0) { echo "</tr>"; }
        else if ($f == 0 && $c == 0)
        {
            $frase = "";
            if ($id_categoria != $constantes["INICIO_ID"] && $id_categoria != $constantes["CESTA_ID"] && $id_categoria != $constantes["BUSCAR_ID"] && $id_categoria != $constantes["PEDIDO_ID"] && $id_categoria != $constantes["CONTACTO_ID"] && $id_categoria != $constantes["HISTORIA_ID"] && $id_categoria != $constantes["GALERIA_ID"] && $id_categoria != $constantes["TALLER_ID"]) { $frase = usar_etiqueta("NO_HAY_PRODUCTOS"); }
            echo "<tr><td align=\"center\"><center><b>" . $frase . "</b></center></td></tr>";
        }
        echo '</table></center><br>';
    }

    
    //Funcion que devuelve el codigo HTML de la imagen de un producto enviado:
    function obtener_producto_codigo_imagen($imagen, $ref)
    {
        global $constantes;
        
        $codigo = "";
        
        $directorio = "img/productos/";
        $directorio_zoom = "img/productos/zoom/";
        //$codigo = imagen_ampliable($imagen, $directorio, $directorio_zoom, false, $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"], $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"], $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"], $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"], $ref);
        $codigo = imagen_ampliable($imagen, $directorio, $directorio_zoom, false, $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"], $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"], -1, -1, $ref);
        
        return $codigo;
    }

    //Funcion que devuelve el codigo HTML de la imagen de un producto enviado (para la cesta):
    function obtener_producto_codigo_imagen_cesta($imagen, $ref)
    {
        global $constantes, $margen_body;
        
        $codigo = "";
        
        $directorio = "img/productos/";
        $directorio_zoom = "img/productos/zoom/";
        //$codigo = imagen_ampliable($imagen, $directorio, $directorio_zoom, false, $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"], $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"], $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"], $constantes["IMAGENES_PRODUCTOS_MINI_ALTO"], $ref);
        
        $ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
        
        //echo "$margen_body ($alto x $ancho) ... ";
        
        $version_encogida = FALSE;
		if (($margen_body - 100) <= $ancho) { $version_encogida = TRUE; }
        
		$codigo = imagen_ampliable($imagen, $directorio, $directorio_zoom, false, $constantes["IMAGENES_PRODUCTOS_ZOOM_ANCHO"], $constantes["IMAGENES_PRODUCTOS_ZOOM_ALTO"], -1, -1, $ref, $version_encogida);
        
        return $codigo;
    }

    //Funcion que muestra un producto pasado por parametro (tiene en cuenta si es libro, tela o no):
    function mostrar_producto($producto)
    {
        global $javascript_soportado, $javascript_version, $constantes, $sesion_form, $id_idioma, $ajax_soportado;
    
        $cesta = recoger_sesion("cesta");
    
		//Prueba para evitar error en el servidor con version de PHP nueva ("Uninitialized string offset"):
		if (!isset($cesta)) { $cesta = Array(); }
		if (!isset($cesta[$producto["ref"]])) { $cesta[$producto["ref"]] = Array(); }
	
        static $contador_producto = 0;

        $identificado = (recoger_sesion("identificado")) ? true : false;
    
        echo "<center>";
    
        //Muestra la imagen:
        echo '<div style="position:relative">';
        echo obtener_producto_codigo_imagen($producto["imagen"], $producto["ref"]) . "<br>";
        echo "</div>";

        $nombre = trim($producto["nombre"]);
        $ref = trim($producto["ref"]);
        $precio_normal = trim($producto["precio_normal"]);

        //Si el precio es incorrecto, sale de la funcion:
        //if ($precio_normal == "" || $precio_normal < 0) { return; } //Permitimos 0 para productos gratuitos.

        //Muestra su nombre:
        if ($nombre != "") { echo '<font size="3" color="#0000aa" face="arial"><b>' . $nombre . '</b></font><br>'; }
        
        //Muestra la referencia:
        if ($ref != "") { echo '<font size="1" color="#55ccff" face="courier">' . $ref . "</font><br>"; }

        if (es_novedad($ref)) { echo "<font color=\"#ffffff\">* " . usar_etiqueta("NOVEDAD") . " *</font><br>"; }
        if (es_oferta($ref)) { echo "<font color=\"#ffffff\">* " . usar_etiqueta("OFERTA") . " *</font><br>"; }

        echo "</center>";

        $hayMasInformacion = FALSE;
        $masInformacion = "";

        if ($producto["id_fabricante"] != "")
        {
            $fabricante_nombre = obtener_fabricante_nombre($producto["id_fabricante"]);
            if (trim($fabricante_nombre) != "")
            {
                $masInformacion .= '<font size="2" color="#00ddcc" face="verdana">' . usar_etiqueta("FABRICANTE") . ': <b>';
                $masInformacion .= trim($fabricante_nombre);
                $masInformacion .= '</b></font><br>';
                
                $hayMasInformacion = TRUE;
            }
        }

        if ($producto["id_marca"] != "")
        {
            $marca_nombre = obtener_marca_nombre($producto["id_marca"]);
            if (trim($marca_nombre) != "")
            {
                $masInformacion .= '<font size="2" color="#00ddcc" face="verdana">' . usar_etiqueta("MARCA") . ': <b>';
                $masInformacion .= trim($marca_nombre);
                $masInformacion .= '</b></font><br>';
                
                $hayMasInformacion = TRUE;
            }
        }
        
        if (trim($producto["descripcion"]) != "")
        {
                $hayMasInformacion = TRUE;
        }

        //Si es un libro, muestra sus idiomas y tematicas:
        if (trim(strtolower($producto["tipo"])) == "libro")
        {
            if (is_array($producto["tematicas"]))
            {
                $x = 0;
                $tematicas_puestas = 0;
                $tematicas = "";
                foreach ($producto["tematicas"] as $id_tematica)
                {
                    $tematica = obtener_tematica($id_tematica);
                    if ($tematica == "") { continue; }
                    if ($x++ > 0) { $tematicas .= ", "; }
                    $tematicas_puestas++;
                    $tematicas .= $tematica;
                }
                if ($tematicas_puestas > 0)
                {
                    $tematica_tematicas = ($tematicas_puestas > 1) ? usar_etiqueta("TEMATICAS") : usar_etiqueta("TEMATICA");
                    $masInformacion .= '<font size="2" color="#00ddcc" face="verdana">' . $tematica_tematicas . ': <b>';
                    $masInformacion .= $tematicas;
                    $masInformacion .= '</b></font><br>';
                    $hayMasInformacion = TRUE;
                }
            }

            if (is_array($producto["idiomas"]))
            {
                $x = 0;
                $idiomas_puestos = 0;
                $idiomas = "";
                foreach ($producto["idiomas"] as $id_idioma_temp)
                {
                    $idioma = obtener_idioma($id_idioma_temp);
                    if ($idioma == "") { continue; }
                    if ($x++ > 0) { $idiomas .= ", "; }
                    $idiomas_puestos++;
                    $idiomas .= $idioma;
                }
                if ($idiomas_puestos > 0)
                {
                    $idioma_idiomas = ($idiomas_puestos > 1) ? usar_etiqueta("IDIOMAS") : usar_etiqueta("IDIOMA");
                    $masInformacion .= '<font size="2" color="#00ddcc" face="verdana">' . $idioma_idiomas . ': <b>';
                    $masInformacion .= $idiomas;
                    $masInformacion .= '</b></font><br>';
                    $hayMasInformacion = TRUE;
                }
            }
        }
        
        //Si es una tela, muestra sus colecciones y diseadores:
        if (trim(strtolower($producto["tipo"])) == "tela")
        {
            if ($producto["metros_por_pieza"] > 0)
            {
                    //Solo lo muestra si se esta identificado:
                    if ($identificado)
                    {
                        $masInformacion .= '<font size="2" color="#00ddcc" face="verdana">' . usar_etiqueta("METROS_POR_PIEZA") . ': <b>';
                        $masInformacion .= $producto["metros_por_pieza"] . " (" . usar_etiqueta("APROXIMADAMENTE") . ")";
                        $masInformacion .= '</b></font><br>';
                    }
            }
        
            if (is_array($producto["colecciones"]))
            {
                $x = 0;
                $colecciones_puestas = 0;
                $colecciones = "";
                foreach ($producto["colecciones"] as $id_coleccion)
                {
                    $coleccion = obtener_coleccion($id_coleccion);
                    if ($coleccion == "") { continue; }
                    if ($x++ > 0) { $colecciones .= ", "; }
                    $colecciones_puestas++;
                    $colecciones .= $coleccion;
                }
                if ($colecciones_puestas > 0)
                {
                    $coleccion_colecciones = ($colecciones_puestas > 1) ? usar_etiqueta("COLECCIONES") : usar_etiqueta("COLECCION");
                    $masInformacion .= '<font size="2" color="#00ddcc" face="verdana">' . $coleccion_colecciones . ': <b>';
                    $masInformacion .= $colecciones;
                    $masInformacion .= '</b></font><br>';
                    $hayMasInformacion = TRUE;
                }
            }
            
            if (is_array($producto["disenyadores"]))
            {
                $x = 0;
                $disenyadores_puestos = 0;
                $disenyadores = "";
                foreach ($producto["disenyadores"] as $id_disenyador)
                {
                    $disenyador = obtener_disenyador($id_disenyador);
                    if ($disenyador == "" || trim($disenyador) == "-") { continue; }
                    if ($x++ > 0) { $disenyadores .= ", "; }
                    $disenyadores_puestos++;
                    $disenyadores .= $disenyador;
                }
                if ($disenyadores_puestos > 0)
                {
                    $disenyador_disenyadores = ($disenyadores_puestos > 1) ? usar_etiqueta("DISENYADORES") : usar_etiqueta("DISENYADOR");
                    $masInformacion .= '<font size="2" color="#00ddcc" face="verdana">' . $disenyador_disenyadores . ': <b>';
                    $masInformacion .= $disenyadores;
                    $masInformacion .= '</b></font><br>';
                    $hayMasInformacion = TRUE;
                }
            }
        }


        //Da la opcion de ampliar informacion (fabricante, marca, descripcion si la hay y otros precios si los hay): <- ponerlo en DHTML si esta disponible i si no en un popup si hay javaskript i si no ke vaya a otra pagina (el popup i la otra pagina pueden kompartir kodigo, aunke la otra pagina debe tener el logo i el menu, etc. de la web).        if ($hayMasInformacion)
        //FALTA: fabricante, marca, descripcion.
        if ($hayMasInformacion)// && trim($masInformacion) != "")
        {
            if ($javascript_soportado && $javascript_version >= 2)
            {
                echo "<center>";
                echo '<div id="producto_informacion_etiqueta_' . $contador_producto . '" onMouseOver="this.style.fontWeight = \'bold\';" onMouseOut="this.style.fontWeight = \'normal\';" onClick="mostrarOcultarInformacionProducto(' . $contador_producto . ');" style="cursor:pointer; cursor:hand;">' . usar_etiqueta("MAS_INFORMACION") . '</div>';
                echo "</center>";
                
                echo '<div id="producto_informacion_' . $contador_producto . '" style="display:none;"><table border="0" cellspacing="0" cellpadding="2"><tr><td align="left">';
            }

            echo $masInformacion;
    
            if (trim($producto["descripcion"]) != "")
            {
                echo '<font size="2" color="#00ddcc" face="verdana">' . usar_etiqueta("DESCRIPCION") . ':<br><b>';
                
                if ($producto["eval_descripcion"])
                {
                    $desc = $producto["descripcion"];
                    eval(trim(html_entity_decode($desc)));
                }
                else
                {
                    echo trim($producto["descripcion"]);
                }
                
                echo '</b></font><br>';
            }

            if ($javascript_soportado && $javascript_version >= 2)
            {
                echo '</td></tr></table></div>';
            }
        }

        //Si se esta identificado y hay otros precios, los muestra ("precios personalizados", por ejemplo), teniendo en cuenta cantidad minima y si son o no piezas (esto ultimo solo para telas):        
        //FALTA: otros precios
        if ($javascript_soportado && $javascript_version >= 2)
        {
            echo "<center>";
            echo '<div id="producto_precio_etiqueta_' . $contador_producto . '" onMouseOver="this.style.fontWeight = \'bold\';" onMouseOut="this.style.fontWeight = \'normal\';" onClick="mostrarOcultarPrecioProducto(' . $contador_producto . ');" style="cursor:pointer; cursor:hand;">' . usar_etiqueta("VER_PRECIO") . '</div>';
            echo "</center>";

            echo '<div id="producto_precio_' . $contador_producto . '" style="display:none;">';
        }

        echo '<table border="0" cellspacing="0" cellpadding="2"><tr><td align="left">';

        //Muestra el precio normal:
        $precio_normal_oferta = es_oferta($ref) ? "PRECIO_OFERTA" : "PRECIO_NORMAL";
		if (trim(strtolower($producto["tipo"])) == "tela")
        {
            echo '<font size="2" color="#000088" face="arial">' . usar_etiqueta($precio_normal_oferta) . ': <b>' . number_format($producto["precio_normal"], usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . '</b> ' . usar_etiqueta("EURO") . '/' . usar_etiqueta("METRO") . '</font><br>';
        }
        else
        {
            echo '<font size="2" color="#000088" face="arial">' . usar_etiqueta($precio_normal_oferta) . ': <b>' . number_format($producto["precio_normal"], usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . '</b> ' . usar_etiqueta("EURO") . '</font><br>';
        }
        
        if (isset($producto["otros_precios"]) && is_array($producto["otros_precios"]))
        {
            $hayPiezaEntera = FALSE;
            $hayPiezaMedia = FALSE;
            $hayPiezaCuarto = FALSE;
            $precioParaCuentaPuesto = FALSE;
            foreach($producto["otros_precios"] as $k)
            {
                $precio = $k["precio"];
                $cantidad_minima = $k["cantidad_minima"];
                $piezas = $k["piezas"];
                
                //Si es -1 o cualquier otro numero negativo, se salta este loop:
                if ($cantidad_minima < 0) { continue; }
                
                $frase = usar_etiqueta("PRECIO_PARA_ESTA_CUENTA") . ": ";
                $precioParaCuenta = TRUE;
                if ($piezas)
                {
                    if ($cantidad_minima == 1) { $frase = usar_etiqueta("PIEZA_ENTERA") . ": "; $hayPiezaEntera = TRUE; }
                    else if ($cantidad_minima == 0.5) { $frase = usar_etiqueta("MEDIA_PIEZA") . ": "; $hayPiezaMedia = TRUE; }
                    else if ($cantidad_minima == 0.25) { $frase = usar_etiqueta("CUARTO_DE_PIEZA") . ": "; $hayPiezaCuarto = TRUE; }
                    else { $frase = "$cantidad_minima " . usar_etiqueta("DE_PIEZA") . ": "; }
                    $precioParaCuenta = FALSE;
                }
                else
                {
                    if (trim(strtolower($producto["tipo"])) == "tela")
                    {
                        if ($cantidad_minima > 0) { $frase = usar_etiqueta("PRECIO_AL_COMPRAR") . " " . $cantidad_minima . ": "; $precioParaCuenta = FALSE; }
                    }
                    else
                    {
                        if ($cantidad_minima > 1) { $frase = usar_etiqueta("PRECIO_AL_COMPRAR") . " " . (int) $cantidad_minima . ": "; $precioParaCuenta = FALSE; }
                    }
                }
                
                if ($precioParaCuentaPuesto && $precioParaCuenta) { continue; }
                else if ($precioParaCuenta) { $precioParaCuentaPuesto = TRUE; }

                if ($precio > 0)
                {
                    echo '<br><font size="2" color="#000088" face="arial">';
                    echo $frase . "<b>" . number_format($precio, usar_etiqueta("MONEDA_NUMERO_DECIMALES"), usar_etiqueta("SEPARADOR_DECIMALES"), usar_etiqueta("SEPARADOR_MILES")) . "</b> " . usar_etiqueta("EURO");
                    if (trim(strtolower($producto["tipo"])) == "tela") { echo "/" . usar_etiqueta("METRO"); }
                    echo "</font><br>";
                }
                else if ($precio == 0)
                {
                    echo '<br><font size="2" color="#000088" face="arial">';
                    echo $frase . "<b>" . usar_etiqueta("GRATIS") . "</b>";
                    echo "</font><br>";
                }
            }
        }

        echo '</td></tr></table>';

        if ($javascript_soportado && $javascript_version >= 2)
        {
            //echo '</td></tr></table></div>';
            echo '</div>';
        }

        if ($javascript_soportado && $javascript_version >= 2)
        {
            echo '<div id="producto_alertas_' . $contador_producto . '" class="alerta_producto"></div>';
        }

        if ($javascript_soportado && $javascript_version >= 2)
        {
            echo "<center>";
            echo '<div id="producto_comprar_etiqueta_' . $contador_producto . '" onMouseOver="this.style.fontWeight = \'bold\';" onMouseOut="this.style.fontWeight = \'normal\';" onClick="mostrarOcultarComprarProducto(' . $contador_producto . ');" style="cursor:pointer; cursor:hand;">' . usar_etiqueta("COMPRAR_PRODUCTO") . '</div>';
            echo "</center>";

            echo '<div id="producto_comprar_' . $contador_producto . '" style="display:none;">';
        }
        echo '<center><table border="0" cellspacing="0" cellpadding="6" class="producto_comprar" align="center">';
        //echo '<table border="1" cellspacing="0" cellpadding="6">';
        if (trim(strtolower($producto["tipo"])) == "tela")
        {
            //if ($producto["metros_por_pieza"] > 0)
            //{
                //if ($identificado) { $centimetros_minimo = $constantes["MINIMO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"]; $incremento_centimetros = $constantes["INCREMENTO_CENTIMETROS_IDENTIFICADO_POR_DEFECTO"]; } else { $centimetros_minimo = $constantes["MINIMO_CENTIMETROS_NORMAL_POR_DEFECTO"]; $incremento_centimetros = $constantes["INCREMENTO_CENTIMETROS_NORMAL_POR_DEFECTO"]; }
                $centimetros_minimo = obtener_minimo_centimetros($producto["ref"]);
                $incremento_centimetros = obtener_incremento_centimetros($producto["ref"]);


                //echo '<form method="get" action="' . $constantes["CESTA_ARCHIVO"] . '" class="producto" onSubmit="return validarComprarCantidad(' . $contador_producto . ', ' . $incremento_centimetros . ', ' . $centimetros_minimo . ');">';
                //echo $sesion_form;

                echo '<tr><td align="left" valign="middle" class="producto_comprar">';
                
                $onSubmit = "";
                if ($javascript_soportado) { $onSubmit = ' onSubmit="return validarComprarCentimetros(' . $contador_producto . ', ' . $incremento_centimetros . ', ' . $centimetros_minimo . ', ' . $id_idioma . ', \'' . $producto["ref"] . '\');"'; }
                echo '<form method="get" action="' . $constantes["CESTA_ARCHIVO"] . '" name="producto_comprar_centimetros_' . $contador_producto . '" id="producto_comprar_centimetros_' . $contador_producto . '" class="producto"' . $onSubmit . '>';

                if ($javascript_soportado && $javascript_version >= 2)
                {
                    echo '<table border="0" width="100%" cellspacing="0" cellpadding="6" class="producto_comprar2">';
                    echo '<tr><td align="left" valign="middle" class="producto_comprar2">';
                }

                echo $sesion_form;
                
                echo '<table border="0" cellspacing="0" cellpadding="2">';
                echo '<tr><td align="center" class="producto_comprar2"><center>';
               
                echo '<input type="hidden" name="ref_producto" value="' . $producto["ref"] . '">';
                echo '<input type="hidden" name="accion" value="agregar">';
                echo '<input type="hidden" name="tipo" value="centimetros">';

                echo '<b>' . usar_etiqueta("CENTIMETROS") . '</b>: ';

                if ($javascript_soportado && $javascript_version >= 2)
                {
                    $display = "none";
                    if (isset($cesta[$producto["ref"]]["centimetros"]) && $cesta[$producto["ref"]]["centimetros"] > 0) { $display = "block"; }
                    echo '<div id="centimetros_agregado_' . $contador_producto . '" style="display:' . $display . '; color:#ffffff; font-size:10px; font-family:arial;">';
                } else { echo "<br>"; }
                if (isset($cesta[$producto["ref"]]["centimetros"]) && $cesta[$producto["ref"]]["centimetros"] > 0) { echo usar_etiqueta("PRODUCTO_EN_CESTA") . "<br>"; }
                if ($javascript_soportado && $javascript_version >= 2) { echo "</div>"; }

                if ($javascript_soportado && $javascript_version >= 2)
                {
                    //echo '<div id="centimetros_errores_' . $contador_producto . '" style="display:none; text-align:left; color:#660000;"></div>';
                    echo '<div id="centimetros_errores_' . $contador_producto . '" class="alerta_producto"></div>';
                }

                echo '</center></td><td align="center"><center>';

                echo '<input type="text" name="cantidad" id="centimetros_' . $contador_producto . '" value="' . $centimetros_minimo . '" size="5" maxlength="5" class="texto"> ';

                
                echo '</center></td><td align="center"><center>';
                
                if ($javascript_soportado && $javascript_version >= 2)
                {
                    echo '<table border="0" cellspacing="0" cellpadding="2" align="center">';
                    echo '<tr><td align="center"><center>';
                    echo '<img src="img/web/productos/mas.gif" hspace="0" vspace="0" border="0" width="15" hspace="15" alt="+" title="' . usar_etiqueta("INCREMENTAR_CENTIMETROS") . '" style="cursor:pointer; cursor:hand;" onClick="incrementarCentimetros(' . $contador_producto . ', ' . $incremento_centimetros . ', ' . $centimetros_minimo . ');">';
                    echo '</center></td></tr><tr><td align="center"><center>';
                    echo '<img src="img/web/productos/menos.gif" hspace="0" vspace="0" border="0" width="15" hspace="15" alt="-" title="' . usar_etiqueta("DECREMENTAR_CENTIMETROS") . '" style="cursor:pointer; cursor:hand;" onClick="decrementarCentimetros(' . $contador_producto . ', ' . $incremento_centimetros . ', ' . $centimetros_minimo . ');">';
                    echo '</center></td></tr>';
                    echo '</table>';
                }
                
                echo '</center></td></tr></table>';
                
                echo '</td><td valign="middle" class="producto_comprar2" align="right">';
                echo '<input type="submit" name="agregar" value="' . usar_etiqueta("AGREGAR_PRODUCTO") . '" class="boton">';
                

                if ($javascript_soportado && $javascript_version >= 2) { echo '</td></tr></table>'; }
                
                echo '</form>';

                echo '</td></tr>';
            //}





            //if (isset($producto["otros_precios"]) && is_array($producto["otros_precios"]))
            if ($producto["metros_por_pieza"] > 0 && isset($producto["otros_precios"]) && is_array($producto["otros_precios"]))
            {
                if ($hayPiezaEntera)
                {
                    echo '<tr><td align="left" class="producto_comprar">';

                    $onSubmit = "";
                    if ($ajax_soportado) { $onSubmit = 'onSubmit="agregar_producto(\'' . $producto["ref"] . '\', ' . $contador_producto . ', 1, \'pieza_entera\'); return false;"'; }
                    echo '<form method="get" action="' . $constantes["CESTA_ARCHIVO"] . '" class="producto"' . $onSubmit . '>';
                    
                    if ($javascript_soportado && $javascript_version >= 2)
                    {
                        echo '<table border="0" width="100%" cellspacing="0" cellpadding="6" class="producto_comprar2">';
                        echo '<tr><td align="left" valign="middle" class="producto_comprar2">';
                    }

                    echo $sesion_form;
                    echo '<input type="hidden" name="ref_producto" value="' . $producto["ref"] . '">';
                    echo '<input type="hidden" name="accion" value="agregar">';
                    echo '<input type="hidden" name="tipo" value="pieza_entera">';
                    echo '<input type="hidden" name="cantidad" value="1">';
                    echo '<b>' . usar_etiqueta("PIEZA_ENTERA") . '</b> ';

                    if ($javascript_soportado && $javascript_version >= 2)
                    {
                        $display = "none";
                        if (isset($cesta[$producto["ref"]]["pieza_entera"]) && $cesta[$producto["ref"]]["pieza_entera"] > 0) { $display = "block"; }
                        echo '<div id="pieza_entera_agregado_' . $contador_producto . '" style="display:' . $display . '; color:#ffffff; font-size:10px; font-family:arial;">';
                    } else { echo "<br>"; }
                    if (isset($cesta[$producto["ref"]]["pieza_entera"]) && $cesta[$producto["ref"]]["pieza_entera"] > 0) { echo usar_etiqueta("PRODUCTO_EN_CESTA") . "<br>"; }
                    if ($javascript_soportado && $javascript_version >= 2) { echo "</div>"; }

                    
                    echo '</td><td align="right" class="producto_comprar2">';
                    echo '<input type="submit" name="agregar" value="' . usar_etiqueta("AGREGAR_PRODUCTO") . '" class="boton">';

                    if ($javascript_soportado && $javascript_version >= 2) { echo '</td></tr></table>'; }
                    
                    echo '</form>';

                    echo '</td></tr>';
                }
                if ($hayPiezaMedia)
                {
                    echo '<tr><td align="left" class="producto_comprar">';

                    $onSubmit = "";
                    if ($ajax_soportado) { $onSubmit = 'onSubmit="agregar_producto(\'' . $producto["ref"] . '\', ' . $contador_producto . ', 1, \'pieza_media\'); return false;"'; }
                    echo '<form method="get" action="' . $constantes["CESTA_ARCHIVO"] . '" class="producto"' . $onSubmit . '>';

                    if ($javascript_soportado && $javascript_version >= 2)
                    {
                        echo '<table border="0" width="100%" cellspacing="0" cellpadding="6" class="producto_comprar2">';
                        echo '<tr><td align="left" valign="middle" class="producto_comprar2">';
                    }

                    echo $sesion_form;
                    echo '<input type="hidden" name="ref_producto" value="' . $producto["ref"] . '">';
                    echo '<input type="hidden" name="accion" value="agregar">';
                    echo '<input type="hidden" name="tipo" value="pieza_media">';
                    echo '<input type="hidden" name="cantidad" value="1">';
                    echo '<b>' . usar_etiqueta("MEDIA_PIEZA") . '</b> ';

                    if ($javascript_soportado && $javascript_version >= 2)
                    {
                        $display = "none";
                        if (isset($cesta[$producto["ref"]]["pieza_media"]) && $cesta[$producto["ref"]]["pieza_media"] > 0) { $display = "block"; }
                        echo '<div id="pieza_media_agregado_' . $contador_producto . '" style="display:' . $display . '; color:#ffffff; font-size:10px; font-family:arial;">';
                    } else { echo "<br>"; }
                    if (isset($cesta[$producto["ref"]]["pieza_media"]) && $cesta[$producto["ref"]]["pieza_media"] > 0) { echo usar_etiqueta("PRODUCTO_EN_CESTA") . "<br>"; }
                    if ($javascript_soportado && $javascript_version >= 2) { echo "</div>"; }


                    echo '</td><td align="right" class="producto_comprar2">';
                    echo '<input type="submit" name="agregar" value="' . usar_etiqueta("AGREGAR_PRODUCTO") . '" class="boton">';
                    
                    if ($javascript_soportado && $javascript_version >= 2) { echo '</td></tr></table>'; }

                    echo '</form>';
                    
                    echo '</td></tr>';
                }
                if ($hayPiezaCuarto)
                {
                    echo '<tr><td align="left" class="producto_comprar">';

                    $onSubmit = "";
                    if ($ajax_soportado) { $onSubmit = 'onSubmit="agregar_producto(\'' . $producto["ref"] . '\', ' . $contador_producto . ', 1, \'pieza_cuarto\'); return false;"'; }
                    echo '<form method="get" action="' . $constantes["CESTA_ARCHIVO"] . '" class="producto"' . $onSubmit . '>';

                    if ($javascript_soportado && $javascript_version >= 2)
                    {
                        echo '<table border="0" width="100%" cellspacing="0" cellpadding="6" class="producto_comprar2">';
                        echo '<tr><td align="left" valign="middle" class="producto_comprar2">';
                    }

                    echo $sesion_form;
                    echo '<input type="hidden" name="ref_producto" value="' . $producto["ref"] . '">';
                    echo '<input type="hidden" name="accion" value="agregar">';
                    echo '<input type="hidden" name="tipo" value="pieza_cuarto">';
                    echo '<input type="hidden" name="cantidad" value="1">';
                    echo '<b>' . usar_etiqueta("CUARTO_DE_PIEZA") . '</b> ';

                    if ($javascript_soportado && $javascript_version >= 2)
                    {
                        $display = "none";
                        if (isset($cesta[$producto["ref"]]["pieza_cuarto"]) && $cesta[$producto["ref"]]["pieza_cuarto"] > 0) { $display = "block"; }
                        echo '<div id="pieza_cuarto_agregado_' . $contador_producto . '" style="display:' . $display . '; color:#ffffff; font-size:10px; font-family:arial;">';
                    } else { echo "<br>"; }
                    if (isset($cesta[$producto["ref"]]["pieza_cuarto"]) && $cesta[$producto["ref"]]["pieza_cuarto"] > 0) { echo usar_etiqueta("PRODUCTO_EN_CESTA") . "<br>"; }
                    if ($javascript_soportado && $javascript_version >= 2) { echo "</div>"; }

                    echo '</td><td align="right" class="producto_comprar2">';
                    echo '<input type="submit" name="agregar" value="' . usar_etiqueta("AGREGAR_PRODUCTO") . '" class="boton">';
                    
                    if ($javascript_soportado && $javascript_version >= 2) { echo '</td></tr></table>'; }

                    echo '</form>';
                                        
                    echo '</td></tr>';
                }
            }
        }
        else
        {
            echo '<tr><td align="left" class="producto_comprar">';

            $onSubmit = "";
            if ($javascript_soportado) { $onSubmit = ' onSubmit="return validarComprarCantidad(' . $contador_producto . ', ' . $id_idioma . ', \'' . $producto["ref"] . '\');"'; }
            echo '<form method="get" action="' . $constantes["CESTA_ARCHIVO"] . '" name="producto_comprar_cantidad_' . $contador_producto . '" class="producto"' . $onSubmit . '>';

            if ($javascript_soportado && $javascript_version >= 2)
            {
                echo '<table border="0" width="100%" cellspacing="0" cellpadding="0" class="producto_comprar2">';
                echo '<tr><td align="left" valign="middle" class="producto_comprar2">';
            }

            //echo '<form method="get" action="' . $constantes["CESTA_ARCHIVO"] . '" class="producto">';
            echo $sesion_form;
            echo '<input type="hidden" name="ref_producto" value="' . $producto["ref"] . '">';
            echo '<input type="hidden" name="accion" value="agregar">';
            echo '<input type="hidden" name="tipo" value="cantidad">';
            echo '<b>' . usar_etiqueta("CANTIDAD") . '</b>: ';

            echo '<input type="text" name="cantidad" id="cantidad_' . $contador_producto . '" value="1" size="5" maxlength="5" class="texto">';

            if ($javascript_soportado && $javascript_version >= 2)
            {
                $display = "none";
                if (isset($cesta[$producto["ref"]]["cantidad"]) && $cesta[$producto["ref"]]["cantidad"] > 0) { $display = "block"; }
                echo '<div id="cantidad_agregado_' . $contador_producto . '" style="display:' . $display . '; color:#ffffff; font-size:10px; font-family:arial;">';
            } else { echo "<br>"; }
            if (isset($cesta[$producto["ref"]]["cantidad"]) && $cesta[$producto["ref"]]["cantidad"] > 0) { echo usar_etiqueta("PRODUCTO_EN_CESTA") . "<br>"; }
            if ($javascript_soportado && $javascript_version >= 2) { echo "</div>"; }


            if ($javascript_soportado && $javascript_version >= 2)
            {
                //echo '<div id="cantidad_errores_' . $contador_producto . '" style="display:none; text-align:left; color:#660000;"></div>';
                echo '<div id="cantidad_errores_' . $contador_producto . '" class="alerta_producto"></div>';
            }
           
            echo '</td><td align="right" class="producto_comprar2">';
            echo '<input type="submit" name="agregar" value="' . usar_etiqueta("AGREGAR_PRODUCTO") . '" class="boton">';
            
            if ($javascript_soportado && $javascript_version >= 2) { echo '</td></tr></table>'; }

            echo '</form>';
            
            echo '</td></tr>';
        }
        echo '</table></center>';
        if ($javascript_soportado && $javascript_version >= 2)
        {
            echo '</div>';
        }
        

        $contador_producto++;
                

        
        

        
        
        

    /*        
            $productos[$ref]["imagen"] = htmlentities($imagen);
            $productos[$ref]["imagen_zoom"] = htmlentities($imagen_zoom);

            $productos[$ref]["nombre"] = htmlentities($nombre);
            $productos[$ref]["ref"] = htmlentities($ref);
            $productos[$ref]["precio_normal"] = htmlentities($precio_normal);

            $productos[$ref]["tipo"] = htmlentities($tipo);

            $productos[$ref]["tematicas"] = $tematicas;
            $productos[$ref]["idiomas"] = $idiomas;

            $productos[$ref]["colecciones"] = $colecciones;
            $productos[$ref]["disenyadores"] = $disenyadores;

            $productos[$ref]["id_fabricante"] = htmlentities($id_fabricante);
            $productos[$ref]["id_marca"] = htmlentities($id_marca);
            $productos[$ref]["descripcion"] = htmlentities($descripcion);
            $productos[$ref]["eval_descripcion"] = $eval_descripcion;

            if (hay_otros_precios($ref, $usuario, $tipo_usuario))
            {
                $productos[$ref]["otros_precios"] = obtener_otros_precios($ref, $usuario, $tipo_usuario);
            }*/
     
    }

    //Funcion que obtiene un fabricante a partir de su id:
    function obtener_fabricante_nombre($id_fabricante)
    {
        global $base_datos;

        if ($id_fabricante <= 0 || trim($id_fabricante) == "") { return ""; }
        
        $consulta = "SELECT nombre_fabricante FROM fabricantes WHERE id_fabricante = $id_fabricante";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $fabricante = htmlentities(trim($row["nombre_fabricante"]), ENT_COMPAT, 'utf-8');
        
        return trim($fabricante);
    }
    
    //Funcion que obtiene una marca a partir de su id:
    function obtener_marca_nombre($id_marca)
    {
        global $base_datos;
        
        if ($id_marca <= 0 || trim($id_marca) == "") { return ""; }
        
        $consulta = "SELECT nombre_marca FROM fabricante_marca WHERE id_marca = $id_marca";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $marca = htmlentities(trim($row["nombre_marca"]), ENT_COMPAT, 'utf-8');
        
        return trim($marca);
    }
    


    //Devuelve una tematica a partir de su id:
    function obtener_tematica($id_tematica)
    {
        global $base_datos, $id_idioma;
        
        $consulta = "SELECT tematica FROM tematica_idioma WHERE id_tematica = $id_tematica AND id_idioma = $id_idioma";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $tematica = htmlentities(trim($row["tematica"]), ENT_COMPAT, 'utf-8');
        
        return $tematica;
    }

    //Devuelve un idioma a partir de su id:
    function obtener_idioma($id_idioma)
    {
        global $base_datos;
        
        $consulta = "SELECT idioma FROM idiomas WHERE id_idioma = $id_idioma";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $idioma = htmlentities(trim($row["idioma"]), ENT_COMPAT, 'utf-8');
        
        return $idioma;
    }

    //Devuelve una coleccion a partir de su id:
    function obtener_coleccion($id_coleccion)
    {
        global $base_datos;
        
        $consulta = "SELECT nombre_coleccion FROM colecciones WHERE id_coleccion = $id_coleccion";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $coleccion = htmlentities(trim($row["nombre_coleccion"]), ENT_COMPAT, 'utf-8');
        
        return $coleccion;
    }

    //Devuelve un diseador a partir de su id:
    function obtener_disenyador($id_disenyador)
    {
        global $base_datos;
        
        $consulta = "SELECT nombre_disenyador FROM disenyadores WHERE id_disenyador = $id_disenyador";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $disenyador = htmlentities(trim($row["nombre_disenyador"]), ENT_COMPAT, 'utf-8');
        
        return $disenyador;
    }
    
    //Funcion que aplica los filtros a los productos:
    function filtrar_productos($productos)
    {
        //FALTA: acabar!!! (o comenzar mejor dicho xDD).
        
        return $productos;
    }
?>
