<?php
    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    //Incluye los archivos requeridos:
    require_once "web/recoger_get.php";
    require_once "web/recoger_sesion.php";
    require_once "web/setear_sesion.php";

    //Width de la tabla principal (con el menu), segun resolucion:
    $anchos_tabla = Array(
                            "min" => 420,
                            "640" => 480,
                            "720" => 675, //"800" => 675,
                            "1024" => 850,
                            "1280" => 980,
                            "1600" => 1100,
                            "1800" => 1400,
                            "max" => 1600
                         );

    //Width del menu, segun resolucion:
    $anchos_menu = Array(
                            "min" => 120,
                            "640" => 120,
                            "720" => 120, //"800" => 120,
                            "1024" => 120,
                            "1280" => 120,
                            "1600" => 120,
                            "1800" => 120,
                            "max" => 120
                         );

    //Define cuales son los estandares de resolucion:
    $resolucion_horizontal_defecto = "1024";
    $ancho_tabla_estandard = $anchos_tabla[$resolucion_horizontal_defecto];
    $ancho_menu_estandard = $anchos_menu[$resolucion_horizontal_defecto];
    $directorio_logos_estandard = $resolucion_horizontal_defecto;

    //Define que se esta utilizando una resolucion estandard:
    $ancho_tabla = $ancho_tabla_estandard;
    $ancho_menu = $ancho_menu_estandard;
    
    //$ancho_body = $ancho_tabla - $ancho_menu - 1 - 1 - 4;
    //$margen_body = $ancho_body - 25;
    //$margen_menu = $ancho_menu - 10;
    
    $directorio_logos = $directorio_logos_estandard;
    
    //Si ya se habia definido una resolucion, la recoge de la sesion:
    $ancho_tabla_sesion = recoger_sesion("ancho_tabla_sesion");
    $ancho_menu_sesion = recoger_sesion("ancho_menu_sesion");
    $directorio_logos_sesion = recoger_sesion("directorio_logos_sesion");
    if ($ancho_tabla_sesion != "" && is_numeric($ancho_tabla_sesion)) { $ancho_tabla = $ancho_tabla_sesion; }
    if ($ancho_menu_sesion != "" && is_numeric($ancho_menu_sesion)) { $ancho_menu = $ancho_menu_sesion; }
    if ($directorio_logos_sesion != "") { $directorio_logos = $directorio_logos_sesion; }

    //Si se ha enviado una resolucion o si JavaScript esta soportado y todavia no se ha definido ninguna resolucion gracias a el, lo hace:
    $cambiar_resolucion = recoger_get("cambiar_resolucion");
    $resolucion_cambiada = recoger_sesion("resolucion_cambiada");

    if ($cambiar_resolucion || $javascript_soportado && !$resolucion_cambiada)
    {
        if (!$javascript_soportado || !$estamos_refrescando)
        {
            $resolucion = recoger_get("resolucion");
            if ($resolucion > 0 && $resolucion != "" && is_numeric($resolucion))
            {
                if ($resolucion < 640) { $ancho_tabla = $anchos_tabla["min"]; $ancho_menu = $anchos_menu["min"]; $directorio_logos = "min"; }
                foreach ($anchos_tabla as $resolucion_definida => $ancho_tabla_definido)
                {
                    if ($resolucion < $resolucion_definida && is_numeric($resolucion_definida)) { break; }
                    else { $ancho_tabla = $ancho_tabla_definido; $directorio_logos = $resolucion_definida; }
                }
                foreach ($anchos_menu as $resolucion_definida => $ancho_menu_definido)
                {
                    if ($resolucion < $resolucion_definida && is_numeric($resolucion_definida)) { break; }
                    else { $ancho_menu = $ancho_menu_definido; }
                }
            }
        //}
            setear_sesion("ancho_tabla_sesion", $ancho_tabla);
            setear_sesion("ancho_menu_sesion", $ancho_menu);
            setear_sesion("directorio_logos_sesion", $directorio_logos);
            setear_sesion("resolucion_cambiada", TRUE);
        }
    }

    //Se define la ruta entera en el directorio de logos:
    $directorio_logos = "img/web/logos/" . $directorio_logos;

    //Se redondea todo:
    $ancho_tabla = round($ancho_tabla);
    $ancho_menu = floor($ancho_menu);

    //Se calcula el ancho total del body (en realidad es la tabla principal sin el menu y los margenes):
    $ancho_body = $ancho_tabla - $ancho_menu - 1 - 1 - 4;

    //Se calcula el ancho del margen dentro del body (lo que en realidad es el contenido, sin el menu):
    $margen_body = $ancho_body - 25;

    //Margen que tienen las tablas dentro del cuerpo:
    $margen_tablas = 10;

    //Se calcula el ancho del margen dentro del menu:
    $margen_menu = $ancho_menu - 10;
    
    //Se pone el metatag viewport:
    echo '<meta name="viewport" content="width=' . $ancho_tabla . ', user-scalable=yes" />';
?>
