<?php
    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    //Incluye el manejador de errores:
    require_once "cod/func/manejador_errores.php";

    //Incluye el archivo para mostrar errores:
    include_once "cod/func/web/error.php";

    //Incluye el archivo para mostrar advertencias:
    include_once "cod/func/web/advertencia.php";

    //Incluye la configuracion:
    require_once "cod/config/config.php";

    //Incluye el archivo necesario para conectar a mySQL:
    require_once "cod/func/db/db.php";

    //Conecta a la base de datos:
    $base_datos = new base_datos();
    $base_datos->conecta();

    //Selecciona la base de datos:
    $base_datos->selecciona();

    //Recoge las constantes de la base de datos:
    require_once "cod/func/constantes.php";

    //Calcula el id de la categoria actual:
    require_once "cod/func/id_categoria.php";

    //Recoge los idiomas existentes y el solcitado (si este no existe, escoge el por defecto):
    include_once "cod/func/idioma.php";

    //Recoge las etiquetas traducibles:
    require_once "cod/func/etiquetas.php";
    
    //Recoge el titulo de la pagina:
    include_once "cod/titulo.php";

    //Inserta el archivo necesario para enviar E-Mails:
    include_once "cod/func/email.php";
    
    //Agrega la funcion de obtener categorias:
    require_once "cod/func/categorias.php";

    //Si hay sistema de login, lo "inicia":
    //if (isset($constantes["USAR_SISTEMA_LOGIN"]) && $constantes["USAR_SISTEMA_LOGIN"] && file_exists("cod/func/web/login.php"))
	if (isset($constantes["USAR_SISTEMA_LOGIN"]) && $constantes["USAR_SISTEMA_LOGIN"] && file_exists("cod/func/web/login_inicio.php"))
    {
        include_once "cod/func/web/login_inicio.php";
    }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html<?php echo " lang=\"".$etiquetas["HTML_LENGUAJE"]["valor"]."\""; ?>>
    <head>
        <title><?php echo $constantes["WEB_TITULO"]; if (trim($titulo) != "") { echo " - " . htmlentities($titulo, ENT_COMPAT, 'utf-8'); } ?></title>
        <?php
            //Detectamos si soporta JavaScript:
            include_once "cod/func/javascript.php";

            //Inserta el codigo para ampliar las imagenes (ya sea con o sin JavaScript):
            //include_once "cod/zoom.php";

            //Se pone el unlogin aqui por si debe hacer una transicion de url:
            include_once "cod/func/web/login_unlogin.php";
            
            //Escogemos la resolucion (si no ha detectado JavaScript, cogera la por defecto):
            include_once "cod/func/resolucion.php";
            
            //Incluimos los meta-tags:
            include_once "cod/metatags.php";

            //Incluimos el codigo CSS:
            include_once "css/css.php";

			
            if ($javascript_soportado)
            {
                if ($ajax_soportado)
                {
                    //echo '<script language="JavaScript1.2" src="cod/js/ajax.js"></script>';
                    include_once "cod/js/ajax.php";
                }
                //echo '<script language="JavaScript1.2" src="cod/js/funciones.js"></script>';
                include_once "cod/js/funciones.php";
                if ($javascript_soportado && $javascript_version >= 2)
                {
                    //echo '<script language="JavaScript1.2" src="cod/js/js2.js"></script>';
                    include_once "cod/js/js2.php";
                }
                else
                {
                    //echo '<script language="JavaScript1.2" src="cod/js/js1.js"></script>';
                    include_once "cod/js/js1.php";
                }
            }
        ?>
        <link rev="made" href="mailto:<?php echo $autor_email; ?>">
        <link rel="shortcut icon" href="favicon.ico">
        <link rel="icon" href="favicon.ico"> 
    </head>
    <?php $codigoJS_click = ""; if ($javascript_soportado && $javascript_version >= 2) { $codigoJS_click = ' onClick="ocultar_menus_dhtml();"'; } ?>
    <body text="<?php echo $constantes["COLOR_TEXTO_GENERAL"]; ?>" link="<?php echo $constantes["COLOR_LINK"]; ?>" alink="<?php echo $constantes["COLOR_LINK_ACTIVE"]; ?>" vlink="<?php echo $constantes["COLOR_LINK_VISITED"]; ?>" bgcolor="<?php echo $constantes["COLOR_BACKGROUND"]; ?>" leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onLoad="window.defaultStatus='<?php echo $constantes["WEB_TITULO"]; ?> &copy;'; return true;"<?php echo $codigoJS_click; ?><?php if ($ajax_soportado) { ?> onUnload="detener_registrar = true;"<?php } ?> id="tagbody">
        <br>
        <center>
        <?php
            //if (isset($constantes["USAR_SISTEMA_LOGIN"]) && $constantes["USAR_SISTEMA_LOGIN"] && file_exists("cod/func/web/login.php"))
			if (isset($constantes["USAR_SISTEMA_LOGIN"]) && $constantes["USAR_SISTEMA_LOGIN"] && file_exists("cod/sistema_login.php"))
            {
                if ($ajax_soportado) { echo '<div id="sistema_login">'; }
                include_once "cod/sistema_login.php";
                if ($ajax_soportado) { echo '</div>'; }

                //Si se soporta JavaScript 2 y no se ha usado ajax, pero si se soporta, quiere decir que se ha dado a actualizar o hemos accedido de alguna forma a esta pagina sin usar ajax, asi que creamos los elementos que usa ajax al cambiar de categoria para que no de error:
                if (isset($identificado) && $identificado && $javascript_soportado && $javascript_version >= 2 && $ajax_soportado && !$usando_ajax)
                {                                                
                    echo '<form style="display:none;">';
                    echo '<input type="hidden" name="login_categoria" id="login_categoria" value="' .  $id_categoria . '">';
                    echo '<input type="hidden" name="login_idioma" id="login_idioma" value="' . $id_idioma . '">';
                    echo '<input type="hidden" name="login_this_file" id="login_this_file" value="' . $this_file . '">';
                    echo "</form>";
                }
            }
            else
            {
                if ($ajax_soportado) { echo '<div id="sistema_login" style="visibility:hidden; position:absolute;"></div>'; }
            }
        ?>
        <table background="img/web/bg/body.gif" bgcolor="<?php echo $constantes["COLOR_TABLA_PRINCIPAL"]; ?>" width="<?php echo $ancho_tabla; ?>" border="0" cellspacing="0" cellpadding="0" align="center">
            <tr>
                <td width="<?php echo $ancho_tabla; ?>" background="img/web/bg/body.gif" align="center" valign="bottom">
                    <img src="<?php echo $directorio_logos; ?>/bar1.gif" width="<?php echo $ancho_tabla; ?>" height="66" alt="Alba Patchwork" title="Alba Patchwork" border="0" hspace="0" vspace="0" align="left" align="bottom"><?php if ($ajax_soportado) { echo '<img src="img/contenido/gorjuss.gif" style="position:absolute; right:30%; top:2px; padding:0px; margin:0px;">'; } ?></td>
            </tr>
            <tr>
                <td width="<?php echo $ancho_tabla; ?>" align="center" valign="top">
                    <table width="<?php echo $ancho_tabla; ?>" border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td width="1" bgcolor="<?php echo $constantes["COLOR_MARGENES_PRINCIPALES"]; ?>" background="img/web/margin.jpg" align="center" valign="middle">
                                <table width="1" border="0" cellspacing="0" cellpadding="0" bgcolor="<?php echo $constantes["COLOR_MARGENES_PRINCIPALES"]; ?>" background="img/web/margin.jpg"><tr><td bgcolor="<?php echo $constantes["COLOR_MARGENES_PRINCIPALES"]; ?>" background="img/web/margin.jpg" width="1" align="center" valign="middle">
                                <!-- <img src="img/blank.gif" alt="" title="" width="0" height="1" border="0" hspace="0" vspace="0" align="center" align="middle"> -->
                                </td></tr></table>
                            </td>
                            <td width="<?php echo $ancho_menu; ?>" bgcolor="<?php echo $constantes["COLOR_MENU_PRINCIPAL"]; ?>" background="img/web/bg/menu.jpg" valign="top">
                                <center>
                                <?php
                                    if ($ajax_soportado) { echo '<div id="banderas">'; }
                                    
                                    //Incluye las banderas (si hay mas de un idioma):
                                    include_once "cod/banderas.php";

                                    if ($ajax_soportado) { echo '</div><br>'; }
                                    else { echo "<br><br>"; }

                                    //Incluye el menu en DHTML (solo si se soporta y asi lo hemos definido en constantes):
                                    if ($javascript_soportado && $javascript_version >= 2 && $constantes["USAR_MENU_DHTML"]) { require_once "cod/menu_dhtml.php"; }

                                    if ($ajax_soportado) { echo '<div id="menu">'; }
                                    
                                    //Incluye el menu:
                                    require_once "cod/menu.php";
                                    
                                    if ($ajax_soportado) { echo '</div>'; }
                                ?>
                                </center>
                                <table width="<?php echo $ancho_menu; ?>" cellspacing="0" cellpadding="0" border="0"><tr><td></td></tr></table>
                            </td>
                            <td width="<?php echo $ancho_body; ?>" background="img/web/bg/body.gif" align="center" valign="top">
                                <center>
                                <table width="<?php echo $margen_body; ?>" background="img/web/bg/body.gif" border="0" cellspacing="0" cellpadding="0">
                                    <tr>
                                        <td width="<?php echo $margen_body; ?>" valign="top"<?php if ($ajax_soportado) { echo ' id="cuerpo"'; } ?>>
                                            <?php
                                                //Incluye el codigo de la seccion en la que estamos:
                                                require_once "cod/cuerpo.php";
                                            ?>
                                        </td>
                                    </tr>
                                </table>
                                <table width="<?php echo $ancho_body; ?>" cellspacing="0" cellpadding="0" border="0"><tr><td></td></tr></table>
                                </center>
                            </td>
                            <td width="4" bgcolor="<?php echo $constantes["COLOR_MENU_PRINCIPAL"]; ?>" background="img/web/bg/menu.jpg" align="center" valign="middle">
                                <!-- <table width="4" border="0" cellspacing="0" cellpadding="0" bgcolor="#3173f7" background="img/menubg.jpg"><tr><td bgcolor="#3173f7" background="img/menubg.jpg" width="4" align="center" valign="middle"> -->
                                <img src="img/web/blank.gif" alt="" title="" width="0" height="1" border="0" hspace="0" vspace="0" align="center" align="middle">
                                <!-- </td></tr></table> -->
                            </td>
                            <td width="1" bgcolor="<?php echo $constantes["COLOR_MARGENES_PRINCIPALES"]; ?>" background="img/web/margin.jpg" align="center" valign="middle">
                                <table width="1" border="0" cellspacing="0" cellpadding="0" bgcolor="<?php echo $constantes["COLOR_MARGENES_PRINCIPALES"]; ?>" background="img/web/margin.jpg"><tr><td bgcolor="<?php echo $constantes["COLOR_MARGENES_PRINCIPALES"]; ?>" background="img/web/margin.jpg" width="1" align="center" valign="middle">
                                <!-- <img src="img/blank.gif" alt="" title="" width="0" height="1" border="0" hspace="0" vspace="0" align="center" align="middle"> -->
                                </td></tr></table>
                            </td>
                        </tr>                            
                    </table>
                </td>
            </tr>
            <tr>
                <td width="<?php echo $ancho_tabla; ?>" background="img/web/bg/body.gif" align="center" valign="top">
                    <img src="<?php echo $directorio_logos; ?>/bar2.gif" alt="---" title="---" width="<?php echo $ancho_tabla; ?>" height="66" border="0" hspace="0" vspace="0" align="left" align="bottom">
                </td>
            </tr>
        </table>
        </center>
        <center>
            <table cellspacing="0" cellpadding="3" border="0">
                <tr>
                    <td>
                        <font color="<?php echo $constantes["COLOR_TEXTO_AUTOR"]; ?>" size="2" face="arial">
                        <span class="autor">Designed and coded by <a href="mailto:<?php echo $autor_email; ?>" title="<?php echo $autor_email; ?>" class="autor"><?php echo $autor_nombre; ?></a></span>
                        </font>
                    </td>
                </tr>
            </table>
        </center>
        <br>
        <?php
            //Imprime las etiquetas traducibles en modo invisible, para poder usarlas en AJAX:
            if ($javascript_soportado && $javascript_version >= 2)
            {
                echo '<div id="div_etiquetas_traducibles" style="position:absolute; left:0px; top:0px; visibility:hidden;">';
                require_once "cod/func/etiquetas_ajax.php";
                echo '</div>';
            }
        ?>
    </body>
</html>
<?php
    //Desconecta de la base de datos:
    $base_datos->desconecta();
?>
