<?php

    //Permite una demora de carga "infinita":
    if (!ini_get("safe_mode")) { @set_time_limit(0); }

    require_once "func/cesta_funciones.php";

    if (file_exists("cod/func/web/fecha.php")) { include_once "cod/func/web/fecha.php"; }
    else if (file_exists("func/web/fecha.php")) { include_once "func/web/fecha.php"; }
    if (file_exists("cod/func/web/hora.php")) { include_once "cod/func/web/hora.php"; }
    else if (file_exists("func/web/hora.php")) { include_once "func/web/hora.php"; }

    if (file_exists("cod/func/web/validar_email.php")) { require_once "cod/func/web/validar_email.php"; }
    else if (file_exists("func/web/validar_email.php")) { require_once "func/web/validar_email.php"; }
    if (file_exists("func/email.php")) { require_once "func/email.php"; }

    $confirmar = recoger_post("confirmar");
    if (trim($confirmar) == "") { $confirmar = recoger_get("confirmar"); }
    
    if (trim($confirmar) == "si")
    {
        echo '<center><table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center><b>';
        echo usar_etiqueta("PEDIDO_ALTERNATIVA_TEXTO");
        echo '</b></center></td></tr></table>';
        echo "<br>";

        $manual = recoger_post("manual");
        if (trim($manual) == "") { $manual = (recoger_get("manual") == "si"); }
        
        //Si se ha enviado el formulario, lo procesa:
        $enviado = (recoger_post("pedido") == "si");
        //if (trim($enviado) == "") { $enviado = recoger_get("enviado"); }
        if ($enviado)
        {
            $formValido = validarFormularioPedido($manual);
            if ($formValido) { $formValido = procesarFormularioPedido($manual); }
        }
        
        //...pero si no se ha enviado o es erroneo, lo muestra:
        if (!$enviado || $enviado && !$formValido)
        {
            mostrarFormularioPedido($manual);
        }
    }
    else
    {
        require_once "func/cesta_funciones.php";

        //Muestra la cesta, de forma no editable:
        mostrar_cesta(FALSE);
    }
    
    //Funcion que devuelve los datos por defecto de un particular o de una empresa:
    function recoger_datos_por_defecto()
    {
        global $base_datos;
        
        $identificado = (recoger_sesion("identificado")) ? true : false;
        
        if (!$identificado) { return false; }
        
        $usuario = recoger_sesion("usuario");
        $tipo = recoger_sesion("tipo");
        
        $usuario = mysqli_real_escape_string($base_datos->conexion, trim($usuario));
        $tipo = mysqli_real_escape_string($base_datos->conexion, strtolower($tipo));

        if ($tipo != "particular" && $tipo != "empresa") { return false; }
        if ($tipo == "" || $usuario == "") { return false; }
        
        $sufijo = "s";
        if ($tipo == "particular") { $sufijo = "es"; }
        $consulta = "SELECT * FROM compradores_" . $tipo . $sufijo . " WHERE usuario LIKE '$usuario'";
        $resultados = $base_datos->haz_consulta($consulta);
        $row = mysqli_fetch_assoc($resultados);
        $id_usuario = $row["id_" . $tipo];
       
        $consulta = "SELECT * FROM " . $tipo . $sufijo . " AS a LEFT JOIN " . $tipo . "_datos AS b, " . $tipo . "_datos_por_defecto AS c ON a.id_$tipo = b.id_$tipo AND b.id_$tipo = c.id_$tipo AND c.id_" . $tipo . "_datos = b.id_" . $tipo . "_datos WHERE a.id_$tipo = $id_usuario";
        $resultados = $base_datos->haz_consulta($consulta);
        
        if (mysqli_num_rows($resultados) > 0)
        {
            $row = mysqli_fetch_assoc($resultados);
            $datos = Array();
            
            $datos["nombre"] = $row["nombre"];
            $datos["telefono"] = $row["telefono"];
            $datos["fax"] = $row["fax"];
            $datos["email"] = $row["email"];
            $datos["direccion"] = $row["direccion"];
            $datos["poblacion"] = $row["poblacion"];
            $datos["codigo_postal"] = $row["codigo_postal"];
            $datos["provincia_o_estado"] = $row["provincia_o_estado"];
            $datos["pais"] = $row["pais"];
            
            return $datos;
        }
        
        return false;
    }
    
    //Funcion que muestra el formulario de pedido (tiene en cuenta si es manual o no):
    function mostrarFormularioPedido($manual)
    {
        global $margen_body, $margen_tablas, $javascript_soportado, $javascript_version, $id_idioma, $constantes, $sesion_form;
        
        $nombre = $telefono = $fax = $email = $direccion = $poblacion = $codigo_postal = $provincia_o_estado = $pais = $comentarios = "";
        
        if (recoger_sesion("identificado") && (recoger_sesion("tipo") == "empresa" || recoger_sesion("tipo") == "particular"))
        {
            $valores_por_defecto = recoger_datos_por_defecto();
            
            if (is_array($valores_por_defecto))
            {
                $nombre = html_entity_decode($valores_por_defecto["nombre"]);
                $fax = html_entity_decode($valores_por_defecto["fax"]);
                $telefono = html_entity_decode($valores_por_defecto["telefono"]);
                $email = html_entity_decode($valores_por_defecto["email"]);
                $direccion = html_entity_decode($valores_por_defecto["direccion"]);
                $poblacion = html_entity_decode($valores_por_defecto["poblacion"]);
                $codigo_postal = html_entity_decode($valores_por_defecto["codigo_postal"]);
                $provincia_o_estado = html_entity_decode($valores_por_defecto["provincia_o_estado"]);
                $pais = html_entity_decode($valores_por_defecto["pais"]);
            }
        }
        
        //Si se ha enviado el formulario anteriormente, carga los datos:
        if (recoger_post("pedido") == "si")
        {
            $nombre = recoger_post("nombre");
            $telefono = recoger_post("telefono");
            $fax = recoger_post("fax");
            $email = recoger_post("email");
            $direccion = recoger_post("direccion");
            $poblacion = recoger_post("poblacion");
            $codigo_postal = recoger_post("codigo_postal");
            $provincia_o_estado = recoger_post("provincia_o_estado");
            $pais = recoger_post("pais");
            $comentarios = recoger_post("comentarios");
        }

        echo '<center><table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center><b>';

        if ($javascript_soportado && $javascript_version >= 2)
        {
            echo '<div id="pedido_errores" class="alerta_producto"></div>';
        }

        $codigoJS_label_nombre = "";
        $codigoJS_label_telefono = "";
        $codigoJS_label_fax = "";
        $codigoJS_label_email = "";
        $codigoJS_label_direccion = "";
        $codigoJS_label_poblacion = "";
        $codigoJS_label_codigo_postal = "";
        $codigoJS_label_provincia_o_estado = "";
        $codigoJS_label_pais = "";
        $codigoJS_label_comentarios = "";
        $codigoJS_texto = $codigoJS_boton = "";
        if ($javascript_soportado && $javascript_version >= 2)
        {
            $codigoJS_label_prototipo = ' onMouseOver="document.getElementById(\'prototipo_label\').style.color=\'#ccccff\'; document.getElementById(\'prototipo\').style.background=\'#3333ff\'; document.getElementById(\'prototipo\').style.color=\'#aaaaff\'; document.getElementById(\'prototipo\').style.border=\'1px solid #0000ff\';" onMouseOut="document.getElementById(\'prototipo_label\').style.color=\'#ffffff\'; document.getElementById(\'prototipo\').style.background=\'#3333bb\'; document.getElementById(\'prototipo\').style.color=\'#bbbbff\'; document.getElementById(\'prototipo\').style.border=\'1px solid #0000aa\';"';
    
            $codigoJS_label_nombre = str_replace("prototipo", "nombre", $codigoJS_label_prototipo);
            $codigoJS_label_telefono = str_replace("prototipo", "telefono", $codigoJS_label_prototipo);
            $codigoJS_label_fax = str_replace("prototipo", "fax", $codigoJS_label_prototipo);
            $codigoJS_label_email = str_replace("prototipo", "email", $codigoJS_label_prototipo);
            $codigoJS_label_direccion = str_replace("prototipo", "direccion", $codigoJS_label_prototipo);
            $codigoJS_label_poblacion = str_replace("prototipo", "poblacion", $codigoJS_label_prototipo);
            $codigoJS_label_codigo_postal = str_replace("prototipo", "codigo_postal", $codigoJS_label_prototipo);
            $codigoJS_label_provincia_o_estado = str_replace("prototipo", "provincia_o_estado", $codigoJS_label_prototipo);
            $codigoJS_label_pais = str_replace("prototipo", "pais", $codigoJS_label_prototipo);
            $codigoJS_label_comentarios = str_replace("prototipo", "comentarios", $codigoJS_label_prototipo);

            $codigoJS_texto = ' onMouseOver="this.style.background=\'#3333ff\'; this.style.color=\'#aaaaff\'; this.style.border=\'1px solid #0000ff\';" onMouseOut="this.style.background=\'#3333bb\'; this.style.color=\'#bbbbff\'; this.style.border=\'1px solid #0000aa\';"';
            $codigoJS_boton = ' onMouseOver="this.style.background=\'#ddddff\'; this.style.color=\'#3333cc\';" onMouseOut="this.style.background=\'#ddddee\'; this.style.color=\'#333366\';"';
        }

        $onSubmit = "";
        if ($javascript_soportado) { $manual_js = ($manual) ? "true" : "false"; $onSubmit = ' onSubmit="return validarPedido(' . $id_idioma . ', ' . $manual_js . ');"'; }

        $ancho = $constantes["IMAGENES_PRODUCTOS_MINI_ANCHO"];
		$version_encogida = FALSE;
        if (($margen_body - 100) <= $ancho) { $version_encogida = TRUE; }
	    $numero_caracteres = 40;
	    $numero_caracteres_intermedio = 30;
	    $numero_caracteres_otros = 20;
	    $numero_filas_comentarios = 10;
		if ($version_encogida) { $numero_caracteres = 7; $numero_caracteres_otros = 6; $numero_filas_comentarios = 5; $numero_caracteres_intermedio = 6; }

        echo '<form method="post" action="' . $constantes["PEDIDO_ARCHIVO"] . '" name="formulario_pedido" id="formulario_pedido" class="pedido"' . $onSubmit . '>';
        echo $sesion_form;
        echo '<input type="hidden" name="confirmar" value="si">';
        echo '<input type="hidden" name="pedido" value="si">';

        if ($manual) { echo '<input type="hidden" name="manual" value="si">'; }

        echo '<br><center><table border="0" align="center">';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="nombre"' . $codigoJS_label_nombre . ' id="nombre_label">';
                echo usar_etiqueta("NOMBRE_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                if (trim($nombre) == "" && recoger_sesion("identificado") && recoger_sesion("tipo") == "particular") { $nombre = htmlentities(recoger_sesion("usuario"), ENT_COMPAT, 'utf-8'); }
                echo '<label for="nombre"' . $codigoJS_label_nombre . '>';
                echo '<input type="text" name="nombre" id="nombre" value="' . htmlentities($nombre, ENT_COMPAT, 'utf-8') . '" size="' . $numero_caracteres . '" class="texto"' . $codigoJS_texto . '> *';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="telefono"' . $codigoJS_label_telefono . ' id="telefono_label">';
                echo usar_etiqueta("TELEFONO_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                echo '<label for="telefono"' . $codigoJS_label_telefono . '>';
                echo '<input type="text" name="telefono" id="telefono" value="' . htmlentities($telefono, ENT_COMPAT, 'utf-8') . '" size="' . $numero_caracteres_otros . '" class="texto"' . $codigoJS_texto . '> *';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="fax"' . $codigoJS_label_fax . ' id="fax_label">';
                echo usar_etiqueta("FAX_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                echo '<label for="fax"' . $codigoJS_label_fax . '>';
                echo '<input type="text" name="fax" id="fax" value="' . htmlentities($fax, ENT_COMPAT, 'utf-8') . '" size="' . $numero_caracteres_otros . '" class="texto"' . $codigoJS_texto . '>';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="email"' . $codigoJS_label_email . ' id="email_label">';
                echo usar_etiqueta("EMAIL_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                echo '<label for="email"' . $codigoJS_label_email . '>';
                echo '<input type="text" name="email" id="email" value="' . htmlentities($email, ENT_COMPAT, 'utf-8') . '" size="' . $numero_caracteres . '" class="texto"' . $codigoJS_texto . '> *';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="direccion"' . $codigoJS_label_direccion . ' id="direccion_label">';
                echo usar_etiqueta("DIRECCION_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                echo '<label for="direccion"' . $codigoJS_label_direccion . '>';
                echo '<input type="text" name="direccion" id="direccion" value="' . htmlentities($direccion, ENT_COMPAT, 'utf-8') . '" size="' . $numero_caracteres . '" class="texto"' . $codigoJS_texto . '> *';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="poblacion"' . $codigoJS_label_poblacion . ' id="poblacion_label">';
                echo usar_etiqueta("POBLACION_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                echo '<label for="poblacion"' . $codigoJS_label_poblacion . '>';
                echo '<input type="text" name="poblacion" id="poblacion" value="' . htmlentities($poblacion, ENT_COMPAT, 'utf-8') . '" size="' . $numero_caracteres_intermedio . '" class="texto"' . $codigoJS_texto . '> *';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="codigo_postal"' . $codigoJS_label_codigo_postal . ' id="codigo_postal_label">';
                echo usar_etiqueta("CODIGO_POSTAL_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                echo '<label for="codigo_postal"' . $codigoJS_label_codigo_postal . '>';
                echo '<input type="text" name="codigo_postal" id="codigo_postal" value="' . htmlentities($codigo_postal, ENT_COMPAT, 'utf-8') . '" size="6" class="texto"' . $codigoJS_texto . '> *';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="provincia_o_estado"' . $codigoJS_label_provincia_o_estado . ' id="provincia_o_estado_label">';
                echo usar_etiqueta("PROVINCIA_O_ESTADO_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                echo '<label for="provincia_o_estado"' . $codigoJS_label_provincia_o_estado . '>';
                echo '<input type="text" name="provincia_o_estado" id="provincia_o_estado" value="' . htmlentities($provincia_o_estado, ENT_COMPAT, 'utf-8') . '" size="' . $numero_caracteres_intermedio . '" class="texto"' . $codigoJS_texto . '> *';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs"><b>';
                echo '<label for="pais"' . $codigoJS_label_pais . ' id="pais_label">';
                echo usar_etiqueta("PAIS_TEXTO") . ': ';
                echo '</label>';
            echo '</b></td><td align="left" class="formulario_inputs">';
                echo '<label for="pais"' . $codigoJS_label_pais . '>';
                echo '<input type="text" name="pais" id="pais" value="' . htmlentities($pais, ENT_COMPAT, 'utf-8') . '" size="' . $numero_caracteres_intermedio . '" class="texto"' . $codigoJS_texto . '> *';
                echo '</label>';
            echo '</td></tr>';

            echo "<tr>";
            echo '<td align="right" class="formulario_inputs" valign="top"><b>';
                echo '<label for="comentarios"' . $codigoJS_label_comentarios . ' id="comentarios_label">';
                if (!$manual) { echo usar_etiqueta("COMENTARIOS_TEXTO") . ': '; }
                else { echo usar_etiqueta("PEDIDO_Y_COMENTARIOS_TEXTO") . ': '; }
                echo '</label>';
            echo '</b></td><td align="left" valign="top" class="formulario_inputs">';
                echo '<label for="comentarios"' . $codigoJS_label_comentarios . '>';
                echo '<textarea name="comentarios" id="comentarios" class="texto" cols="' . $numero_caracteres . '" rows="' . $numero_filas_comentarios . '"' . $codigoJS_texto . '>' . htmlentities($comentarios, ENT_COMPAT, 'utf-8') . '</textarea>';
                if ($manual) { echo " *"; }
                echo '</label>';
            echo '</td></tr>';

        echo '</table>';
    
        echo '<table border="0" align="center"><tr><td align="center" class="formulario_inputs"><center><b>';
    
        //echo "* Los campos marcados con asterisco son obligatorios.";
        echo "* " . usar_etiqueta("CAMPOS_OBLIGATORIOS_ASTERISCO");
    
        //echo '</b></center></td></tr></table>';
    
	    echo '</b></center></td></tr><tr><td align="center" class="formulario_inputs" colspan="2"><center>'; //Para que funcione JS en nuevos navegadores.

        echo '<br><input type="submit" name="boton" value="' . usar_etiqueta("ENVIAR") . '" class="boton"' . $codigoJS_boton . '>';

        echo '</form>';

		echo "</center></td></tr></table>"; //Para que funcione JS en nuevos navegadores.
    
        echo '</b></center></td></tr></table><br>';
    }

    //Funcion que valida el formulario de pedido:
    function validarFormularioPedido($manual)
    {
        global $margen_body, $margen_tablas;
        
        $errores = "";

        $nombre = recoger_post("nombre");
        $telefono = recoger_post("telefono");
        //$fax = recoger_post("fax");
        $email = recoger_post("email");
        $direccion = recoger_post("direccion");
        $poblacion = recoger_post("poblacion");
        $codigo_postal = recoger_post("codigo_postal");
        $provincia_o_estado = recoger_post("provincia_o_estado");
        $pais = recoger_post("pais");
        $comentarios = recoger_post("comentarios");
        
        if ($nombre == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        if ($telefono == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        if ($direccion == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        if ($poblacion == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        if ($codigo_postal == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        if ($provincia_o_estado == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        if ($pais == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        if ($manual && $comentarios == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        if ($email == "") { $errores = usar_etiqueta("CAMPOS_OBLIGATORIOS_ERROR") . "<br>"; }
        else if (!validar_email($email)) { $errores .= usar_etiqueta("EMAIL_ERROR") . "<br>"; }

        if (trim($errores) != "")
        {
            echo '<center><table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center><b>';
                echo $errores;
            echo '</b></center></td></tr></table>';
        }
        
        return ($errores == "");
    }
    
    //Funcion que procesa el formulario de pedido (tiene en cuenta si es manual o no):
    function procesarFormularioPedido($manual, $html = TRUE)
    {
        global $margen_body, $margen_tablas, $constantes;
        //$todoBien = FALSE;

        $nombre = recoger_post("nombre");
        $telefono = recoger_post("telefono");
        $fax = recoger_post("fax");
        $email = recoger_post("email");
        $direccion = recoger_post("direccion");
        $poblacion = recoger_post("poblacion");
        $codigo_postal = recoger_post("codigo_postal");
        $provincia_o_estado = recoger_post("provincia_o_estado");
        $pais = recoger_post("pais");
        $comentarios = recoger_post("comentarios");
        
        $email_destino = $constantes["EMAIL_PEDIDOS"];
        if ($manual) { $asunto = "Pedido manual mediante el formulario web de Alba Patchwork"; $comentario_o_pedido = "Pedido y comentarios"; }
        else { $asunto = "Pedido mediante el formulario web de Alba Patchwork"; $comentario_o_pedido = "Comentarios"; }
        $texto = "
                Nombre: <b>" . htmlentities($nombre, ENT_COMPAT, 'utf-8') . "</b><br>
                Tel&eacute;fono: <b>" . htmlentities($telefono, ENT_COMPAT, 'utf-8') . "</b><br>
                Fax: <b>" . htmlentities($fax, ENT_COMPAT, 'utf-8') . "</b><br>
                E-Mail: <b>" . htmlentities($email, ENT_COMPAT, 'utf-8') . "</b><br>
                Direcci&oacute;n: <b>" . htmlentities($direccion, ENT_COMPAT, 'utf-8') . "</b><br>
                Poblaci&oacute;n: <b>" . htmlentities($poblacion, ENT_COMPAT, 'utf-8') . "</b><br>
                C&oacute;digo postal: <b>" . htmlentities($codigo_postal, ENT_COMPAT, 'utf-8') . "</b><br>
                Provincia o estado: <b>" . htmlentities($provincia_o_estado, ENT_COMPAT, 'utf-8') . "</b><br>
                Pais: <b>" . htmlentities($pais, ENT_COMPAT, 'utf-8') . "</b><br>
                " . $comentario_o_pedido . ":<br><b>" . str_replace("<br />", "<br>", nl2br(htmlentities($comentarios, ENT_COMPAT, 'utf-8'))) . "</b><br>
                ";
        
        if (!$manual) { $texto .= "Cesta:<br>" . obtener_cesta_html() . " <br>"; }

        //Intenta enviar el E-Mail:
        $todoBien = @enviar_email($email_destino, $asunto, $texto, $email, $nombre);

        echo '<center><table border="0" width="' . ($margen_body - $margen_tablas) . '" align="center" class="cesta_base"><tr><td align="center" class="cesta_producto"><center><b>';
        if ($todoBien)
        {
            //echo "E-Mail de contacto enviado.";
            echo usar_etiqueta("PEDIDO_ENVIADO");
            echo "<br>";
            echo usar_etiqueta("MODO_ENVIO");
            
            //Borra la cesta:
            setear_sesion("cesta", Array());
            
            //Envia E-Mail de confirmacion:
            $email_confirmacion = @enviar_email($email, $asunto, usar_etiqueta("PEDIDO_ENVIADO") . "<br>" . usar_etiqueta("MODO_ENVIO") . "<br><br>" . $texto, $email_destino, "", TRUE, FALSE, FALSE, FALSE);
            if (!$email_confirmacion) { registrar("error", "Fallo al enviar E-Mail de confirmacin de pedido a " . $email); }
        }
        else
        {
            //echo "No se pudo enviar el E-Mail de contacto. Vuelva a intentarlo m&aacute;s tarde si lo cree conveniente. Disculpe las molestias.";
            echo usar_etiqueta("PEDIDO_ERROR");
        }
        echo '</b></center></td></tr></table>';

        //Pone un salto de linea en cada <br> para que se pueda ver en clientes de email basados en texto (sin HTML):
        $texto = str_replace("<br/>", "<br>\n", str_replace("<br />", "<br>\n", str_replace("<br>", "<br>\n", $texto)));
        $texto_sin_nl = preg_replace("/\r\n|\r|\n/", "", $texto);

        //Si el email no debe contener HTML, quita los tags:
        //if (!$html) { $texto = html_entity_decode(strip_tags($texto)); }

        //Se registra en el archivo de pedidos:
        registrar("pedido", "<hr>INICIO DE PEDIDO<hr><br>\n" . $asunto . ":\n<br>" . $texto_sin_nl . "<br>\n<hr>FIN DE PEDIDO<hr><br><br>\n\n");
      
        return $todoBien;
    }
?>
