<?php
	if (!ini_get("safe_mode")) { @set_time_limit(0); }
	
	session_name("albapatch_session_admin");
	if (@!session_start("albapatch_session_admin"))
	{
		session_regenerate_id();
		session_start("albapatch_session_admin");
	}
	if (file_exists("../cod/func/web/recoger_sesion.php"))
	{
		require_once("../cod/func/web/recoger_sesion.php");
	}
	else
	{
		require_once("../../cod/func/web/recoger_sesion.php");
	}
	$autorizado = recoger_sesion("autorizado");
	if ($autorizado != "si") { exit(0); }

    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Pragma: no-cache");

	if (file_exists("../cod/func/web/recoger_post.php"))
	{
		require_once("../cod/func/web/recoger_post.php");
	}
	else
	{
		require_once("../../cod/func/web/recoger_post.php");
	}

	$mostrar_contador = strtolower(trim(recoger_post("mostrar_contador")));
	if ($mostrar_contador != "si") { exit(0); }
	
	$tipo = strtolower(trim(recoger_post("tipo")));

	$tipos_permitidos = array("pedido", "contacto", "email", "error", "ajax");
	
	if ($tipo == "" || !in_array($tipo, $tipos_permitidos)) { exit(0); }
	
	$archivo = "logs/" . $tipo . ".php";
	
	$existeArchivo = FALSE;
	if (file_exists($archivo))
	{
		require_once($archivo);
		$existeArchivo = TRUE;
	}
	else if ("../" . $archivo)
	{
		require_once("../" . $archivo);
		$existeArchivo = TRUE;
	}

	if ($existeArchivo)
	{
		$archivo_archivados = "logs/" . $tipo . "_archivados.php";
		
		$existeArchivoArchivados = FALSE;
		if (file_exists($archivo_archivados))
		{
			require_once($archivo_archivados);
			$existeArchivoArchivados = TRUE;
		}
		else if (file_exists("../" . $archivo_archivados))
		{
			require_once("../" . $archivo_archivados);
			$existeArchivoArchivados = TRUE;
		}
		
		$numero_mensajes = 0;
		$mensajes_archivados = 0;
		$mensajes_no_archivados = 0;
		foreach ($mensajes as $id => $mensaje)
		{
			if (!isset($mensaje["fecha"])) { continue; }
			else if (!isset($mensaje["hora"])) { continue; }
			else if (!isset($mensaje["ip_dns"])) { continue; }
			else if (!isset($mensaje["session_name"])) { continue; }
			else if (!isset($mensaje["session_id"])) { continue; }
			else if (!isset($mensaje["contenido"])) { continue; }

			$numero_mensajes++;
			if (isset($mensajes[$id]["archivado"]) && $mensajes[$id]["archivado"]) { $mensajes_archivados++; }
			else { $mensajes_no_archivados++; }
		}
		$registro_registros = ($numero_mensajes == 1) ? "registro" : "registros";
		$archivado_archivados = ($mensajes_archivados == 1) ? "archivado" : "archivados";
		$no_archivado_no_archivados = ($mensajes_no_archivados == 1) ? "no archivado" : "no archivados";
		echo '<span style="font-weight:bold;">Total:</span> ' . $numero_mensajes . ' ' . $registro_registros;
		echo ' (';
			echo $mensajes_archivados . ' ' . $archivado_archivados . ', ';
			echo $mensajes_no_archivados . ' ' . $no_archivado_no_archivados;
		echo ')';
	}
?>