var idiomaInicial = "ca";
var idiomaActual;


function init()
{
	aplicarIdioma();
	setTimeout(preguntarIdioma, 100);
}


function preguntarIdioma()
{
	var selectorIdiomas = document.getElementById("selector_idiomas_inicio");
	if (selectorIdiomas != null)
	{
		selectorIdiomas.style.visibility = "visible";
	}
	return;
}


function ocultarPreguntarIdioma()
{
	var selectorIdiomas = document.getElementById("selector_idiomas_inicio");
	if (selectorIdiomas != null)
	{
		selectorIdiomas.style.visibility = "hidden";
	}
	return;
}


function aplicarIdioma()
{
	if (typeof(idiomaActual) == "undefined" || idiomaActual == null || idiomaActual == "")
	{
		idiomaActual = idiomaInicial;
	}

	cambiarElementosTodos(idiomaActual);
}


function cambiarIdioma()
{
	if (typeof(idiomaActual) == "undefined" || idiomaActual == null || idiomaActual == "")
	{
		idiomaActual = (idiomaInicial == "es") ? "ca" : "es";
	}

	var idiomaNuevo = (idiomaActual == "es") ? "ca" : "es";

	cambiarElementosTodos(idiomaNuevo);
	
	idiomaActual = idiomaNuevo;
	
	return;
}


function cambiarElementosTodos(idiomaNuevo)
{
	cambiarElementos(idiomaNuevo);
	cambiarElementos(idiomaNuevo, document.getElementById("menu_iframe"));
	cambiarElementos(idiomaNuevo, document.getElementById("cuerpo_iframe"));
	return;
}


function cambiarElementos(idiomaNuevo, iframe)
{
	var documentElement = document;
	if (typeof(iframe) != "undefined" && iframe != null)
	{
		documentElement = iframe.contentDocument || iframe.contentWindow.document;
	}

	var idiomaOcultar = (idiomaNuevo == "es") ? "ca" : "es";
	var elementos = getElementsByClassName(idiomaOcultar, documentElement);
	for (var x = 0; x <= elementos.length; x++)
	{
		if (elementos[x] != null)
		{
			elementos[x].style.visibility = "hidden";
			elementos[x].style.display = "none";
		}
	}

	elementos = getElementsByClassName(idiomaNuevo, documentElement);
	for (x = 0; x <= elementos.length; x++)
	{
		if (elementos[x] != null)
		{
			elementos[x].style.visibility = "visible";
			elementos[x].style.display = "inline-block";
		}
	}
}


function getElementsByClassName(classname, node)
{
	if (typeof(node) == "undefined" || node == null) { node = document; }
    var a = [];
    var re = new RegExp('(^| )'+classname+'( |$)');
    var els = node.getElementsByTagName("*");
    for(var i=0,j=els.length; i<j; i++)
        if(re.test(els[i].className))a.push(els[i]);
    return a;
}


/*
function getElementsByClassName(className)
{
    if (document.all) {
        var allElements = document.all;
    } else {
        var allElements = document.getElementsByTagName("*");
    }
 
    var foundElements = [];  
 
    for (var i = 0, ii = allElements.length; i < ii; i++) {
        if (allElements[i].className == className) {
            foundElements[foundElements.length] = allElements[i];
        }
    }
 
    return foundElements;
}*/
