/* Joc del Pong, compilat en Dev-C++ */

/* Biblioteques necessaries: */
#include <stdio.h>
#include <stdlib.h> /* Necessaria per utilitzar system(). */
//#include <ncurses.h> /* Necessaria en Unix per a utilitzar kbhit() i getch(). */
#include <conio.h> /* Necessaria en MS-DOS i Windows per a utilitzar kbhit() i getch(). */


/* Constants necessaries: */
#define ESBORRAR_PANTALLA "cls" /* En sistems posix ficar "clear". */
#define SEPARACIO_PALETES 21
#define AE 0 /* Direccio de la pilota cap adalt a l'esquerra. */
#define AD 1 /* Direccio de la pilota cap adalt a la dreta. */
#define BE 2 /* Direccio de la pilota cap abaix a l'esquerra. */
#define BD 3 /* Direccio de la pilota cap abaix a la dreta. */


/* Prototip de les funciones necessaries: */
void posxy(int x, int y); /* Analoga a gotoxy(). */
void representa_paletes(); /* Representa les paleta en unes coordenades. */
void mou_pilota(); /* Calcula colisions i mou la pilota. */
void mou_ordinador(); /* Mou la paleta del ordinador. */


/* Variables necessaries: */
int usuari_x = 0, ordinador_x = 0; /* Posicio horizontal de les paletes. */
int paletes_ample = 11; /* El ample de les paletes (sense contar l'espai final). */
int gols_ordinador = 0; /* Gols que ha fet l'ordinador. */
int gols_usuari = 0; /* Gols que ha fet l'usuari. */
int pilota_treta = 0; /* Variable boolean. 0 = pilota encara no treta. */
int li_toca_a = 0; /* 0 = li toca treure al ordinador, 1 = li toca treure al usuari */
int pilota_x = 0, pilota_y = 0; /* Coordenades de la pilota. */
//int pilota_direccio = (li_toca_a) ? AD : BE; /* Direccio inicial de la pilota. */
int pilota_direccio = AD;
int tope_x = 80; /* Tope de columnes. */
int tope_y = 25; /* Tope de files. */


/* Funcio principal: */
int main()
{
    /* Variables necessaries: */
    int tecla = 0;

    /* Representa la paleta del usuari i la de l'ordinador: */
    representa_paletes(usuari_x, ordinador_x);
    
    /* Mentre no es premi la tecla "escape": */
    while (tecla != 27)
    {
          /* Capturem la tecla: */
          if(kbhit()) { tecla = getch(); } /* Fletxa adalt: 72, abaix: 80, dreta: 77, esquerra: 75, espai: 32. */
          else { tecla = 0; }

          /* Si es prem la fletxa dreta, mou la paleta cap a la dreta: */
          if (tecla == 77) { usuari_x+=3; }
          /* Si es prem la fletxa esquerra, mou la paleta cap a l'esquerra: */
          if (tecla == 75) { usuari_x-=3; }
          /* Si es prem l'espai o la fletxa cap adalt i encara no s'ha tret i li toca treure al usuari, es treu: */
          if ((tecla == 32 || tecla == 72) && !pilota_treta && li_toca_a == 1) { pilota_treta = 1; }

          /* Si les coordenares son menors a 0, es fiquen a 0: */
          if (usuari_x < 0) { usuari_x = 0; }

          /* Si les coordenares son major que el seu tope, es fiquen al tope: */
          if (usuari_x + paletes_ample > tope_x) { usuari_x = tope_x - paletes_ample; }

          /* Fa moure al ordinador, si cal: */
          mou_ordinador();

          /* Representem la paleta del usuari i de l'ordinador: */
          representa_paletes(usuari_x, ordinador_x);
    }
    
    /* Surt del programa: */
    return 0;
}


/* Funcio que representa la paleta en unes coordenades: */
void representa_paletes()
{
     /* Variable contador: */
     int x;
     
     /* Esborra la pantalla: */
     system(ESBORRAR_PANTALLA);

     /* Dibuixa el marcador: */
     printf("Marcador: %d - %d ", gols_ordinador, gols_usuari);
     if (gols_ordinador > gols_usuari) { printf("(guanya ordinador)"); }
     else if (gols_ordinador < gols_usuari) { printf("(guanya usuari)"); }
     else { printf("(taules)"); }
     //printf(" [fletxes mou, ESC surt]");
     if (pilota_treta) { printf(" - Pilota treta"); }
     else { printf(" - Pilota no treta"); }
     printf(" (%d, %d)\n\n", pilota_x, pilota_y);

     /* Si no s'ha tret, actualitza les coordenades de la pilota: */
     if (!pilota_treta && li_toca_a == 0) { pilota_x = ordinador_x + (paletes_ample / 2); pilota_y = 4; }
     else if (!pilota_treta && li_toca_a == 1) { pilota_x = usuari_x + (paletes_ample / 2); pilota_y = 23; }
     
     /* Posiciona el cursor per dibuixar la paleta del ordinador: */
     for (x = 0; x < ordinador_x; x++) { printf(" "); }
     /* Dibuixa la paleta del ordinador: */
     printf("[=========] "); /* Fa un espai a la dreta per esborrar cap a dreta si existeis algun caracter. */     

     /* Si la pilota no sha tret i li toca treure al ordinador, la dibuixa a la seva paleta: */
     if (!pilota_treta && li_toca_a == 0) /* Podriem ficar !li_toca_a. */
     {
        printf("\n");
        for (x = 0; x < ordinador_x + (paletes_ample / 2); x++) { printf(" "); }
        printf("*");
     }
     else { printf("\n"); }

     /* Si ja s'ha tret: */
     if (pilota_treta)
     {
        /* Dibuia la pilota: */
        mou_pilota(usuari_x, ordinador_x);
     }
     /* ...pero si no: */
     else
     {
         /* Fa les lines que separen un jugador de l'altre: */
         for (x = 0; x < SEPARACIO_PALETES - 2; x++) { printf("\n"); }

         /* Si li toca treure al ordinador, ho fa: */
         if (!pilota_treta && li_toca_a == 0) { pilota_treta = 1; }
     }
     
     /* Si la pilota no sha tret i li toca treure al usuari, la dibuixa a la seva paleta: */
     if (!pilota_treta && li_toca_a == 1) /* Podriem ficar li_toca_a. */
     {
        for (x = 0; x < usuari_x + (paletes_ample / 2); x++) { printf(" "); }
        printf("*");
     }
     printf("\n");

     /* Posiciona el cursor per dibuixar la paleta del usuari: */
     for (x = 0; x < usuari_x; x++) { printf(" "); }
     /* Dibuixa la paleta del usuari: */
     printf("[=========] "); /* Fa un espai a la dreta per esborrar cap a dreta si existeis algun caracter. */     
}


/* Funcio que calcula colisions i mou la pilota: */
void mou_pilota()
{
     /* Variable contadora: */
     int x;

     /* Calcula si s'ha arribat a un limit vertical: */
     if ((pilota_direccio == AE || pilota_direccio == AD) && pilota_y == 4 && pilota_x >= ordinador_x && pilota_x <= ordinador_x + paletes_ample || (pilota_direccio == BE || pilota_direccio == BD) && pilota_y == 23 && pilota_x >= usuari_x && pilota_x <= usuari_x + paletes_ample)
     {
        /* ...si n'hi ha paleta, fa rebotar la pilota canviant la seva direccio: */
        if (pilota_direccio == AD) { pilota_direccio = BD; }
        else if (pilota_direccio == BD) { pilota_direccio = AD; }
        else if (pilota_direccio == AE) { pilota_direccio = BE; }
        else if (pilota_direccio == BE) { pilota_direccio = AE; }
     }
     /* ...pero si no, es fica un gol a qui correspongui i s'ha de treure un altre cop (si el gol ha sigut del ordinador treura el usuari o viceversa): */
     else if (pilota_y <= 4) { gols_usuari++; li_toca_a = 0; pilota_treta = 0; }
     else if (pilota_y >= 23) { gols_ordinador++; li_toca_a = 1; pilota_treta = 0; }

     /* Si no s'ha tret, actualitza les coordenades de la pilota: */
     //if (!pilota_treta && li_toca_a == 0) { pilota_x = ordinador_x + (paletes_ample / 2) + 1; pilota_y = 4; }
     //else if (!pilota_treta && li_toca_a == 1) { pilota_x = usuari_x + (paletes_ample / 2) + 1; pilota_y = 23; }
        
     /* Calcula si s'ha arribat a un limit horizontal i llavors fa rebotar la pilota: */
     if (pilota_x == tope_x)
     {
        if (pilota_direccio == AD) { pilota_direccio = AE; }
        else if (pilota_direccio == BD) { pilota_direccio = BE; }
     }
     else if (pilota_x == 0)
     {
        if (pilota_direccio == AE) { pilota_direccio = AD; }
        else if (pilota_direccio == BE) { pilota_direccio = BD; }
     }

     /* Calcula la X i la Y de la pilota segons la direccio que porta (sempre que no hagi agut un gol): */
     if (pilota_treta) /* Si ha agut un gol, pilota treta sera 0 i no entrara al if. */
     {
        if (pilota_direccio == AE) { pilota_x--; pilota_y--; }
        else if (pilota_direccio == AD) { pilota_x++; pilota_y--; }
        else if (pilota_direccio == BE) { pilota_x--; pilota_y++; }
        else if (pilota_direccio == BD) { pilota_x++; pilota_y++; }

     }

     /* Baixa linies segons pilota_y (entre la paleta de l'ordinador i la pilota): */
     for (x = 4; x < pilota_y; x++) { printf("\n"); }
     
     /* Fa espais segons pilota_x: */
     for (x = 0; x < pilota_x; x++) { printf(" "); }

     /* Dibuixa la pilota: */
     printf("*");
     
     /* Baixa linies segons pelota_y (entre la pilota i la paleta de l'usuari): */
     for (x = pilota_y + 1; x < tope_y - 1; x++) { printf("\n"); }

}


/* Funcio que mou la paleta del ordinador. */
void mou_ordinador()
{
     /* Si la pilota esta mes a la dreta que la paleta de l'ordinador, es mou a la dreta: */
     if (pilota_x > ordinador_x + (paletes_ample / 2)) { ordinador_x++; }
     /* ...pero si esta mes a l'esquerra, es mou cap a l'esquerra: */
     else if (pilota_x < ordinador_x + (paletes_ample / 2)) { ordinador_x--; }
     
     /* Si la paleta de l'ordinador esta fora dels topes, es fixa: */
     if (ordinador_x < 0) { ordinador_x = 0; }
     else if (ordinador_x > tope_x - paletes_ample) { ordinador_x = tope_x - paletes_ample; }
}
