#include <stdio.h>
#include <stdlib.h>

#define PAUSA "pause >NUL"
#define ESBORRA "cls"

#define booleana int
#define CERT 1
#define FALS 0

#define NOM 0
#define COGNOM1 1
#define TELEFON 2

#define DIM 10

struct contacte
{
       int numero;
       char nom[15];
       char cognom1[15];
       char cognom2[15];
       char telefon[10];
} agenda[DIM];

int dim = 0;
int ultim_numero = 0;

void entra_contacte();
void esborra_contacte(int num);
int mostra_agenda(booleana fer_pausa);
void mostra_contacte(int num);
void cerca(char dada[45], int lloc);
void ordena_alfabeticament();
char *minuscules(char *frase, char *minuscules);
void treure_espais(char *frase);
char *junta_nom(struct contacte persona, char *resultat);
int compara(int i, int j);
void mostra_capsalera();

int main()
{
    int opcio, num;
    char dada[45];

    do
    {
      system(ESBORRA);
      printf("\n\t== Menu ==\n\n\
      1) Entra un nou contacte\n\
      2) Esborra un contacte\n\
      3) Mostra tota l'agenda\n\
      4) Cerca per nom\n\
      5) Cerca per primer cognom\n\
      6) Cerca per telefon\n\
      7) Ordena alfabeticament\n\n\
      0) Sortir\n\n\
      \tOpcio: ");
      scanf("%d", &opcio);
      fflush(stdin);
      switch (opcio)
      {
             case 1: entra_contacte(); break;
             case 2:
                  if (mostra_agenda(FALS))
                  {
                     printf("\nFica el numero del contacte a esborrar: ");
                  } else { printf("No hi han contactes encara!"); }
                  scanf("%d", &num);
                  fflush(stdin);
                  esborra_contacte(num);
                  break;
             case 3:
                  mostra_agenda(CERT);
                  break;
             case 4:
                  printf("Fica el nom del contacte a cercar: ");
                  gets(dada);
                  cerca(dada, NOM);
                  break;
             case 5:
                  printf("Fica el primer cognom del contacte a cercar: ");
                  gets(dada);
                  cerca(dada, COGNOM1);
                  break;
             case 6:
                  printf("Fica el telefon del contacte a cercar: ");
                  gets(dada);
                  cerca(dada, TELEFON);
                  break;
             case 7:
                  ordena_alfabeticament();
                  break;
             default:
                      if (opcio != 0)
                      {
                         printf("Opcio incorrecta");
                         system(PAUSA);
                      }
                      break;
      }
    } while (opcio != 0);

    printf("\n\tAdeu!");

    system(PAUSA);
    return 0;
}

void entra_contacte()
{
    printf("\nFica el NOM del nou contacte: ");
    gets(agenda[dim].nom);
    treure_espais(agenda[dim].nom);
    printf("\nFica el PRIMER COGNOM del nou contacte: ");
    gets(agenda[dim].cognom1);
    printf("\nFica el SEGON COGNOM del nou contacte: ");
    gets(agenda[dim].cognom2);
    printf("\nFica el TELEFON del nou contacte: ");
    gets(agenda[dim].telefon);

    agenda[dim].numero = ultim_numero;

    ultim_numero++;
    dim++;

    return;
}

void esborra_contacte(int num)
{
     int x, x_trobat;
     booleana trobat = FALS;
    
     for (x = 0; x < dim && !trobat; x++)
     {
         if (agenda[x].numero == num) { trobat = CERT; x_trobat = x;}
     }
     
     if (trobat)
     {
        dim--;
        for (x = x_trobat; x < dim; x++)
        {
            agenda[x] = agenda[x+1];
        }
        printf("\nContacte numero %d esborrat!");
     } else { printf("\nNo s'ha trobat el contacte numero %d!", num); }

     system(PAUSA);

     return;    
}

int mostra_agenda(booleana fer_pausa)
{
    int x;

    mostra_capsalera();

    for (x = 0; x < dim; x++)
    {
        mostra_contacte(x);
    }
    
    if (dim == 0) { printf("\n\n\t\t\t\t[ Agenda buida! ]"); }
    
    if (fer_pausa) { system(PAUSA); }

    return dim;
}

void cerca(char dada[45], int lloc)
{
     int x = 0;
     char *dades, *minus_dades, *minus_dada = (char *) malloc(sizeof(char) * (strlen(dada) + 1));
     booleana trobat = FALS;

     if (lloc == NOM) { dades = agenda[0].nom; }
     else if (lloc == COGNOM1) { dades = agenda[0].cognom1; }
     else { dades = agenda[0].telefon; }

     minus_dades = (char *) malloc(sizeof(char) * (strlen(dades) + 1));

     mostra_capsalera();
     
     while (x++ < dim)
     {
           /* if ( !strcmp( minuscules(dada), minuscules(dades) ) ) */
           /* if (!strcmpi(dada, dades)) */
           if (strstr(minuscules(dades, minus_dades), minuscules(dada, minus_dada)))
           {
              mostra_contacte(x-1);
              trobat = CERT;
           }
           dades += sizeof(struct contacte);
     }
     
     if (!trobat) { printf("\n\n\t\t\t[ no s'han trobat coincidencies! ]"); }
     free(minus_dada);
     free(minus_dades);
     system(PAUSA);
     return;
}

void ordena_alfabeticament()
{
     int x, y;
     struct contacte temp;

     for (x = 1; x < dim; x++)
     {
         temp = agenda[x];
         for (y = x; y > 0 && compara(y-1 , y) > 0; y--)
         {
             agenda[y] = agenda[y-1];
         }
         agenda[y] = temp;
     }
     
     return;
}

char *junta_nom(struct contacte persona, char *resultat)
{
     strcpy(resultat, persona.cognom1);
     strcat(resultat, " ");
     strcat(resultat, persona.cognom2);
     strcat(resultat, " ");
     strcat(resultat, persona.nom);     
     strcat(resultat, " ");
     strcat(resultat, persona.telefon);
//     strcat(resultat," ");
//     strcat(resultat, (char) persona.numero); /* no n'hi ha un atoi() pero al inreves? */

     return resultat;
}

int compara(int i, int j)
{
     char cadena1[62], cadena2[62];
     return strcmpi(junta_nom(agenda[i], cadena1), junta_nom(agenda[j], cadena2));
}

void mostra_contacte(int num)
{
     printf("\n%3d %-15s %-15s %-15s %-10s", agenda[num].numero, agenda[num].nom, agenda[num].cognom1, agenda[num].cognom2, agenda[num].telefon);
}

void mostra_capsalera()
{
     printf("\nNum %-15s %-15s %-15s %-10s", "Nom", "Primer cognom", "Segon cognom", "Telefon");
}

char *minuscules(char *frase, char *minus)
{
    /* char *caracter_inicial = frase; */
    char *caracter_inicial = minus; /* Punter que apunta a un espai indeterminat. */    
    
    /* Copia el contingut de la cadena frase al espai que apunta el punter: */
    strcpy(minus,frase);
    
    while (*minus != '\0') 
    {
        *minus = tolower(*minus);
        minus++;
    }
    
    return caracter_inicial;
    // return strlwr(strcpy(minus, frase));
}

void treure_espais(char *frase)
{
     char *frase_pulida=frase;
     
     while (*frase != '\0')
     {
           if (*frase != ' ' && *frase != '\n') { *frase_pulida = *frase; frase_pulida++; }
           frase++;
     }

     *frase_pulida='\0';
     
     return;
}
