#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define bool int
#define true 1
#define false 0

#define PAUSA "pause >NUL" /* Hace una pausa (se ha de cambiar en otros sistemas operativos). */
#define BORRAR_PANTALLA "cls" /* Borra la pantalla (se ha de cambiar en otros sistemas operativos). */

#define CUADRADOS 38 /* Numero de casillas que tiene la ruleta. */
#define SALDO_INICIAL 10000



void crear_ruleta(int ruleta_numeros[], bool ruleta_colores[]); /* Crea la ruleta con los numeros distribuidos aleatoriamente. */
int girar_ruleta(int ruleta_numeros[], bool ruleta_colores[]); /* Gira la ruleta y devuelve la posicion donde ha caido la bola. */
float hacer_apuesta(int ruleta_numeros[], bool ruleta_colores[], int tipo_apuesta, float apostado); /* Comienza el juego y dice el tipo de premio segun la apuesta realizada. */



/* Funcion que crea la ruleta con los numeros distribuidos aleatoriamente: */
void crear_ruleta(int ruleta_numeros[], bool ruleta_colores[])
{
     int numero = -1, posicion;
     bool color;
     
     /* Pone todos los numeros del vector a -2: */
     for (posicion = 0; posicion < CUADRADOS; posicion++)
     {
         ruleta_numeros[posicion] = -2;
     }
     
     /* Distribuye los numeros aleatoriamente (de -1 a CUADRADOS): */
     srand(time(NULL));
     while (numero < CUADRADOS - 2) /* REVISAR SI ES -1 o -2!!!!!!!! */
     {
           posicion = rand() % CUADRADOS;
           if (ruleta_numeros[posicion] == -2)
           {
              ruleta_numeros[posicion] = numero;
              numero++;
           }
     }
     
     /* Distribuye los colores alternandolos: */
     color = rand() % 2;
     for (posicion = 0; posicion < CUADRADOS; posicion++)
     {
         ruleta_colores[posicion] = color;
         color = !color;
     }

     return;
}


/* Funcion que gira la ruleta y devuelve la posicion donde ha caido la bola: */
int girar_ruleta(int ruleta_numeros[], bool ruleta_colores[])
{
    int posicion;
    
    /* Calcula una posicion aleatoria (un cuadrado) de la ruleta: */
    srand(time(NULL));
    posicion = rand() % CUADRADOS;
    
    /* Devuelva la posicion: */
    return posicion;
    
}


/* Funcion que comienza el juego y dice el tipo de premio segun la apuesta realizada: */
float hacer_apuesta(int ruleta_numeros[], bool ruleta_colores[], int tipo_apuesta, float apostado)
{
     int posicion, numero;
     float premio = 0;

     /* Hace girar la ruleta y recoge la posicion final de la bola: */
     posicion = girar_ruleta(ruleta_numeros, ruleta_colores);
     
     /* Si la bola ha caido en 0 o 00 (-1), pierde automaticamente: */
     if (ruleta_numeros[posicion] <= 0) { printf("La bola ha caido en verde. Has perdido de inmediato.\n"); }
     /* ...pero si no, se calcula si se ha ganado y cuanto (depdende de la apuesta): */
     else
     {
         /* Si se ha hecho la apuesta tipo 1: */
         if (tipo_apuesta == 1)
         {
            /* Pregunta el numero (de 0 a CUADRADOS - 2): */
            do
            {
              printf("Escribe el numero por el que apuestas (de 1 a %d): ", CUADRADOS-2);
              scanf("%d", &numero);
            } while(numero <= 0 || numero > CUADRADOS - 2);
            
            /* Si ha acertado, gana apuesta + 35: */
            if (numero == ruleta_numeros[posicion]) { premio = apostado + 35; }
         }
         else if (tipo_apuesta == 2)
         {
              /* Pregunta color (rojo o negro): */
              do
              {
                printf("Escribe 0 para rojo y 1 para negro: ");
                scanf("%d", &numero);
              } while(numero != 0 && numero != 1);
              
              /* Si ha acertado, gana el doble de la apuesta: */
              if (numero == ruleta_colores[posicion]) { premio = apostado * 2; }
         }
         else if (tipo_apuesta == 3)
         {
              /* Pregunta si quiere par o impar: */
              do
              {
                printf("Escribe 0 para par y 1 para impar: ");
                scanf("%d", &numero);
              } while(numero != 0 && numero != 1);
             
              /* Si ha acertado, gana el doble de la apuesta: */
              if (numero == 0 && ruleta_numeros[posicion] % 2 == 0 || numero == 1 && ruleta_numeros[posicion] % 2 != 0) { premio = apostado * 2; }
         }
         else if (tipo_apuesta == 4)
         {
              /* Pregunta si quiere altos o bajos: */
              do
              {
                printf("Escribe 0 para bajos y 1 para altos: ");
                scanf("%d", &numero);
              } while(numero != 0 && numero != 1);
              
              /* Si ha acertado, gana el doble de apuesta: */
              if (numero == 0 && ruleta_numeros[posicion] < CUADRADOS - 2 / 2 || numero == 1 && ruleta_numeros[posicion] >= CUADRADOS - 2 / 2) { premio = apostado * 2; }
         }
     }

     /* Informa de lo que ha salido: */
     printf("\tHa salido: %d ", ruleta_numeros[posicion]);
     if (ruleta_numeros > 0)
     {
        if (ruleta_colores[posicion]) { printf("(negro)"); }
        else { printf("(rojo)"); }
     } else { printf("(verde)"); }

     /* Retorna el premio obtenido: */
     return premio;
}
