#include <stdio.h>
#include <stdlib.h>

#define F 8
#define C F
#define F_MIN 2
#define C_MIN F_MIN

void crear_matriu(int matriu[][C], int *f, int *c);
void mostrar_matriu(int matriu[][C], int f, int c);
void sumar_veins(int matriu[][C], int matriu_final[][C], int f, int c);

int main()
{
    int matriu[F][C] = { { 0 } }, matriu_final[F][C] = { { 0 } }, f, c;
    
    crear_matriu(matriu, &f, &c);

    printf("\nMatriu inicial:\n\n");
    mostrar_matriu(matriu, f, c);

    sumar_veins(matriu, matriu_final, f, c);

    printf("\nMatriu final:\n\n");
    mostrar_matriu(matriu_final, f, c);
    
    system("pause >NUL");
    return 0;
}

void crear_matriu(int matriu[][C], int *f, int *c)
{
    int files, columnes;
    srand(time(NULL));
    *f = rand() % F + F_MIN;
    *c = rand() % C + C_MIN;
    for (files = 0; files < *f; files++)
    {
            for (columnes = 0; columnes < *c; columnes++)
            {
                matriu[files][columnes] = rand() % 10;
            }
    }
}

void mostrar_matriu(int matriu[][C], int f, int c)
{
    int files, columnes;
    for (files = 0; files < f; files++)
    {
            for (columnes = 0; columnes < c; columnes++)
            {
                printf("%-3d", matriu[files][columnes]);
            }
            printf("\n");
    }
}

void sumar_veins(int matriu[][C], int matriu_final[][C], int f, int c)
{
    int files, columnes, suma;
    for (files = 0; files < f; files++)
    {
            for (columnes = 0; columnes < c; columnes++)
            {
                suma = 0;
                if (files > 0)
                {
                   suma += matriu[files-1][columnes];
                   if (columnes > 0) { suma += matriu[files-1][columnes-1]; }
                }
                if (columnes > 0)
                {
                   suma += matriu[files][columnes-1];
                   if (files < f-1) { suma += matriu[files+1][columnes-1]; }
                }
                if (files < f-1)
                {
                   suma += matriu[files+1][columnes];
                   if (columnes < c-1) { suma += matriu[files+1][columnes+1]; }
                }
                if (columnes < c-1)
                {
                   suma += matriu[files][columnes+1];
                   if (files > 0) { suma += matriu[files-1][columnes+1]; }
                }
                matriu_final[files][columnes] = suma;
            }
    }
}
