#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef int booleana;
#define FALS 0
#define CERT 1

#define PAUSA "pause >NUL"
#define ESBORRA "cls"

booleana obre_base_dades(char *nom_arxiu);
booleana insereix_alumnes();
void mostra_alumnes();
booleana cerca_nom();
booleana modifica_alumne();
booleana elimina_alumne();
booleana compacta_base_dades();
booleana tanca_base_dades();
int cerca_codi(int codi);

FILE *arxiu = NULL;
char nom_arxiu[255];

struct fitxa
{
       int codi;
       char nom[20];
       char cognom[20];
       float nota;
};

booleana main(int argc, char *argv[])
{
    int opcio;
    booleana base_dades_oberta = FALS;

    do
    {
      system(ESBORRA);
      printf("\n\n\t\t,.-={[< Menu: >]}=-.,\n\n\
                     1) Obre Base de Dades\n\
                     2) Insereix alumnes\n\
                     3) Mostra alumnes\n\
                     4) Cerca nom\n\
                     5) Modifica alumne\n\
                     6) Elimina alumne\n\
                     7) Compcta Base de Dades\n\
                     8) Tanca Base de Dades\n\
                     9) Surt\n\n\
                     Opcio: ");
      scanf("%d", &opcio);
      fflush(stdin);

      switch (opcio)
      {
             case 1:
                  if (base_dades_oberta) { tanca_base_dades(); }
                  else { base_dades_oberta = CERT; }
                  obre_base_dades(nom_arxiu);
                  break;
             case 2:
                  if (base_dades_oberta) { insereix_alumnes(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 3:
                  if (base_dades_oberta) { mostra_alumnes(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 4:
                  if (base_dades_oberta) { cerca_nom(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 5:
                  if (base_dades_oberta) { modifica_alumne(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 6:
                  if (base_dades_oberta) { elimina_alumne(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 7:
                  if (base_dades_oberta) { compacta_base_dades(); }
                  else { printf("\n\t\tHas d'obrir primer la base de dades!"); system(PAUSA); }
                  break;
             case 8:
                  if (base_dades_oberta)
                  {
                     tanca_base_dades();
                     base_dades_oberta = FALS;
                  } else { printf("\n\t\tEncara no has obert cap arxiu!"); system(PAUSA); }
                  break;
             case 9:
                  if (base_dades_oberta)
                  {
                     tanca_base_dades();
                     base_dades_oberta = FALS; /* innecesari. */
                  }
                  printf("\n\t\tAdeu!");
                  break;
             default:
                     printf("Opcio incorrecta!");
                     system(PAUSA);
      }
    } while (opcio != 9);
    
    printf("\n\nFi del programa.");
    system(PAUSA);
    return FALS;
}

booleana obre_base_dades(char *nom_arxiu)
{
         char opcio;

         arxiu = NULL;

         while (arxiu == NULL)
         {
               printf("\n\t\tFica el nom de l'arxiu: ");
               gets(nom_arxiu);
    
               arxiu = fopen(nom_arxiu, "r+b");
    
               if (arxiu == NULL)
               {
                  printf("\n\t\tL'arxiu no existeix (o no es pot obrir)!\nvols intentar crear-ho? (s/n): ");
                  scanf("%c", &opcio);
                  fflush(stdin);
                  if (opcio == 's')
                  {
                     arxiu = fopen(nom_arxiu, "w+b");
                     if (arxiu == NULL) { printf("\n\t\t\tError creant l'arxiu!\n"); }
                     else { printf("\n\t\t\tArxiu creat i obert!"); }
                  }
               }
               else
               {
                   printf("\n\t\t\tArxiu obert!");
               }
         }

         system(PAUSA);

         return CERT;    
}

booleana insereix_alumnes()
{
         struct fitxa alumne;
         booleana codi_posicio = -1;

         do
         {
           printf("\n\t\tFica un codi: ");
           scanf("%d", &alumne.codi);
           fflush(stdin);
           codi_posicio = cerca_codi(alumne.codi);
           if (codi_posicio != -1) { printf("\n\t\t\tEl codi ja existeix!\n"); }
         } while (codi_posicio != -1);

         do
         {
           printf("\n\t\tFica un nom: ");
           scanf("%s", alumne.nom);
           fflush(stdin);
           if (!strcmp(alumne.nom, "")) { printf("\n\t\t\tFica alguna cosa!\n"); }
         } while (!strcmp(alumne.nom, ""));

         do
         {
           printf("\n\t\tFica un nom: ");
           gets(alumne.cognom);
           if (!strcmp(alumne.cognom, "")) { printf("\n\t\t\tFica alguna cosa!\n"); }
         } while (!strcmp(alumne.cognom, ""));

         do
         {
           printf("\n\t\tFica una nota: ");
           scanf("%f", &alumne.nota);
           fflush(stdin);
           if (alumne.nota < 0 || alumne.nota > 10) { printf("\n\t\t\tLa nota ha de ser entre 0 i 10!\n"); }
         } while (alumne.nota < 0 || alumne.nota > 10);

         fseek(arxiu, 0, SEEK_END);
         
         if (!fwrite(&alumne, sizeof(alumne), 1, arxiu))
         {
            printf("\n\t\tL'alumne no ha pogut ser insertat!");
            system(PAUSA);
            return FALS;
         }
         else { printf("\n\t\tAlumne insertat!"); }

         system(PAUSA);

         return CERT;
}

void mostra_alumnes()
{
     struct fitxa alumne;

     rewind(arxiu);

     printf("\n\n\t\t%s\t%s\t%s\t%s", "Codi", "Nom", "Cognom", "Nota");
     while (fread(&alumne, sizeof(struct fitxa), 1, arxiu))
     {
           printf("\n\t\t%d\t%s\t%s\t%g", alumne.codi, alumne.nom, alumne.cognom, alumne.nota);
     }

     system(PAUSA);

     return;
}

booleana cerca_nom()
{
         printf("\n\n\t\t%s\t%s\t%s\t%s", "Codi", "Nom", "Cognom", "Nota");
}

booleana modifica_alumne()
{
    
}

booleana elimina_alumne()
{
    
}

booleana compacta_base_dades()
{
    
}

booleana tanca_base_dades()
{
         if (fclose(arxiu) != EOF) { printf("\n\t\tArxiu %s tancat!\n", nom_arxiu); system(PAUSA); return CERT; }
         else { printf("\n\t\tNo s'ha pogut tancar l'arxiu %s!\n", nom_arxiu); system(PAUSA); return FALS; }
}

int cerca_codi(int codi)
{
    struct fitxa alumne;

    rewind(arxiu);

    while (fread(&alumne, sizeof(struct fitxa), 1, arxiu))
    {
          if (alumne.codi == codi) { return ftell(arxiu); }
    }

    return -1;
}
