#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ALUMNES 5
#define ASSIGNATURES 3

struct persona
{
       int no_exp;
       char nom[20];
       char domicili[30];
} personal[ALUMNES];

struct nota
{
       int no_exp;
       int assignatura;
       float nota;
} notes[ALUMNES * ASSIGNATURES];

char assignatures[ASSIGNATURES][20];

int introduir_alumnes(int n_assignatures);
int introduir_assignatures();
void pregunta_notes_alumne(int no_exp, int n_assignatures);
void mostrar_notes_alumne(char *alumne, int alumnes, int n_assignatures);
void mostrar_notes_assignatura(char *assignatura, int alumnes, int n_assignatures);
int busca_numero_alumne(char *alumne, int alumnes, char *nom_alumne);

int main()
{
    int alumnes, n_assignatures;
    char opcio, cad[20];

    do
    {
      system("cls");
      printf("\n\t== Menu: ==\n\n\
                1) Introduir dades\n\
                2) Mostrar notes d'un alumne\n\
                3) Mostrar notes d'una assignatura\n\
                0) Sortir\n\n\
                Opcio: ");
      scanf("%c", &opcio);
      fflush(stdin);
      switch (opcio)
      {
             case '1':
                  n_assignatures = introduir_assignatures();
                  alumnes = introduir_alumnes(n_assignatures);
                  break;
             case '2':
                  printf("\n\tFica el nom de l'alumne: ");
                  scanf("%s", cad);
                  fflush(stdin);
                  mostrar_notes_alumne(cad, alumnes, n_assignatures);
                  break;
             case '3':
                  printf("\n\tFica el nom de l'assignatura: ");
                  scanf("%s", cad);
                  fflush(stdin);
                  mostrar_notes_assignatura(cad, alumnes, n_assignatures);
                  break;
             default:
                     if (opcio != '0' && opcio != '\n') { printf("\n\tOpcio incorrecta!"); system("pause >NUL"); }
      }
    } while(opcio != '0');

    printf("\n\tAdeu!");
    system("pause >NUL");
    return 0;
}

int introduir_alumnes(int n_assignatures)
{
    int alumnes, x, no_exp;
    char nom[20], domicili[20];
    
    do
    {
      printf("\n\tQuants alumnes vols ficar? ");
      scanf("%d", &alumnes);
      fflush(stdin);
    } while (alumnes <= 0 || alumnes > ALUMNES);

    for (x = 0; x < alumnes; x++)
    {
        printf("\tAlumne #%d: \n", x);
        do
        {
          printf("\t\tNumero d'expedient: ");
          scanf("%d", &no_exp);
          fflush(stdin);
        } while (no_exp < 0);
        personal[x].no_exp = no_exp;
        do
        {
          printf("\t\tNom: ");
          gets(nom);
          fflush(stdin);
        } while (strlen(nom) <= 0);
        strcpy(personal[x].nom, nom);
        do
        {
          printf("\t\tDomicili: ");
          gets(domicili);
          fflush(stdin);
        } while (strlen(domicili) <= 0);
        strcpy(personal[x].domicili, domicili);
        pregunta_notes_alumne(no_exp, n_assignatures);
    }

    return alumnes;
}

int introduir_assignatures()
{
    int n_assignatures, x;
    
    do
    {
      printf("\n\tQuantes assignatures vols ficar? ");
      scanf("%d", &n_assignatures);
      fflush(stdin);
    } while (n_assignatures <= 0 || n_assignatures > ASSIGNATURES);

    for (x = 0; x < n_assignatures; x++)
    {
        do
        {
          printf("\t\tNom de l'assignatura #%d: ", x);
          fflush(stdin);
          gets(assignatures[x]);
        } while (strlen(assignatures[x]) <= 0);
    }
    
    return n_assignatures;
}

void pregunta_notes_alumne(int no_exp, int n_assignatures)
{
     int x;
     float nota;
     
     for (x = 0; x < n_assignatures; x++)
     {
         do
         {
           printf("\n\t\tFica la nota de l'alumne en %s: ", assignatures[x]);
           scanf("%f", &nota);
         } while (nota < 0 || nota > 10);
         notes[x].no_exp = no_exp;
         notes[x].assignatura = x;
         notes[x].nota = nota;
     }

     return;
}

void mostrar_notes_alumne(char *alumne, int alumnes, int n_assignatures)
{
     int no_exp, x;
     char nom_alumne[20];
     
     no_exp = busca_numero_alumne(alumne, alumnes, nom_alumne);
     
     if (no_exp < 0) { printf("\n\tAlumne no trobat!"); }
     else { printf("\n\tAlumne %s amb expedient %d:\n", nom_alumne, no_exp); }
     
     for (x = 0; x < n_assignatures*alumnes && no_exp >= 0; x++)
     {
         if (notes[x].no_exp == no_exp)
         {
            printf("\n\t\tAssignatura %s: %g", assignatures[notes[x].assignatura], notes[x].nota);
         }
     }

     return;
}

void mostrar_notes_assignatura(char *assignatura, int alumnes, int n_assignatures)
{
     return;
}

int busca_numero_alumne(char *alumne, int alumnes, char *nom_alumne)
{
    int no_exp = -1, x;
    
    for (x = 0; x < alumnes && no_exp == -1; x++)
    {
        if (strstr(strlwr(personal[x].nom), strlwr(alumne)))
        {
           no_exp = personal[x].no_exp;
           nom_alumne = personal[x].nom;
        }
    }

    return no_exp;
}
