/* Bibloteca de funcions relatives al temps. */


/* Inclueix les biblioteques necessaries: */
#include "boolean.h"
#include <time.h> /* Necessaria per data_actual(). */
#include <dos.h> /* Necessaria per data_actual(). */


/* Definicio de funcions: */
boolean bixest(int any); /* Calcula si un nombre es bixest o no. */
int dies_mes(int mes, int any); /* Calcula el nombre de dies d'un mes d'un any concret. */
boolean data_valida(int dia, int mes, int any); /* Valida una data. */
boolean data_anterior(int dia_a, int mes_a, int any_a, int dia_b, int mes_b, int any_b); /* Torna 1 (cert) si la primera data es anterior o igual. */
int dies_transcorreguts(int dia_a, int mes_a, int any_a, int dia_b, int mes_b, int any_b); /* Torna els dies transcorreguts entre dues dates. */
int dies_transcorreguts_alternativa(int dia_a, int mes_a, int any_a, int dia_b, int mes_b, int any_b); /* Torna els dies transcorreguts entre dues dates (alternativa). */
int dies_transcorreguts_alternativa2(int dia_a, int mes_a, int any_a, int dia_b, int mes_b, int any_b); /* Torna els dies transcorreguts entre dues dates (alternativa). */
void data_actual(int *dia, int *mes, int *any); /* Torna el dia, mes i any actuals. */
int dia_setmana(int dia, int mes, int any); /* Torna el dia setmana d'una data determinada (1 = dilluns). */


/* Funcio que calcula si un nombre es bixest o no: */
boolean bixest(int any)
{
        /* Retorna 1 (cert) si la condicio logica tambe ho fa (es bixest): */
        return (any % 400 == 0 || any % 4 == 0 && any % 100 != 0);
}


/* Funcio que calcula el nombre de dies d'un mes d'un any concret: */
int dies_mes(int mes, int any)
{
    /* Es declaren les variables necessaries: */
    int dies = 0;

    /* Si es gener, mar, maig, juliol, agost, octubre o desembre... te 31 dies: */
    if (mes == 1 || mes == 3 || mes == 5 || mes == 7 || mes == 8 || mes == 10 || mes == 12) { dies = 31; }
    /* ...pero si es febrer, pot tenir 29 o 28 dies: */
    else if (mes == 2) { dies = (bixest(any)) ? 29 : 28; } /* Si es bixest tindra 29 dies i si no, 28. */
    /* ...pero si no, tindra 30 dies (sempre que sigui un numero de mes legal): */
    else if (mes >= 1 && mes <= 12) { dies = 30; }

    /* Es retorna el numero de dies del mes: */
    return dies;
}


/* Funcio que valida una data: */
boolean data_valida(int dia, int mes, int any)
{
        /* Calcula els dies que te el mes del any enviat: */
        int dies_total = dies_mes(mes, any); /* Si el mes es superior a 12, dies_total sera 0. */
        
        /* Retorna 1 (cert) si el dia enviat es menor o igual que el maxim permes, o 0 (fals) si no: */
        return (dia <= dies_total && dia >= 1);
}


/* Funcio que torna 1 (cert) si la primera data es anterior o igual: */
boolean data_anterior(int dia_a, int mes_a, int any_a, int dia_b, int mes_b, int any_b)
{
        /* Suposem que inicialment la primera data no es anterior: */
        boolean primera_anterior = FALSE;
        
        /* Calcula si la primera data es anterior o igual i si es aixi, ho defineix: */
        if (any_a < any_b || any_a == any_b && mes_a < mes_b || any_a == any_b && mes_a == mes_b && dia_a <= dia_b) { primera_anterior = TRUE; }

        /* Retorna cert o fals: */
        return primera_anterior;
}


/* Funcio que torna els dies transcorreguts entre dues dates: */
int dies_transcorreguts(int dia_a, int mes_a, int any_a, int dia_b, int mes_b, int any_b)
{
    /* Defineix les variables necessaries: */
    int dia, mes, any; /* Data des de la que comenara a contar. */
    int dia_f, mes_f, any_f; /* Data fins a la que arrivara. */
    int dies = 0; /* Dies transcorreguts. */
    
    /* Si la primera data es anterior o igual: */
    if (data_anterior(dia_a, mes_a, any_a, dia_b, mes_b, any_b)) { dia = dia_a; mes = mes_a; any = any_a; dia_f = dia_b; mes_f = mes_b; any_f = any_b; }
    /* ...i si la segonda data es anterior: */
    else { dia = dia_b; mes = mes_b; any = any_b; dia_f = dia_a; mes_f = mes_a; any_f = any_a; }
    
    /* Fa el bucle mentre la data "contadora" no arrivi a la data final: */
    while (data_anterior(dia, mes, any, dia_f, mes_f, any_f))
    {
          /* Incrementa la data "contadora": */
          dia++;

          /* Si el numero de dia ja no es valid, torna al dia 1 i incrementa el mes: */
          if (dia > dies_mes(mes, any)) { dia = 1; mes++; }
          
          /* Si el numero de mes ja no es valid (mes de 12), torna el mes a 1 i incrementa el any: */
          if (mes > 12) { mes = 1; any++; }
          
          /* Conta un dia mes: */
          dies++;
    }

    /* Com que data_anterior() da cert quan les dates son iguals, s'ha de restar un dia que s'ha contat de mes: */
    dies--; /* Tambe hagues funcionat inicialitzant dies a -1. */

    /* Retorna els dies transcorreguts: */
    return dies;
}


/* Torna el dia, mes i any actuals: */
void data_actual(int *dia, int *mes, int *any)
{
   time_t instant;
   struct tm *data;

   instant = time(NULL); /* Pren l'hora actual en segons. */
   data = localtime(&instant); /* Converteix l'hora a una estructura. */

   *dia = data->tm_mday;
   *mes = data->tm_mon+1;
   *any = data->tm_year+1900;
}


/* Funcio que torna el dia setmana d'una data determinada (1 = dilluns): */
int dia_setmana(int dia, int mes, int any)
{
     /* Declara variables necessaries: */
     int dies_totals, x = 1, dia_set = 0; /* dia_set = 1;*/
    
     /* Calcula els dies que han transcorregut des de la data donada i el dia 1/1/2006 (dilluns): */
     dies_totals = dies_transcorreguts(dia, mes, any, 1, 1, 2006);
     
//     while (x <= dies_totals && data_valida(dia, mes, any)) /* Si no es una data valida, es salta el bucle. */
//     {
         /* Si la data donada es superior al 1/1/2006, els dies van incrementant: */     
//         if (data_anterior(1, 1, 2006, dia, mes, any)) { dia_set++; }
         /* ...pero si no, van decrementant: */
//         else { dia_set--; }
//         if (dia_set > 7) { dia_set = 1; } /* Si es major que 7 (diumenge), torna a 1 (dilluns). */
//         if (dia_set < 1) { dia_set = 7; } /* Si es menor que 1 (dilluns), torna a 7 (diumenge). */
//         x++;
//     }
     
     if (data_anterior(1, 1, 2006, dia, mes, any)) { dia_set=(dia_set+dies_totals)%7; }
     else { dia_set=(dia_set-dies_totals)%7; 
            if(dia_set<0)
               dia_set+=7;
          }

     /* Si no era una data valida, el dia sera 7: */
     if (!data_valida(dia, mes, any)) { dia_set = 7; }
     /* if (!data_valida(dia, mes, any)) { dia_set = 0; } */
     
     /* Retorna el dia de la setmana (1 = dilluns): */
     return dia_set;
}


/* Funcio que torna els dies transcorreguts entre dues dates (alternativa): */
int dies_transcorreguts_alternativa(int dia_a, int mes_a, int any_a, int dia_b, int mes_b, int any_b)
{
    /* Defineix les variables necessaries: */
    int x, anys = 0, mesos = 0;
    int dia, mes, any, any_inicial_backup; /* Data des de la que comenara a contar. */
    int dia_f, mes_f, any_f; /* Data fins a la que arrivara. */
    int dies = 0; /* Dies transcorreguts. */
    
    /* Si la primera data es anterior o igual: */
    if (data_anterior(dia_a, mes_a, any_a, dia_b, mes_b, any_b)) { dia = dia_a; mes = mes_a; any = any_a; dia_f = dia_b; mes_f = mes_b; any_f = any_b; }
    /* ...i si la segonda data es anterior: */
    else { dia = dia_b; mes = mes_b; any = any_b; dia_f = dia_a; mes_f = mes_a; any_f = any_a; }

    /* Conta els anys transcorreguts: */
    for (x = any; x < any_f; x++)
        anys++;
    if (mes > mes_f || mes == mes_f && dia > dia_f) { anys--; }
    
    /* Conta els mesos transcorreguts: */
    if (mes <= mes_f) { mesos = mes_f - mes; }
    else { mesos = 12 - mes + mes_f; }
    //if (dia > dia_f) { mesos--; }
    if (mes == mes_f && dia > dia_f) { mesos--; }

    /* Conta els dies dels anys: */
    any_inicial_backup = any;
    for (x = 0; x < anys; x++)
    {
        dies += 365 + (bixest(any));
        /* Si estem a l'any inicial i no s'ha de contar febrer i era bixest, es resta un dia: */
        if (any == any_inicial_backup && mes <= 2 && (mes_f > 2 || mes_f == 2 && dia_f >= 28) && bixest(any))
           dies--;
        /* Si estem a l'any final i no s'ha de contar febrer i era bixest, es resta un dia: */
        else if (any == any_f && (mes_f < 2 || mes_f == 2 && dia_f < 28) && bixest(any))
             dies--;
        any++;
    }

    printf("\nDIES ANYS: %d (%d anys)\n", dies, anys);
    
    /* Conta els dies dels mesos: */
    for (x = 0; x < mesos; x++)
    {
        dies += dies_mes(mes, any_f);
        mes++;
        if (mes > 12) mes=1;
    }

    printf("\nDIES MESOS: %d (%d mesos)\n", dies, mesos);

    /* Conta els dies transcorreguts: */
    while (dia != dia_f)
    {
          dies++;
          dia++;
          if (dia > dies_mes(mes_f, any_f)) { dia = 1; }
    }

    printf("\nDIES DIES: %d\n", dies);

    /* Retorna els dies: */
    return dies;
}


/* Funcio que torna els dies transcorreguts entre dues dates (alternativa 2): */
int dies_transcorreguts_alternativa2(int dia_a, int mes_a, int any_a, int dia_b, int mes_b, int any_b)
{
    /* Defineix les variables necessaries: */
    int x, anys = 0, mesos = 0;
    int dia, mes, any, any_inicial_backup; /* Data des de la que comenara a contar. */
    int dia_f, mes_f, any_f; /* Data fins a la que arrivara. */
    int dies = 0; /* Dies transcorreguts. */
    
    /* Si la primera data es anterior o igual: */
    if (data_anterior(dia_a, mes_a, any_a, dia_b, mes_b, any_b)) { dia = dia_a; mes = mes_a; any = any_a; dia_f = dia_b; mes_f = mes_b; any_f = any_b; }
    /* ...i si la segonda data es anterior: */
    else { dia = dia_b; mes = mes_b; any = any_b; dia_f = dia_a; mes_f = mes_a; any_f = any_a; }

    /* Conta els dies dels anys transcorreguts: */
    for (x = any; x <= any_f-1; x++)
        dies += 365 + (bixest(x));

    /* Conta els dies dels mesos de l'any inicial: */
    for (x = 1; x < mes; x++)
        dies -= dies_mes(x, any);

    /* Conta els dies dels mesos de l'any final: */
    for (x = 1; x < mes_f; x++)
        dies += dies_mes(x, any_f);

    /* Conta els dies transcorreguts: */
    dies += dia_f - dia;
    
    /* Retorna els dies: */
    return dies;
}
