/* Bibloteca de funcions matematiques. */


/* Defineix una variable per a que no es torni a incloure: */
#ifndef _MATES_H
        #define _MATES_H


/* Inclueix les biblioteques necessaries: */
#ifndef _BOOLEAN_H
        #include "boolean.h"
#endif

/* Definicio de funcions: */
double valor_absolut(double n); /* Retorna el valor absolut d'un nombre: */
long factorial(int n); /* Calcula el factorial de un nombre. */
int nombre_combinatori(int n, int m); /* Calcula el nombre combinatori de n i m. */
double potencia(double x, int n); /* Calcula la potencia n-essima de x. */
int mcd(int a, int b); /* Calcula el Maxim Comu Divisor de dos nombres. */
boolean primer(int n); /* Calcula si un nombre es primer o no. */
int seguent_primer(int n); /* Calcula el nombre primer que ve despres d'un donat. */
double arrel_quadrada(float n); /* Calcula l'arrel quadrada d'un nombre. */
boolean quadrat_perfecte(int n); /* Calcula si un nombre es quadrat perfecte. */
boolean quadrat_perfecte_alternativa(int n); /* Calcula si un nombre es quadrat perfecte (alternativa). */
boolean cub_perfecte(int n); /* Calcula si un nombre es cub perfecte. */

/* Inclueix les biblioteques necessaries (despres de declarar les funcions locals): */
#ifndef _UTIL_H
        #include "util.h"
#endif


/* Funcio que retorna el valor absolut d'un nombre: */
double valor_absolut(double n)
{
   /* Si el nombre enviat es negatiu, es passa a positiu: */
    if (n < 0) { n *= -1; }

    /* Retorna el nombre en valor absolut: */
    return n;
}



/* Funcio que calcula el factorial de un nombre: */
long factorial(int n)
{
     /* Declara variables internes (locals): */
     int i, num_factorial = 1;

     /* Calcula el factorial: */
     for (i=1; i<=n; i++)
         num_factorial = num_factorial * i;

     /* Retorna el factorial: */
     return num_factorial;
}


/* Calcula el nombre combinatori de n i m. */
int nombre_combinatori(int n, int m)
{
    /* Declara variables internes (locals): */
    int divisor, dividend;
    
    /* Calcula el dividend de la formula: */
    dividend = factorial(n);
    /* Calcula el divisor de la formula: */
    divisor = factorial(m) * factorial(n-m);

    /* Retorna el nombre combinatori, segons la formula: */
    return dividend / divisor;
}


/* Calcula la potencia n-essima de x: */
double potencia(double x, int n)
{
       /* Declara variables internes (locals): */
       int i;
       double resultat = 1;

       /* Calcula x elevat a n: */
       for (i=0; i<n; i++)
           resultat = resultat * x;
       
       /* Retorna el resultat (x^n): */
       return resultat;
}


/* Funcio que calcula el Maxim Comu Divisor de dos nombres: */
int mcd(int a, int b)
{
    /* Mentre a sigui diferent de b: */
    while (a != b)
    {
        /* Si a es mes gran, se li resta b: */  
        if (a > b) { a = a - b; }
        /* ...i si no (es mes petit), se resta en b el valor de a: */
        else { b = b - a; }
    }

    /* Retorna el mcm de a i b: */
    return a;
}


/* Funcio que calcula si un nombre es primer o no: */
boolean primer(int n)
{
        /* Declara les variables necessaries: */
        int x = 2; /* primer numero divisor. */
        boolean es_primer = TRUE;

        /* Converteix en valor absolut el nombre: */
        n = valor_absolut(n);

        /* Fa el bucle mentre no es detecti que no sigui primer o no arrivi a 2: */
        while (es_primer && x < n / 2) /* <-- El limit es la meitat del nombre (cap nombre es divisible per un que sigui superior a la seva meitat). */
        /* while (es_primer && x < n / x) <-- aquesta solucio es la mes rapida perque solament arriva a dividir fins a n / x. */
        {
            /* Si el nombre es divisible per x, vol dir que no es primer: */
            if (n % x == 0) { es_primer = FALSE; }
            /* Es decrementa el divisor: */
            x++;
        }
        
        /* Retorna si es primer o no: */
        return es_primer;
}


/* Funcio que calcula el nombre primer que ve despres d'un donat: */
int seguent_primer(int n)
{
        /* Converteix en valor absolut el nombre: */
        n = valor_absolut(n);

        /* Mentre no es detecti que es primer, s'incrementa i torna a comprovar: */
        do { n++; } while (!primer(n));

        /* Si hem arrivat aqui es que ha detectat un primer i el retornem: */
        return n;
}


/* Funcio que calcula l'arrel quadrada d'un nombre: */
double arrel_quadrada(float n)
{
       /* Declara variables necessaries: */
       double prediccio = 2, prediccio_anterior = prediccio;
       
       /* Realitza el bucle: */
       do
       {
             prediccio_anterior = prediccio;
             prediccio = (prediccio+(n/prediccio))/2;
       } while (valor_absolut(prediccio - prediccio_anterior) >= 0.00000000001); /* Precisio de 8 decimals. */
       
       /* Retorna el resultat: */
       return prediccio;
}


/* Funcio que calcula si un nombre es quadrat perfecte: */
boolean quadrat_perfecte(int n)
{
        /* Declara variables necessaries: */
        double arrel_quadrada_n = arrel_quadrada(n);
        int arrel_quadrada_n_sencera = arrodoneix(arrel_quadrada_n);
        
        /* Retorna 1 (cert) si es un quadrat perfecte (la arrel quadrada es sencera): */
        return (arrel_quadrada_n == arrel_quadrada_n_sencera);
}


/* Funcio que calcula si un nombre es quadrat perfecte (alternativa): */
boolean quadrat_perfecte_alternativa(int n)
{
        /* Declara variables necessaries: */
        boolean es_quadrat_perfecte = FALSE;
        int x = 1;
        
        while (!es_quadrat_perfecte && x*x <= n)
        {
              if (x*x == n) { es_quadrat_perfecte = TRUE; }
              x++;
        }
        
        /* Retorna 1 (cert) si es un quadrat perfecte (la arrel quadrada es sencera): */
        return es_quadrat_perfecte;
}


/* Funcio que calcula si un nombre es cub perfecte: */
boolean cub_perfecte(int n)
{
        /* Declara variables necessaries: */
        boolean es_cub_perfecte = FALSE;
        int x = 1;
        
        while (!es_cub_perfecte && x*x*x <= n)
        {
              if (x*x*x == n) { es_cub_perfecte = TRUE; }
              x++;
        }
        
        /* Retorna 1 (cert) si es un cub perfecte (la arrel cubica es sencera): */
        return es_cub_perfecte;
}


#endif /* Solament s'inclueix la llibreria si abans no s'havia fet. */
