/* Biblioteca amb funcions que tenen utilitats varies. */


/* Defineix una variable per a que no es torni a incloure: */
#ifndef _UTIL_H
        #define _UTIL_H


/* Inclueix les biblioteques necessaries: */
#ifndef _BOOLEAN_H
        #include "boolean.h"
#endif

/* Definicio de funcions: */
int arrodoneix(float n); /* Arrodoneix un nombre decimal al enter mes proper. */
int nombre_xifres(int n); /* Calcula el nombre de xifres d'un enter. */
int invertir(int n); /* Inverteix un nombre enter. */
boolean palindrom(int n); /* Calcula si un nombre es palindrom o no. */
void ordenar_max_min(float *a, float *b, float *c); /* Ordena tres nombres reals de major a menor. */
void intercanvia(int *a, int *b); /* Intercanvia dos valors sencers. */

/* Inclueix les biblioteques necessaries (despres de declarar les funcions locals): */
#ifndef _MATES_H
        #include "mates.h"
#endif



/* Funcio que arrodoneix un nombre decimal al enter mes proper: */
int arrodoneix(float n) { return (int) (n + 0.5); }


/* Funcio que retorna el numero de xifres que te un nombre enter: */
int nombre_xifres(int n)
{
    /* Converteix en valor absolut el nombre: */
    n = valor_absolut(n);

    /* El numero de xifres inicial d'un enter es 1 (fins el 0 necessita 1 xifra): */
    int xifres = 1;
    
    /* Si el nombre dividit entre 10 es igual o superior a 1, te mes d'una xifra: */
    while (n / 10 >= 1)
    {
          /* S'incrementa el contador de xifres que te el nombre: */
          xifres++;
          /* Es redueix el nombre en una xifra menys: */
          n = n / 10;
    }
    
    /* Retorna el resultat: */
    return xifres;
}


/* Funcio que inverteix un nombre enter: */
int invertir(int n)
{
    /* Declara variables (el invertit comena sent la ultima xifra): */
    int invertit = n % 10, penultima_xifra;

    while (n / 10 >= 1)
    {
          /* Es treu l'ultima xifra al nombre: */
          n /= 10;
          /* Es guarda la penultima xifra (que ara seria la ultima): */
          penultima_xifra = n % 10;
          /* Es calcula amb la formula: */
          invertit = invertit * 10 + penultima_xifra;
    }
    
    /* Es retorna el numero invertit: */
    return invertit;
}


/* Funcio que calcula si un nombre es palindrom o no: */
boolean palindrom(int n)
{
        /* Retorna lo mateix que retorna la expressio logica: */
        return n == invertir(n);
}


/* Funcio que ordena tres nombres reals de major a menor: */
void ordenar_max_min(float *a, float *b, float *c)
{
     float temp;
     if (*a < *b) { temp = *b; *b = *a; *a = temp; }
     if (*a < *c) { temp = *a; *a = *c; *c = temp; }
     if (*b < *c) { temp = *b; *b = *c; *c = temp; }
}


/* Funcio que intercanvia dos valors sencers: */
void intercanvia(int *a, int *b)
{
     int aux=*a;
     *a=*b;
     *b=aux;
}

#endif /* Solament s'inclueix la llibreria si abans no s'havia fet. */
