#include <time.h>

#define ESBORRAR_PANTALLA "cls"
#define PAUSA "pause >NUL"


/* Algorismes de ordenacio: */
void seleccio_directa(int vector[], int dim); /* Ordena vector per seleccio directa. */
void insercio_directa(int vector[], int dim); /* Ordena vector per insercio directa. */
void metode_bombolla(int vector[], int dim); /* Ordena vector per el metode de la bombolla. */
int cercar_mes_petit(int vector[], int dim, int index_inicial); /* Busca el element del vector mes petit a partir de l'index enviat. */
void seleccio_directa_descendent(int vector[], int dim); /* Ordena vector per seleccio directa, descendent. */
void insercio_directa_descendent(int vector[], int dim); /* Ordena vector per insercio directa, descendent. */
void metode_bombolla_descendent(int vector[], int dim); /* Ordena vector per el metode de la bombolla, descendent. */
int cercar_mes_gran(int vector[], int dim, int index_inicial); /* Busca el element del vector mes gran a partir de l'index enviat. */

/* Algoritmes de recerca: */
int recerca_sequencial(int vector[], int dim, int valor); /* Busca un valor dintre del vector de forma sequencial. */
int recerca_dicotomica(int vector[], int dim, int valor); /* Busca un valor dintre del vector de forma dicotomica. */

/* Altres: */
void omplir_vector(int vector[], int dim, int min, int max); /* Omple un vector amb valors aleatoris que van de min a max (incluits). */
void omplir_vector_lletres_majuscules(int vector[], int dim); /* Omple un vector amb lletres majuscules aleatories. */
void mostrar_vector(int vector[], int dim); /* Mostra un vector per pantalla. */
void mostrar_vector_caracters(int vector[], int dim); /* Mostra un vector de caracters per pantalla. */
void intercanvia (int *a, int *b); /* Intercanvia dos valors. */


/* Funcio que ordena vector per seleccio directa: */
void seleccio_directa(int vector[], int dim)
{
     int x, backup, index_mes_petit;
     //for (x = 0; x < dim; x++)
     for (x = 0; x < dim - 1; x++)
     {
         index_mes_petit = cercar_mes_petit(vector, dim, x);
         backup = vector[x];
         vector[x] = vector[index_mes_petit];
         vector[index_mes_petit] = backup;
     }
}


/* Funcio que ordena vector per insercio directa: */
void insercio_directa(int vector[], int dim)
{
     int x, y, backup;
     for (x = 1; x < dim; x++)
     {
         backup = vector[x];
         for (y = x; (y > 0) && (vector[y-1] > backup); y--)
         {
             vector[y] = vector[y-1];
         }
         vector[y] = backup;
     }

}


/* Funcio que ordena vector per el metode de la bombolla: */
void metode_bombolla(int vector[], int dim)
{
     int x, y;
     for (x = dim - 1; x > 0; x--)
     {
         for (y = 0; y < x; y++)
         {
             if (vector[y] > vector[y+1]) { intercanvia(&vector[y], &vector[y+1]); }
         }
     }
}


/* Funcio que busca el element del vector mes petit a partir de l'index enviat: */
int cercar_mes_petit(int vector[], int dim, int index_inicial)
{
    int x, posicio = index_inicial;
    for (x = index_inicial + 1; x < dim; x++)
    {
        if (vector[x] < vector[posicio]) { posicio = x; }
    }
    return posicio;
}


/* Funcio que ordena vector per seleccio directa, descendent: */
void seleccio_directa_descendent(int vector[], int dim)
{
     int x, backup, index_mes_gran;
     //for (x = 0; x < dim; x++)
     for (x = 0; x < dim - 1; x++)
     {
         index_mes_gran = cercar_mes_gran(vector, dim, x);
         backup = vector[x];
         vector[x] = vector[index_mes_gran];
         vector[index_mes_gran] = backup;
     }
}


/* Funcio que ordena vector per insercio directa, descendent: */
void insercio_directa_descendent(int vector[], int dim)
{
     int x, y, backup;
     for (x = 1; x < dim; x++)
     {
         backup = vector[x];
         for (y = x; (y > 0) && (vector[y-1] < backup); y--)
         {
             vector[y] = vector[y-1];
         }
         vector[y] = backup;
     }

}


/* Funcio que ordena vector per el metode de la bombolla, descendent: */
void metode_bombolla_descendent(int vector[], int dim)
{
     int x, y;
     for (x = dim - 1; x > 0; x--)
     {
         for (y = 0; y < x; y++)
         {
             if (vector[y] < vector[y+1]) { intercanvia(&vector[y], &vector[y+1]); }
         }
     }
}


/* Funcio que busca el element del vector mes gran a partir de l'index enviat: */
int cercar_mes_gran(int vector[], int dim, int index_inicial)
{
    int x, posicio = index_inicial;
    for (x = index_inicial + 1; x < dim; x++)
    {
        if (vector[x] > vector[posicio]) { posicio = x; }
    }
    return posicio;
}


/* Funcio que omple un vector amb valors aleatoris que van de min a max (incluits): */
void omplir_vector(int vector[], int dim, int min, int max)
{
    int valor_aleatori, x;
    srand(time(NULL));
    
    for (x = 0; x < dim; x++)
    {
        vector[x] = rand() % (max - min + 1) + min;
    }

    return;
}


/* Funcio que mostra un vector per pantalla: */
void mostrar_vector(int vector[], int dim)
{
     int x;
     for (x = 0; x < dim; x++) { printf("%d, ", vector[x]); }
     printf("\b\b ");
}


/* Funcio que intercanvia dos valors: */
void intercanvia (int *a, int *b)
{
     int temp;
     temp = *a;
     *a = *b;
     *b = temp;
}


/* Busca un valor dintre del vector de forma sequencial: */
int recerca_sequencial(int vector[], int dim, int valor)
{
    int index_buscat = -1, x;
    
    for (x = 0; x < dim && index_buscat < 0; x++)
    {
        if (vector[x] == valor) { index_buscat = x; }
    }
    
    return index_buscat;
}


/* Busca un valor dintre del vector de forma dicotomica. */
int recerca_dicotomica(int vector[], int dim, int valor)
{
    int min = 0, max = dim - 1, mig, index_buscat = -1;

    while (min <= max && index_buscat == -1)
    {
          mig = (min + max) / 2;
          
          if (vector[mig] > valor) { max = mig - 1; }
          else if (vector[mig] < valor) { min = mig + 1; }
          else { index_buscat = mig; }
    }

    return index_buscat;
}


/* Funcio que mostra un vector de caracters per pantalla: */
void mostrar_vector_caracters(int vector[], int dim)
{
     int x;
     for (x = 0; x < dim; x++) { printf("%c, ", vector[x]); }
     printf("\b\b ");
}


/* Funcio que omple un vector amb lletres majuscules aleatories: */
void omplir_vector_lletres_majuscules(int vector[], int dim)
{
    int min = 'A', max = 'Z';

    omplir_vector(vector, dim, min, max);

    return;
}
